/*

 Copyright (C) 2006 NTT DATA Corporation

 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License
 as published by the Free Software Foundation, version 2.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 */

package com.clustercontrol.performance.dialog;

import java.util.ArrayList;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

import com.clustercontrol.dialog.CommonDialog;
import com.clustercontrol.dialog.ValidateResult;
import com.clustercontrol.composite.PositiveNumberVerifyListener;
import com.clustercontrol.performance.composite.tree.CollectorRuleComposite;
import com.clustercontrol.performance.composite.tree.CollectorTreeComposite;
import com.clustercontrol.performance.composite.tree.CollectorBasicScopeComposite;
import com.clustercontrol.performanceMGR.bean.CollectorProperty;
import com.clustercontrol.performanceMGR.bean.CollectorType;
import com.clustercontrol.performanceMGR.ejb.bmp.RecordCollectorData;
import com.clustercontrol.util.Messages;

/**
 * ʹƻѹ饹Ǥ
 * 
 * @version 2.0.0
 * @since 2.0.0
 */
public class RecordSetDialog extends CommonDialog {
	
	public static final int WIDTH_TITLE = 3;
	public static final int WIDTH_VALUE = 2;

    // ----- instance ե ----- //

    /** ͤݻ륪֥ */
    private CollectorProperty inputData = null;

    /** ͤݻ륪֥ */
    private ValidateResult validateResult = null;
    
    /** ѹоݤμID */
//    private String collectorId = null;
    
    /** ܾ(IDоݥ) */
    private CollectorBasicScopeComposite m_collectorBasic = null;
    
    /** ֳ */
    private CollectorRuleComposite m_collectorRule = null;

    /**  */
	private Composite periodComposite = null;
	private Label periodLabel = null;
	private Text hourText = null;
	private Label hourLabel = null;
	private Text minText = null;
	private Label minLabel = null;
	private Text dayText = null;
	private Label dayLabel = null;
	private boolean enabled = true;
	private Button limitButton = null; 
	private Button unlimitButton = null;
	private Label presaveLabel = null;
	private Text presaveText = null;
	private Label dayLabel2 = null;

//    /** ͭˤ */
//    private Button confirmValid = null;

    /** ѥĥ꡼ڥ */
    private CollectorTreeComposite itemTreeComposite;
    
    // ----- 󥹥ȥ饯 ----- //

    /**
     * ѥΥ󥹥󥹤֤ޤ
     * 
     * @param parent
     *            ƤΥ륪֥
     */
    public RecordSetDialog(Shell parent) {
        super(parent);
    }

    /**
     * ѹѥΥ󥹥󥹤֤ޤ
     * 
     * @param parent
     *            ƤΥ륪֥
     * @param property
     *            
     */
    public RecordSetDialog(Shell parent, CollectorProperty property, boolean enabled) {
        super(parent);

        this.inputData = property;
        this.enabled = enabled;
    }

    // ----- instance ᥽å ----- //

    /**
     * ꥢޤ
     * 
     * @param parent
     *            ƤΥ󥹥
     */
    protected void customizeDialog(Composite parent) {
        Shell shell = this.getShell();

        // ȥ
        if(enabled){
        	shell.setText(Messages.getString(Messages.getString("dialog.performance.collector.create")));
        } else {
        	shell.setText(Messages.getString(Messages.getString("dialog.performance.collector.property")));
        }
      
        // ѿȤѤ٥
        Label label = null;
        // ѿȤѤ륰åɥǡ
        GridData gridData = null;

        // 쥤
        GridLayout layout = new GridLayout(1, true);
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        layout.numColumns = 15;
        parent.setLayout(layout);
        
        // ƻܾ
        m_collectorBasic = new CollectorBasicScopeComposite(parent, SWT.NONE);
        gridData = new GridData();
		gridData.horizontalSpan = 15;
		gridData.horizontalAlignment = GridData.FILL;
		gridData.grabExcessHorizontalSpace = true;
		m_collectorBasic.setLayoutData(gridData);
        // ͤꤵƤϤ̤
        if(inputData != null){
        	// ܾ
        	m_collectorBasic.setInputData(inputData.getCollectorData());
        }
		
        // ٥
        label = new Label(parent, SWT.NONE);
        gridData = new GridData();
        gridData.horizontalSpan = 15;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData(gridData);
        label.setText(Messages.getString("collection.setting") + " : ");
        
        // 롼
        Group groupRule = new Group(parent, SWT.NONE);
        layout = new GridLayout(1, true);
        layout.marginWidth = 5;
        layout.marginHeight = 5;
        layout.numColumns = 1;
        groupRule.setLayout(layout);
        gridData = new GridData();
        gridData.horizontalSpan = 15;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        groupRule.setLayoutData(gridData);
        
        // ֳѥܥܥå
        m_collectorRule = new CollectorRuleComposite(groupRule, SWT.NONE);
        gridData = new GridData();
		gridData.horizontalSpan = 15;
		gridData.horizontalAlignment = GridData.FILL;
		gridData.grabExcessHorizontalSpace = true;
		m_collectorRule.setLayoutData(gridData);
        // ͤꤵƤϤ̤
		if(inputData != null){
        	m_collectorRule.setInputData(inputData.getCollectorData());
        }
		
        // ΰ
		createPeriodGroup(groupRule);
		
        /*
         * 롼
         */
        // ٥
        label = new Label(groupRule, SWT.NONE);
        gridData = new GridData();
        gridData.horizontalSpan = 15;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData(gridData);
        label.setText(Messages.getString("collection.item") + " : ");

        String collectorId = null;
        if(inputData != null){
        	collectorId = inputData.getCollectorData().getCollectorID();
        }
        
        // ܥĥ꡼
        itemTreeComposite = new CollectorTreeComposite(
        		groupRule,
        		SWT.NONE,
        		m_collectorBasic.getFacilityId(),
        		collectorId
        );
        
        // ꤬ѹˤʤȹܥĥ꡼褦
        m_collectorBasic.setUpdateComposite(itemTreeComposite);
        
        gridData = new GridData();
        gridData.horizontalSpan = 150;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        gridData.heightHint = 300;
        itemTreeComposite.setLayoutData(gridData);
        // ͤꤵƤϤ̤
        if(inputData != null){
        	// ܤΥꥹȤĥ꡼ڥ
        	this.itemTreeComposite.setItemList(inputData.getItemList());
        }
        
        // Ŭ
        // åɥ쥤ȤѤ硢ʤȲ̤äѤˤʤޤ
        shell.pack();
        shell.setSize(new Point(550, shell.getSize().y));

        // 
        Display display = shell.getDisplay();
        shell.setLocation((display.getBounds().width - shell.getSize().x) / 2,
                (display.getBounds().height - shell.getSize().y) / 2);
        
        setEnabled(enabled);
    }
    
	/**
	 * This method initializes periodGroup 
	 *
	 */
	private void createPeriodGroup(Composite parent) {
		periodComposite = new Composite(parent, SWT.NONE);
		GridLayout compLayout = new GridLayout(8,false);
		compLayout.marginWidth = 0;
		compLayout.marginHeight = 0;
				
		periodComposite.setLayout(compLayout);

		GridData labelData = new GridData(GridData.FILL_VERTICAL);
		labelData.verticalSpan=2;
		GridData limitRadioData = new GridData();
		GridData preiodDayTextData = new GridData();	
		GridData periodDayData  = new GridData();
		GridData periodHoutTextData = new GridData();
		GridData periodHourData  = new GridData();
		GridData periodMinTextData = new GridData();
		GridData periodMinData  = new GridData();
		GridData unlimitRadioData = new GridData();
		GridData presaveLabelData = new GridData(GridData.FILL_HORIZONTAL);
		GridData presaveTextData = new GridData();
		GridData presaveDay2Data = new GridData();
		VerifyListener verifyListener = new PositiveNumberVerifyListener();
		
		periodLabel = new Label(periodComposite, SWT.NONE);
		periodLabel.setText(Messages.getString("collection.period") + " : ");
		periodLabel.setLayoutData(labelData);
		
		limitButton = new Button(periodComposite, SWT.RADIO);
		limitButton.setText(com.clustercontrol.performance.util.Messages.getString("PERIOD_SETTING")+"  ");
		limitButton.setLayoutData(limitRadioData);
		limitButton.setSelection(true);
		limitButton.addSelectionListener(new SelectionListener() {
			public void widgetSelected(SelectionEvent e) {
				dayText.setEnabled(true);
				hourText.setEnabled(true);
				minText.setEnabled(true);
				presaveText.setEnabled(false);
			}

			public void widgetDefaultSelected(SelectionEvent e) {	
			}
			
		});
		
		dayText = new Text(periodComposite, SWT.BORDER);
		dayText.addVerifyListener(verifyListener);
		dayText.setLayoutData(preiodDayTextData);
		dayText.setText("0   ");  //  //$NON-NLS-1$
	
		dayLabel = new Label(periodComposite, SWT.NONE);
		dayLabel.setText(com.clustercontrol.performance.util.Messages.getString("DAY")+"   ");
		dayLabel.setLayoutData(periodDayData);
		
		hourText = new Text(periodComposite, SWT.BORDER);
		hourText.addVerifyListener(verifyListener);
		hourText.setLayoutData(periodHoutTextData);	
		hourText.setText("0   ");  //  //$NON-NLS-1$
	
		hourLabel = new Label(periodComposite, SWT.NONE);
		hourLabel.setText("  " + com.clustercontrol.performance.util.Messages.getString("HOUR")+"   ");
		hourLabel.setLayoutData(periodHourData);
		
		minText = new Text(periodComposite, SWT.BORDER);
		minText.addVerifyListener(verifyListener);
		minText.setLayoutData(periodMinTextData);
		minText.setText("10  ");  //  //$NON-NLS-1$
	
		minLabel = new Label(periodComposite, SWT.NONE);
		minLabel.setText("  " + com.clustercontrol.performance.util.Messages.getString("MINUTE")+"   "); 
		minLabel.setLayoutData(periodMinData);
				
		unlimitButton = new Button(periodComposite, SWT.RADIO);
		unlimitButton.setText(com.clustercontrol.performance.util.Messages.getString("UNLIMIT_COLLECT")+ "   ");
		unlimitButton.setLayoutData(unlimitRadioData);
		unlimitButton.setSelection(false);
		unlimitButton.addSelectionListener(new SelectionListener() {
			public void widgetSelected(SelectionEvent e) {
				dayText.setEnabled(false);
				hourText.setEnabled(false);
				minText.setEnabled(false);
				presaveText.setEnabled(true);
			}

			public void widgetDefaultSelected(SelectionEvent e) {	
			}
			
		});
		presaveLabel = new Label(periodComposite, SWT.NONE);
		presaveLabel.setText(com.clustercontrol.performance.util.Messages.getString("PRESAVE_PERIOD")); 
		presaveLabel.setLayoutData(presaveLabelData);
		presaveText = new Text(periodComposite, SWT.BORDER);
		presaveText.addVerifyListener(verifyListener);
		presaveText.setText("30  ");  //$NON-NLS-1$
		presaveText.setLayoutData(presaveTextData);
		 
       dayLabel2 = new Label(periodComposite, SWT.NONE);
		dayLabel2.setText("  "+com.clustercontrol.performance.util.Messages.getString("DAY")); 
		dayLabel2.setLayoutData(presaveDay2Data);
		
		
        // ͤꤵƤϤ̤
        if(inputData != null){
        	// 
        	this.setPeriod(inputData.getCollectorData().getPeriod());
        }
	}
	
	/**
    * ¸֤ꤷޤ 
    */
	private void setPresave(int presave){
		String prev = Integer.toString(presave);
		//		ʸ4ʸʾǤʤȤʤ
		for (int i = 0 ; i <=(4-prev.length());i++)
			prev = prev + " "; //$NON-NLS-1$
		presaveText.setText(prev);
	}
	/**
	 * ֤ޤ
	 * @return
	 */
	private int getPresave(){
		String presave=presaveText.getText();
		return Integer.parseInt(presave.trim());
	}
	
	/**
	 * ΰꤵƤƤޤ
	 * 
	 * @return ֤
	 */
	private int getPeriod(){
		int period = 
			Integer.parseInt(dayText.getText().trim()) * 24 * 60 + 	
			Integer.parseInt(hourText.getText().trim()) * 60 +	
			Integer.parseInt(minText.getText().trim());	
		
		return period;
	}

	/**
	 * ΰɽ֤ꤷޤ
	 * 
	 * @param period
	 */
	private void setPeriod(int period){
		//֤-1Ǥ̵¼
		if(period != -1){
			String day = Integer.toString(period / 60 / 24);
			String hour = Integer.toString(period / 60 % 24);
			String min = Integer.toString(period % 60);
			
			//ʸ4ʸʾǤʤȤʤ
			for(int i= 0; i <= (4-day.length());i++)
				day = day+ " ";		 //$NON-NLS-1$
			for(int i= 0; i <= (4-hour.length());i++)
				hour = hour+ " "; //$NON-NLS-1$
			for(int i= 0; i <= (4-min.length());i++)
				min = min+ " "; //$NON-NLS-1$
			
		dayText.setText(day);
		hourText.setText(hour);
		minText.setText(min);
		
		this.setPresave(0);
		
		}else{
			this.limitButton.setSelection(false);
			this.unlimitButton.setSelection(true);
			this.setPresave(inputData.getCollectorData().getPresavePeriod());
			minText.setText("0   "); //$NON-NLS-1$
		}
	}
	
    /**
     * Ƥ֤ޤ
     * 
     * @return Ƥݻ
     */
    public CollectorProperty getInputData() {
        return this.inputData;
    }

    /**
     * ƹܤͤꤷޤ
     * 
     * @param property 
     */
    private void setInputData(CollectorProperty property) {
    	inputData = property;
    }

    /**
     * ͤѤξޤ
     * 
     * @return ͤݻξ
     */
    protected CollectorProperty createInputData() {
    	CollectorProperty info = new CollectorProperty();   	
    	RecordCollectorData collectorData = new RecordCollectorData();
    	info.setCollectorData(collectorData);
        
        // IDоݥפ
        validateResult = m_collectorBasic.createInputData(info.getCollectorData());
        if(validateResult != null){
        	return null;
        }
        // ̤Ӽ
        info.getCollectorData().setCollectorType(CollectorType.RECORD);

    	// ֳ֤
    	validateResult = m_collectorRule.createInputData(info.getCollectorData());
        if(validateResult != null){
        	return null;
        }

        //Ǥ
        if(limitButton.getSelection()){
        // ֤
        if(getPeriod() == 0){
        	validateResult = new ValidateResult();
        	validateResult.setMessage( // "֤ꤷƲ"
        			com.clustercontrol.performance.util.Messages.getString("MSG_SPECIFY_COLLECTION_PERIOD"));
        	validateResult.setValid(false);
        	return null;
        } else {
        	info.getCollectorData().setPeriod(getPeriod());
        		info.getCollectorData().setPresavePeriod(0);
        	}
        }else{//̵¤˼롣
        	if(getPresave()==0){
        		validateResult = new ValidateResult();
        		//	validateResult.setMessage( // "֤ꤷƲ"
        		//			com.clustercontrol.performance.util.Messages.getString("MSG_SPECIFY_COLLECTION_PERIOD"));
        		validateResult.setMessage(  com.clustercontrol.performance.util.Messages.getString("SET_PRESAVE_PERIOD")); 
        		validateResult.setValid(false);
        		return null;
        	}else{
        		info.getCollectorData().setPresavePeriod(getPresave());
        		//ʹƻμ֤-1Τᡢ̵¤-1Ȥ롣
        		info.getCollectorData().setPeriod(-1);
        	}
        }
        
    	// ܤ
        ArrayList itemList = itemTreeComposite.getItemList();
        if(itemList.size() == 0){
        	validateResult = new ValidateResult();
        	validateResult.setValid(false);
        	validateResult.setMessage(  // "ܤꤷƲ"
        			com.clustercontrol.performance.util.Messages.getString("MSG_SPECIFY_COLLECTION_ITEM")); //$NON-NLS-1$
        	return null;
        } else {
        	info.setItemList(itemList);
        }
        return info;
    }

    /**
     * ͥå򤷤ޤ
     * 
     * @return ڷ
     */
    protected ValidateResult validate() {
        // 
        this.inputData = this.createInputData();

        if (this.inputData != null) {
            return super.validate();
        } else {
            return validateResult;
        }
    }

    /**
     * ϣ˥ܥΥƥȤ֤ޤ
     * 
     * @return ϣ˥ܥΥƥ
     */
    protected String getOkButtonText() {
        return Messages.getString("ok");
    }

    /**
     * 󥻥ܥΥƥȤ֤ޤ
     * 
     * @return 󥻥ܥΥƥ
     */
    protected String getCancelButtonText() {
        return Messages.getString("cancel");
    }
    
    /**
     * ̵ͤξꤷޤ
     *  
     */
    private void setValidateResult(String id, String message) {

        this.validateResult = new ValidateResult();
        this.validateResult.setValid(false);
        this.validateResult.setID(id);
        this.validateResult.setMessage(message);
    }
    
    public void setEnabled(boolean enabled){
        m_collectorBasic.setEnabled(enabled);
        m_collectorRule.setEnabled(enabled);
     
    	this.dayText.setEnabled(enabled);
    	this.hourText.setEnabled(enabled);
    	this.minText.setEnabled(enabled);
       this.limitButton.setEnabled(enabled);
       this.unlimitButton.setEnabled(enabled);
    	this.presaveText.setEnabled(false);
    	itemTreeComposite.setEnabled(enabled);
    }
}