/*

 Copyright (C) 2006 NTT DATA Corporation

 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License
 as published by the Free Software Foundation, version 2.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 */

package com.clustercontrol.performance.monitor.dialog;

import java.util.ArrayList;

import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

import com.clustercontrol.bean.YesNoConstant;
import com.clustercontrol.dialog.CommonDialog;
import com.clustercontrol.dialog.ValidateResult;
import com.clustercontrol.monitor.run.bean.MonitorInfo;
import com.clustercontrol.performance.monitor.action.AddPerformance;
import com.clustercontrol.performance.monitor.action.DeletePerformance;
import com.clustercontrol.performance.monitor.action.GetPerformance;
import com.clustercontrol.performance.monitor.action.ModifyPerformance;
import com.clustercontrol.performance.monitor.bean.PerformanceTabelDefine;
import com.clustercontrol.performance.monitor.composite.PerformanceListComposite;
import com.clustercontrol.util.Messages;

/**
 * ꥽ʹƻ饹Ǥ
 * 
 * @version 2.0.0
 * @since 2.0.0
 */
public class PerformanceListDialog extends CommonDialog {

    // ----- instance ե ----- //

    /** ꥽Ͱ */
    private PerformanceListComposite perfList = null;

    /** ɲåܥ */
    private Button buttonAdd = null;

    /** ѹܥ */
    private Button buttonModify = null;

    /** ܥ */
    private Button buttonDelete = null;

    /** ͭܥ */
    private Button buttonValid = null;
    
    /** ̵ܥ */
    private Button buttonInvalid = null;


    // ----- 󥹥ȥ饯 ----- //

    /**
     * Υ󥹥󥹤֤ޤ
     * 
     * @param parent
     *            ƤΥ륪֥
     */
    public PerformanceListDialog(Shell parent) {
        super(parent);
    }

    // ----- instance ᥽å ----- //

    /**
     * ν֤ޤ
     * 
     * @return 
     */
    protected Point getInitialSize() {
        return new Point(800, 350);
    }

    /**
     * ꥢޤ
     * 
     * @param parent ƤΥ󥹥
     */
    protected void customizeDialog(Composite parent) {
        Shell shell = this.getShell();

        // ȥ
        shell.setText(Messages.getString("dialog.performance.monitor.list"));

        // 쥤
        GridLayout layout = new GridLayout(8, true);
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        layout.numColumns = 8;
        parent.setLayout(layout);

        /*
         * ꥽ƻ
         */
        this.perfList = new PerformanceListComposite(parent, SWT.BORDER);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.verticalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalSpan = 7;
        this.perfList.setLayoutData(gridData);

        /*
         * ܥ
         */
        Composite composite = new Composite(parent, SWT.NONE);
        layout = new GridLayout(1, true);
        layout.numColumns = 1;
        composite.setLayout(layout);
        gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.verticalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalSpan = 1;
        composite.setLayoutData(gridData);

        // ɲåܥ
        this.buttonAdd = this
                .createButton(composite, Messages.getString("add"));
        this.buttonAdd.addSelectionListener(new SelectionAdapter() {
            public void widgetSelected(SelectionEvent e) {
            	PerformanceCreateDialog dialog = new PerformanceCreateDialog(getParentShell());
                if (dialog.open() == IDialogConstants.OK_ID) {
                	
                	MonitorInfo info = dialog.getInputData();
                	if(info != null){
                    	boolean result = new AddPerformance().add(info);
                        String[] args = { info.getMonitorId() };
                        if(result){
                            MessageBox box = new MessageBox(getShell(), SWT.OK | SWT.ICON_INFORMATION);
                            box.setText(Messages.getString("successful"));
                            box.setMessage(Messages.getString("message.monitor.33",args));
                            box.open();
                            
                        	perfList.update();
                        }
                        else{
                            MessageBox box = new MessageBox(getShell(), SWT.OK | SWT.ICON_ERROR);
                            box.setText(Messages.getString("failed"));
                            box.setMessage(Messages.getString("message.monitor.34",args));
                            box.open();
                        }
                	}
                }
            }
        });

        // ѹܥ
        Label dummy = new Label(composite, SWT.NONE);
        this.buttonModify = this.createButton(composite, Messages.getString("modify"));
        this.buttonModify.addSelectionListener(new SelectionAdapter() {
            public void widgetSelected(SelectionEvent e) {
            	
            	String monitorId = null;
            	
            	Table table = perfList.getTableViewer().getTable();
            	TableItem[] item = table.getSelection();
            	
            	if(item != null && item.length>0){
            		try{
            			monitorId = (String)((ArrayList)item[0].getData()).get(PerformanceTabelDefine.MONITOR_ID);
            		}
            		catch(Exception ex){
            		}
            	}

                if (monitorId != null) {
                	PerformanceCreateDialog dialog = new PerformanceCreateDialog(getParentShell(), monitorId);
                    if (dialog.open() == IDialogConstants.OK_ID) {
                    	boolean result = new ModifyPerformance().modify(dialog.getInputData());
                        String[] args = { monitorId };
                        if(result){
                            MessageBox box = new MessageBox(getShell(), SWT.OK | SWT.ICON_INFORMATION);
                            box.setText(Messages.getString("successful"));
                            box.setMessage(Messages.getString("message.monitor.35",args));
                            box.open();
                            
                            int selectIndex = table.getSelectionIndex();
                            perfList.update();
                            table.setSelection(selectIndex);
                        }
                        else{
                            MessageBox box = new MessageBox(getShell(), SWT.OK | SWT.ICON_ERROR);
                            box.setText(Messages.getString("failed"));
                            box.setMessage(Messages.getString("message.monitor.36",args));
                            box.open();
                        }
                    }
                }
                else{
                    MessageBox box = new MessageBox(getShell(), SWT.OK | SWT.ICON_WARNING);
                    box.setText(Messages.getString("warning"));
                    box.setMessage(Messages.getString("message.monitor.1"));
                    box.open();
                  }
            }
        });

        // ܥ
        dummy = new Label(composite, SWT.NONE);
        this.buttonDelete = this.createButton(composite, Messages
                .getString("delete"));
        this.buttonDelete.addSelectionListener(new SelectionAdapter() {
            public void widgetSelected(SelectionEvent e) {
            	
            	String monitorId = null;
            	
            	Table table = perfList.getTableViewer().getTable();
            	TableItem[] item = table.getSelection();
            	
            	if(item != null && item.length>0){
            		try{
            			monitorId = (String)((ArrayList)item[0].getData()).get(PerformanceTabelDefine.MONITOR_ID);
            		}
            		catch(Exception ex){
            		}
            	}

                if (monitorId != null) {
                	
                  MessageBox confirmBox = new MessageBox(getShell(), SWT.OK | SWT.CANCEL | SWT.ICON_WARNING);
                  confirmBox.setText(Messages.getString("confirmed"));
                  String[] args = { monitorId };
                  String message = Messages.getString("message.monitor.39",args);
                  confirmBox.setMessage(message);

		          if (confirmBox.open() == SWT.OK) {
		        	  boolean result = new DeletePerformance().delete(monitorId);
                      if(result){
                          MessageBox box = new MessageBox(getShell(), SWT.OK | SWT.ICON_INFORMATION);
                          box.setText(Messages.getString("successful"));
                          box.setMessage(Messages.getString("message.monitor.37", args));
                          box.open();
                          
                          perfList.update();
                      }
                      else{
                          MessageBox box = new MessageBox(getShell(), SWT.OK | SWT.ICON_ERROR);
                          box.setText(Messages.getString("failed"));
                          box.setMessage(Messages.getString("message.monitor.38", args));
                          box.open();
                      }
		          }
                }
                else{
                  MessageBox box = new MessageBox(getShell(), SWT.OK | SWT.ICON_WARNING);
                  box.setText(Messages.getString("warning"));
                  box.setMessage(Messages.getString("message.monitor.1"));
                  box.open();
                }
            }
        });
        
        // ͭܥ
        dummy = new Label(composite, SWT.NONE);
        this.buttonValid = this.createButton(composite, Messages
                .getString("valid"));
        this.buttonValid.addSelectionListener(new SelectionAdapter() {
            public void widgetSelected(SelectionEvent e) {
            	//ͭѹ
            	setValid(YesNoConstant.TYPE_YES);
            }
        });
        
        // ̵ܥ
        this.buttonInvalid = this.createButton(composite, Messages
                .getString("invalid"));
        this.buttonInvalid.addSelectionListener(new SelectionAdapter() {
            public void widgetSelected(SelectionEvent e) {
            	//̵ѹ
            	setValid(YesNoConstant.TYPE_NO);
            }
        });
        
        // 饤
        Label line = new Label(parent, SWT.SEPARATOR | SWT.HORIZONTAL);
        gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 8;
        line.setLayoutData(gridData);

        // 
        Display display = shell.getDisplay();
        shell.setLocation((display.getBounds().width - shell.getSize().x) / 2,
                (display.getBounds().height - shell.getSize().y) / 2);
    }

    /**
     * ͥå򤷤ޤ
     * 
     * @return ڷ
     */
    protected ValidateResult validate() {
        return super.validate();
    }

    /**
     * ̤Υܥޤ
     * 
     * @param parent
     *            ƤΥݥå
     * @param label
     *            ܥΥ٥
     * @return 줿ܥ
     */
    private Button createButton(Composite parent, String label) {
        Button button = new Button(parent, SWT.NONE);

        GridData gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        button.setLayoutData(gridData);

        button.setText(label);

        return button;
    }
    
    /**
     * Ĥܥޤ
     * 
     * @param parent ܥСݥå
     */
    protected void createButtonsForButtonBar(Composite parent) {
    	
        // Ĥܥ
        this.createButton(parent, IDialogConstants.CANCEL_ID, IDialogConstants.CLOSE_LABEL, false);
    }

    /**
     * ̵ͭѹ
     * 
     * @param valid
     */
    public void setValid(int valid) {

		//򤵤줿ƻID
		ArrayList<String> list = perfList.getSelectionData();
		if (list != null && list.size() > 0) {

			StringBuilder monitorIds = new StringBuilder();
			for(int i = 0; i < list.size(); i++){
				if(i > 0){
					monitorIds.append(", ");
				}
				monitorIds.append(list.get(i));
			}
			MessageBox confirmBox = new MessageBox(getShell(), SWT.OK | SWT.CANCEL | SWT.ICON_WARNING);
			confirmBox.setText(Messages.getString("confirmed"));
            String[] confirmArgs = { monitorIds.toString() };
            if(valid == YesNoConstant.TYPE_YES)
            	confirmBox.setMessage(Messages.getString("message.monitor.47",confirmArgs));
            else
            	confirmBox.setMessage(Messages.getString("message.monitor.48",confirmArgs));
            if(confirmBox.open() == SWT.CANCEL){
            	return;
            }
			
			for(int i = 0; i < list.size(); i++){
				String monitorId = list.get(i);
				
				if(monitorId != null && !monitorId.equals("")){
			        //ƻ
			        MonitorInfo info = new GetPerformance().getProcess(monitorId);   	
			        
			        //̵ˤ
			        info.setValid(valid);
			        
			        //ƻ򹹿
			        boolean result = new ModifyPerformance().modify(info);
                    if(!result){
                        MessageBox box = new MessageBox(getShell(), SWT.OK | SWT.ICON_ERROR);
                        box.setText(Messages.getString("failed"));
                        String[] args = { monitorId };
                        box.setMessage(Messages.getString("message.monitor.36",args));
                        box.open();
                    }
				}
			}
    			
            int selectIndex = perfList.getTableViewer().getTable().getSelectionIndex();
            perfList.update();
            perfList.getTableViewer().getTable().setSelection(selectIndex);
		}
		else{
        	MessageBox box = new MessageBox(getShell(), SWT.OK | SWT.ICON_WARNING);
            box.setText(Messages.getString("warning"));
            box.setMessage(Messages.getString("message.monitor.1"));
            box.open();
        }
    }
}