/*
 
 Copyright (C) 2006 NTT DATA Corporation
 
 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License
 as published by the Free Software Foundation, version 2.
 
 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.
 
 */

package com.clustercontrol.performance.view;

import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;

import com.clustercontrol.performance.composite.CollectionListComposite;
import com.clustercontrol.performance.util.Messages;
import com.clustercontrol.performance.view.action.DeleteCollectedDataAction;
import com.clustercontrol.performance.view.action.ExportCollectedDataAction;
import com.clustercontrol.performance.view.action.ShowPropertyAction;
import com.clustercontrol.performance.view.action.StopCollectorAction;
import com.clustercontrol.performance.view.action.ViewCurrentGraphAction;
import com.clustercontrol.performanceMGR.bean.CollectorRunStatus;
import com.clustercontrol.view.CommonViewPart;

/**
 * μΥơΥꥹȤɽView饹
 * 
 * @version 1.0
 * @since 1.0
 */
public class CurrentListView extends CommonViewPart {
    public static final String ID = Messages.getString("VIEW_CURRENT_LIST");

    //	 ----- instance ե ----- //

    /** ݥå */
    private CollectionListComposite tableComposite = null;

    //	 ----- 󥹥ȥ饯 ----- //

    //	 ----- instance ᥽å ----- //
    
    /**
     * ơ֥ɲäޤ
     * 
     * @param parent ƤΥݥå
     */
    public void createPartControl(Composite parent) {
        GridLayout layout = new GridLayout(1, true);
        parent.setLayout(layout);
        layout.marginHeight = 0;
        layout.marginWidth = 0;

        this.tableComposite = new CollectionListComposite(parent, SWT.NONE);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.verticalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        this.tableComposite.setLayoutData(gridData);
        
        tableComposite.getTableViewer().getTable().addSelectionListener(
        new SelectionAdapter(){
			public void widgetSelected(SelectionEvent e) {
				// ơ֥򤵤Ƥξ֤ˤ
				// ӥ塼Υܥͭ/̵ꤹ
				setEnabledAction(tableComposite.getRunStatus());
			}
        });
        
        this.refresh();
    }

    /**
     * ӥ塼򹹿ޤ
     */
    public void refresh() {
        this.tableComposite.update();
    }

    /**
     * 򤵤ƤID֤ޤ
     *
     * @return 򤵤ƤCollectorID
     */
    public String getSelectedID() {
        return tableComposite.getSelectedID();
    }
    
    /**
     * ӥ塼Υͭ/̵
     * 
     * @param type
     * @since 1.0
     */
    public void setEnabledAction(int status) {
        //ӥ塼ΥΥ󥹥󥹤
        IToolBarManager toolbar = this.getViewSite().getActionBars()
                .getToolBarManager();
        ActionContributionItem stopCollectorAction = (ActionContributionItem) toolbar
                .find(StopCollectorAction.ID);
        ActionContributionItem showPropertyAction = (ActionContributionItem) toolbar
                .find(ShowPropertyAction.ID);
        ActionContributionItem viewCurrentGraphAction = (ActionContributionItem) toolbar
        		.find(ViewCurrentGraphAction.ID);
        ActionContributionItem exportCollectedDataAction = (ActionContributionItem) toolbar
                .find(ExportCollectedDataAction.ID);
        ActionContributionItem deleteCollectedDataAction = (ActionContributionItem) toolbar
                .find(DeleteCollectedDataAction.ID);
        
        // ӥ塼λѲ/ԲĤ
        // ͤ
    	stopCollectorAction.getAction().setEnabled(false);
    	showPropertyAction.getAction().setEnabled(false);
    	viewCurrentGraphAction.getAction().setEnabled(false);
    	exportCollectedDataAction.getAction().setEnabled(false);
    	deleteCollectedDataAction.getAction().setEnabled(false);
        
    	if (status == CollectorRunStatus.RUNNING) {
        	stopCollectorAction.getAction().setEnabled(true);
        	showPropertyAction.getAction().setEnabled(true);
        	viewCurrentGraphAction.getAction().setEnabled(true);
        } else if (status == CollectorRunStatus.FINISHED) {
        	showPropertyAction.getAction().setEnabled(true);
        	viewCurrentGraphAction.getAction().setEnabled(true);
        	exportCollectedDataAction.getAction().setEnabled(true);
        	deleteCollectedDataAction.getAction().setEnabled(true);
        } else if (status == CollectorRunStatus.SUSPEND) {
        	// СǤ̤ξ
        } else if (status == CollectorRunStatus.ERROR) {
        	stopCollectorAction.getAction().setEnabled(true);
        	showPropertyAction.getAction().setEnabled(true);
        	viewCurrentGraphAction.getAction().setEnabled(true);
        	exportCollectedDataAction.getAction().setEnabled(true);
        	deleteCollectedDataAction.getAction().setEnabled(true);
        }
    }
}