/*
 
 Copyright (C) 2006 NTT DATA Corporation
 
 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License
 as published by the Free Software Foundation, version 2.
 
 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.
 
 */

package com.clustercontrol.performance.view.action;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import com.clustercontrol.performance.dialog.RealtimeSetDialog;
import com.clustercontrol.performance.util.Messages;
import com.clustercontrol.performance.view.RecordGraphView;

/**
 * ѤߥǡμӤΥɽԤ󥯥饹
 * 
 * @version 1.0
 * @since 1.0
 */
public class RecordSetGraphAction implements IViewActionDelegate {

	/*
	 * ( Javadoc)
	 * 
	 * @see org.eclipse.ui.IViewActionDelegate#init(org.eclipse.ui.IViewPart)
	 */
	public void init(IViewPart view) {

	}

	/*
	 * ( Javadoc)
	 * 
	 * @see org.eclipse.ui.IActionDelegate#run(org.eclipse.jface.action.IAction)
	 */
	public void run(IAction action) {
		/*
		 * ƤӽФViewäƤޤ
		 */
		IWorkbenchPage page = PlatformUI.getWorkbench()
				.getActiveWorkbenchWindow().getActivePage();

		RecordGraphView view = (RecordGraphView) page.findView(Messages
				.getString("VIEW_RECORD_GRAPH"));

		try {
			if (view.collectorInfo.getCollectStartTime() == null) {
				return; // ⤷ʤ.
			}

			Shell shell = new Shell();
			RealtimeSetDialog dialog = new RealtimeSetDialog(shell);
			dialog.setCollectorInfo(view.collectorInfo);
			dialog.setCollectorItemInfo(view.collectorItemInfo);
			dialog.update();
			dialog.setInterval(false);

			int ret = dialog.open();

			// OKܥ󤬲줿Ȥν
			if (ret == IDialogConstants.OK_ID) {

				view.update();

			} else if (ret == IDialogConstants.CANCEL_ID) {
			}
		} catch (Exception e) {
		}

	}

	/*
	 * ( Javadoc)
	 * 
	 * @see org.eclipse.ui.IActionDelegate#selectionChanged(org.eclipse.jface.action.IAction,
	 *      org.eclipse.jface.viewers.ISelection)
	 */
	public void selectionChanged(IAction action, ISelection selection) {

	}

}