/*
 
 Copyright (C) 2006 NTT DATA Corporation
 
 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License
 as published by the Free Software Foundation, version 2.
 
 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.
 
 */

package com.clustercontrol.performance.view.action;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;

import com.clustercontrol.performance.action.RecordController;
import com.clustercontrol.performance.util.Messages;
import com.clustercontrol.performance.view.CurrentListView;

/**
 * ߤ륢󥯥饹
 * 
 * @version 1.0
 * @since 1.0
 */
public class StopCollectorAction implements IViewActionDelegate {
	public static final String ID = "com.clustercontrol.performance.view.action.StopCollectorAction";
	
    private IViewPart viewPart; // ӥ塼

    /*
     * (non-Javadoc)
     * 
     * @see org.eclipse.ui.IViewActionDelegate#init(org.eclipse.ui.IViewPart)
     */
    public void init(IViewPart view) {
        this.viewPart = view;
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.eclipse.ui.IActionDelegate#run(org.eclipse.jface.action.IAction)
     */
    public void run(IAction action) {

        /*
         * ƤӽФViewäƤޤ
         */
        IWorkbenchPage page = PlatformUI.getWorkbench()
                .getActiveWorkbenchWindow().getActivePage();
        CurrentListView currentListView = (CurrentListView) page
                .findView(Messages.getString("VIEW_CURRENT_LIST"));

        /*
         * ơ֥ФƤIDޤ
         */
        if (currentListView.getSelectedID() != null) {
    		// ʤξ硢顼ɽ
        	if(!RecordController.getInstance().checkPermissionExecute()){
        		MessageDialog.openInformation(null, com.clustercontrol.util.Messages.getString("message"),
        				com.clustercontrol.util.Messages.getString("message.accesscontrol.16"));
        		return;
        	}
        	
            String msg = Messages.getString("COLLECTION_ID") + currentListView.getSelectedID()
                    + Messages.getString("BACKSLASH_MSG_STOP_COLLECTING");

            if (MessageDialog.openQuestion(null, Messages
                    .getString("MESSAGE_0020"), msg)) {

                /*
                 * BeanäƤޤ
                 */
                RecordController controller = RecordController.getInstance();
                // ޥ͡Ȥ³˼Ԥϥ顼ɽ
                if (controller == null) {
                    MessageDialog.openError(this.viewPart.getSite().getShell(),
                            Messages.getString("MESSAGE_0020"),  // "ǧ"
                            Messages.getString("CONNECTION_ERROR_MESSAGE"));
                    return;
                }

                if (!controller.stopRecordCollector(currentListView
                        .getSelectedID())) {
                    // ߤ˼Ԥϥ顼ɽ
                    MessageDialog.openError(this.viewPart.getSite().getShell(),
                            Messages.getString("MESSAGE_0020"),  // "ǧ"
                            Messages.getString("STOP_COLLECTOR_ERROR_MESSAGE"));
                }

                //ơꥹȤΥեåԤޤ
                currentListView.refresh();
            } else {
            }
        } else {

            String msg = Messages.getString("MESSAGE_0014");

            MessageDialog.openError(null,
                    Messages.getString("ERROR_IN_JP"), msg);
        }

    }

    /*
     * (non-Javadoc)
     * 
     * @see org.eclipse.ui.IActionDelegate#selectionChanged(org.eclipse.jface.action.IAction,
     *      org.eclipse.jface.viewers.ISelection)
     */
    public void selectionChanged(IAction action, ISelection selection) {

    }

}