/*
                                                                                                                                                                 
Copyright (C) 2006 NTT DATA Corporation
                                                                                                                                                                 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.
                                                                                                                                                                 
This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.
                                                                                                                                                                 
*/

package com.clustercontrol.performanceMGR.bean;

import java.io.Serializable;
import java.util.Date;

/**
 * ǽͤǼDTO饹
 * 
 * ǽͤڥݻޤ
 * 
 * @version 1.0
 * @since 1.0
 *
 */
public class CollectedDataInfo implements Serializable {
	private String m_facilityID;
	private String m_itemCode;
	private int m_deviceIndex;
	private int m_collectorItemID;
	private Date m_date;
	private double m_value;

	/**
	 * ꤵ줿եƥIDIDǼCollectedDataInfo֥Ȥޤ
	 * 
	 * @param facilityID եƥID
	 * @param deviceIndex ID
	 */
	public CollectedDataInfo(final String facilityID, final String itemCode, final int deviceIndex){
		this.m_facilityID = facilityID;
		this.m_itemCode = itemCode;
		this.m_deviceIndex = deviceIndex;
	}
	
	/**
	 * ꤵ줿եƥIDIDǼCollectedDataInfo֥Ȥޤ
	 * 
	 * @param facilityID եƥID
	 * @param collectorItemID ID
	 */
	public CollectedDataInfo(final String facilityID, final int collectorItemID){
		m_facilityID = facilityID;
		m_collectorItemID = collectorItemID;
	}
	
	/**
	 * ꤵ줿CollectedDataInfo󥹥󥹤ȤCollectedDataInfo֥Ȥޤ
	 * 
	 * @param collectorItemInfo 
	 */
	public CollectedDataInfo(final CollectorItemInfo collectorItemInfo){
		m_collectorItemID = collectorItemInfo.getCollectorItemID();
	}
	
	/**
	 * ꤵ줿եƥIDIDǽͤǼCollectedDataInfo֥Ȥޤ
	 * 
	 * @param facilityID եƥID
	 * @param collectorItemID ID
	 * @param date 
	 * @param value ǽ
	 */
	public CollectedDataInfo(final String facilityID, final int collectorItemID, final Date date, final double value){
		m_facilityID = facilityID;
		m_collectorItemID = collectorItemID;
		m_date = date;
		m_value = value;
	}
	
	/**
	 * ꤵ줿CollectedDataInfoƱͤݻ륪֥Ȥޤ
	 * 
	 * @param dataInfo ǡå
	 */
	public CollectedDataInfo(final CollectedDataInfo dataInfo){
		m_facilityID = dataInfo.getFacilityID();
		m_collectorItemID = dataInfo.getCollectorItemID();
		m_date = dataInfo.getDate();
		m_value = dataInfo.getValue();
	}
	
	/**
	 * ID ޤ
	 * @return ID 
	 */
	public int getCollectorItemID() {
		return m_collectorItemID;
	}
	
	/**
	 * եƥID ޤ
	 * @return եƥID
	 */
	public String getFacilityID() {
		return m_facilityID;
	}
	
	/**
	 *  ޤ
	 * @return 
	 */
	public Date getDate() {
		return m_date;
	}
	
	/**
	 * ǽ ޤ
	 * @return  ǽ
	 */
	public double getValue() {
		return m_value;
	}
	
	/**
	 *  ꤷޤ
	 * @param date  
	 */
	public void setDate(Date date) {
		m_date = date;
	}
	
	/**
	 * ǽ ꤷޤ
	 * @param value ǽ
	 */
	public void setValue(double value) {
		m_value = value;
	}
	/**
	 * facilityID ꤷޤ
	 * @param facilityid եƥID
	 */
	public void setFacilityID(String facilityid) {
		m_facilityID = facilityid;
	}

	/**
	 * ǥХֹޤ
	 * @return
	 */
	public int getDeviceIndex() {
		return m_deviceIndex;
	}

	/**
	 * ǥХֹꤷޤ
	 * @param deviceIndex ǥХֹ
	 */
	public void setDeviceIndex(int deviceIndex) {
		this.m_deviceIndex = deviceIndex;
	}

	/**
	 * ܥɤޤ
	 * @return ܥ
	 */
	public String getItemCode() {
		return m_itemCode;
	}

	/**
	 * ܥɤꤷޤ
	 * @param itemCode ܥ
	 */
	public void setItemCode(String itemCode) {
		this.m_itemCode = itemCode;
	}
	
	/**
	 * ǡƤʸȤ֤ޤ
	 */
	public String toString(){
		String str =
			"FID:" + m_facilityID + 
			"  Item:" +  m_itemCode +
			"." + m_deviceIndex +
			"  " + m_date + 
			" : " + m_value;
		return str;
	}
}
