/*
                                                                                                                                                                 
Copyright (C) 2006 NTT DATA Corporation
                                                                                                                                                                 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.
                                                                                                                                                                 
This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.
                                                                                                                                                                 
*/

package com.clustercontrol.performanceMGR.bean;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

/**
 * ʣμѤǽͤΥꥹȡCollectedDataInfoΥꥹȡˤޤȤݻ륯饹Ǥ
 * եƥIDȼܤΣĤ򥭡ȤơѤǽͤΥꥹȤ뤳Ȥޤ
 * @version 1.0
 * @since 1.0
 */
public class CollectedDataSet implements Serializable {
	private HashMap dataMap;
	
	/**
	 * 󥹥ȥ饯
	 *
	 */
	public CollectedDataSet(){
		dataMap = new HashMap();
	}
	
	/**
	 * ΥեƥIDȼID򥭡˼ѤǽͥǡΥꥹȤϿޤ
	 * 
 	 * @param facilityID եƥID
	 * @param collectionItemID ID
	 * @param data ǽͥǡΥꥹ
	 */
	public void setCollectedDataList(String facilityID, int collectionItemID, List data){
		HashMap subDataMap = (HashMap)dataMap.get(facilityID);
		
		if(subDataMap == null){
			// ΥեƥIDΥǡϽƤϿǤ뤿ῷ
			subDataMap = new HashMap();
		}
		subDataMap.put(Integer.toString(collectionItemID), data);
		
		dataMap.put(facilityID, subDataMap);
	}
	
	/**
	 * ߤǽͥǡΥåȤˡ
	 * CollectedDataSetμѤǽͥǡɲäޤ
	 * Ʊ facilityID, collectionItemId ΥǡϾ񤭤ޤ
	 * 
 	 * @param dataSet ɲäǽͥǡ
	 */
	public void addCollectedDataList(CollectedDataSet dataSet){
		Set facilityIDSet = dataSet.dataMap.keySet();
		Iterator fItr = facilityIDSet.iterator();
		
		while(fItr.hasNext()){
			String facilityID = (String)fItr.next();

			HashMap subDataMap = (HashMap)dataSet.dataMap.get(facilityID);
			Set itemIDSet = subDataMap.keySet();		
			Iterator iItr = itemIDSet.iterator();			
			
			while(iItr.hasNext()){
				String collectionItemID = (String)iItr.next();
				
				// ܤؤȤΥǡ
				List dataList = dataSet.getCollectedDataList(facilityID, Integer.parseInt(collectionItemID));
				
				// ǡ򥻥åȤ
				setCollectedDataList(facilityID, Integer.parseInt(collectionItemID), dataList);
			}
		}
	}
	
	/**
	 * ΥեƥIDȼID򥭡˼Ѥǽ;ΥꥹȤޤ
	 * 
	 * @param facilityID եƥID
	 * @param collectionItemID ID
	 * @return ǽͥǡΥꥹ
	 */
	public List getCollectedDataList(String facilityID, int collectionItemID){
		HashMap subDataMap = (HashMap)dataMap.get(facilityID);
		if(subDataMap != null){
			return (List)subDataMap.get(Integer.toString(collectionItemID));
		} else {
			// ΥꥹȤ֤
			return new ArrayList();
		}
	}
	
	/**
	 * ΥեƥIDϿƤѤߥǡꥹȤοޤ
	 * 
	 * @param facilityID եƥID
	 * @return ΥեƥIDϿƤѤߥǡꥹȤο
	 */
	public int getDataListNum(String facilityID){
		HashMap subDataMap = (HashMap)dataMap.get(facilityID);
		if(subDataMap != null){
			return subDataMap.size();
		} else {
			return 0;
		}
	}
}
