/*
                                                                                                                                                                 
Copyright (C) 2006 NTT DATA Corporation
                                                                                                                                                                 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.
                                                                                                                                                                 
This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.
                                                                                                                                                                 
*/

package com.clustercontrol.performanceMGR.bean;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

/**
 * ˴ޤޤեƥΥǥХ򽸤᤿DTO饹<P>
 * 
 * ץѥƥ򥯥饤¦ɽݤˤϡΥǥХ
 * ɬפȤʤΤǡξ򥻥åȤǤꤹ뤿Υ饹
 * 
 * @version 1.0
 * @since 1.0
 */
public class DeviceDataSet implements Serializable {
	private HashMap deviceMap;
	
	/**
	 * 󥹥ȥ饯
	 *
	 */
	public DeviceDataSet(){
		deviceMap = new HashMap();
	}
	
	/**
	 * ǥХϿޤ
	 * 
	 * @param deviceDataġΥǥХ
	 */
	public void putDeviceList(DeviceData deviceData){
		String facilitID = deviceData.getFacilityId();
		String deviceType = deviceData.getDeviceType();
		
		HashMap facilityDeviceMap = getFacilityDeviceMap(facilitID);
		// ΥեƥIDǤϿƤξ
		if(facilityDeviceMap == null){
			// եƥID򥭡Ͽ
			facilityDeviceMap = new HashMap();
			deviceMap.put(facilitID, facilityDeviceMap);
		}
		
		ArrayList deviceList = (ArrayList)facilityDeviceMap.get(deviceType);
		// ΥǥХ̤ǤϿƤξ
		if(deviceList == null){
			// ǥХ̤򥭡Ͽ
			deviceList = new ArrayList();
			facilityDeviceMap.put(deviceType, deviceList);
		}
		// ǥХɲ
		deviceList.add(deviceData);
	}
	
	/**
	 * եƥݻƤ
	 * ǥХΥꥹȤޤ
	 * 
	 * ¸ߤʤnull֤
	 * 
	 * @param facilityID եƥ
	 * @param deviceTypeǥХ "Disk" or "Nic"
	 * @returnlist Disk ޤ Nic ΥǥХΥꥹ
	 */
	public List getDeviceList(String facilityID, String deviceType){
		HashMap facilityDeviceMap = getFacilityDeviceMap(facilityID);
		if(facilityDeviceMap != null){
			return getDeviceList(facilityDeviceMap, deviceType);
		} else {
			return null;
		}
	}
	/**
	 * եƥʥΡɡˤݻƤǥХ
	 * ΥǥХ̤diskΤΤΥꥹȤޤ
	 * 
	 * ¸ߤʤnull֤
	 * @param  facilityID եƥID
	 * @returnlistDisk˴ؤǥХΥꥹ
	 */
	public List getDisk(String facilityID){
		return getDeviceList(facilityID, "disk");
	}
	/**
	 * եƥʥΡɡˤݻƤǥХ
	 * ΥǥХ̤nicΤΤΥꥹȤޤ
	 * 
	 * ¸ߤʤnull֤
	 * 
	 * @param  facilityID եƥID
	 * @returnlistNIC˴ؤǥХΥꥹ
	 */
	public List getNic(String facilityID){
		return getDeviceList(facilityID, "nic");
	}
	
	/**
	 * Υ󥹥󥹤ݻƤƤΥǥХ֤ޤ
	 * 
	 * @returnlistǥХΥꥹ
	 */
	public List getAll(){
		ArrayList deviceList = new ArrayList();
		
		Set keys = deviceMap.keySet();
		
		Iterator itr = keys.iterator();
		
		while(itr.hasNext()){
			String facilitID = (String)itr.next();
			HashMap facilityDeviceMap = getFacilityDeviceMap(facilitID);
			Collection dl = facilityDeviceMap.values();
			Iterator itrDl = dl.iterator();
			
			while(itrDl.hasNext()){
				deviceList.addAll((ArrayList)(itrDl.next()));
			}
		}
		
		return deviceList;
	}
	
	/**
	 * եƥΥǥХݻϥåޥåפ֤ޤ
	 * 
	 * @param facilityIDեƥID
	 * @returnHashMap եƥбǥХΤHashMap
	 */
	private HashMap getFacilityDeviceMap(String facilityID){
		return (HashMap)deviceMap.get(facilityID);
	}
	
	/**
	 * ǥХޥåפΥǥХפ˹פΤΥꥹȤ֤ޤ
	 * 
	 * @param facilityDeviceMap
	 * @param deviceType
	 * @return
	 */
	private ArrayList getDeviceList(HashMap facilityDeviceMap, String deviceType){
		return (ArrayList)facilityDeviceMap.get(deviceType);
	}
}
