/*
 
 Copyright (C) 2006 NTT DATA Corporation
 
 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License
 as published by the Free Software Foundation, version 2.
 
 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.
 
 */

package com.clustercontrol.performanceMGR.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import javax.ejb.CreateException;
import javax.ejb.DuplicateKeyException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.performanceMGR.ejb.bmp.CollectorDAO;
import com.clustercontrol.performanceMGR.ejb.bmp.CollectorPK;
import com.clustercontrol.performanceMGR.ejb.bmp.CollectorBean;
import com.clustercontrol.performanceMGR.util.ConnectionManager;


/**
 * DBԤ饹
 * 
 * EJBEntutyBeanCollectorDAOμ饹
 * 
 * @version 2.0.0
 * @since 1.0
 */
public class CollectorDAOImpl implements CollectorDAO {
	//
	protected static Log m_log = LogFactory.getLog( CollectorDAOImpl.class );
	
	/**
	 * 󥹥ȥ饯
	 */
	public CollectorDAOImpl() {
		m_log.trace("󥹥ȥ饯 in CollectorDAO");
	}
	/* ( Javadoc)
	 * @see com.clustercontrol.performanceMGR.ejb.CollectorDAO#init()
	 */
	/**
	 * Ԥ
	 */
	public void init() {
		
		m_log.trace("init CollectorDAO");
	}
	
	/* ( Javadoc)
	 * @see com.clustercontrol.performanceMGR.ejb.CollectorDAO#load(com.clustercontrol.performanceMGR.ejb.CollectorPK, com.clustercontrol.performanceMGR.ejb.RecordCollectorBean)
	 */
	/**
	 * EntityBeanɬפȤʤload᥽å
	 * EntityBeanDBΥǡ˹
	 * @param pk PK
	 * @param ejb ƱԤEntityBean
	 */
	public void load(CollectorPK pk, CollectorBean ejb)
	throws EJBException {	
		m_log.debug("load() start : " + pk.getCollectorID());
	
		Connection conn = null;
		PreparedStatement stmt = null;
		ResultSet res = null;
		try {
			conn = ConnectionManager.getConnectionManager().getConnection();
			//SQLʸ
			String sql = "SELECT * FROM COLLECTOR_PROFILE WHERE COLLECTORID = ?";
			//SQLʸΥå
			stmt = conn.prepareStatement(sql);
			
			stmt.setString(1,pk.collectorID );
			
			res = stmt.executeQuery();
			
			if (res.next()) {
				//ͤBean˥å
				ejb.setCollectorID(res.getString("COLLECTORID"));
				ejb.setCollectorType(res.getShort("COLLECTOR_TYPE"));
				ejb.setLabel(res.getString("LABEL"));
				
				Timestamp startTimestamp= res.getTimestamp("START_DATE");    			
				if(startTimestamp != null){
					ejb.setStartTime(startTimestamp.getTime());
				} else {
					ejb.setStartTime(0);
				}
				Timestamp stopTimestamp= res.getTimestamp("STOP_DATE");
				if(stopTimestamp != null){
					ejb.setStopTime(stopTimestamp.getTime());
				} else {
					ejb.setStopTime(0);
				}
				
				// եƥID
				ejb.setFacilityID(res.getString("TARGET_FACILITYID"));
				
				// ꥢ륿ʹƻξϡݥȥ꤫顢
				// ӼξϡDBĥ꡼ScopeTree֥Ȥꤹ롣
				ejb.updateScopeTree();
				
				ejb.setScopePath(res.getString("SCOPE_PATH"));
				ejb.setInterval(res.getInt("INTERVAL"));
				ejb.setPeriod(res.getInt("PERIOD"));
				ejb.setPresavePeriod(res.getInt("PRESAVE_PERIOD"));
				
				// ܤDB
				ejb.setCollectorItems(pk.collectorID);
			}else{	
				String msg = "Collector data is not found.";
				m_log.error("load() error : " + pk.getCollectorID() + " SQLException " + msg);
				throw new EJBException(msg);
			}
		} catch (SQLException e) {
			m_log.error("load() error : " + pk.getCollectorID() + " SQLException");
			throw new EJBException(e.getMessage());
		}  finally{
//			ͥ󡢷̥åȡץڥɥơȥȤΥ
			try {
				if(stmt != null){
					stmt.close();}
				if(res != null){
					res.close();}
				if(conn != null){
					conn.close();
				}
			} catch (SQLException e1) {
				m_log.error("load() error : " + pk.getCollectorID() + " SQLException");
				throw new EJBException(e1.getMessage());
			}
		}
		
		m_log.debug("load() end   : " + pk.getCollectorID());		
	}
	
	/* ( Javadoc)
	 * @see com.clustercontrol.performanceMGR.ejb.CollectorDAO#store(com.clustercontrol.performanceMGR.ejb.RecordCollectorBean)
	 */
	/**
	 * EntityBeanɬפȤʤstore᥽å
	 * EntityBeandeDBΥǡ򹹿
	 * @param ejb ¸EntityBean
	 */
	public void store(CollectorBean ejb) throws EJBException {
		m_log.debug("store() start : " + ejb.getCollectorID());
		
		Connection conn = null;
		PreparedStatement stmt = null;
		try {
			conn = ConnectionManager.getConnectionManager().getConnection();
			//SQLʸ
			String sql = "UPDATE COLLECTOR_PROFILE SET " +
			"COLLECTOR_TYPE = ?," +
			"LABEL = ?," +
			"START_DATE = ?," +
			"STOP_DATE = ?," +
			"TARGET_FACILITYID = ?," +
			"SCOPE_PATH = ?," +
			"INTERVAL = ?," +
			"PERIOD = ?," +
			"PRESAVE_PERIOD = ? " +
			"WHERE COLLECTORID = ?";
			
			//SQLʸΥå
			stmt = conn.prepareStatement(sql);
			
			stmt.setShort(1, (short)ejb.getCollectorType());
			stmt.setString(2, ejb.getLabel());
			
			Date startDate = ejb.getStartDate();
			if(startDate != null){
				stmt.setTimestamp(3, new Timestamp(startDate.getTime()));	
			} else {
				stmt.setTimestamp(3, null);				
			}
			
			Date stopDate = ejb.getStopDate();
			if(stopDate != null){
				stmt.setTimestamp(4, new Timestamp(stopDate.getTime()));	
			} else {
				stmt.setTimestamp(4, null);				
			}
			
			stmt.setString(5, ejb.getFacilityID());
			stmt.setString(6, ejb.getScopePath());
			stmt.setInt(7, ejb.getInterval());
			stmt.setInt(8, ejb.getPeriod());
			stmt.setInt(9, ejb.getPresavePeriod());
			stmt.setString(10, ejb.getCollectorID());
			
			int row = stmt.executeUpdate();
			
			if (row != 1) {	
				String msg = "result row is not 1";
				m_log.error("store() error : " + ejb.getCollectorID() + " SQLException" + msg);
				throw new EJBException(msg);
			}
		} catch (SQLException e) {
			m_log.error("store() error : " + ejb.getCollectorID() + " SQLException");
			e.printStackTrace();
			throw new EJBException(e.getMessage());
		}finally{
//			ͥ󡢷̥åȡץڥɥơȥȤΥ
			try {
				if(stmt != null){
					stmt.close();
				}
				if(conn != null){
					conn.close();
				}
			} catch (SQLException e1) {
				m_log.error("store() error : " + ejb.getCollectorID() + " SQLException");
				e1.printStackTrace();
				throw new EJBException(e1.getMessage());
			}
		}
		
		m_log.debug("store() end   : " + ejb.getCollectorID());
	}	
	
	/* ( Javadoc)
	 * @see com.clustercontrol.performanceMGR.ejb.CollectorDAO#remove(com.clustercontrol.performanceMGR.ejb.CollectorPK)
	 */
	/**
	 * EntityBeanɬפȤʤremove᥽å
	 * DBΥǡ
	 * @param pkԤpk֥
	 */
	public void remove(CollectorPK pk) throws EJBException {
		m_log.debug("remove()  start: " + pk.getCollectorID());
		
		Connection conn = null;
		PreparedStatement stmt = null;
		try {
			conn = ConnectionManager.getConnectionManager().getConnection();
			
			//SQLʸ
			String sql = "DELETE  FROM  COLLECTOR_PROFILE WHERE COLLECTORID = ? ";
			//SQLʸΥå
			stmt = conn.prepareStatement(sql);
			
			stmt.setString(1,pk.collectorID );
			
			int row = stmt.executeUpdate();
			
			if (row != 1 ) {
				String msg = "result row is not 1";
				m_log.error("remove() error : " + pk.toString() + " SQLException" + msg);
				throw new EJBException(msg);	
			}
		} catch (SQLException e) {
			m_log.error("remove() error : " + pk.toString() + " SQLException");
			throw new EJBException(e.getMessage());
			
		} finally {
			try {
				if(stmt != null){
					stmt.close();
				}
				if(conn != null){
					conn.close();
				}
			} catch (SQLException e1) {
				m_log.error("remove() error : " + pk.toString() + " SQLException");
				throw new EJBException(e1.getMessage());
			}
			
		}
		m_log.debug("remove() end   : " + pk.getCollectorID());
	}
	
	/* ( Javadoc)
	 * @see com.clustercontrol.performanceMGR.ejb.CollectorDAO#create(com.clustercontrol.performanceMGR.ejb.RecordCollectorBean)
	 */
	/**
	 * EntityBeanɬפȤʤcreate᥽å
	 * DB¸ߤʤEntityBeanݤDB˥󥵡Ȥ
	 * @param ejb 󥵡ȤEntityBean֥
	 * @return DBǥ쥳ɤռ̤pk֥
	 */
	public CollectorPK create(CollectorBean ejb) throws CreateException,
	EJBException ,DuplicateKeyException{
		
		m_log.debug("create() start : " + ejb.getCollectorID());

		Connection conn = null;
		PreparedStatement stmt = null;
		CollectorPK pk;
		try {
			conn = ConnectionManager.getConnectionManager().getConnection();
			//SQLʸ
			String sql = "INSERT INTO COLLECTOR_PROFILE " +
			"(collectorID, " +
			"COLLECTOR_TYPE, " +
			"LABEL," +
			"START_DATE," +
			"STOP_DATE," +
			"TARGET_FACILITYID," +
			"SCOPE_PATH," +
			"INTERVAL," +
			"PERIOD," +
			"PRESAVE_PERIOD)" +
			"values (?,?,?,?,?,?,?,?,?,?);";
			
			//SQLʸΥå
			stmt = conn.prepareStatement(sql);
			
			stmt.setString(1,ejb.getCollectorID());
			stmt.setShort(2,(short)ejb.getCollectorType());
			stmt.setString(3,ejb.getLabel());
			if(ejb.getStartDate() != null){
				stmt.setTimestamp(4, new Timestamp(ejb.getStartDate().getTime()));
			} else {
				stmt.setTimestamp(4, null);    			
			}
			if(ejb.getStopDate() != null){
				stmt.setTimestamp(5, new Timestamp(ejb.getStopDate().getTime()));
			} else {
				stmt.setTimestamp(5, null);    			
			}
			stmt.setString(6,  ejb.getFacilityID());
			stmt.setString(7,  ejb.getScopePath());
			stmt.setInt(8,  ejb.getInterval());
			stmt.setInt(9, ejb.getPeriod());
			stmt.setInt(10, ejb.getPresavePeriod());
			
			int row =	stmt.executeUpdate();
			pk = new CollectorPK(ejb.getCollectorID());
			
			if (row != 1) {
				String msg = "result row is not 1";
				m_log.error("create() error : " + ejb.getCollectorID() + " SQLException");
				throw new EJBException(msg);
			}
		} catch (SQLException e) {
			if(e.getSQLState().equals("23505")){
				m_log.error("create() error : " + ejb.getCollectorID() + " SQLException" + "DuplicateKeyException ");
				throw new DuplicateKeyException(e.getMessage());
			}
			throw new CreateException(e.getMessage());
		}finally{
			try {
				if(stmt != null){
					stmt.close();
				}
				if(conn != null){
					conn.close();
				}
			} catch (SQLException e1) {
				m_log.error("create() error : " + ejb.getCollectorID() + " SQLException");
				throw new EJBException(e1.getMessage());
			}
		}
		m_log.debug("create() end   : " + ejb.getCollectorID());
		return pk;
	}
	
	/* ( Javadoc)
	 * @see com.clustercontrol.performanceMGR.ejb.CollectorDAO#findByPrimaryKey(java.lang.String)
	 */
	/**
	 *  EntityBeanɬפȤʤfindByPrimaryKey᥽å
	 * 饤Ȥ׵᤬äȤˤΥ֥Ȥ줤뤫å
	 * ¸ߤƤСռ̻ҤǤpk֥Ȥ֤
	 * @param pk ռ̻Ҥpk֥
	 * @return pk ռ̻Ҥpk֥
	 * @throws FinderException
	 */
	public CollectorPK findByPrimaryKey(CollectorPK pk) throws FinderException {		
		m_log.debug("findbyPK() start : " + pk.getCollectorID());

		Connection conn = null;
		PreparedStatement stmt = null;
		ResultSet res = null;
		try {
			conn = ConnectionManager.getConnectionManager().getConnection();
			//SQLʸ
			String sql = "SELECT * FROM COLLECTOR_PROFILE WHERE COLLECTORID = ?";
			//SQLʸΥå
			stmt = conn.prepareStatement(sql);
			
			stmt.setString(1,pk.collectorID );
			
			res = stmt.executeQuery();
			
			if (res.next()) {
				return pk;
			} else {
				String msg = "id " + pk.getCollectorID() + " not found.";
				throw new FinderException(msg);
			}
		} catch (SQLException e) {
			m_log.error("find() error : " + pk.toString() + " SQLException");
			throw new EJBException(e.getMessage());
		}  finally{
			try {
				if(stmt != null){
					stmt.close();}
				if(res != null){
					res.close();}
				if(conn != null){
					conn.close();
				}
			} catch (SQLException e1) {
				m_log.error("find() error : " + pk.toString() + " SQLException");
				throw new EJBException(e1.getMessage());
			}
			
			m_log.debug("findbyPK() end : " + pk.getCollectorID());
		}
	}
	
	/* ( Javadoc)
	 * @see com.clustercontrol.performanceMGR.ejb.CollectorDAO#findAll()
	 */
	/**
	 * DB¸ߤƤμ
	 * @return ռ̻ҤpkΥ쥯
	 */
	public Collection findAll() throws EJBException {
		
		m_log.debug("findAll() start : ");
		
		ArrayList<CollectorPK> ret = new ArrayList<CollectorPK>();
		
		Connection conn = null;
		PreparedStatement stmt = null;
		ResultSet res = null;
		try {
			conn = ConnectionManager.getConnectionManager().getConnection();	
			//SQLʸ
			String sql = "SELECT * FROM COLLECTOR_PROFILE ORDER BY START_DATE";
			//SQLʸΥå
			stmt = conn.prepareStatement(sql);
			res = stmt.executeQuery();
			
			while(res.next()) {
				CollectorPK pk=  new CollectorPK(res.getString("COLLECTORID"));
				ret.add(pk);
			}
			
		} catch (SQLException e) {
			m_log.error("findAll() error :  SQLException");
			throw new EJBException(e.getMessage());
		}  finally{
			try {
				if(stmt != null){
					stmt.close();}
				if(res != null){
					res.close();}
				if(conn != null){
					conn.close();
				}
			} catch (SQLException e1) {
				m_log.error("findAll() error :  SQLException");
				throw new EJBException(e1.getMessage());
			}
		}
		m_log.debug("findAll() end : ");
		return ret;
	}
	
	/* ( Javadoc)
	 * @see com.clustercontrol.performanceMGR.ejb.CollectorDAO#findByStatus(int)
	 */
	/**
	 * ̤˳EntityBean򸡺᥽å
	 * @param status 
	 * @return ռ̻ҤpkΥ쥯
	 */
	public Collection findByCollectorType(int type) throws EJBException {
		m_log.debug("findCollectorType() start : ");
		ArrayList<CollectorPK> ret = new ArrayList<CollectorPK>();
		
		Connection conn = null;
		PreparedStatement stmt = null;
		ResultSet res = null;
		try {
			conn = ConnectionManager.getConnectionManager().getConnection();
			//SQLʸ
			String sql = 
				"SELECT * FROM COLLECTOR_PROFILE WHERE COLLECTOR_TYPE = ? ORDER BY START_DATE";
			//SQLʸΥå
			stmt = conn.prepareStatement(sql);
			stmt.setShort(1,(short)type);
			res = stmt.executeQuery();
			
			while(res.next()) {
				CollectorPK pk = new CollectorPK(res.getString("COLLECTORID"));	
				ret.add(pk);
			}
		} catch (SQLException e) {
			m_log.error("findByCollectorType() error :  SQLException");
			throw new EJBException(e.getMessage());
		}  finally{
			try {
				if(stmt != null){
					stmt.close();}
				if(res != null){
					res.close();}
				if(conn != null){
					conn.close();
				}
			} catch (SQLException e1) {
				m_log.error("findByCollectorType() error :  SQLException");
				throw new EJBException(e1.getMessage());
			}
		}
		m_log.debug("findbyCollectorType() end : ");
		return ret;
	}
	/**
	 * 
	 * @return
	 * @throws EJBException
	 */
	public Collection findByPresave() throws EJBException {
		
		m_log.debug("findByPresave() start : ");
		
		ArrayList<CollectorPK> ret = new ArrayList<CollectorPK>();
		
		Connection conn = null;
		PreparedStatement stmt = null;
		ResultSet res = null;
		try {
			conn = ConnectionManager.getConnectionManager().getConnection();
			//SQLʸ
			String sql = "SELECT * FROM COLLECTOR_PROFILE " +
						  "WHERE COLLECTOR_TYPE = 2 " +
						  "AND PERIOD=-1 " +
						  "AND STOP_DATE is null";
			
			//COLLECTOR_TYPE=2 :Ӽ (01ꥢ륿ࡢ3ʹƻ)
			//PERIOD=-1        :¤ꤷʤǤ롣
			//STOP_DATE is null   :Ǥ롣
			
			//SQLʸΥå
			stmt = conn.prepareStatement(sql);
			res = stmt.executeQuery();
			
			while(res.next()) {
				CollectorPK pk = new CollectorPK(res.getString("COLLECTORID"));
				m_log.debug("unlimit collector pk : " + pk.toString());
				ret.add(pk);
			}
		} catch (SQLException e) {
			m_log.error("findByCollectorType() error :  SQLException");
			throw new EJBException(e.getMessage());
		}  finally{
			try {
				if(stmt != null){
					stmt.close();}
				if(res != null){
					res.close();}
				if(conn != null){
					conn.close();
				}
			} catch (SQLException e1) {
				m_log.error("findByCollectorType() error :  SQLException");
				throw new EJBException(e1.getMessage());
			}
		}
		m_log.debug("findbyCollectorType() end : ");
		return ret;
	}
}
