/*
                                                                                                                                                                 
Copyright (C) 2006 NTT DATA Corporation
                                                                                                                                                                 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.
                                                                                                                                                                 
This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.
                                                                                                                                                                 
*/

package com.clustercontrol.performanceMGR.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;

import javax.ejb.CreateException;
import javax.ejb.DuplicateKeyException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.performanceMGR.ejb.bmp.CollectorStatusDAO;
import com.clustercontrol.performanceMGR.ejb.bmp.CollectorStatusBean;
import com.clustercontrol.performanceMGR.ejb.bmp.CollectorStatusPK;
import com.clustercontrol.performanceMGR.util.ConnectionManager;


/**
 * ơDBԤ饹
 * 
 * EJBEntityBeanCollectorStatusDAOμ饹
 * 
 * @version 1.0
 * @since 1.0
 */
public class CollectorStatusDAOImpl implements CollectorStatusDAO{
	//
	protected static Log m_log = LogFactory.getLog( CollectorStatusDAO.class );
	
	/**
	 * 󥹥ȥ饯
	 */
	public CollectorStatusDAOImpl(){

	}
	
	/**
	 * Ԥʤ
	 */
	public void init() {
		
		m_log.trace("init CollectorStatusDAO");
	}
	
	/**
	 * EntityBeanɬפȤʤload᥽å
	 * EntityBeanDBΥǡ˹
	 * @param pk PK
	 * @param ejb ƱԤEntityBean
	 */
	public void load(CollectorStatusPK pk, CollectorStatusBean ejb)
	throws EJBException {
		
		m_log.debug("load() start : " + pk.getCollectorID());
		
		Connection conn = null;
		PreparedStatement stmt = null;
		ResultSet res = null;
		try {
			conn = ConnectionManager.getConnectionManager().getConnection();
			
			//SQLʸ
			String sql = "SELECT * FROM COLLECTOR_STATUS WHERE COLLECTORID = ?";
			//SQLʸΥå
			stmt = conn.prepareStatement(sql);
			
			stmt.setString(1, pk.collectorID );
			
			res = stmt.executeQuery();
			
			if (res.next()) {
				//ͤBean˥å
				ejb.setCollectorID(res.getString("COLLECTORID"));
				ejb.setRunStatus(res.getShort("RUN_STATUS"));			
				ejb.setErrorStatus(res.getShort("ERROR_STATUS"));
				ejb.setEndStatus(res.getShort("END_STATUS"));
				ejb.setCount(res.getInt("COUNT"));
				Timestamp timestamp = res.getTimestamp("LAST_COLLECT_DATE");
				if(timestamp != null){
					ejb.setLastCollectDate(new Date(timestamp.getTime()));
				} else {
					ejb.setLastCollectDate(null);
				}
			}else{	
				String msg = "CollectorStatus data is not found.";
				m_log.error("load() error : " + pk.getCollectorID() + " SQLException " + msg);
				throw new EJBException(msg);
			}
		} catch (SQLException e) {
			m_log.error("load() error : " + pk.getCollectorID() + " SQLException");
			throw new EJBException(e.getMessage());
		}  finally{
			//ͥ󡢷̥åȡץڥɥơȥȤΥ
			try {
				if(stmt != null){
					stmt.close();}
				if(res != null){
					res.close();}
				if(conn != null){
					conn.close();
				}
			} catch (SQLException e1) {
				m_log.error("load() error : " + pk.getCollectorID() + " SQLException");
				throw new EJBException(e1.getMessage());
			}
		}
		m_log.debug("load() end   : " + pk.getCollectorID());	
	}
	
	/**
	 *  EntityBeanɬפȤʤstore᥽å
	 */
	public void store(CollectorStatusBean ejb) 
	throws EJBException{
		
		m_log.debug("store() start :" + ejb.getCollectorID());

		Connection conn = null;
		PreparedStatement stmt = null;
		try {
			conn = ConnectionManager.getConnectionManager().getConnection();
			//SQLʸ
			String sql = "UPDATE COLLECTOR_STATUS SET " +
			"RUN_STATUS = ?," +
			"ERROR_STATUS = ?," +
			"END_STATUS = ?," +
			"COUNT = ?," +
			"LAST_COLLECT_DATE = ? " +
			"WHERE COLLECTORID = ?";
						
			//SQLʸΥå
			stmt = conn.prepareStatement(sql);
			
			stmt.setShort(1, (short)ejb.getRunStatus());			
			stmt.setShort(2, (short)ejb.getErrorStatus());
			stmt.setShort(3, (short)ejb.getEndStatus());
			stmt.setInt(4, ejb.getCount());
			
			Date lastCollectDate = ejb.getLastCollectDate();
			if(lastCollectDate != null){
				stmt.setTimestamp(5, new Timestamp(lastCollectDate.getTime()));
			} else {
				stmt.setTimestamp(5, null);
			}

			stmt.setString(6, ejb.getCollectorID());
			
			int row = stmt.executeUpdate();
			
			if (row != 1) {	
				String msg = "result row is not 1";
				m_log.error("store() error : " + ejb.getCollectorID() + " SQLException" + msg);
				throw new EJBException(msg);
			}
		} catch (SQLException e) {
			m_log.error("store() error : " + ejb.getCollectorID() + " SQLException");
			throw new EJBException(e.getMessage());
		} finally {
			//ͥ󡢷̥åȡץڥɥơȥȤΥ
			try {
				if(stmt != null){
					stmt.close();
				}
				if(conn != null){
					conn.close();
				}
			} catch (SQLException e1) {
				m_log.error("store() error : " + ejb.getCollectorID() + " SQLException");
				throw new EJBException(e1.getMessage());
			}
		}
		
		m_log.debug("store() end   :" + ejb.getCollectorID());		
	}
	
	/**
	 * EntityBeanɬפȤʤremove᥽å
	 * DBΥǡ
	 * @param pkԤpk֥
	 */
	public void remove(CollectorStatusPK pk) throws EJBException {
		m_log.debug("remove()  start: " + pk.getCollectorID());
		
		Connection conn = null;
		PreparedStatement stmt = null;
		
		try {
			conn = ConnectionManager.getConnectionManager().getConnection();
			
			//SQLʸ
			String sql = "DELETE FROM COLLECTOR_STATUS WHERE COLLECTORID = ? ";
			//SQLʸΥå
			stmt = conn.prepareStatement(sql);
			
			stmt.setString(1,pk.collectorID );
			
			int row = stmt.executeUpdate();
			
			if (row != 1 ) {
				String msg = "result row is not 1";
				m_log.error("remove() error : " + pk.toString() + " SQLException" + msg);
				throw new EJBException(msg);	
			}
		} catch (SQLException e) {
			m_log.error("remove() error : " + pk.toString() + " SQLException");
			throw new EJBException(e.getMessage());
			
		} finally {
			
			//ͥ󡢷̥åȡץڥɥơȥȤΥ
			try {
				if(stmt != null){
					stmt.close();
				}
				if(conn != null){
					conn.close();
				}
			} catch (SQLException e1) {
				m_log.error("remove() error : " + pk.toString() + " SQLException");
				throw new EJBException(e1.getMessage());
			}
			
		}
		m_log.debug("remove() end : " + pk.getCollectorID());
	}
	
	/**
	 * EntityBeanɬפȤʤcreate᥽å
	 * DB¸ߤʤEntityBeanݤDB˥󥵡Ȥ
	 * @param ejb 󥵡ȤEntityBean֥
	 * @return DBǥ쥳ɤռ̤pk֥
	 */
	public CollectorStatusPK create(CollectorStatusBean ejb) 
	throws CreateException, EJBException, DuplicateKeyException{
		
		m_log.debug("create() start : " + ejb.getCollectorID());

		Connection conn = null;
		CollectorStatusPK pk = new CollectorStatusPK();
		PreparedStatement stmt = null;
		
		try {
			conn = ConnectionManager.getConnectionManager().getConnection();
			//SQLʸ
			String sql = "INSERT INTO COLLECTOR_STATUS " +
			"(COLLECTORID, " +
			"RUN_STATUS," +
			"ERROR_STATUS," +
			"END_STATUS," +
			"COUNT," +
			"LAST_COLLECT_DATE)" +
			"values (?,?,?,?,?,?);";
			
			//SQLʸΥå
			stmt = conn.prepareStatement(sql);
			
			stmt.setString(1, ejb.getCollectorID() );
			stmt.setShort(2, (short)ejb.getRunStatus());
			stmt.setShort(3, (short)ejb.getErrorStatus());
			stmt.setShort(4, (short)ejb.getEndStatus());
			stmt.setInt(5, ejb.getCount());
			stmt.setTimestamp(6, null);  // ޤ򳫻ϤƤʤǽnullꤹ
			
			int row =	stmt.executeUpdate();
			
			if (row == 1) {
				/**
				 * CollectorStatusPKͤĤޤ
				 */
				pk = new CollectorStatusPK(ejb.getCollectorID());
			}
			else{
				
				String msg = "result row is not 1";
				m_log.error("create() error : " + ejb.getCollectorID() + " SQLException");
				throw new EJBException(msg);
			}
		} catch (SQLException e) {
			
			//Error Codel "23505" mean DuplicateKey
			if(e.getSQLState().equals("23505")){
				m_log.error("create() error : " + ejb.getCollectorID() + "DuplicateKeyException ");
				throw new DuplicateKeyException(e.getMessage());
			}
			m_log.error("create() error :" + ejb.toString() + " EJBException ");
			throw new CreateException(e.getMessage());
		
		} finally {
			
			//ͥ󡢷̥åȡץڥɥơȥȤΥ
			try {
				if(stmt != null){
					stmt.close();}
				if(conn != null){
					conn.close();
				}
			} catch (SQLException e1) {
				m_log.error("create() error : " + ejb.getCollectorID() + " SQLException");
				throw new EJBException(e1.getMessage());
			}
		}
		m_log.debug("create() end : " + ejb.getCollectorID());
		return pk;
	}
	
	/**
	 *  EntityBeanɬפȤʤfindByPrimaryKey᥽å
	 * 饤Ȥ׵᤬äȤˤΥ֥Ȥ줤뤫å
	 * ¸ߤƤСռ̻ҤǤpk֥Ȥ֤
	 * @param pk ռ̻Ҥpk֥
	 * @return pk ռ̻Ҥpk֥
	 * @throws FinderException
	 */
	public CollectorStatusPK findByPrimaryKey(CollectorStatusPK pk) 
	throws FinderException ,EJBException{
		
		m_log.debug("findbyPK() start : " + pk.getCollectorID());
		
		Connection conn = null;
		PreparedStatement stmt = null;
		ResultSet res = null;
		try {
			conn = ConnectionManager.getConnectionManager().getConnection();
			//SQLʸ
			String sql = "SELECT * FROM COLLECTOR_STATUS WHERE COLLECTORID = ?";
			//SQLʸΥå
			stmt = conn.prepareStatement(sql);
			
			
			stmt.setString(1,pk.collectorID );
			
			res = stmt.executeQuery();
			
			if (res.next()) {
				return pk;
			}
			else{
				String msg = "id " + pk.getCollectorID() + " not found.";
				m_log.error("findbyPK() error : " + pk.toString() + " SQLException");
				throw new FinderException(msg);
			}
		} catch (SQLException e) {
			m_log.error("findbyPK() error : " + pk.toString() + " SQLException");
			throw new EJBException(e.getMessage());
		}  finally{
			
			//ͥ󡢷̥åȡץڥɥơȥȤΥ			
			try {
				stmt.close();
				res.close();
				conn.close();
			} catch (SQLException e1) {
				m_log.error("findbyPK() error : " + pk.toString() + " SQLException");
				throw new EJBException(e1.getMessage());
			}
		
		m_log.debug("findbyPK() end : " + pk.getCollectorID());
		}
	}
}
