/*
                                                                                                                                                                 
Copyright (C) 2006 NTT DATA Corporation
                                                                                                                                                                 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.
                                                                                                                                                                 
This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.
                                                                                                                                                                 
*/

package com.clustercontrol.performanceMGR.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import com.clustercontrol.performanceMGR.bean.ScopeRelationData;
import com.clustercontrol.performanceMGR.util.ConnectionManager;


/**
 * եƥδطDB¸ɤ߽ФDAO饹
 * 
 * եƥοƻҴطϼΥեƥĥ꡼¤Ƹ뤿
 * ɬפȤʤΤǡ¸ɤ߽Ф򤪤ʤ
 * 
 * @version 2.0.0
 * @since 1.0
 */
public class ScopeRelationDAO {
	
//	
	protected static Log m_log = LogFactory.getLog(ScopeRelationDAO.class );
	
	/**
	 * 󥹥ȥ饯
	 *
	 */
	public ScopeRelationDAO(){
	
	}
	
	/**
	 * طIDȥեƥIDȤ˸ޤ
	 * 
	 *ĤΥեƥʣοƥեƥ¸ߤˤʣδط󤬸ޤ
	 *
	 * @param collectorID ID
	 * @param facilityIDեƥID
	 * @return եƥƻҴطξΥ쥯
	 * @throws SQLException
	 */
	public Collection selectScopeRelation(String collectorID, String facilityID)
	throws EJBException{
		
		m_log.debug("selectScopeRelation() start :" + collectorID  + " " + facilityID);
		
		ArrayList<ScopeRelationData> ret= new ArrayList<ScopeRelationData>();
		Connection conn = null;
		PreparedStatement stmt = null;
		ResultSet res = null;
		
		try {
			conn = ConnectionManager.getConnectionManager().getConnection();
	
			//		SQLʸκ
			String sql = "SELECT * FROM SCOPE_RELATION WHERE COLLECTORID=? AND FACILITYID = ?";
			// SQLʸȯԽ
			stmt = conn.prepareStatement(sql);
			// ̥å
			
			
			stmt.setString(1, collectorID);
			stmt.setString(2, facilityID);
			res = stmt.executeQuery();
			
			while(res.next()) {
				ScopeRelationData finfo =new  ScopeRelationData(
						res.getString("COLLECTORID"),
						res.getString("FACILITYID"),
						res.getString("PARENT_FACILITYID")
				);
				
				ret.add(finfo);
			} 
			
			
		} catch (SQLException e) {
			m_log.error("selectScopeRelation() error :" + collectorID + " EJBException ");
			throw new EJBException(e.getMessage());
		}  finally{
			
			//ͥ󡢷̥åȡץڥɥơȥȤΥ
			try {
				if(stmt != null){
					stmt.close();
				}
				if(res != null){
					res.close();
				}
				if(conn != null){
					conn.close();
				}
			} catch (SQLException e1) {
				m_log.error("selectScopeRelation() error :" + collectorID + " EJBException ");
				throw new EJBException(e1.getMessage());
			}
		}
		m_log.debug("selectScopeRelation() end :" + collectorID  + " " + facilityID);
		return ret;
	}
	
	
	/**
	 * եƥοƻҴط򥤥󥵡Ȥޤ
	 * @param finfo եƥοƻҴط
	 * @throws SQLException
	 * @throws CreateException
	 */
	
	public void insertScopeRelation(ScopeRelationData finfo)
	throws EJBException, CreateException{
		
		m_log.debug("insertScopeRelation() start :" + finfo.toString());

		Connection conn = null;
		PreparedStatement stmt = null;		
			
			try {
				conn = ConnectionManager.getConnectionManager().getConnection();
			//SQLʸ
			String sql = "INSERT INTO SCOPE_RELATION " +
			"(collectorID, " +
			"facilityID," +
			"parent_facilityID)" +
			"values (?,?,?);";
			
			//SQLʸΥå
			stmt = conn.prepareStatement(sql);
			
			stmt.setString(1,finfo.getCollectorID());
			stmt.setString(2,finfo.getFacilityID());
			stmt.setString(3,finfo.getParentFacilityID());
			
			int row = stmt.executeUpdate();
			
			if (row != 1) {
				String msg = "Insert Error In ScopeSnapDAO";
				m_log.error("insertScopeRelation() error :" + finfo.toString() + " CreateException ");
				throw new CreateException(msg);
			}
			} catch (SQLException e) {
				m_log.error("insertScopeRelation() error :" + finfo.toString() + " SQLException ");
				throw new EJBException(e.getMessage());
			}  finally{
				
				//ͥ󡢷̥åȡץڥɥơȥȤΥ
				try {
					if(stmt != null){
						stmt.close();
					}
					if(conn != null){
						conn.close();
					}
				} catch (SQLException e1) {
					m_log.error("insertScopeRelation() error :" + finfo.toString() + " SQLException ");
					throw new EJBException(e1.getMessage());
				}
				m_log.debug("insertScopeRelation() start :" + finfo.toString());
			}	
	}
	
	/**
	 * ˤեƥοƻҴط縡ޤ
	 * @param collectorIDID
	 * @returnեƥƻҴطΥ쥯
	 * @throws SQLException
	 */
	public Collection selectScopeRelationByCollectorID(String collectorID)
	throws EJBException{
		m_log.debug("selectScopeRelationByCollectorID() start :" + collectorID);
		
		ArrayList ret = new ArrayList();
		Connection conn = null;
		PreparedStatement stmt = null;
		// ̥å
		ResultSet res =null;
		
		try {
			conn = ConnectionManager.getConnectionManager().getConnection();
			//		SQLʸκ
			String sql = "SELECT * FROM SCOPE_RELATION WHERE COLLECTORID=?";
			// SQLʸȯԽ
	        stmt = conn.prepareStatement(sql);
	
			stmt.setString(1, collectorID);
			res = stmt.executeQuery();
			
			while(res.next()) {
				ScopeRelationData finfo =new  ScopeRelationData(
						res.getString("COLLECTORID"),
						res.getString("FACILITYID"),
						res.getString("PARENT_FACILITYID")
				);
				
				ret.add(finfo);
			} 
			
		} catch (SQLException e) {
			m_log.error("selectScopeRelationByCollectorID() error :" + collectorID + " SQLException ");
			throw new EJBException(e.getMessage());
		}  finally{
			
			//ͥ󡢷̥åȡץڥɥơȥȤΥ
			try {
				if(stmt != null){
					stmt.close();
				}
				if(res != null){
					res.close();
				}
				if(conn != null){
					conn.close();
				}
			} catch (SQLException e1) {
				m_log.error("selectScopeRelationByCollectorID() error :" + collectorID + " SQLException ");
				throw new EJBException(e1.getMessage());
			}
		}
		m_log.debug("selectScopeRelationByCollectorID() end :" + collectorID);
		return ret;
		
	}
	
	/**
	 * ˤեƥοƻҴطޤ
	 * @param collectorIDID
	 * @throws SQLException
	 */
	public void deleteScopeRelationByCollectorID(String collectorID)
	throws EJBException{
		
		m_log.debug("deleteScopeRelationByCollectorID() start :" + collectorID);
		Connection conn = null;
		PreparedStatement stmt = null;
		
		try {
			conn = ConnectionManager.getConnectionManager().getConnection();
			//SQLʸ
			String sql = "DELETE FROM SCOPE_RELATION WHERE COLLECTORID = ? ";
			//SQLʸΥå
			stmt = conn.prepareStatement(sql);
			stmt.setString(1,collectorID );
			stmt.executeUpdate();
			
		} catch (SQLException e) {
			m_log.error("deleteScopeRelationByCollectorID() error :" + collectorID + " SQLException ");
			throw new EJBException(e.getMessage());
		}  finally{
			
			//ͥ󡢷̥åȡץڥɥơȥȤΥ
			try {
				if(stmt != null){
					stmt.close();
				}
				if(conn != null){
					conn.close();
				}
			} catch (SQLException e1) {
				m_log.error("deleteScopeRelationByCollectorID() error :" + collectorID + " SQLException ");
				throw new EJBException(e1.getMessage());
			}
			m_log.debug("deleteScopeRelationByCollectorID() end :" + collectorID);
		}	
	}
}
