/*
 
 Copyright (C) 2006 NTT DATA Corporation
 
 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License
 as published by the Free Software Foundation, version 2.
 
 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.
 
 */

package com.clustercontrol.performanceMGR.ejb.bmp;

import java.rmi.RemoteException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.EntityBean;
import javax.ejb.EntityContext;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.CronTrigger;
import org.quartz.JobDetail;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;

import com.clustercontrol.bean.EndStatusConstant;
import com.clustercontrol.bean.FacilityTreeItem;
import com.clustercontrol.performanceMGR.bean.CollectedDataInfo;
import com.clustercontrol.performanceMGR.bean.CollectorItemInfo;
import com.clustercontrol.performanceMGR.bean.CollectorRunStatus;
import com.clustercontrol.performanceMGR.bean.CollectorType;
import com.clustercontrol.performanceMGR.bean.DeviceData;
import com.clustercontrol.performanceMGR.bean.EventCode;
import com.clustercontrol.performanceMGR.bean.OIDInfo;
import com.clustercontrol.performanceMGR.bean.QuartzConstant;
import com.clustercontrol.performanceMGR.bean.ScopeTree;
import com.clustercontrol.performanceMGR.bean.SnmpPollerConstant;
import com.clustercontrol.performanceMGR.dao.CalculatedDataDAO;
import com.clustercontrol.performanceMGR.dao.CollectorItemDAO;
import com.clustercontrol.performanceMGR.dao.DeviceDAO;
import com.clustercontrol.performanceMGR.dao.RecordDataDAO;
import com.clustercontrol.performanceMGR.dao.ScopeRelationDAO;
import com.clustercontrol.performanceMGR.dao.ScopeSnapDAO;
import com.clustercontrol.performanceMGR.ejb.bmp.CollectorStatusLocal;
import com.clustercontrol.performanceMGR.ejb.bmp.CollectorStatusPK;
import com.clustercontrol.performanceMGR.ejb.bmp.CollectorStatusUtil;
import com.clustercontrol.performanceMGR.job.CollectJob;
import com.clustercontrol.performanceMGR.monitor.ejb.entity.MonitorPerfInfo;
import com.clustercontrol.performanceMGR.monitor.ejb.entity.MonitorPerfInfoHome;
import com.clustercontrol.performanceMGR.monitor.factory.RunMonitorPerformance2;
import com.clustercontrol.performanceMGR.util.CalculationMethod;
import com.clustercontrol.performanceMGR.util.FacilityTreeDB;
import com.clustercontrol.performanceMGR.util.JNDIConnectionManager;
import com.clustercontrol.performanceMGR.util.Repository;
import com.clustercontrol.snmppoller.SnmpSharedTable;
import com.clustercontrol.snmppoller.bean.PollingConfig;
import com.clustercontrol.util.apllog.AplLogger;

/**
 * @ejb.bean name="Collector"
 *           display-name="Name for Collector"
 *           description="Description for Collector"
 *           jndi-name="Collector"
 *           type="BMP"
 *           view-type="both"
 * 
 * @jboss.depends name="jboss.jca:service=DataSourceBinding,name=HinemosDS"
 * 
 * @ejb.permission
 *     unchecked="true"
 * 
 * @ejb.data-object name="RecordCollectorData"
 *           
 * @ejb.dao
 *  class="com.clustercontrol.performanceMGR.ejb.bmp.CollectorDAO" 
 *  impl-class="com.clustercontrol.performanceMGR.dao.CollectorDAOImpl"
 *  
 * @jboss.container-configuration name="Collector Configuration"
 */
public class CollectorBean implements EntityBean {
//	public class CollectorBean implements EntityBean, TimedObject {
	// ѥ֥
	protected static Log m_log = LogFactory.getLog(CollectorBean.class);
	
	// ׻ѤǽͤǼDBؤΥ֥
//	private CalculatedDataDAO m_dao;
	
	// ̿κ(ͤۤȤʤߤ٤ȽǤ)
	private final int MAX_LIFECOUNT = 2;  
	private int lifetimeCounter;    // λޤǤΥ
	// ߤϳ remove()᥽åɤƤӽФȤǹԤ
	// Bean ʬȤߤ뤳ȤϤʤ
	
	private int collectorType;      // (ꥢ륿//ʹƻ)
	
	// ³ѿ
	private String collectorID = null; // ID
	private int interval;              // ֳ
	private String facilityID;         // оݥ
	private ScopeTree scopeTree;       // ǽͻѤΥץĥ꡼
	private CollectorItemInfo[] items; // ܤΥꥹȡʼܿʬݡ
	
	private String label;
	private long startTime;
	private long stopTime;             // λ
	private String scopePath;
	private int period;
	private int presavePeriod;
	
	private OIDInfo[] targetOID;       // оݤOIDξ
	
	protected EntityContext entityCtx;  // Entyty Context
	
	public CollectorBean() {
		super();
	}

	/**
	 * EntityBeanݤ˥ƥʤƤФޤ
	 * @param dataΰռ̻pk֥
	 * 	 * <!-- begin-user-doc -->
	 * The  ejbCreate method.
	 * <!-- end-user-doc -->
	 *
	 * <!-- begin-xdoclet-definition --> 
	 * @ejb.create-method 
	 * <!-- end-xdoclet-definition --> 
	 * @generated
	 */
	public CollectorPK ejbCreate(RecordCollectorData data, List itemList)
	throws CreateException {
		m_log.debug("ejbCreate() start : " + data.getCollectorID());
		
//		m_dao = new CalculatedDataDAO();
		
		this.items = (CollectorItemInfo[])itemList.toArray(new CollectorItemInfo[itemList.size()]);
		setCollectorID(data.getCollectorID());
		setCollectorType(data.getCollectorType());
		setFacilityID(data.getFacilityID());
		setInterval(data.getInterval());
		setLabel(data.getLabel());
		setPeriod(data.getPeriod());
		setScopePath(data.getScopePath());
		setPresavePeriod(data.getPresavePeriod());
		// եƥĥ꡼ϡǤϹԤ鷺 ejbPostCreate() Ǽ¹Ԥ
		
		m_log.debug("ejbCreate() e : " + data.getCollectorID());
		
		return new CollectorPK(data.getCollectorID());
	}
	
	/**
	 * EntityBeanľ˥ƥʤƤФޤ
	 * 
	 * ܤDB˽񤭹ߤޤ
	 * 
	 * @param pk ΰռ̻pk֥
	 */
	public void ejbPostCreate(RecordCollectorData data, List itemList)
	throws javax.ejb.CreateException {
		m_log.debug("ejbPostCreate()  Collector Type : " + collectorType);
		
		Repository repository = new Repository();
		
		// ݥȥ꤫ĥ꡼ScopeTree֥Ȥ
		FacilityTreeItem facilityTree = repository.getFacilityTree(facilityID);
		scopeTree = new ScopeTree(facilityTree);
		
		// פΥեѥ
		setScopePath(repository.getFacilityPath(facilityID));
		
		// Ӽξϥեƥĥ꡼DB˳Ǽ
		if(collectorType == CollectorType.RECORD){
			// ĥ꡼DB˽񤭹
			new FacilityTreeDB().insertFacilityTree(collectorID, facilityTree);
			
			// ݥȥ꤫ǥХ
			List deviceList = repository.getDeviceList(facilityID);
			
			// ǥХѤDAO
			DeviceDAO dvdao = new DeviceDAO();
			
			Iterator itr = deviceList.iterator();
			while(itr.hasNext()){		
				// ǥХDB˽񤭹
				dvdao.insertDeviceData(collectorID, (DeviceData)itr.next());
			}
		}
		
		// ѤDAO
		CollectorItemDAO cidao = new CollectorItemDAO();
		
		for(int i=0; i<items.length; i++){
			// ꥢ륿ξϡ˼IDåȤʤᤳǥåȤ
			items[i].setCollectorID(collectorID);
			
			// ܤDB˽񤭹
			cidao.registCollectorItem(items[i]);
		}
		
		// ֤ݻEntityBean
		try {
			CollectorStatusUtil.getLocalHome().create(new CollectorStatusPK(collectorID));
		} catch (NamingException e) {
			m_log.error(e);
			throw new EJBException(e);
		}
	}
	
	/**
	 * DBܤξꤷޤ
	 *
	 */
	public void setCollectorItems(String collectoId){
		// ѤDAO
		CollectorItemDAO cidao = new CollectorItemDAO();
		
		Collection col = cidao.selectCollectorItemByCollectorID(collectoId);
		items = (CollectorItemInfo[])col.toArray(new CollectorItemInfo[col.size()]);
		
		// μɬפȤʤоݤOID
		targetOID = CalculationMethod.getTargetOid(items);
	}
	
	/**
	 * ץ饤ޥꥭȤEntityBean򸡺ݤ˥ƥʤƤФޤ
	 * @param pk ΰռ̻pk
	 * @return pk
	 **/
	public CollectorPK ejbFindByPrimaryKey(CollectorPK pk) throws FinderException {
		return pk; 
	}
	
	/**
	 * ̤ǸԤޤ
	 *
	 * @param type 
	 * @return CollectorPK ΰռ̻pk֥ȤΥꥹ
	 **/
	public Collection ejbFindByCollectorType(int type) throws FinderException { 
		m_log.debug("ejbFindByStatus() : Type = " + type);
		
		// Ǥϲ⤻DAOμ饹˽ޤ
		return null; 
	}
	/*
	 * ư̵¼ޤ
	 */
	public Collection ejbFindByPresave() throws FinderException{
		m_log.debug("ejbFindByPresave() : ");
		
		// Ǥϲ⤻DAOμ饹˽ޤ
		return null; 
		
	}
	
	
	/**
	 * ƤμθԤޤ
	 *
	 * @return CollectorPK ΰռ̻pk֥ȤΥꥹ
	 **/
	public Collection ejbFindAll() throws FinderException { 
		m_log.debug("ejbFindAll() : ");
		
		// Ǥϲ⤻DAOμ饹˽ޤ
		return null; 
	}
	
	public void ejbActivate() throws EJBException, RemoteException {
	}
	
	public void ejbLoad() throws EJBException, RemoteException {
		m_log.debug("ejbLoad() start : " + collectorID);
		
		m_log.debug("ejbLoad() end   : " + collectorID);
	}
	
	public void ejbPassivate() throws EJBException, RemoteException {
	}
	
	public void ejbRemove()
	throws RemoveException,	EJBException, RemoteException {
		m_log.debug("ejbRemove() start : " + collectorID);
		
		// Quartz ꤵƤ른֤
		deleteJob();
		
		// ֤ݻEntityBean
		try {
			CollectorStatusUtil.getLocalHome().remove(new CollectorStatusPK(collectorID));
		} catch (NamingException e) {
			m_log.error(e);
			throw new EJBException(e);
		}
		
		// μID˴Ϣܤ
		CollectorItemDAO cidao = new CollectorItemDAO();
		cidao.deleteCollectorItemByCollectorID(collectorID);
		
		// μID˴ϢǥХ
		DeviceDAO dvdao = new DeviceDAO();
		dvdao.deleteDeviceDataByCollectorID(collectorID);
		
		// եƥĥ꡼
		ScopeRelationDAO srdao = new ScopeRelationDAO();
		ScopeSnapDAO ssdao = new ScopeSnapDAO();
		srdao.deleteScopeRelationByCollectorID(collectorID); // פδط
		ssdao.deleteScopeSnapByCollectorID(collectorID); // ׾	
		
		// MIBΥǡ
		RecordDataDAO dataDao = new RecordDataDAO();
		dataDao.deleteRecordData(collectorID);
		
		// ǽͥǡ
		CalculatedDataDAO calDao = new CalculatedDataDAO();
		calDao.delete(collectorID);
		
		m_log.debug("ejbRemove() end   : " + collectorID);
	}
	
	public void ejbStore() throws EJBException, RemoteException {
		// Ǥϲ⤻DAOμ饹˽ޤ
	}
	
	public void setEntityContext(EntityContext ctx)
	throws EJBException, RemoteException {
		entityCtx = ctx;
	}
	
	public void unsetEntityContext() throws EJBException, RemoteException {
	}
	
	/**
	 * ޤ
	 * @return 
	 * 
	 * @ejb.interface-method
	 *  view-type="both"
	 */
	public RecordCollectorData getRecordColletorData(){
		m_log.debug("getRecordColletorData() strat : ");
		
		RecordCollectorData data =  new RecordCollectorData();
		
		data.setCollectorID(getCollectorID());
		data.setCollectorType(getCollectorType());
		data.setFacilityID(getFacilityID());
		data.setInterval(getInterval());
		data.setCount(getCount());
		data.setLabel(getLabel());
//		data.setMonitorFlag(isMonitorFlag());
		data.setStatus(getStatus());
		data.setPeriod(getPeriod());
		data.setScopePath(getScopePath());
		data.setStartDate(getStartDate());
		data.setStopDate(getStopDate());
		data.setFacilityTree(getFacilityTree());
		data.setRealCollectPeriod(getRealCollectPeriod());
		data.setEndStatus(getEndStatus());
		data.setPresavePeriod(getPresavePeriod());
		m_log.debug("getRecordColletorData() end   : ");
		return data;
	}
	
	/**
	 * 򳫻Ϥޤ
	 * @throws NamingException 
	 * 
	 * @ejb.interface-method
	 *	view-type="both" 
	 */
	public void startCollect() throws NamingException{
		m_log.debug("startCollect() start : " + collectorID + " " + collectorType);
		
		setCollectorType(collectorType);
		
		// SNMPݡ󥰤򥹥Ȥ
		startPoller();
		
		// μɬפȤʤоݤOID
		this.targetOID = CalculationMethod.getTargetOid(this.items);
		
		// λͽ
		if(period == -1){
			this.stopTime = Long.MAX_VALUE;
		} else {
			this.stopTime = System.currentTimeMillis() + period * 60 * 1000l;
		}
		
		// Quartz ˥塼
		scheduleJob();
		
		// ϻ
		setStartTime(System.currentTimeMillis());
		
		//  getValue() ƤФ줿ˤʤ
		scopeTree.fetchMibValue(this.facilityID, this.targetOID, this.interval);
		
		m_log.debug("startCollect() end   : " + collectorID + " " + collectorType);
	}
	
	
	/**
	 * Ƴޤ
	 * @throws NamingException 
	 * 
	 * @ejb.interface-method
	 *	view-type="both" 
	 * 
	 * @return Ƴ true Ƴʤä false ֤
	 * @throws NamingException
	 */
	public boolean restartCollect() throws NamingException {
		m_log.debug("restartCollect() start : " + collectorID + " " + collectorType);
		
		boolean isRunning = false;
		
		// 椫ɤĴ٤
		if(getStatus() == CollectorRunStatus.RUNNING){
			isRunning = true;
		}
		
		boolean isRestart = false;
		
		// λ
		if(period == -1){
			this.stopTime = Long.MAX_VALUE;
		}
		
		// ߻λΤۤ礭Ϻټ򳫻Ϥ
		if(System.currentTimeMillis() < stopTime){
			// SNMPݡ󥰤򥹥Ȥ
			startPoller();
			
			// μɬפȤʤоݤOID
			this.targetOID = CalculationMethod.getTargetOid(this.items);
			
			//  getValue() ƤФ줿ˤʤ
			scopeTree.fetchMibValue(this.facilityID, this.targetOID, this.interval);
			
			// Quartz ˥塼
			scheduleJob();
			
			isRestart = true;

			if(collectorType == CollectorType.RECORD){
				// ץꥱ
				// IDȤƥϤ
				String[] messages = { "CollectorID : " + collectorID };
				outputLog(EventCode.WarningRestart, messages);
			} else if (collectorType == CollectorType.MONITOR){
				// ץꥱ
				// ƻIDȤƥϤ
				String[] messages = { "MonitorID : " + label };
				outputLog(EventCode.WarningRestart, messages);
			}
			
			// ˼ǤäΤǺƼ¹ԤΤϥ顼֤ѹʤ
			if(!isRunning){
				setErrorStatus(EndStatusConstant.TYPE_WARNING);
			}
		}
		
		m_log.debug("restartCollect() end   : " + collectorID + " " + collectorType);
		
		return isRestart;
	}
	
	/**
	 * SNMPݡ顼ư
	 * @throws NamingException 
	 */
	private void startPoller() throws NamingException {
		if(scopeTree == null || facilityID == null){
			// 顼
			return;
		}
		
		// оݥեƥ˴ޤޤΡɤΥꥹȤ
		String[] nodeIDList = scopeTree.getNodeIDList(facilityID);
		
		// SNMPͤζͭơ֥ååפޤ
		SnmpSharedTable sst = null;
		
		InitialContext iniCtx = JNDIConnectionManager.getInitialContext();
		Object obj = iniCtx.lookup(SnmpPollerConstant.JNDI_NAME);
		
		// ֥Ȥ򥭥㥹Ȥޤ
		sst = (SnmpSharedTable)PortableRemoteObject.narrow(obj, SnmpSharedTable.class);
		
		// SNMPݡ顼Υ塼
		if(collectorType != CollectorType.REALTIME){
			// ꥢ륿ʳξϡݡ󥰳Ϥ1ԤäƤ
			// 椬ɤ褦˸ƤӽФ
			// 1ðSNMPΥݡ󥰤ͤǤСͤвǽȤʤ
			m_log.debug("polling start . wait time 1000ms");
			sst.setPollingSchedule(nodeIDList, interval, 1000);
		} else {
			m_log.debug("polling start . wait time 0ms");
			sst.setPollingSchedule(nodeIDList, interval, 0);
		}
	}
	
	/**
	 * ͤޤ(¾getValue᥽åɤƤФ縵Ȥʤ᥽å)
	 * 
	 * @ejb.interface-method
	 *	view-type="both" 
	 **/
	public CollectedDataInfo getValue(String facilityId, String itemCode, int deviceIndex){
		// ¸֥󥿤ꥻå
		resetLifetimeCounter();
		
		CollectedDataInfo data = scopeTree.getValue(facilityId, itemCode, deviceIndex);
		
		// ꥢ륿ͤǤʤä֤ͤ
		if((collectorType == CollectorType.REALTIME) && Double.isNaN(data.getValue())){
			data = scopeTree.getTempValue(facilityId, itemCode, deviceIndex);
		}
		
		return data;
	}
	
	/**
	 * ͤޤ
	 * 
	 * @ejb.interface-method
	 *	view-type="both" 
	 **/
	public CollectedDataInfo getValue(String facilityId, int itemId){
		for(int i=0; i<items.length; i++){
			if(items[i].getCollectorItemID() == itemId){
				return getValue(
						facilityId, 
						items[i].getCollectorItemCode(), 
						items[i].getDeviceIndex()
				);
			}
		}
		
		// μID˰פܤդʤä
		return null;
	}
	
	/**
	 * ͤޤ
	 * 
	 * @ejb.interface-method
	 *	view-type="both" 
	 **/
	public CollectedDataInfo[] getValueAll(String facilityId){
		CollectedDataInfo[] dataList = new CollectedDataInfo[items.length];
		
		for(int i=0; i<items.length; i++){
			dataList[i] = getValue(
					facilityId, 
					items[i].getCollectorItemCode(), 
					items[i].getDeviceIndex()
			);
			
		}
		
		return dataList;
	}
	
	/**
	 * ꥹפΥ֥פΥեƥͤޤ
	 * 
	 * @ejb.interface-method
	 *	view-type="both" 
	 **/
	public List getSubScopeValues(String facilityId, String itemCode, int deviceIndex){
		ArrayList ret = new ArrayList();		
		String[] subScopeFids = scopeTree.getSubScopeIDList(facilityId);
		
		for(int i=0; i<subScopeFids.length; i++){
			ret.add(getValue(subScopeFids[i], itemCode, deviceIndex));
		}
		
		return ret;
	}
	
	/**
	 * ꥹפΥ֥פΥեƥͤޤ
	 * 
	 * @ejb.interface-method
	 *	view-type="both" 
	 **/
	public List getSubScopeValues(String facilityId, int itemId){
		for(int i=0; i<items.length; i++){
			if(items[i].getCollectorItemID() == itemId){
				return getSubScopeValues(
						facilityId, 
						items[i].getCollectorItemCode(), 
						items[i].getDeviceIndex()
				);
			}
		}
		
		// μID˰פܤդʤä
		return null;
	}
	
	/**
	 * λޤ
	 * 
	 * @ejb.interface-method
	 *	view-type="both" 
	 **/
	public void stopCollect(){
		m_log.debug("stopCollect() start : " + collectorID);
		
		// Quartz ꤵƤ른֤
		deleteJob();
		
		// λ
		setStopTime(System.currentTimeMillis());
		
		m_log.debug("stopCollect() end   : " + collectorID);
	}	
	
	/**
	 * 塼Quartzꤹ
	 * @throws NamingException 
	 */
	private void scheduleJob() throws NamingException {
		m_log.debug("scheduleJob()  Group : "  + QuartzConstant.GROUP_COLLECT + " : " + collectorID + " : " + interval);
		
		//JobDetail
		JobDetail job = new JobDetail(
				collectorID, 
				QuartzConstant.GROUP_COLLECT, 
				CollectJob.class);
		
		//ִλ˺ʤ褦ˤ
		job.setDurability(true);
		
		//JobDetail˸ƤӽФ᥽åɤΰ
		job.getJobDataMap().put("pk", new CollectorPK(collectorID));
		job.getJobDataMap().put("type", collectorType);
		
		//CronTrigger
		CronTrigger cronTrigger = new CronTrigger(collectorID, QuartzConstant.GROUP_COLLECT);
		
		try {
			String cronString = PollingConfig.parseCronExpression(interval);
			
			cronString = "0 */10 * * * ? *";
			
			if(interval < 60){  // ñ̤ξ
				cronString = "*/" + interval + " * * * * ? *";
			} else if (60 <= interval && interval < 3600){  // ʬñ̤ξ
				cronString = "0 */" + interval/60 + " * * * ? *";
			} else if (3600 <= interval){  // ñ̤ξ
				cronString = "0 0 */" + interval/3600 + " * * ? *";
			} else {
				String message = "ݡȤƤʤֳ֤Ǥ";
				throw new EJBException(message);
			}
			
			cronTrigger.setCronExpression(cronString);
			cronTrigger.setEndTime(new Date(stopTime));
		} catch (ParseException e) {
			m_log.error(e);
		} catch (IllegalArgumentException e){
			// CronTrigger饹setEndTime() 
			// end time  start time Τۤ礭throw
			m_log.error(e);
			
			// QuartzưɬפʤΤǤΤޤ޽λ
			return;
		}
		
		//QuartzScheduleråå
		InitialContext iniCtx = JNDIConnectionManager.getInitialContext();
		Scheduler scheduler = (Scheduler)iniCtx.lookup(QuartzConstant.QUARTZ_NAME);
		
		try {
			// ϿƤ른֤(ϿƤʤϲ⤪ʤ)
			scheduler.deleteJob(collectorID, QuartzConstant.GROUP_COLLECT);
			
			// ֤Ͽ
			scheduler.scheduleJob(job, cronTrigger);
		} catch (SchedulerException e) {
			m_log.error(e);
		}
	}
	
	/**
	 * ư֤ߤޤ
	 *
	 */
	private void pauseJob() {
		m_log.debug("pauseJob() start : " + collectorID);
		
		//QuartzScheduleråå
		try {
			InitialContext iniCtx = JNDIConnectionManager.getInitialContext();
			Scheduler scheduler = (Scheduler)iniCtx.lookup(QuartzConstant.QUARTZ_NAME);
			
			// ϿƤ른֤(ϿƤʤϲ⤪ʤ)
			scheduler.pauseJob(collectorID, QuartzConstant.GROUP_COLLECT);
		} catch (NamingException e) {
			throw new EJBException(e);
		} catch (SchedulerException e) {
			m_log.error(e);
		}
		m_log.debug("pauseJob() end   : " + collectorID);
	}
	
	/**
	 * ư֤Ƴޤ
	 *
	 */
	private void resumeJob() {
		m_log.debug("pauseJob() start : " + collectorID);
		
		//QuartzScheduleråå
		try {
			InitialContext iniCtx = JNDIConnectionManager.getInitialContext();
			Scheduler scheduler = (Scheduler)iniCtx.lookup(QuartzConstant.QUARTZ_NAME);
			
			// ϿƤ른֤(ϿƤʤϲ⤪ʤ)
			scheduler.resumeJob(collectorID, QuartzConstant.GROUP_COLLECT);
		} catch (NamingException e) {
			throw new EJBException(e);
		} catch (SchedulerException e) {
			m_log.error(e);
		}
		m_log.debug("pauseJob() end   : " + collectorID);
	}
	
	/**
	 * ư֤ޤ
	 *
	 */
	private void deleteJob() {
		m_log.debug("deleteJob() start : " + collectorID);
		
		//QuartzScheduleråå
		try {
			InitialContext iniCtx = JNDIConnectionManager.getInitialContext();
			Scheduler scheduler = (Scheduler)iniCtx.lookup(QuartzConstant.QUARTZ_NAME);
			
			// ϿƤ른֤(ϿƤʤϲ⤪ʤ)
			scheduler.deleteJob(collectorID, QuartzConstant.GROUP_COLLECT);
		} catch (NamingException e) {
			throw new EJBException(e);
		} catch (SchedulerException e) {
			m_log.error(e);
		}
		m_log.debug("deleteJob() end   : " + collectorID);
	}
	
	/**
	 * ݡ顼Υơ֥뤬ݻMIBͤޤ
	 * 
	 * @ejb.interface-method
	 *	view-type="both" 
	 */
	public void fetchMibValue(){
		m_log.debug("fetchMibValue() start : " + collectorID + "  " + collectorType);
		
		try{
			if(scopeTree == null || targetOID == null){
				m_log.debug("lost facility tree info.");
			} else {
				// MIBͤ
				scopeTree.fetchMibValue(this.facilityID, this.targetOID, this.interval);
			}
			
			// ǽDB˽񤭹ߤޤ
			setLastCollectDate(new Date(System.currentTimeMillis()));
			
			// DB˽񤭹ߤޤ
			setCount(getCount()+1);
			
			// ̿󥿤äޤ
			lifetimeCounter++;
		} catch (Exception e) {
			m_log.error(e);
			// ֤۾ѹ
			this.setErrorStatus(EndStatusConstant.TYPE_ABNORMAL);
		}
		
		m_log.debug("fetchMibValue() end   : " + collectorID + "  " + collectorType);
	}
	
	/**
	 * ǽͤ򻻽ФDB˽񤭹ߤޤ
	 * 
	 * @ejb.interface-method
	 *	view-type="both" 
	 */
	public void storeCalcValue(){
		m_log.debug("storeCalcValue() start : " + collectorID + "  " + collectorType);
		
		try{
			if(scopeTree == null || items == null || targetOID == null){
				m_log.debug("򼺤äƤޤ");
			} else {
				// MIBͤ
				scopeTree.fetchMibValue(this.facilityID, this.targetOID, this.interval);
				
				// ƤΥեƥID
				String[] fids = scopeTree.getAllFacilityIdList();
				
				for(int i=0; i<items.length; i++){
					for(int j=0; j<fids.length; j++){
						CollectedDataInfo data = getValue(
								fids[j], 
								items[i].getCollectorItemCode(), 
								items[i].getDeviceIndex()
						);
						
						// DBؽ
						CalculatedDataDAO dao = new CalculatedDataDAO();
						dao.insert(collectorID, data);
					}
				}

				// ǽ
				setLastCollectDate(new Date(scopeTree.getLastCollectTime()));
				
				// DB˽񤭹ߤޤ
				setCount(getCount()+1);
			}
		} catch (Exception e) {
			e.printStackTrace();
			m_log.error(e);
			// ֤۾ѹ
			this.setErrorStatus(EndStatusConstant.TYPE_ABNORMAL);
		}
		
		m_log.debug("storeCalcValue() end   : " + collectorID + "  " + collectorType);
	}
	
	/**
	 * ǽͤ򻻽ФȽꤷޤ
	 * 
	 * @ejb.interface-method
	 *	view-type="both" 
	 */
	public void monitorCalcValue(){
		m_log.debug("monitorCalcValue() start : " + collectorID + "  " + collectorType);
		
		if(scopeTree == null || items == null || targetOID == null){
			m_log.debug("򼺤äƤޤ");
			return;
		}
		
		try{
			// MIBͤ
			scopeTree.fetchMibValue(this.facilityID, this.targetOID, this.interval);
			
			// ǽʹƻ
			MonitorPerfInfoHome home = JNDIConnectionManager.getMonitorPerfInfo();
			Collection mPerfInfos = home.findAll();
			
			Iterator itr = mPerfInfos.iterator();
			while(itr.hasNext()){
				MonitorPerfInfo monInfoLocal = (MonitorPerfInfo)itr.next();
				
				if(monInfoLocal.getCollectorId().equals(collectorID)){
					String monitorTypeId = monInfoLocal.getMonitorTypeId();
					String monitorId = monInfoLocal.getMonitorId();
					String itemCode = monInfoLocal.getItemCode();
					int deviceIndex = monInfoLocal.getDeviceIndex();
					
					// оݥեƥ(Ρɤ⤷ϥ)Ƚ¹Ԥ
					CollectedDataInfo data = getValue(this.facilityID, itemCode, deviceIndex);
					
					// Ƚ¹
					RunMonitorPerformance2 runMonitor = new RunMonitorPerformance2();
					runMonitor.run(monitorTypeId, monitorId, data);

					 // ƻоݥեƥפξϡפ˴ޤޤΡɤؤνԤ
					Repository rep = new Repository();
					if(!rep.isNode(this.facilityID)){
						// פ˴ޤޤΡɤȽ¹
						// ƤΥΡɤID
						String[] nodeFids = scopeTree.getNodeIDList(this.facilityID);
						
						for(int j=0; j<nodeFids.length; j++){
							data = getValue(nodeFids[j], itemCode, deviceIndex);
							
							// Ƚ¹
							runMonitor = new RunMonitorPerformance2();
							runMonitor.run(monitorTypeId, monitorId, data);
						}
					}
				}
			}
			
			// ǽ
			setLastCollectDate(new Date(scopeTree.getLastCollectTime()));
			
			// DB˽񤭹ߤޤ
			setCount(getCount()+1);
		} catch (Exception e) {
			m_log.error(e);
			e.printStackTrace();
		}
		
		m_log.debug("monitorCalcValue() end   : " + collectorID + "  " + collectorType);
	}
	
	/**
	 * ¸֥󥿤ꥻåȤޤ
	 *
	 */
	private void resetLifetimeCounter(){
		lifetimeCounter = 0;
	}
	
	
	/**
	 * IDޤ
	 * 
	 * @return ID
	 * 
	 * @ejb.persistence
	 * @ejb.pk-field 
	 * 
	 * @ejb.interface-method
	 *	view-type="both" 
	 */
	public String getCollectorID() {
		return collectorID;
	}
	
	/**
	 * IDꤷޤ
	 * @param collectorID ID
	 */
	public void setCollectorID(String collectorID) {
		this.collectorID = collectorID;
	}
	
	/**
	 * μ̤ޤ(ꥢ륿⤷ϼӼ)
	 * 
	 * @return 
	 * 
	 * @ejb.persistence
	 */
	public int getCollectorType() {
		return collectorType;
	}
	
	/**
	 * μ̤ꤷޤ(ꥢ륿⤷ϼӼ)
	 * 
	 * @return 
	 */
	public void setCollectorType(int collectorType) {
		this.collectorType = collectorType;
	}
	
	/**
	 * եƥIDޤ
	 * @return facilityID եƥID
	 * 
	 * @ejb.persistence 
	 */
	public String getFacilityID() {
		return facilityID;
	}
	
	/**
	 * եƥIDꤷޤ
	 * @param facilityID եƥID
	 */
	public void setFacilityID(String facilityID) {
		m_log.debug("setFacilityID() start : " + collectorID);
		
		this.facilityID = facilityID;
		
		m_log.debug("setFacilityID() end   : " + collectorID);
	}
	
	/**
	 * ǽͻѤΥեƥĥ꡼ƹۤ
	 */
	public void updateScopeTree() {
		m_log.debug("updateScopeTree() start : " + collectorID);
		
		FacilityTreeItem tree = getFacilityTree();
		
		if(tree != null){
			// եƥĥ꡼ƹۤ
			this.scopeTree = new ScopeTree(tree);
		}
		
		m_log.debug("updateScopeTree() end   : " + collectorID);
	}
	
	
	/**
	 * եƥĥ꡼ޤ
	 * @return facilityTree եƥĥ꡼
	 * 
	 * @ejb.interface-method
	 *  view-type="both"
	 * 
	 * @ejb.persistence 
	 */
	public FacilityTreeItem getFacilityTree() {
		m_log.debug("getFacilityTree() collector type : " + collectorType); 
		
		if(facilityID != null && 
				(collectorType == CollectorType.REALTIME || collectorType == CollectorType.MONITOR)){
			// ݥȥ꤫
			// ݥȥξѹ줿ʤɤͳǻΥեƥID¸ߤʤ null ֤
			return new Repository().getFacilityTree(facilityID);
		} else if(collectorID != null && collectorType == CollectorType.RECORD){
			// DBեƥĥ꡼
			return new FacilityTreeDB().getFacilityTree(collectorID);
		} else {
			return null;
		}
	}
	
	/**
	 * ֳ֤ޤ
	 * @return interval ֳ
	 *
	 * @ejb.interface-method
	 *  view-type="both"
	 * 
	 * @ejb.persistence 
	 */
	public int getInterval() {
		return interval;
	}
	
	/**
	 * ֳ֤ꤷޤ
	 * @param interval ֳ
	 */
	public void setInterval(int interval) {
		this.interval = interval;
	}
	
	/**
	 * Υ٥ޤ
	 * @return label ٥
	 * 
	 * @ejb.persistence 
	 */
	public String getLabel() {
		return label;
	}
	
	/**
	 * ٥ꤷޤ
	 * @param label ٥
	 */
	public void setLabel(String label) {
		this.label = label;
	}
	
	/**
	 * ֤ޤ
	 * @return period 
	 * 
	 * @ejb.persistence 
	 */
	public int getPeriod() {
		return period;
	}
	
	/**
	 * ֤ꤷޤ
	 * @param period 
	 */
	public void setPeriod(int period) {
		this.period = period;
	}
	
	/**
	 * ޤ
	 * @return count 
	 * 
	 * @ejb.persistence 
	 */
	public int getCount() {
		return getCollectorStatus().getCount();
	}
	
	/**
	 * ꤷޤ
	 * 
	 * @param count 
	 */
	public void setCount(int count) {
		getCollectorStatus().setCount(count);
	}
	
	/**
	 * ¹Υ顼֤ꤷޤ
	 * 
	 * @param status ¹Υ顼
	 */
	public void setErrorStatus(int status) {
		getCollectorStatus().setErrorStatus(status);
		
		int endStatus = getCollectorStatus().getEndStatus();
		
		// ߤޤǤξ֤꿼ʾ֤ξϽλ֤ѹ
		
		// ߤޤǤνλ֤""ǡ֤"ٹ"ޤ"۾"Ѳ
		if(endStatus == EndStatusConstant.TYPE_NORMAL &&
				(status == EndStatusConstant.TYPE_WARNING || 
						status == EndStatusConstant.TYPE_ABNORMAL)){
			getCollectorStatus().setEndStatus(status);
		}
		
		// ߤޤǤνλ֤"ٹ"ǡ֤"۾"Ѳ
		if(endStatus == EndStatusConstant.TYPE_WARNING &&
				status == EndStatusConstant.TYPE_ABNORMAL){
			getCollectorStatus().setEndStatus(status);
		}
		
		// ߤޤǤνλ֤"۾"ʳǡ֤"۾"Ѳ
		if(endStatus != EndStatusConstant.TYPE_ABNORMAL &&
				status == EndStatusConstant.TYPE_ABNORMAL){
			getCollectorStatus().setEndStatus(status);
		}
	}
	
	/**
	 * ץѥޤ
	 * @return scopePath ץѥ
	 * 
	 * @ejb.persistence 
	 */
	public String getScopePath() {
		return scopePath;
	}
	
	/**
	 * ץѥꤷޤ
	 * @param scopePath ץѥ
	 */
	public void setScopePath(String scopePath) {
		this.scopePath = scopePath;
	}
	
	/**
	 * ޤ
	 * @return startDate ϻ(򳫻ϤƤʤnull֤)
	 *  @ejb.interface-method
	 *  view-type="both"
	 * @ejb.persistence 
	 */
	public Date getStartDate() {
		if(startTime != 0){
			return new Date(startTime);
		} else {
			return null;
		}
	}
	
	/**
	 * ꤷޤ
	 * @param startTime 
	 * 
	 *  @ejb.interface-method
	 *  view-type="both"
	 *  
	 */
	public void setStartTime(long startTime) {
		this.startTime = startTime;
	}
	
	/**
	 * ơޤ
	 * @return status ơ
	 * 
	 * @ejb.interface-method
	 *  view-type="both"
	 *  
	 * @ejb.persistence 
	 */
	public int getStatus() {
		//QuartzScheduleråå
		try {
			InitialContext iniCtx = JNDIConnectionManager.getInitialContext();
			Scheduler scheduler = (Scheduler)iniCtx.lookup(QuartzConstant.QUARTZ_NAME);
			
			// ϿƤ른֤
			JobDetail job;
			try {
				job = scheduler.getJobDetail(collectorID, QuartzConstant.GROUP_COLLECT);
			} catch (SchedulerException e) {
				m_log.error(e);
				return CollectorRunStatus.ERROR;
			}
			
			// ϿƤȥꥬ
			Trigger trigger = null;
			try {
				trigger = scheduler.getTrigger(collectorID, QuartzConstant.GROUP_COLLECT);
			} catch (SchedulerException e) {
				m_log.error(e);
				return CollectorRunStatus.ERROR;
			}
			
			if(trigger == null){  // ¹ԥ֤¸ߤƤʤ
				if(getStartDate() == null){
					return CollectorRunStatus.READY;
				} else {
					return CollectorRunStatus.FINISHED;
				}
			} else if(job.isDurable()){
				return CollectorRunStatus.RUNNING;
			} else {
				return CollectorRunStatus.SUSPEND;
			}
		} catch (NamingException e) {
			throw new EJBException(e);
		}
	}
		
	/**
	 * λޤ
	 * @return λ
	 * 
	 * @ejb.persistence 
	 */
	public Date getStopDate() {
		if(stopTime == 0 || stopTime == Long.MAX_VALUE) {
			return null;  // ̵¤ξ
		} else {
			return new Date(stopTime);
		}
	}
	
	/**
	 * λꤷޤ
	 * @param stopTime λ
	 */
	public void setStopTime(long stopTime) {
		this.stopTime = stopTime;
	}
	
	/**
	 * ºݤ˼Ƥ֤֤ޤ
	 * @return (ߥ)
	 * 
	 * @ejb.persistence 
	 */
	public long getRealCollectPeriod() {
		Date lastCollect = getCollectorStatus().getLastCollectDate();
		if(lastCollect == null){
			return 0l;
		} else {
			return lastCollect.getTime() - startTime;
		}
	}
	
	private CollectorStatusLocal getCollectorStatus(){
		try {
			return CollectorStatusUtil.getLocalHome().findByPrimaryKey(
					new CollectorStatusPK(collectorID));
		} catch (FinderException e) {
			e.printStackTrace();
		} catch (NamingException e) {
			e.printStackTrace();
		}
		
		return null;
	}
	
	/**
	 * λξ֤ޤ
	 * @return count λ
	 * 
	 * @ejb.persistence 
	 */
	public int getEndStatus() {
		return getCollectorStatus().getEndStatus();
	}
	
	private void setLastCollectDate(Date date)
	{
		getCollectorStatus().setLastCollectDate(date);
	}
	
	/**
	 * ³٤ɤȽꤷޤ
	 * Υ쥯βʾ廲ȤƤʤϡfalse֤ޤ
	 * 
	 * @return ޤ³true򡢽λ٤֤ˤϡfalse֤ޤ
	 * 
	 * @ejb.interface-method
	 *  view-type="both"
	 *  
	 **/
	public boolean checkLifetime(){
		if (MAX_LIFECOUNT >= lifetimeCounter){
			return true;
		} else {
			return false;
		}
	}
	
	/**
	 * ץꥱ˥
	 * 
	 * @param e 㳰
	 */
	private void outputLog(String index, String[] messages) {
		AplLogger apllog = new AplLogger("PERF", "perf");
		apllog.put("SYS", index, messages);
	}
	
	// Ϻͽ
	/**
	 * ʹƻե饰ޤ
	 * @return monitorFlag ʹƻե饰
	 * 
	 * @ejb.persistence 
	 */
	public boolean isMonitorFlag() {
		return false;
	}

	/**
	 * ̵¼Ѥ¸־롣
	 * @return
	 * 	@ejb.interface-method
	 *  view-type="both"
	 *  @ejb.persistence 
	 */
	public int getPresavePeriod() {
		return presavePeriod;
	}
	/**
	 * ̵¼Ѥ¸־򥻥åȤ롣 
	 * @param presavePeriod
	 */
	public void setPresavePeriod(int presavePeriod) {
		this.presavePeriod = presavePeriod;
	}
	
	/**
	 * ǽͤΥޥ͡Ȥ򤪤ʤޤ
	 * 
	 * @ejb.interface-method
	 *	view-type="both" 
	 */
	public void managePresave(Date startDate){

		CalculatedDataDAO dao = new CalculatedDataDAO();
		dao.deleteOverPresave(collectorID, startDate);
		int count = dao.recountFromDB(collectorID);
		if(count != 0){
			this.setCount(count);
		}
	}
	
}
