/*
                                                                                                                                                                 
Copyright (C) 2006 NTT DATA Corporation
                                                                                                                                                                 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.
                                                                                                                                                                 
This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.
                                                                                                                                                                 
*/

package com.clustercontrol.performanceMGR.util;
import java.io.File;
import java.io.FileInputStream;
import java.util.HashMap;
import java.util.Properties;
import java.util.TreeMap;

import javax.ejb.EJBException;

import com.clustercontrol.performanceMGR.bean.CollectorItemInfo;
import com.clustercontrol.performanceMGR.bean.OIDInfo;

/**
 *SNMPǼͤ饰դɬפͤؤη׻Ԥ饹
 *
 * 
 * @version 1.0
 * @since 1.0
 */

public final class CalculationMethod {
	public static int NonDeviece = 0;	// ǥХռʤ
	public static int SingleDevice = 1;	// ǥХ̤ͤ
	public static int MultiDevice = 2;	// ǥХιͤ
	
	// SNMPǼͤηCOUNTER32Ǥäκ
	private static long COUNTER32_MAX_VLUE = ((long)(Integer.MAX_VALUE))*2+1;
	
	private static HashMap m_OIDTable = new HashMap();
	private static String UPTIME_OID;
	private static Boolean initializeFlg = new Boolean(false);
	
	public static void initialize() {
		// ˽Ѥߤξϲ⤷ʤ
		if(initializeFlg.booleanValue()){
			return;
		}
	
		// ǽͻեɤ߹
	    Properties properties = new Properties();
		
		try {
			String homedir = System.getProperty("jboss.server.home.dir");
			String propertyFile = homedir + File.separator + "conf" + File.separator + "performance.properties";
			
			// ץѥƥե뤫饭ͤΥꥹȤɤ߹ߤޤ
			properties.load(new FileInputStream(propertyFile));
		} catch (Exception e) {
			// 顼
			e.printStackTrace();
			return;
		}

		// UPTIME
		UPTIME_OID = properties.getProperty("collector.uptime.oid");
		
		// UPTIME_OIDκǸ"."ʬФUPTIME_BASEOIDȤ
		StringBuffer buffer = new StringBuffer(UPTIME_OID);
//		UPTIME_BASEOID = buffer.delete(buffer.lastIndexOf("."), buffer.length()).toString();
		
		// ǽͤλˡȻФɬפOIDpropertiesե뤫ɤ߹
		int itemNum = 0;
		while(properties.getProperty("collector.item.code." + itemNum) != null){
			itemNum++;
		}
		
		for(int i=0; i<itemNum; i++) {
			String itemCode = properties.getProperty("collector.item.code." + i);
			String operation = properties.getProperty("collector.method." + i);

			int OIDNum = 0;
			while(properties.getProperty("collector.oid." + i + '.' + OIDNum) != null){
				OIDNum++;
			}
			
			String[] oidBase = new String[OIDNum];
			String[] oidIndex = new String[OIDNum];
			int[] types = new int[OIDNum];
			
			for(int j=0; j < OIDNum; j++) {
				String fullOid = properties.getProperty("collector.oid." + i + '.' + j);
				
				// Ǹ"."ʬФOIDȤ
				buffer = new StringBuffer(fullOid);
				oidBase[j] = buffer.delete(buffer.lastIndexOf("."), buffer.length()).toString(); //$NON-NLS-1$

				// Ǹ"."ʬФOIDΥǥåȤ
				buffer = new StringBuffer(fullOid);
				oidIndex[j] = buffer.delete(0, buffer.lastIndexOf(".")+1).toString(); //$NON-NLS-1$
				
				if(fullOid.endsWith(".*")){ //$NON-NLS-1$
					types[j] = MultiDevice;
				} else if (fullOid.endsWith(".?")){ //$NON-NLS-1$
					types[j] = SingleDevice;
				} else {
					types[j] = NonDeviece;
				}
			}
			
			Definition definition = new Definition(
					itemCode,
					operation,
					oidBase,
					oidIndex,
					types
				);
			m_OIDTable.put(itemCode, definition);
		}
		
		// Ѥߥե饰򥻥åȤ롣
		initializeFlg = new Boolean(true);
	}
	

	/**
	 * оݤOIDξ֤ޤ
	 * 
	 * @param itemCodeList ܥɤ
	 * @param deviceIndexList ǥХǥå
	 * @return
	 */
	public static OIDInfo[] getTargetOid(String[] itemCodeList, int[] deviceIndexList){
		initialize();
		
		TreeMap oidInfoMap = new TreeMap();
		
		// åץɬǽ󻻽лǿδˤ뤿
		oidInfoMap.put(CalculationMethod.getUPTimeOID(), CalculationMethod.getUPTimeOIDInfo());
		
		for(int i=0; i<itemCodeList.length; i++){
			// ɬפOIDΥåȤ
			String[] oidBase = CalculationMethod.getOIDs(itemCodeList[i]);  // OID
			String[] oidIndex = CalculationMethod.getOidIndex(itemCodeList[i]);  // OIDΥǥå
			
			for(int j=0; j<oidBase.length; j++){
				OIDInfo buffer = new OIDInfo();
				buffer.setBaseOid(oidBase[j]);

				if(oidIndex[j].equals("*")){ 
					String fullOID = oidBase[j] + "." + "*";
					buffer.setAllIndex(true);
					oidInfoMap.put(fullOID, buffer);
					
				} else if (oidIndex[j].equals("?")){
					String fullOID = oidBase[j] + "." + deviceIndexList[i];  // OIDΥǥåȤƥǥХǥå //$NON-NLS-1$
					buffer.setOidIndex(deviceIndexList[i]);
					buffer.setAllIndex(false);
					oidInfoMap.put(fullOID, buffer);
				} else {
					String fullOID = oidBase[j] + "." + oidIndex[j];  // OIDΥǥå //$NON-NLS-1$
					buffer.setOidIndex(Integer.parseInt(oidIndex[j]));
					buffer.setAllIndex(false);
					oidInfoMap.put(fullOID, buffer);  	// OIDΤߤоݤȤOIDꥹȤ˲ä
				}
			}
		}
		
		// ޥåפ˳ǼƤͤ
		OIDInfo[] targetOID = new OIDInfo[oidInfoMap.values().size()];
		oidInfoMap.values().toArray(targetOID);
		
		return targetOID;
	}
	
	/**
	 * оݤOIDξ֤ޤ
	 * 
	 * @param items ܤ
	 * @return
	 */
	public static OIDInfo[] getTargetOid(CollectorItemInfo[] items){
		initialize();
		
		TreeMap oidInfoMap = new TreeMap();
		
		// åץɬǽ󻻽лǿδˤ뤿
		oidInfoMap.put(CalculationMethod.getUPTimeOID(), CalculationMethod.getUPTimeOIDInfo());
		
		for(int i=0; i<items.length; i++){
			// ɬפOIDΥåȤ
			String[] oidBase = CalculationMethod.getOIDs(items[i].getCollectorItemCode());  // OID
			String[] oidIndex = CalculationMethod.getOidIndex(items[i].getCollectorItemCode());  // OIDΥǥå
			
			for(int j=0; j<oidBase.length; j++){
				OIDInfo buffer = new OIDInfo();
				buffer.setBaseOid(oidBase[j]);

				if(oidIndex[j].equals("*")){ 
					String fullOID = oidBase[j] + "." + "*";
					buffer.setAllIndex(true);
					oidInfoMap.put(fullOID, buffer);
					
				} else if (oidIndex[j].equals("?")){
					String fullOID = oidBase[j] + "." + items[i].getDeviceIndex();  // OIDΥǥåȤƥǥХǥå //$NON-NLS-1$
					buffer.setOidIndex(items[i].getDeviceIndex());
					buffer.setAllIndex(false);
					oidInfoMap.put(fullOID, buffer);
				} else {
					String fullOID = oidBase[j] + "." + oidIndex[j];  // OIDΥǥå //$NON-NLS-1$
					buffer.setOidIndex(Integer.parseInt(oidIndex[j]));
					buffer.setAllIndex(false);
					oidInfoMap.put(fullOID, buffer);  	// OIDΤߤоݤȤOIDꥹȤ˲ä
				}
			}
		}
		
		// ޥåפ˳ǼƤͤ
		OIDInfo[] targetOID = new OIDInfo[oidInfoMap.values().size()];
		oidInfoMap.values().toArray(targetOID);
		
		return targetOID;
	}
	
	/**
	 * ܥɤǽͤη׻ɬפOIDΥꥹȤ֤ʽݻ
	 */
	private static String[] getOIDs(String itemCode){
		initialize();
		return ((Definition)m_OIDTable.get(itemCode)).getOIDs();
	}

	/**
	 * ܥɤǽͤη׻ɬפOIDΥǥåΥꥹȤ֤ʽݻ
	 */
	private static String[] getOidIndex(String itemCode){
		initialize();
		return ((Definition)m_OIDTable.get(itemCode)).getOidIndex();
	}
	
	/**
	 * SNMPuptimeOID ޤ
	 * @return uptimeOID
	 */
	private static String getUPTimeOID(){
		initialize();
		return CalculationMethod.UPTIME_OID;
	}

	/**
	 * SNMPuptimeOID ޤ
	 * @return uptimeOIDInfo
	 */
	public static OIDInfo getUPTimeOIDInfo(){
		initialize();
		OIDInfo returnValue = new OIDInfo();
		
		// Ǹ"."ʬФ
		StringBuffer buffer = new StringBuffer(UPTIME_OID);
		returnValue.setBaseOid(buffer.delete(buffer.lastIndexOf("."), buffer.length()).toString()); //$NON-NLS-1$

		// Ǹ"."ʬФOIDΥǥåȤ
		buffer = new StringBuffer(UPTIME_OID);
		returnValue.setOidIndex(Integer.parseInt(buffer.delete(0, buffer.lastIndexOf(".")+1).toString())); //$NON-NLS-1$
		
		returnValue.setAllIndex(false);
		
		return returnValue;
	}
	
	/**
	 * ܥɤбǽͤη׻Ԥޤ
	 * ǽͻФ˻Ѥޤ
	 * 
	 * @param itemCode ܥ
	 * @param deviceIndexǥХΥǥå
	 * @param mibValueSNMPͤĥϥåޥå
	 * @return ׻줿ǽ
	 */
	public static double getPerformance(final String itemCode, final int deviceIndex, final HashMap mibValue){
		initialize();
		return ((Definition)m_OIDTable.get(itemCode)).calc(deviceIndex, mibValue);	
	}

	/**
	 * ǽͤμоOIDȡǽͤλˡݻ륤ʡ饹
	 */
	public static class Definition {
		private String m_itemCode;
		private Operation m_operation;
		private String m_oidBase[];
		private String m_oidIndex[];
		private int m_types[];
		
		public Definition(String itemCode, String operationType, String baseOIDs[], String[] oidIndex, int[] types) {
			m_itemCode = itemCode;
			m_oidBase = baseOIDs;
			m_oidIndex = oidIndex;
			m_types = types;
			
			String operationClassName = "com.clustercontrol.performanceMGR.util.CalculationMethod$" + operationType;
			
			try{
				m_operation = (Operation)Class.forName(operationClassName).newInstance();
			} catch (ClassNotFoundException e){
				throw new EJBException(e);
			} catch (IllegalAccessException e){
				throw new EJBException(e);
			} catch (InstantiationException e){
				throw new EJBException(e);
			}
		}

		public synchronized double calc(final int deviceIndex, HashMap mibValueSet){	
			m_operation.setOIDBuffer(m_oidBase);
			m_operation.setOIDIndexBuffer(m_oidIndex);
			m_operation.setMibValueSetBuffer(mibValueSet);

			double returnValue = m_operation.calc(deviceIndex);

			m_operation.setOIDBuffer(null);
			m_operation.setOIDIndexBuffer(null);
			m_operation.setMibValueSetBuffer(null);
			
			return returnValue;
		}
		
		/**
		 * @return itemCode ᤷޤ
		 */
		public String getItemCode() {
			return m_itemCode;
		}
		/**
		 * @return OID ᤷޤ
		 */
		public String[] getOidIndex(){
			return m_oidIndex;
		}
		/**
		 * @return OID ᤷޤ
		 */
		public String getOidIndex(int index){
			return m_oidIndex[index];
		}
		/**
		 * @return OID ᤷޤ
		 */
		public String[] getOIDs(){
			return m_oidBase;
		}
		/**
		 * @return OID ᤷޤ
		 */
		public String getOIDs(int index){
			return m_oidBase[index];
		}
		/**
		 * @return types ᤷޤ
		 */
		public int[] getTypes() {
			return m_types;
		}
		/**
		 * @return types ᤷޤ
		 */
		public int getTypes(int index) {
			return m_types[index];
		}
	}

	private abstract static class Operation {
		private String[] m_OIDBuffer;
		private String[] m_OIDIndex;
		private HashMap m_mibValueSetBuffer;
		
		public abstract double calc(final int deviceIndex);
	
		public void setOIDBuffer(String[] OIDBuffer){		
			m_OIDBuffer = OIDBuffer;
		}

		public void setOIDIndexBuffer(String[] OIDIndex){		
			m_OIDIndex = OIDIndex;
		}

		public String getOIDIndex(int index){		
			return m_OIDIndex[index];
		}
		
		public void setMibValueSetBuffer(HashMap mibValueSetBuffer){
			m_mibValueSetBuffer = mibValueSetBuffer;
		}
		
		protected long getMibValue(int OIDIndex, int tableIndex, int timeIndex){
			long[][] mibSet = (long[][])m_mibValueSetBuffer.get(m_OIDBuffer[OIDIndex]);
			if(mibSet == null || mibSet[tableIndex] == null || mibSet.length <= tableIndex){
				return 0;
			} else {
				return mibSet[tableIndex][timeIndex];
			}
		}
		
		protected long[] getMibValueArray(int OIDIndex, int tableIndex){
			long[][] mibSet = (long[][])m_mibValueSetBuffer.get(m_OIDBuffer[OIDIndex]);			
			if(mibSet == null || mibSet[tableIndex] == null || mibSet.length <= tableIndex){
				return null;
			} else {
				return mibSet[tableIndex];
			}
		}

		protected long getCurrentMibValue(int OIDIndex, int tableIndex){
			long[][] mibSet = (long[][])m_mibValueSetBuffer.get(m_OIDBuffer[OIDIndex]);			
			if(mibSet == null || mibSet[tableIndex] == null || mibSet.length <= tableIndex){
				return 0;
			} else {
				return mibSet[tableIndex][1];
			}
		}

		protected long getPreviousMibValue(int OIDIndex, int tableIndex){
			long[][] mibSet = (long[][])m_mibValueSetBuffer.get(m_OIDBuffer[OIDIndex]);			
			if(mibSet == null || mibSet[tableIndex] == null || mibSet.length <= tableIndex){
				return 0;
			} else {
				return mibSet[tableIndex][0];
			}
		}

		
		/**
		 * OID Table Object ο֤
		 * @return
		 */
		public int getTableObjectCount(){
			return m_OIDBuffer.length;
		}
		
		/**
		 * ꤵ줿 OID Table Object ˴ޤޤ֤ܿ
		 * @param OIDIndex
		 * @return
		 */ 
		protected int getOIDCountOfTableObject(int OIDIndex){
			long[][] mibSet = (long[][])m_mibValueSetBuffer.get(m_OIDBuffer[OIDIndex]);		
			return mibSet.length;
		}
	}
	
	// ʿѤɴʬΨǵ׻
	public static class TimeMeanPercentage extends Operation {
		public double calc(int deviceIndex){
			long uptimeDiff;
			long valDirff;
			double perfData;
			
			// uptime  0 ξϻǽ
			if(getPreviousMibValue(0, 0) == 0){
				return Double.NaN;
			}
			
			uptimeDiff = getCurrentMibValue(0, 0) - getPreviousMibValue(0, 0);
			// COUNTER32ξ¤ۤ롼פ˺ͤ­
			if(uptimeDiff < 0){
				uptimeDiff = COUNTER32_MAX_VLUE + 1 + uptimeDiff; 
			}
			
			// ʬ줬0ξʹƤʤ
			if(uptimeDiff == 0){
				return Double.NaN;
			}
			
			valDirff = getCurrentMibValue(1, deviceIndex) - getPreviousMibValue(1, deviceIndex);
			// COUNTER32ξ¤ۤ롼פ˺ͤ­
			if(valDirff < 0){
				valDirff = COUNTER32_MAX_VLUE + 1 + valDirff; 
			}
			
			perfData = ((double)valDirff)/uptimeDiff * 100.0D;
			
			return perfData;
		}
	}
	
	// ʿѤ׻
	public static class TimeMean extends Operation {
		public double calc(int deviceIndex){
			long uptimeDiff;
			long valDirff;
			double perfData;
			
			// uptime  0 ξϻǽ
			if(getPreviousMibValue(0, 0) == 0){
				return Double.NaN;
			}
			
			uptimeDiff = getCurrentMibValue(0, 0) - getPreviousMibValue(0, 0);
			// COUNTER32ξ¤ۤ롼פ˺ͤ­
			if(uptimeDiff < 0){
				uptimeDiff = COUNTER32_MAX_VLUE + 1 + uptimeDiff; 
			}
			
			// ʬ줬0ξʹƤʤ
			if(uptimeDiff == 0){
				return Double.NaN;
			}
			
			valDirff = getCurrentMibValue(1, deviceIndex) - getPreviousMibValue(1, deviceIndex);
			// COUNTER32ξ¤ۤ롼פ˺ͤ­
			if(valDirff < 0){
				valDirff = COUNTER32_MAX_VLUE + 1 + valDirff; 
			}
			
			perfData = ((double)valDirff)/uptimeDiff * 100.0D;  // åץ10ߥñ̤Τ
			
			return perfData;
		}
	}
	
	// ʿѤιפ׻
	public static class TimeMeanSum extends Operation {
		public double calc(int deviceIndex){
			long uptimeDiff;
			long valDirff1;
			long valDirff2;
			double perfData;
			
			// uptime  0 ξϻǽ
			if(getPreviousMibValue(0, 0) == 0){
				return Double.NaN;
			}
			
			uptimeDiff = getCurrentMibValue(0, 0) - getPreviousMibValue(0, 0);
			// COUNTER32ξ¤ۤ롼פ˺ͤ­
			if(uptimeDiff < 0){
				uptimeDiff = COUNTER32_MAX_VLUE + 1 + uptimeDiff; 
			}
			
			// ʬ줬0ξʹƤʤ
			if(uptimeDiff == 0){
				return Double.NaN;
			}
			
			valDirff1 = getCurrentMibValue(1, deviceIndex) - getPreviousMibValue(1, deviceIndex);
			// COUNTER32ξ¤ۤ롼פ˺ͤ­
			if(valDirff1 < 0){
				valDirff1 = COUNTER32_MAX_VLUE + 1 + valDirff1; 
			}
			valDirff2 = getCurrentMibValue(2, deviceIndex) - getPreviousMibValue(2, deviceIndex);
			// COUNTER32ξ¤ۤ롼פ˺ͤ­
			if(valDirff2 < 0){
				valDirff2 = COUNTER32_MAX_VLUE + 1 + valDirff2; 
			}
			
			perfData = ((double)(valDirff1 + valDirff2))/uptimeDiff * 100.0D;  // åץ10ߥñ̤Τ
			
			return perfData;
		}
	}
	
	// ʿѤɴʬΨ;׻
	public static class InvTimeMeanPercentage extends Operation {
		public double calc(int deviceIndex){		
			long uptimeDiff;
			long valDirff;
			double perfData;
			
			uptimeDiff = getCurrentMibValue(0, 0) - getPreviousMibValue(0, 0);
			// COUNTER32ξ¤ۤ롼פ˺ͤ­
			if(uptimeDiff < 0){
				uptimeDiff = COUNTER32_MAX_VLUE + 1 + uptimeDiff; 
			}
			
			// ʬ줬0ξʹƤʤ
			if(uptimeDiff == 0){
				return Double.NaN;
			}
			
			valDirff = getCurrentMibValue(1, deviceIndex) - getPreviousMibValue(1, deviceIndex);
			// COUNTER32ξ¤ۤ롼פ˺ͤ­
			if(valDirff < 0){
				valDirff = COUNTER32_MAX_VLUE + 1 + valDirff; 
			}
			
			perfData = ((double)valDirff)/uptimeDiff * 100.0D;
			
			return 100.0D - perfData;
		}
	}

	// 1ܤǤΤ׻
	public static class PercentageOfTotal  extends Operation {
		public double calc(int deviceIndex){
			long targetDiff;
			long diffTotal = 0;
			double perfData;
			
			targetDiff = getCurrentMibValue(0, deviceIndex) - getPreviousMibValue(0, deviceIndex);
			// COUNTER32ξ¤ۤ롼פ˺ͤ­
			if(targetDiff < 0){
				targetDiff = COUNTER32_MAX_VLUE + 1 + targetDiff; 
			}
			
			long diff;
			diffTotal = targetDiff;  // ǵ᤿ʬͤѤμǤ׻Ԥ
			for(int i=1; i<getTableObjectCount(); i++){
				diff = getCurrentMibValue(i, deviceIndex) - getPreviousMibValue(i, deviceIndex);				
				// COUNTER32ξ¤ۤ롼פ˺ͤ­
				if(diff < 0){
					diff = COUNTER32_MAX_VLUE + 1 + diff; 
				}
				diffTotal += diff;
			}
			
			// ʬ줬0ξʹƤʤ
//			if(diffTotal == 0){
			if(diffTotal <= 100 && targetDiff == 0){  // ɤ줫ͤƤʤн
				return Double.NaN;
			}

			perfData = (double)targetDiff / diffTotal * 100.0D;
			
			return perfData;
		}
	}
	
	// 1ܤ2ܤǤιפΤ׻
	public static class SumPerTotal  extends Operation {
		public double calc(int deviceIndex){
			long targetDiff1;
			long targetDiff2;
			long diffTotal = 0;
			double perfData;

			targetDiff1 = getCurrentMibValue(0, deviceIndex) - getPreviousMibValue(0, deviceIndex);	// 1ܤ
			// COUNTER32ξ¤ۤ롼פ˺ͤ­
			if(targetDiff1 < 0){
				targetDiff1 = COUNTER32_MAX_VLUE + 1 + targetDiff1; 
			}
			
			targetDiff2 = getCurrentMibValue(1, deviceIndex) - getPreviousMibValue(1, deviceIndex); // 2ܤ
			// COUNTER32ξ¤ۤ롼פ˺ͤ­
			if(targetDiff2 < 0){
				targetDiff2 = COUNTER32_MAX_VLUE + 1 + targetDiff2; 
			}
			
			diffTotal = targetDiff1 + targetDiff2;
			for(int i=2; i<getTableObjectCount(); i++){
				diffTotal += getCurrentMibValue(i, deviceIndex) - getPreviousMibValue(i, deviceIndex);
			}
			
			// ʬ줬0ξʹƤʤ
			if(diffTotal == 0){
				return Double.NaN;
			}

			perfData = (double)(targetDiff1 + targetDiff2) / diffTotal * 100.0D;
			
			return perfData;
		}
	}
	
	// 1ܤǰʳΤ׻
	public static class InvPercentageOfTotal extends Operation {	
		public double calc(int deviceIndex){
			long targetDiff;
			long diffTotal = 0;
			double perfData;
			
			targetDiff = getCurrentMibValue(0, deviceIndex) - getPreviousMibValue(0, deviceIndex);
			// COUNTER32ξ¤ۤ롼פ˺ͤ­
			if(targetDiff < 0){
				targetDiff = COUNTER32_MAX_VLUE + 1 + targetDiff; 
			}
			
			long diff;
			diffTotal = targetDiff;  // ǵ᤿ʬͤѤμǤ׻Ԥ
			for(int i=1; i<getTableObjectCount(); i++){
				diff = getCurrentMibValue(i, deviceIndex) - getPreviousMibValue(i, deviceIndex);
				// COUNTER32ξ¤ۤ롼פ˺ͤ­
				if(diff < 0){
					diff = COUNTER32_MAX_VLUE + 1 + diff; 
				}
				
				diffTotal += diff;
			}
			
			// ʬ줬0ξʹƤʤ
			if(diffTotal <= 100 && targetDiff == 0){  // ɤ줫ͤƤʤ100%Ȥʤ뤳Ȥн
				return Double.NaN;
			}

			perfData = (double)targetDiff / diffTotal * 100.0D;
			
			if(perfData == 0){
				for(int i=0; i<getTableObjectCount(); i++){
					long cur = getCurrentMibValue(i, deviceIndex);
					long pre = getPreviousMibValue(i, deviceIndex);
				}
			}
			
			return 100.0D - perfData;
		}
	}
	
	// (1 - x/(y+z))*100׻
	public static class InvPercentage12 extends Operation {
		public double calc(int deviceIndex){
			long total;
			double perfData;
			
			total = getCurrentMibValue(1, deviceIndex) + getCurrentMibValue(2, deviceIndex);
			
			if(total == 0){
				// 顼餯ͤȤƤʤ
				return Double.NaN;
			}
			
			perfData = 100.0D - (double)getCurrentMibValue(0, deviceIndex) / total * 100.0D;
						
			return perfData;
		}
	}
	
	// ʿѤιפ׻
	public static class TimeMeanPerTotal extends Operation {
		public double calc(int deviceIndex){
			long uptimeDiff;
			long totalDiff = 0;
			double perfData;	
			
			// uptime  0 ξϻǽ
			if(getPreviousMibValue(0, 0) == 0){
				return Double.NaN;
			}
			
			uptimeDiff = getCurrentMibValue(0, 0) - getPreviousMibValue(0, 0);
			// COUNTER32ξ¤ۤ롼פ˺ͤ­
			if(uptimeDiff < 0){
				uptimeDiff = COUNTER32_MAX_VLUE + 1 + uptimeDiff; 
			}
			
			// ʬ줬0ξʹƤʤ
			if(uptimeDiff == 0){
				// 顼餯ͤȤƤʤ
				return Double.NaN;
			}
			
			long diff = 0;
			// ǥå1κʬιסʥǥå0uptime
			for(int j=1; j<getTableObjectCount(); j++){
				// ơ֥륤ǥå1ι
				for(int i=1; i<getOIDCountOfTableObject(j); i++){
					diff = getCurrentMibValue(j, i) - getPreviousMibValue(j, i);
					// COUNTER32ξ¤ۤ롼פ˺ͤ­
					if(diff < 0){
						diff = COUNTER32_MAX_VLUE + 1 + diff; 
					}
					
					totalDiff = totalDiff + diff;
				}
			}
			
			perfData = (double)totalDiff/(double)uptimeDiff * 100.0D;  // åץ10ߥñ̤Τ
			
			return perfData;			
		}
	}
	
	// ʿѤιפ򣲤ǳ׻
	public static class TimeMeanPerTotalDividedBy2 extends Operation {
		public double calc(int deviceIndex){
			long uptimeDiff;
			long totalDiff = 0;
			double perfData;	
			
			// uptime  0 ξϻǽ
			if(getPreviousMibValue(0, 0) == 0){
				return Double.NaN;
			}
			
			uptimeDiff = getCurrentMibValue(0, 0) - getPreviousMibValue(0, 0);
			// COUNTER32ξ¤ۤ롼פ˺ͤ­
			if(uptimeDiff < 0){
				uptimeDiff = COUNTER32_MAX_VLUE + 1 + uptimeDiff; 
			}
			
			// ʬ줬0ξʹƤʤ
			if(uptimeDiff == 0){
				// 顼餯ͤȤƤʤ
				return Double.NaN;
			}
			
			long diff = 0;
			// ǥå1κʬιסʥǥå0uptime
			for(int j=1; j<getTableObjectCount(); j++){
				// ơ֥륤ǥå1ι
				for(int i=1; i<getOIDCountOfTableObject(j); i++){
					diff = getCurrentMibValue(j, i) - getPreviousMibValue(j, i);
					// COUNTER32ξ¤ۤ롼פ˺ͤ­
					if(diff < 0){
						diff = COUNTER32_MAX_VLUE + 1 + diff; 
					}
					
					totalDiff = totalDiff + diff;
				}
			}
			
			perfData = (double)totalDiff/(double)uptimeDiff * 100.0D;  // åץ10ߥñ̤Τ
			
			return perfData / 2;
		}
	}
	
	// (x-z)/(x+y) ɴʬΨ׻
	public static class PercentageDiffAdd extends Operation {
		public double calc(int deviceIndex){
			long diff;
			long total;
			double perfData;
			
			diff = getCurrentMibValue(0, deviceIndex) - getCurrentMibValue(2, deviceIndex);
			
			total = getCurrentMibValue(0, deviceIndex) + getCurrentMibValue(1, deviceIndex);
			
			if(total == 0){
				// 顼餯ͤȤƤʤ
				return Double.NaN;
			}
			
			perfData = (double)diff / total * 100.0D;
	
			return perfData;			
		}
	}

	// 1ܤǤͤ100ǳäͤ1ܤǤͤ뤳Ȥա
	public static class DividedBy100 extends Operation {
		public double calc(int deviceIndex){			
			return getCurrentMibValue(0, Integer.parseInt(getOIDIndex(0))) / 100.0D;			
		}
	}
	
	// ¤
	public static class Sum extends Operation {
		public double calc(int deviceIndex){
			return getCurrentMibValue(0, deviceIndex) + getCurrentMibValue(1, deviceIndex);			
		}
	}
	
	// ùʤ᤹ͤ
	public static class Non extends Operation {
		public double calc(int deviceIndex){
			return getCurrentMibValue(0, deviceIndex);			
		}
	}
	
	// 1ܤιܤ2ܤιܤǳäΤɴʬΨ᤹
	public static class Percentage extends Operation {
		public double calc(int deviceIndex){
			double perfData;
			
			if(getCurrentMibValue(1, deviceIndex) == 0) {
				return Double.NaN;				
			} else {
				perfData = (double)getCurrentMibValue(0, deviceIndex) / getCurrentMibValue(1, deviceIndex) * 100.D;
			}
				
			return perfData;			
		}
	}
	
	// 1ܤιܤ2ܤιܤǳäΤλĤγɴʬΨ᤹
	public static class InvPercentage extends Operation {
		public double calc(int deviceIndex){
			double perfData;
			
			if(getCurrentMibValue(1, deviceIndex) == 0) {
				return Double.NaN;				
			} else {
				perfData = 100.0D - (double)getCurrentMibValue(0, deviceIndex) / getCurrentMibValue(1, deviceIndex) * 100.D;
			}
				
			return perfData;			
		}
	}
	
	// 100-(val1+val2+val3)/val0)*100 ׻
	public static class InvPercentage31 extends Operation {
		public double calc(int deviceIndex){
			long total;
			double perfData;

			if(getCurrentMibValue(0, deviceIndex) == 0){
				// 顼餯ͤȤƤʤ
				return Double.NaN;
			}
			
			total = getCurrentMibValue(1, deviceIndex) + getCurrentMibValue(2, deviceIndex) + getCurrentMibValue(3, deviceIndex);
			
			perfData = 100 - (double)total / getCurrentMibValue(0, deviceIndex) * 100.0D;
	
			return perfData;			
		}
	}
}
