/*
                                                                                                                                                                 
Copyright (C) 2006 NTT DATA Corporation
                                                                                                                                                                 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.
                                                                                                                                                                 
This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.
                                                                                                                                                                 
*/

package com.clustercontrol.performanceMGR.util;

/**
 * DBȤΥͥ륯饹
 *
 * @version 1.0
 * @since 1.0
 */

import java.io.File;
import java.io.FileInputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;

import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ConnectionManager {
	//
	protected static Log m_log = LogFactory.getLog(ConnectionManager.class);
	
	private static ConnectionManager instance = null;
	private InitialContext ctx;
	private DataSource ds;
	
	/**
	 * Υ֥Ȥޤ
	 * @returnConnectionManager ͥޥ͡
	 * @throws SQLException
	 */
	public synchronized static ConnectionManager getConnectionManager() throws SQLException {
		if (instance == null) {
			instance = new ConnectionManager();
		}
		return instance;
	}
	
	private ConnectionManager() throws SQLException {
		try {
			ctx = JNDIConnectionManager.getInitialContext();
	
			// ǽͻեɤ߹
		    Properties properties = new Properties();
			
			try {
				String homedir = System.getProperty("jboss.server.home.dir");
				String propertyFile = homedir + File.separator + "conf" + File.separator + "performance.properties";
				
				// ץѥƥե뤫饭ͤΥꥹȤɤ߹ߤޤ
				properties.load(new FileInputStream(propertyFile));
			} catch (Exception e) {
				// 顼
				e.printStackTrace();
				return;
			}
			
			ds = (DataSource) ctx.lookup(properties.getProperty("DataSource"));
		} catch (NamingException e1) {
			throw new SQLException(e1.getMessage());
		}
	}
	
	/**
	 * ͥޤ
	 * @returnconnection DBȤΥͥ
	 * @throws SQLException
	 */
	public synchronized Connection getConnection() throws SQLException {
		return ds.getConnection();
	}
}
