/*
                                                                                                                                                                 
Copyright (C) 2006 NTT DATA Corporation
                                                                                                                                                                 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.
                                                                                                                                                                 
This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.
                                                                                                                                                                 
*/

package com.clustercontrol.performanceMGR.util;

import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;

import javax.ejb.CreateException;

import com.clustercontrol.bean.FacilityConstant;
import com.clustercontrol.bean.FacilityInfo;
import com.clustercontrol.bean.FacilityTreeItem;
import com.clustercontrol.performanceMGR.bean.ScopeRelationData;
import com.clustercontrol.performanceMGR.dao.ScopeRelationDAO;
import com.clustercontrol.performanceMGR.dao.ScopeSnapDAO;

public class FacilityTreeDB {

	/**
	 * ץĥ꡼DB˽񤭹ߤޤ
	 * 
	 * @param collectorID ID
	 * @param fItem եƥΥĥ꡼
	 */
	public void insertFacilityTree(String collectorID, FacilityTreeItem fItem) {
		insertFacilityTree(collectorID, fItem, null);
	}
	
	/**
	 * ץĥ꡼DB˽񤭹ߤޤ
	 * 
	 * @param collectorID ID
	 * @param fItem եƥΥĥ꡼
	 * @param writtenSet DB˽񤭹ߺѤߤΥեƥIDΥåȡ(ƽФκݤnullͿ)
	 */
	private void insertFacilityTree(String collectorID, FacilityTreeItem fItem, HashSet writtenSet) {
		ScopeRelationDAO srdao =  new ScopeRelationDAO();
		ScopeSnapDAO sndao = new ScopeSnapDAO();
		// ʣDB񤭹ߤ򤷤ʤˡ񤭹ߺѤߤΤΤ
		if(writtenSet == null){
			writtenSet = new HashSet(); 
		}
		
		FacilityInfo fInfo = fItem.getData(); //ScopeSnapDAOϤޤ
		FacilityTreeItem[] fArray = fItem.getChildren(); //ҥեƥ
		
		ScopeRelationData  srData = new ScopeRelationData();
		srData.setCollectorID(collectorID);
		
		if(fItem.getParent() !=null ){
			//ƤrelationDTOFacilityID
			srData.setParentFacilityID(fItem.getParent().getData().getFacilityId());
		}else{
			//̵null
			srData.setParentFacilityID("");
		}
		//ʬFacilityID
		srData.setFacilityID(fInfo.getFacilityId());
		
		try {
			// ޤ񤭹ޤƤʤեƥξDB˽񤭹
			if(writtenSet.contains(fInfo.getFacilityId()) == false){
				sndao.insertScopeSnap(collectorID, fInfo);
				writtenSet.add(fInfo.getFacilityId());
			}
			// եƥ֤δطDB˽񤭹
			srdao.insertScopeRelation(srData);	
		} catch (CreateException e) {
		}
		
		for(int i= 0; i < fArray.length;i++){
			insertFacilityTree(collectorID, fArray[i], writtenSet);
		}
	}
	
	/**
	 * եƥĥ꡼ޤ
	 * @return facilityTree եƥĥ꡼
	 * 
	 * @ejb.interface-method
	 *  view-type="both"
	 * 
	 * @ejb.persistence 
	 */
	public FacilityTreeItem getFacilityTree(String collectorID) {
		
		/*
		 * ƥݥ꡼ΰhtȤơĥ꡼¤ޤ
		 * ƻҴطľ֤ht˳ǼƤrootFalicity
		 * Ϣ뤵줿֤֤ͤȤޤ
		 */
		
		ScopeRelationDAO srdao =  new ScopeRelationDAO();
		ScopeSnapDAO sndao = new ScopeSnapDAO();
		
		Hashtable ht = new Hashtable();	//ƥݥ꡼Υϥåơ֥
		
		Hashtable sncol =  null;
		Collection srcol =  null;
		
		//DAOȷ̥å
		FacilityTreeItem currentItem = null;
		FacilityTreeItem parentItem = null;
		
		ScopeRelationData srData = null;
		String current = null;
		String parent = null;
		
		sncol =  sndao.selectScopeSnapByCollectorID(collectorID);
		srcol =  srdao.selectScopeRelationByCollectorID(collectorID);
		
		String topFacility = null;  // Ǿ̤Υեƥ(ݥå)
		
		if(sncol.isEmpty() || srcol.isEmpty()){
		} else {
			Iterator it = srcol.iterator();
			
			while(it.hasNext()){			
				srData =	(ScopeRelationData)it.next();
				
				//ʬȿƤΥեƥID
				current = srData.getFacilityID();
				parent =  srData.getParentFacilityID();
				
				/*ĥ꡼뤿˰ʲԤ
				 * 1. ơʬΥ󥹥󥹤
				 * 2.ʬsetParent,addChildrenǷҤ
				 */
				
				// ʬηݥåȤǤʤϡƤ¸ߤ뤿ᡢ
				if(((FacilityInfo)sncol.get(current)).getType() != FacilityConstant.TYPE_COMPOSITE){
					if(ht.containsKey(parent)){
						//Ƥ¸ߤɤƤ
						parentItem = (FacilityTreeItem) ht.get(parent);
					} else {
						//Ƥ¸ߤʤȤˤϡ礨Ƥ(οƤnullȤƤ)
						parentItem =  new FacilityTreeItem((FacilityTreeItem)null,(FacilityInfo)sncol.get(parent));
						ht.put(parent,parentItem);
					}
				} else {
					// ʬηݥåȤξϡƤ¸ߤʤ				
					parentItem = null;
					topFacility = ((FacilityInfo)sncol.get(current)).getFacilityId();
				}
	
				// ʬΥ󥹥󥹤ƤȷҤ
				if(ht.containsKey(current)){
					//˥󥹥󥹤ƤϡsetParentaddChildrenǷҤ
					currentItem = (FacilityTreeItem) ht.get(current);
					
					// ˿Ƥ¸ߤΡɤξϡΥ󥹥󥹤˿˿ƤϢŤȡ
					// ϿƤƤȤδطڤƤޤᡢ˥󥹥󥹤
					// Υ󥹥󥹤Ͽ롣
					if(currentItem.getData().getType() == FacilityConstant.TYPE_NODE && 
							currentItem.getParent() != null){
						FacilityInfo info = new FacilityInfo();
						info.setFacilityId(currentItem.getData().getFacilityId());
						info.setFacilityName(currentItem.getData().getFacilityName());
						info.setType(currentItem.getData().getType());
						// Ƥꤷƥ󥹥󥹤(Ʊ˿ƥפλҤȤƼʬϿ)
						currentItem =  new FacilityTreeItem(parentItem, info);
					} else {
						// ޤƤϿƤʤեƥ(פ⤷ϥΡ)ξϡƤꤹ롣
						currentItem.setParent(parentItem);
						
						// ƤΥפλҤȤƼʬϿ
						parentItem.addChildren(currentItem);
					}
				} else {
					//ʬ¸ߤʤ
					currentItem =  new FacilityTreeItem(parentItem, (FacilityInfo)sncol.get(current));

					ht.put(current, currentItem);
				}	
			}
		}
		
		// եƥĥ꡼򥳥ݥåȥƥ˷Ҥ
		FacilityTreeItem top = (FacilityTreeItem)ht.get(topFacility);

		return top;
	}
}
