/*
                                                                                                                                                                 
Copyright (C) 2006 NTT DATA Corporation
                                                                                                                                                                 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.
                                                                                                                                                                 
This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.
                                                                                                                                                                 
*/

package com.clustercontrol.performanceMGR.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.naming.NamingException;
import com.clustercontrol.bean.FacilityConstant;
import com.clustercontrol.bean.FacilityInfo;
import com.clustercontrol.bean.FacilityPath;
import com.clustercontrol.bean.FacilityTreeItem;
import com.clustercontrol.repository.bean.FacilityAttributeConstant;
import com.clustercontrol.repository.ejb.session.RepositoryControllerBean;
import com.clustercontrol.repository.ejb.session.RepositoryControllerLocal;
import com.clustercontrol.repository.ejb.session.RepositoryControllerUtil;

/**
 * ݥȥ꤫Υǡ󶡤륯饹
 * @version 1.0
 * @since 1.0
 */
public class Repository {
	/**
	 * ݥȥ꤫鸽ߤΥեƥĥ꡼ޤ
	 * @param facilityID ĥ꡼κǾ̤ΥեƥID
	 * @return եƥĥ꡼κǾ̤
	 */
	public FacilityTreeItem getFacilityTree(String facilityID) {
		// ĥ꡼
		try {
			RepositoryControllerLocal bean = RepositoryControllerUtil.getLocalHome().create();
			FacilityTreeItem facilityTree = bean.getFacilityTree(Locale.getDefault());
			bean.remove();
			
			// ΥեƥIDʲΥĥ꡼
			FacilityTreeItem subFacilityTree = selectFacilityTreeItem(facilityTree, facilityID);
			
			if(subFacilityTree == null){
				// 顼
				String message= "Facility not found : " + facilityID;
				return null;
			}
			
			//FacilityTreeκǾ̥󥹥󥹤
			FacilityInfo info = new FacilityInfo();
			info.setFacilityName(FacilityConstant.STRING_COMPOSITE);
			info.setType(FacilityConstant.TYPE_COMPOSITE);
			FacilityTreeItem top = new FacilityTreeItem(null, info);
			
			// եƥĥ꡼򥳥ݥåȥƥ˷Ҥ
			subFacilityTree.setParent(top);
			top.addChildren(subFacilityTree);
			
			return top;
		} catch (CreateException e) {
			e.printStackTrace();
			throw new EJBException(e);
		} catch (NamingException e) {
			e.printStackTrace();
			throw new EJBException(e);
		} catch (FinderException e) {
			// ݥȥƤѹˤʤäƤʤɤͳǼǤʤä
			// EJBException  throw ʤ
			// ʳˤEntityBeanλȻ(߻ʤ)˻Ȥ뤿
			// EJBException  throw ȽλƤޤߤǤʤʤ
			e.printStackTrace();
		} catch (RemoveException e) {
			e.printStackTrace();
			throw new EJBException(e);
		}
		return null;
	}
	
	/**
	 * ΥեƥIDΥѥޤ
	 * @param facilityID ѥեƥΥեƥID
	 * @return եƥѥ
	 */
	public String getFacilityPath(String facilityID) {
		// ĥ꡼
		try {
			RepositoryControllerLocal bean = RepositoryControllerUtil.getLocalHome().create();
			FacilityTreeItem facilityTree = bean.getFacilityTree(Locale.getDefault());
			bean.remove();

			FacilityTreeItem treeItem = selectFacilityTreeItem(facilityTree, facilityID);
			
			if(treeItem == null){
				// 顼
				String message= "Facility not found : " + facilityID;
				throw new EJBException(message);
			}
			
			FacilityPath fpath = new FacilityPath(">");
			
			return fpath.getPath(treeItem);
		} catch (CreateException e) {
			throw new EJBException(e);
		} catch (NamingException e) {
			throw new EJBException(e);
		} catch (FinderException e) {
			throw new EJBException(e);
		} catch (RemoveException e) {
			throw new EJBException(e);
		}
	}

	/**
	 * ݥȥ꤫ΥեƥIDʲγؤΥΡɤΥǥХޤ
	 * 
	 * @param collectorID ID
	 * @param facilityID оݥեƥID
	 * @returnǥХΥꥹ
	 */
	public List getDeviceList(String facilityID) {
		try {
			RepositoryControllerLocal bean = RepositoryControllerUtil.getLocalHome().create();

			ArrayList deviceList = new ArrayList();
			
			if(facilityID == null){  // եƥIDnullξ
				// פˤդޤƤΥΡɤIDΥꥹȤ
				List nodeList = bean.getNodeFacilityIdList();
				
				Iterator itr = nodeList.iterator();
				while(itr.hasNext()){
					String nodeID = (String)itr.next();

					// ǥХꥹȤɲ
					deviceList.addAll(bean.getDeviceList(nodeID));
				}
			} else if(bean.isNode(facilityID)){	// оݥեƥΡɤξ
				// ΥեƥIDΥǥХ
				 deviceList.addAll(bean.getDeviceList(facilityID));
			} else {	// оݥեƥפξ
				// פˤդޤΡɤIDΥꥹȤ
				List nodeList = bean.getNodeFacilityIdList(facilityID, RepositoryControllerBean.ALL);
				
				Iterator itr = nodeList.iterator();
				while(itr.hasNext()){
					String nodeID = (String)itr.next();

					// ǥХꥹȤɲ
					deviceList.addAll(bean.getDeviceList(nodeID));
				}
			}
			bean.remove();

			return deviceList;
		} catch (CreateException e) {
			throw new EJBException(e);
		} catch (NamingException e) {
			throw new EJBException(e);
		} catch (FinderException e) {
			throw new EJBException(e);
		} catch (RemoveException e) {
			throw new EJBException(e);
		}
	}
	
	/**
	 * եƥĥ꡼ǻΥեƥIDĥեƥƵŪõޤ
	 * 
	 * @param facilityTree оݤΥեƥĥ꡼
	 * @param facilityID ѥեƥΥեƥID
	 * @return եƥ
	 */
	private FacilityTreeItem selectFacilityTreeItem(FacilityTreeItem facilityTree, String facilityID){
		if(facilityTree.getData().getFacilityId().equals(facilityID)){
			return facilityTree;
		} else {
			for(int i=0; i<facilityTree.getChildren().length; i++){
				FacilityTreeItem target = facilityTree.getChildren()[i];
				FacilityTreeItem temp = selectFacilityTreeItem(target, facilityID);  // ƵŪ
				if(temp != null){
					return temp;  
				}
			}
		}
		return null;
	}
	
	/**
	 * եƥIDΥΡɤIPɥ쥹ޤ
	 * 
	 * @param facilityID оݤΥեƥID
	 */
	public String getIPAddress(String facilityID) {
		HashMap nodeInfo = new HashMap();
		
		// IPɥ쥹
		try {
			RepositoryControllerLocal bean = RepositoryControllerUtil.getLocalHome().create();
			ArrayList attributes = new ArrayList();
			attributes.add(FacilityAttributeConstant.IPNETWORKNUMBER);
			nodeInfo = bean.getNodeDetail(facilityID, attributes);
			bean.remove();
		} catch (CreateException e) {
			throw new EJBException(e);
		} catch (NamingException e) {
			throw new EJBException(e);
		} catch (FinderException e) {
			throw new EJBException(e);
		} catch (RemoveException e) {
			throw new EJBException(e);
		}

		if(nodeInfo != null){
			return (String)nodeInfo.get(FacilityAttributeConstant.IPNETWORKNUMBER);
		} else {
			// 顼
			String message= "Couldn't get an IP Address : " + facilityID;
			throw new EJBException(message);
		}
	}
	
	/**
	 * ΥեƥIDΡɤǤ뤫ݤȽꤷޤ
	 * 
	 * @param facilityID եƥID
	 * @return Ρɤξ true
	 */
	public boolean isNode(String facilityID){
		RepositoryControllerLocal bean = null;
		try {
			bean = RepositoryControllerUtil.getLocalHome().create();
			return bean.isNode(facilityID);
		} catch (CreateException e) {
			throw new EJBException(e);
		} catch (NamingException e) {
			throw new EJBException(e);
		} catch (FinderException e) {
			throw new EJBException(e);
		} finally {
			try {
				bean.remove();
			} catch (EJBException e) {
				throw new EJBException(e);
			} catch (RemoveException e) {
				throw new EJBException(e);
			}
		}
	}
}
