/*
                                                                                                                                                                 
Copyright (C) 2006 NTT DATA Corporation
                                                                                                                                                                 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.
                                                                                                                                                                 
This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.
                                                                                                                                                                 
*/

package com.clustercontrol.performanceMGR.ejb.session;

import javax.ejb.DuplicateKeyException;
import javax.ejb.EJBException;
import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.swt.SWT;

import java.rmi.RemoteException;
import java.util.Collection;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Date;
import java.util.Locale;

import com.clustercontrol.bean.FacilityTreeItem;
import com.clustercontrol.bean.TableColumnInfo;
import com.clustercontrol.performanceMGR.bean.CollectorItemInfo;
import com.clustercontrol.performanceMGR.bean.CollectedDataInfo;
import com.clustercontrol.performanceMGR.bean.CollectedDataSet;
import com.clustercontrol.performanceMGR.bean.CollectorLockKey;
import com.clustercontrol.performanceMGR.bean.CollectorProperty;
import com.clustercontrol.performanceMGR.bean.CollectorRunStatus;
import com.clustercontrol.performanceMGR.bean.CollectorType;
import com.clustercontrol.performanceMGR.bean.DeviceData;
import com.clustercontrol.performanceMGR.bean.DeviceDataSet;
import com.clustercontrol.performanceMGR.bean.CollectionTabelDefine;
import com.clustercontrol.performanceMGR.dao.CalculatedDataDAO;
import com.clustercontrol.performanceMGR.dao.CollectorItemDAO;
import com.clustercontrol.performanceMGR.dao.DeviceDAO;
import com.clustercontrol.performanceMGR.ejb.bmp.Collector;
import com.clustercontrol.performanceMGR.ejb.bmp.CollectorHome;
import com.clustercontrol.performanceMGR.ejb.bmp.CollectorPK;
import com.clustercontrol.performanceMGR.ejb.bmp.CollectorUtil;
import com.clustercontrol.performanceMGR.ejb.bmp.RecordCollectorData;

import com.clustercontrol.performanceMGR.util.FacilityTreeDB;
import com.clustercontrol.performanceMGR.util.JNDIConnectionManager;
import com.clustercontrol.performanceMGR.util.LockManager;
import com.clustercontrol.performanceMGR.util.Messages;
import com.clustercontrol.performanceMGR.util.Repository;
import com.clustercontrol.performanceMGR.util.code.CollectorItemCodeTable;
import com.clustercontrol.performanceMGR.util.code.CollectorItemTreeItem;

/**
 * 饤Ȥ饢դStatefullSessionBean饹
 *
 * SessionFacadeԤޤ
 * 
 * @version 1.0
 * @since 1.0
 *
 * <!-- begin-xdoclet-definition --> 
 * @ejb.bean name="CollectorController"	
 *           jndi-name="CollectorController"
 *           type="Stateful" 
 *           transaction-type="Container"
 *           
 * <!-- @jboss.clustered -->
 * 
 * @jboss.depends name="jboss.j2ee:service=EJB,jndiName=AccessController"
 * @jboss.depends name="jboss.j2ee:service=EJB,jndiName=RepositoryController"
 * @jboss.depends name="jboss.j2ee:service=EJB,jndiName=MonitorController"
 * @jboss.depends name="jboss.j2ee:service=EJB,jndiName=QuartzManager"
 * @jboss.depends name="jboss.j2ee:service=EJB,jndiName=NotifyController"
 * @jboss.depends name="jboss.j2ee:service=EJB,jndiName=MonitorInfo"
 *           
 * @ejb.permission
 *     unchecked="true"
 *     method-intf="Home"
 *     
 * @ejb.permission
 *     unchecked="true"
 *     method-intf="LocalHome"
 *     
 * @ejb.permission
 *     unchecked="true"
 *     method-intf="Local"
 * 
 * <!-- end-xdoclet-definition --> 
 * @generated
 */
public abstract class CollectorControllerBean implements javax.ejb.SessionBean {
	
	//	
	protected static Log m_log = LogFactory.getLog(CollectorControllerBean.class);
	
	/** ǽͤμоݤס*/
	public static final int CURRENT_SCOPE = 0;
	/** ǽͤоݤ֥*/
	public static final int SUB_SCOPE = 1;
	
	private String m_collectorID;  // ID
	private int m_collectorType;   // ̡ʥꥢ륿 ⤷ ӡ
	
	/**
	 * SessionBean˥ƥʤƤФޤ
	 *
	 * <!-- begin-user-doc -->
	 * The  ejbCreate method.
	 * <!-- end-user-doc -->
	 *
	 * <!-- begin-xdoclet-definition --> 
	 * @ejb.create-method 
	 * <!-- end-xdoclet-definition --> 
	 * @generated
	 */
	public void ejbCreate() throws CreateException {
		// Υơ
		this.m_collectorType = CollectorType.UNKNOWN;		
	}
	
	/**
	 * SessionBean˥ƥʤƤФޤ
	 **/
	public void ejbRemove() {
		m_log.debug("ejbRemove() start : " + m_collectorID);
		
		// ꥢ륿ξ
		if(this.m_collectorType == CollectorType.REALTIME){
			try {			
				CollectorHome home = JNDIConnectionManager.getCollectorHome();
				Collector myBean = home.findByPrimaryKey(new CollectorPK(m_collectorID));
				
				// 
				myBean.stopCollect();
				
				// DBμ
				myBean.remove();
			} catch (FinderException e) {
				throw new EJBException(e.getMessage(), e);
			} catch (NamingException e) {
				throw new EJBException(e.getMessage(), e);
			} catch (EJBException e) {
				throw new EJBException(e.getMessage(), e);
			} catch (RemoveException e) {
				throw new EJBException(e.getMessage(), e);
			} catch (RemoteException e) {
				throw new EJBException(e.getMessage(), e);
			}
		}
		m_log.debug("ejbRemove() end : " + m_collectorID);
	}
	
	/**
	 * SessionBean󥹥󥹤׾֤ˤʤ˥ƥʤƤФޤ
	 **/
	public void ejbPassivate(){
	}
	
	/**
	 * ꥢ륿ѤEntityBeanޤ
	 * 
	 * @param facilityID եƥID
	 * @param interval ֳ
	 * @param colletorItemListΥꥹ
	 * 
	 * @ejb.interface-method
	 *	view-type="both" 
	 *
	 * @ejb.permission
     *  role-name="PerformanceExecute"
     *  method-intf="Remote"
     *  
	 **/
	public void createRealtimeColletor(String facilityID, int interval, List colletorItemList) {
		m_collectorType = CollectorType.REALTIME;
		
		// ID
		m_collectorID = (CollectorUtil.generateGUID(this));
		
		// ǥХå
		m_log.debug("createRealtimeColletor() start : " + 
				Thread.currentThread().getName() + "\t" + m_collectorID);
		
		try {
			RecordCollectorData data = new RecordCollectorData();
			data.setCollectorID(m_collectorID);
			data.setCollectorType(CollectorType.REALTIME);
			data.setLabel(Thread.currentThread().getName());  // å̾ܤ
			data.setFacilityID(facilityID);
			data.setInterval(interval);
			data.setPeriod(-1);  // ̵֤¤

			// ץĥ꡼
			Repository repository = new Repository();
			FacilityTreeItem facilityTree = repository.getFacilityTree(facilityID);
			data.setFacilityTree(facilityTree);

			// оݥפ¸ߤʤϥ顼
			if(facilityTree == null){
				// 顼
				return;				
			}
			
			// RealtimeCollector Entity Bean 
			CollectorHome home = JNDIConnectionManager.getCollectorHome();
			Collector myBean = home.create(data, colletorItemList);
			
			// γϤؼ
			myBean.startCollect();
		} catch (CreateException e) {
			throw new EJBException(e);
		} catch (NamingException e){
			throw new EJBException(e);
		} catch (RemoteException e) {
			throw new EJBException(e);
		}
		
		m_log.debug("createRealtimeColletor() end : " + Thread.currentThread().getName() + "\t" + m_collectorID);
	}
	
	/**
	 * ꥢ륿μѤߥǡޤ
	 * @param facilityID եƥID
	 * @param itemIDID
	 * @param optionоݤؼʻꥹסCURRENT_SCOPEˤ⤷ϻꥹפΥ֥סSUB_SCOPEˡ
	 * @returnѤǽǡΥ쥯
	 * 
	 * @ejb.interface-method
	 *	view-type="both" 
	 *
	 * @ejb.permission
     *  role-name="PerformanceExecute"
     *  method-intf="Remote"
     *  
	 */
	public Collection getRealtimeCollectedData(String facilityID, int itemID, int option) { 
		try {
			CollectorHome home = JNDIConnectionManager.getCollectorHome();
			Collector myBean = home.findByPrimaryKey(new CollectorPK(m_collectorID));
			
			// ǽͤ
			if(option == CURRENT_SCOPE){
				CollectedDataInfo data = myBean.getValue(facilityID, itemID);
				ArrayList<CollectedDataInfo> ret = new ArrayList<CollectedDataInfo>();
				ret.add(data);
				return ret;
			} else if(option == SUB_SCOPE){
				return myBean.getSubScopeValues(facilityID, itemID);
			} else {
				return null;
			}
		} catch (FinderException e) {
			throw new EJBException(e);
		} catch (NamingException e){
			throw new EJBException(e);
		} catch (RemoteException e) {
			throw new EJBException(e);
		}
	}
	
	/**
	 * ꥢ륿μѤߥǡޤ 	 
	 * @param facilityIDեƥID
	 * @param itemIDs ܤ
	 * @return ѤǽǡΥ쥯
	 * 
	 * @ejb.interface-method
	 *	view-type="both" 
	 *
	 * @ejb.permission
     *  role-name="PerformanceExecute"
     *  method-intf="Remote"
	 *
	 */
	public Collection getRealtimeCollectedData(String facilityID, int[] itemIDs) {
		try{
			ArrayList<CollectedDataInfo> ret = new ArrayList<CollectedDataInfo>();

			CollectorHome home = JNDIConnectionManager.getCollectorHome();
			Collector myBean = home.findByPrimaryKey(new CollectorPK(m_collectorID));
			
			for(int i=0; i<itemIDs.length; i++){
				// ǽͤ
				ret.add(myBean.getValue(facilityID, itemIDs[i]));
			}
			
			return ret;
		} catch (FinderException e) {
			throw new EJBException(e);
		} catch (NamingException e){
			throw new EJBException(e);
		} catch (RemoteException e) {
			throw new EJBException(e);
		}
	}
	
	/**
	 * ꥢ륿μѤߥǡޤ
	 * ΥեƥǼƤƤμܤǽͥǡޤ
	 * 
	 * @param facilityID
	 * @return ѤǽǡΥ쥯
	 * 
	 * @ejb.interface-method
	 *	view-type="both" 
	 *
	 * @ejb.permission
     *  role-name="PerformanceExecute"
     *  method-intf="Remote"
	 *
	 **/
	public Collection getRealtimeCollectedDataAll(String facilityID) {
		try {
			CollectedDataInfo[] returnData = null;
			
			CollectorHome home = JNDIConnectionManager.getCollectorHome();
			Collector myBean = home.findByPrimaryKey(new CollectorPK(m_collectorID));
			
			// ǽͤ
			returnData = myBean.getValueAll(facilityID);
			return Arrays.asList(returnData); 
		} catch (FinderException e) {
			throw new EJBException(e);
		} catch (NamingException e){
			throw new EJBException(e);
		} catch (RemoteException e) {
			throw new EJBException(e);
		}
	}
	
	/**
	 * Υץѥƥޤ
	 * @param collectorID ID
	 * @return Υץѥƥ
	 * 
	 * @ejb.interface-method
	 *	view-type="remote"
	 *
	 *	 * @ejb.permission
     *  role-name="PerformanceRead"
     *  method-intf="Remote"
	 *
	 **/
	public CollectorProperty getCollectorProperty(String collectorID) { 
		// ID
		m_collectorID = collectorID;
		
		CollectorProperty property = new CollectorProperty();
		
		RecordCollectorData collectorData = null;
		
		try {
			// Entity Bean 
			CollectorHome home = JNDIConnectionManager.getCollectorHome();
			Collector myBean = home.findByPrimaryKey(new CollectorPK(collectorID));
			
			// 
			collectorData = myBean.getRecordColletorData();
			
			// ǥХ
			property.setDeviceSet(getDeviceSet(collectorID));
			
			// ץĥ꡼
			collectorData.setFacilityTree(this.getFacilityTree(collectorID));
			
			// Ǽ
			property.setCollectorData(collectorData);
			
			// ѤDAO
			CollectorItemDAO dao = new CollectorItemDAO();
			
			
			ArrayList itemList = new ArrayList(
					dao.selectCollectorItemByCollectorID(collectorID)
			);
			
			property.setItemList(itemList);
						
			return property;
		} catch (FinderException e) {
			throw new EJBException(e);
		} catch (NamingException e){
			throw new EJBException(e);
		} catch (RemoteException e) {
			throw new EJBException(e);
		}
	}
	
	/**
	 * ӾѤEntityBeanޤ
	 * @param collectorDef
	 * 
	 * @ejb.interface-method
	 *	view-type="remote" 
	 *
	 * @ejb.permission
     *  role-name="PerformanceWrite"
     *  method-intf="Remote"
	 *
	 **/
	public void createRecordColletor(CollectorProperty collectorDef)
	throws DuplicateKeyException {
		// ǥХå
		m_log.debug("createRecordColletor() start : " + Thread.currentThread().getName() + "\t" + m_collectorID);
		
		// ̤
		this.m_collectorType = CollectorType.RECORD;
		
		// Bean˼ID
		m_collectorID = collectorDef.getCollectorData().getCollectorID();
		
		RecordCollectorData collectorData = collectorDef.getCollectorData();
		collectorData.setCollectorType(m_collectorType);
		
		// ν񤭹ߤEntity Bean
		try {
			// γϤؼ
			CollectorHome home = JNDIConnectionManager.getCollectorHome();
			Collector collector = home.create(collectorData, collectorDef.getItemList());
			
			collector.startCollect();
		} catch (DuplicateKeyException e) {
			throw e;  // ʣϥ饤Ȥޤꤲ
		} catch (CreateException e) {
			throw new EJBException(e);
		} catch (NamingException e){
			throw new EJBException(e);
		} catch (RemoteException e) {
			throw new EJBException(e);
		}
		
		m_log.debug("createRecordColletor() end : " + Thread.currentThread().getName() + "\t" + m_collectorID);
	}
	
	/**
	 * Ӽߤޤ
	 * 
	 * @param collectorID ߤID
	 * @ejb.interface-method
	 *	view-type="remote" 
	 *
	 * @ejb.permission
     *  role-name="PerformanceExecute"
     *  method-intf="Remote"
	 *
	 */
	public void stopRecordCollector(String collectorID) {
		
		try {
			CollectorHome home = JNDIConnectionManager.getCollectorHome();
			Collector myBean = home.findByPrimaryKey(new CollectorPK(collectorID));
			
			// ߤؼ
			myBean.stopCollect();
		} catch (FinderException e) {
			throw new EJBException(e);
		} catch (NamingException e){
			throw new EJBException(e);
		} catch (RemoteException e) {
			throw new EJBException(e);
		}
	}
	
	/**
	 * ӼǼ줿ǡޤ
	 * @param collectorID ID
	 * @param facilityIDեƥID
	 * @param itemIDID
	 * @param startDateλ
	 * @param endDateλ
	 * @returnǡΥǡå
	 *  
	 * @ejb.interface-method
	 *	view-type="remote" 
	 *
	 * @ejb.permission
     *  role-name="PerformanceRead"
     *  method-intf="Remote"
	 *
	 */
	public List getRecordCollectedData(
			CollectorItemInfo item, String facilityID, Date startDate, Date endDate) {
		m_log.debug("getRecordCollectedData() " + facilityID);
		CalculatedDataDAO dao = new CalculatedDataDAO();
		
		List data = dao.select(
				item.getCollectorID(), 
				item.getCollectorItemCode(), 
				item.getDeviceIndex(), 
				facilityID,
				startDate, 
				endDate);
		
		return data;
	}
	
	/**
	 * ӼǼ줿ǡޤ
	 * @param collectorID ID
	 * @param facilityIDsեƥID
	 * @param itemIDsID
	 * @param startDateλ
	 * @param endDateλ
	 * @returnǡΥǡå
	 *  
	 * @ejb.interface-method
	 *	view-type="remote" 
	 *
	 * @ejb.permission
     *  role-name="PerformanceRead"
     *  method-intf="Remote"
	 *
	 */
	public CollectedDataSet getRecordCollectedData
	(CollectorItemInfo[] items, String[] facilityIDs, Date startDate, Date endDate) {
		CollectedDataSet ret = new CollectedDataSet();

		for(int j=0; j<facilityIDs.length; j++){
			for(int i=0; i<items.length; i++){
				List dataList = getRecordCollectedData(
						items[i], 
						facilityIDs[j],
						startDate,
						endDate);
				ret.setCollectedDataList(facilityIDs[j], items[i].getCollectorItemID(), dataList);
			}
		}
		
		return ret;
	}
	
	/**
	 * ӼǼ줿ǡޤ
	 * @param collectorID ID
	 * @param facilityIDեƥID
	 * @param itemIDID
	 * @param startDateλ
	 * @param endDateλ
	 * @returnǡΥǡå
	 *  
	 * @ejb.interface-method
	 *  view-type="remote"
	 *
	 * @ejb.permission
     *  role-name="PerformanceRead"
     *  method-intf="Remote"
	 *
	 */
	public CollectedDataSet getRecordCollectedData
	(String collectorID, String[] facilityIDs, int[] itemID, Date startDate, Date endDate) {
		CollectedDataSet ret = new CollectedDataSet();

		CollectorItemDAO dao = new CollectorItemDAO();
		
		for(int j=0; j<facilityIDs.length; j++){
			for(int i=0; i<itemID.length; i++){
				// ܤDBޤ
				CollectorItemInfo item = dao.selectCollectorItem(collectorID, itemID[i]);
				
				List dataList = getRecordCollectedData(
						item, 
						facilityIDs[j],
						startDate,
						endDate);
				ret.setCollectedDataList(facilityIDs[j],item.getCollectorItemID(), dataList);
			}
		}
		
		return ret;
	}
	
	/**
	 * Ӽڤӡǽƺޤ
	 * @param collectorIDID
	 * 
	 * @ejb.interface-method
	 *	view-type="remote" 
	 *
	 * @ejb.permission
     *  role-name="PerformanceWrite"
     *  method-intf="Remote"
	 *
	 **/
	public void deleteRecordCollector(String collectorID) throws RemoveException {
		// ǥХå
		m_log.debug("deleteRecordCollector() start : " + Thread.currentThread().getName() + "\t" + m_collectorID);
		
		// åƤ뤫ݤå
		if(LockManager.isLocked(collectorID)){
			m_log.debug("deleteRecordCollector()  : " + collectorID + " is locked.");
			throw new RemoveException(collectorID + " is locked.");
		}
		
		try {
			// CollectorIDEntityBean
			CollectorHome home = JNDIConnectionManager.getCollectorHome();
			Collector myBean = home.findByPrimaryKey(new CollectorPK(collectorID));
			
			// ޤưξ
			if(myBean.getStatus() == CollectorRunStatus.RUNNING){
				m_log.debug("deleteRecordCollector()  : " + collectorID + " is running.");
				throw new RemoveException(collectorID + " is running.");
			}
			
			myBean.remove();
		} catch (FinderException e) {
			throw new RemoveException(e.getMessage());
		} catch (NamingException e){
			throw new RemoveException(e.getMessage());
		} catch (RemoveException e) {
			throw e;
		} catch (RemoteException e) {
			throw new RemoveException(e.getMessage());
		}		
		
		m_log.debug("deleteRecordCollector() end : " + Thread.currentThread().getName() + "\t" + m_collectorID);
	}
	
	/**
	 * Υեƥĥ꡼ޤ
	 * @param collectorID ID
	 * @return FacilityTreeItem եƥĥ꡼
	 * 
	 * @ejb.interface-method
	 *	view-type="remote" 
	 *
	 * @ejb.permission
     *  role-name="PerformanceRead"
     *  method-intf="Remote"
	 *
	 **/
	public FacilityTreeItem getFacilityTree(String collectorID){
		return new FacilityTreeDB().getFacilityTree(collectorID);
	}
	
	/**
	 * ߤΥݥȥϿƤǥХ󤫤
	 * ΥեƥIDʲγؤΥΡɤΥǥХΥꥹȤޤ
	 * @param եƥID
	 * @return ǥХΥå
	 * 
	 * @ejb.interface-method
	 *	view-type="remote" 
	 *
	 * @ejb.permission
     *  role-name="PerformanceRead"
     *  method-intf="Remote"
	 *
	 **/
	public DeviceDataSet getCurrentDeviceSet(String facilityID) {
		DeviceDataSet dataSet = new DeviceDataSet();
		
		Repository repository = new Repository();
		List deviceList = repository.getDeviceList(facilityID);
		Iterator itr = deviceList.iterator();
		
		// ǥХ
		while(itr.hasNext()){
			dataSet.putDeviceList((DeviceData)itr.next());
		}
		
		return dataSet;
	}

	/**
	 * ˴ޤޤ줿եƥΥǥХޤ
	 * @param collectorIDID
	 * @return ǥХΥå
	 * 
	 * @ejb.interface-method
	 *	view-type="remote" 
	 *
	 * @ejb.permission
     *  role-name="PerformanceRead"
     *  method-intf="Remote"
	 *
	 **/
	public DeviceDataSet getDeviceSet(String collectorID)
	throws FinderException, NamingException {
		DeviceDataSet dataSet = new DeviceDataSet();
		
		// ǥХѤDAO
		DeviceDAO dao = new DeviceDAO();
		
		// ǥХDB
		Collection devicList = dao.selectDeviceByCollectorID(collectorID);
		
		// ǥХ
		Iterator itr = devicList.iterator();
		while(itr.hasNext()){
			dataSet.putDeviceList((DeviceData)itr.next());
		}
		
		return dataSet;
	}
	
	/**
	 * μIDΥǡФƺå򤫤ޤ
	 * 
	 * @ejb.interface-method
	 *	view-type="remote" 
	 *
	 * @ejb.permission
     *  unchecked="true"
     *  method-intf="Remote"
	 *
	 **/
	public void lock(String collectorID, CollectorLockKey key) {
		LockManager.lock(collectorID, key);
	}

	/**
	 * μIDΥǡФåޤ
	 * 
	 * @ejb.interface-method
	 *	view-type="remote"
	 *
	 * @ejb.permission
     *  unchecked="true"
     *  method-intf="Remote"
	 *
	 **/
	public void unlock(CollectorLockKey key){
		LockManager.unlock(key);
	}
	
	/**
	 * Υơ֥֤ޤ
	 * 
	 * @ejb.interface-method
	 * @generated
	 * 
 	 * @ejb.permission
     *  unchecked="true"
     *  method-intf="Remote"
	 * 
	 * @param locale 
	 * @return TableColumnInfo
	 */
	public ArrayList getCollectionListTableDefine(Locale locale) {
		
		/** ơ֥ */
		ArrayList<TableColumnInfo> tableDefine = new ArrayList<TableColumnInfo>();

		tableDefine.add(CollectionTabelDefine.RUN_STATUS, 
				new TableColumnInfo(Messages.getString("run.status", locale), TableColumnInfo.STATE, 70, SWT.LEFT));
		tableDefine.add(CollectionTabelDefine.ERROR_STATUS, 
				new TableColumnInfo(Messages.getString("error.status", locale), TableColumnInfo.END_STATUS, 70, SWT.LEFT));
		tableDefine.add(CollectionTabelDefine.COLLECTOR_ID, 
				new TableColumnInfo(Messages.getString("collector.id", locale), TableColumnInfo.NONE, 200, SWT.LEFT));
		tableDefine.add(CollectionTabelDefine.DESCRIPTION, 
				new TableColumnInfo(Messages.getString("description", locale), TableColumnInfo.NONE, 220, SWT.LEFT));
		tableDefine.add(CollectionTabelDefine.SCOPE, 
				new TableColumnInfo(Messages.getString("scope", locale), TableColumnInfo.FACILITY, 220, SWT.LEFT));
		tableDefine.add(CollectionTabelDefine.START_DATE, 
				new TableColumnInfo(Messages.getString("start.date", locale), TableColumnInfo.NONE, 150, SWT.LEFT));
		tableDefine.add(CollectionTabelDefine.STOP_DATE, 
				new TableColumnInfo(Messages.getString("stop.date", locale), TableColumnInfo.NONE, 150, SWT.LEFT));
		tableDefine.add(CollectionTabelDefine.INTERVAL, 
				new TableColumnInfo(Messages.getString("interval", locale), TableColumnInfo.NONE, 70, SWT.LEFT));
		tableDefine.add(CollectionTabelDefine.COUNT, 
				new TableColumnInfo(Messages.getString("count", locale), TableColumnInfo.NONE, 70, SWT.LEFT));

		return tableDefine;
	}
	
	/**
	 * Ӽ֤ޤ
	 * 
	 * @ejb.interface-method
	 * @generated
	 * 
	 * @ejb.permission
     *  role-name="PerformanceRead"
     *  method-intf="Remote"
	 * 
	 * @return Object2
	 * @throws NamingException 
	 * @throws FinderException 
	 */
	public ArrayList getCollectionList() {
		m_log.debug("getCollectionList() start : ");
		
		ArrayList<ArrayList> list = new ArrayList<ArrayList>();
		
		try {
			// ̤ӤǤEntityBean
			CollectorHome home = JNDIConnectionManager.getCollectorHome();
			Collection myBeans = home.findByCollectorType(CollectorType.RECORD);
			
			Iterator itr = myBeans.iterator();
			while(itr.hasNext())
			{
				Collector myBean = (Collector)itr.next();
				
				// 
				RecordCollectorData data = myBean.getRecordColletorData();
				
				ArrayList<Object> info = new ArrayList<Object>();
				info.add(new Integer(data.getStatus()));
				info.add(new Integer(data.getEndStatus()));
				info.add(data.getCollectorID());
				info.add(data.getLabel());
				info.add(data.getScopePath());
				info.add(data.getStartDate());
				info.add(data.getStopDate());
				info.add(data.getInterval());
				info.add(new Integer(data.getCount()));
				list.add(info);
			}
		} catch (FinderException e) {
			throw new EJBException(e);
		} catch (NamingException e) {
			throw new EJBException(e);
		} catch (RemoteException e) {
			throw new EJBException(e);
		}
		
		m_log.debug("getCollectionList() end   : ");
		return list;
	}
	
	/**
	 * ܥɤΰޤ
	 * 
	 * @ejb.interface-method
	 * @generated
	 * 
	 * @ejb.permission
     *  unchecked="true"
     *  method-intf="Remote"
     *   
	 * @return
	 */
	public HashMap<String, CollectorItemTreeItem> getItemCodeMap(){
		return CollectorItemCodeTable.getItemCodeMap();
	}
	
	/**
	 * ܥĥ꡼֤ޤ
	 * 
	 * @ejb.interface-method
	 * @generated
	 * 
	 * @ejb.permission
     *  role-name="PerformanceRead"
     *  method-intf="Remote"
	 * 
	 * @param facilityId
	 * @param collectorId
	 * @return
	 */
    public CollectorItemTreeItem[] getCollectorTree(String facilityId, String collectorId) {
    	return CollectorItemCodeTable.getCollectorTree(facilityId, collectorId);
    }
    
    /**
     * ǽʹܤΥꥹȤ֤ޤ
     * 
	 * @ejb.interface-method
	 * @generated
	 * 
	 * @ejb.permission
     *  role-name="PerformanceRead"
     *  method-intf="Remote"
     *
     * @param facilityId
     * @return
     */
    public List getAvailableCollectorItemList(String facilityId) {
    	return CollectorItemCodeTable.getAvailableCollectorItemList(facilityId);
    }

    /**
     * ǽɤå뤿Υ᥽å
     * ɤ߹߸¤ΤroleǸƤӽФtrue֤
     * 
	 * @ejb.interface-method
	 * @generated
	 * 
	 * @ejb.permission
     *  role-name="PerformanceRead"
     *  method-intf="Remote"
     *
     * @return true
     */
    public boolean checkPermissionRead() {
    	return true;
    }
    
    /**
     * ǽɤå뤿Υ᥽å
     * 񤭹߸¤ΤroleǸƤӽФtrue֤
     * 
	 * @ejb.interface-method
	 * @generated
	 * 
	 * @ejb.permission
     *  role-name="PerformanceWrite"
     *  method-intf="Remote"
     *
     * @return true
     */
    public boolean checkPerformanceWrite() {
    	return true;
    }
    
    /**
     * ǽɤå뤿Υ᥽å
     * 񤭹߸¤ΤroleǸƤӽФtrue֤
     * 
	 * @ejb.interface-method
	 * @generated
	 * 
	 * @ejb.permission
     *  role-name="PerformanceExecute"
     *  method-intf="Remote"
     *
     * @return true
     */
    public boolean checkPermissionExecute() {
    	return true;
    }
}