/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.ping.factory;

import javax.ejb.CreateException;
import javax.naming.NamingException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.monitor.run.factory.AddMonitorNumericValueType;
import com.clustercontrol.ping.bean.MonitorPingInfo;
import com.clustercontrol.ping.ejb.entity.MonitorPingInfoUtil;
import com.clustercontrol.ping.ejb.session.MonitorPingRunManagementHome;

/**
 * pingƻϿ饹
 *
 * @version 2.0.0
 * @since 2.0.0
 */
public class AddMonitorPing extends AddMonitorNumericValueType{
	
	protected static Log m_log = LogFactory.getLog( AddMonitorPing.class );
	
	/* ( Javadoc)
	 * @see com.clustercontrol.monitor.run.factory.AddMonitor#addCheckInfo()
	 */
	@Override
	public boolean addCheckInfo() throws CreateException, NamingException{
		
		// pingƻ
		MonitorPingInfo ping = (MonitorPingInfo)m_monitorInfo.getCheckInfo();
		
		MonitorPingInfoUtil.getLocalHome().create(
				m_monitorInfo.getMonitorTypeId(),
				m_monitorInfo.getMonitorId(),
				ping.getRunCount(),
				ping.getRunInterval(),
				ping.getTimeout());
		
		return true;
	}
	
	/* ( Javadoc)
	 * @see com.clustercontrol.monitor.run.factory.AddMonitor#getJndiName()
	 */
	@Override
	public String getJndiName() {
		return MonitorPingRunManagementHome.JNDI_NAME;
	}
}
