/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.ping.factory;

import java.util.ArrayList;
import java.util.HashMap;

import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.jms.JMSException;
import javax.naming.NamingException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.bean.PingRunCountConstant;
import com.clustercontrol.bean.PingRunIntervalConstant;
import com.clustercontrol.bean.PriorityConstant;
import com.clustercontrol.monitor.run.bean.MonitorNumericValueInfo;
import com.clustercontrol.monitor.run.factory.RunMonitorNumericValueType;
import com.clustercontrol.ping.ejb.entity.MonitorPingInfoLocal;
import com.clustercontrol.ping.ejb.entity.MonitorPingInfoPK;
import com.clustercontrol.ping.ejb.entity.MonitorPingInfoUtil;
import com.clustercontrol.ping.util.ReachAddress;
import com.clustercontrol.repository.bean.FacilityAttributeConstant;
import com.clustercontrol.util.Messages;

/**
 * pingƻ륯饹
 *
 * @version 2.1.0
 * @since 2.0.0
 */
public class RunMonitorPing extends RunMonitorNumericValueType {
	
	protected static Log m_log = LogFactory.getLog( RunMonitorPing.class );
	
	public static final String MESSAGE_ID_INFO = "001";
	public static final String MESSAGE_ID_WARNING = "002";
	public static final String MESSAGE_ID_CRITICAL = "003";
	public static final String MESSAGE_ID_UNKNOWN = "004";
	
	/** pingƻ */
	protected static final ArrayList<String> m_attributeList = new ArrayList<String>();
	static{
		m_attributeList.add(FacilityAttributeConstant.NODENAME);
		m_attributeList.add(FacilityAttributeConstant.IPNETWORKNUMBER);
		m_attributeList.add(FacilityAttributeConstant.IPNETWORKNUMBERV6);
	}
	
	/** pingƻ */
	protected MonitorPingInfoLocal m_ping = null;
	
	/** ping¹ */
	protected ReachAddress m_reachability = null;
	
	/** ¹Բ */
	protected int m_runCount = PingRunCountConstant.TYPE_COUNT_01;
	
	/** ¹Դֳ֡ʥߥá */
	protected int m_runInterval = PingRunIntervalConstant.TYPE_SEC_01;
	
	/** ॢȡʥߥá */
	protected int m_pingTimeout;
	
	/** å */
	protected String m_message = null;
	
	/** å */
	protected String m_unKnownMessage = null;
	
	/** ꥸʥå */
	protected String m_messageOrg = null;
	
//	 /** pingãΨ% */
//	protected int m_reachRatio = 0;
	
	 /** ѥåʶΨ% */
	protected int m_lost = 0;
    
    /** ʿѻ֡ʥߥá */
	protected long m_average = 0;
	
	/**
	 * 󥹥ȥ饯
	 * 
	 */
	public RunMonitorPing() throws NamingException, JMSException, CreateException{
		super();
	}
	
	/**
	 * ping
	 * 
	 * @param facilityId եƥID
	 * @return ͼ硢true
	 */
	@Override
	@SuppressWarnings("unchecked")
	public boolean collect(String facilityId) {
		
		m_nodeDate = m_now.getTime();
		m_message = "";
		m_messageOrg = "";
//		m_reachRatio = 0;
		m_lost = 0;
		m_average = 0;
		
		if(m_reachability == null){
			m_reachability = new ReachAddress(m_runCount, m_runInterval, m_pingTimeout);
		}
		
		try{
			// Ρɤ°
			HashMap facilityAttrMap = m_repository.getNodeDetail(facilityId, m_attributeList);
			
			String ipNetworkNumber = (String)facilityAttrMap.get(FacilityAttributeConstant.IPNETWORKNUMBER);
			String nodeName = (String)facilityAttrMap.get(FacilityAttributeConstant.NODENAME);
			
			boolean result = m_reachability.isReachable(ipNetworkNumber, nodeName);
			m_message = m_reachability.getMessage();
			m_messageOrg = m_reachability.getMessageOrg();
			if(result){
//				m_reachRatio = m_reachability.getReachRatio();
				m_lost = m_reachability.getLost();
				m_average = m_reachability.getAverage();
			}
			return result;
		}
		catch(FinderException e){
			m_log.debug("run():" + e.getMessage());
            
            m_message = Messages.getString("message.ping.4");
            m_messageOrg = e.getMessage();
			return false;
		}
		catch(NamingException e){
			m_log.debug("run():" + e.getMessage());
            
            m_message = Messages.getString("message.ping.4");
            m_messageOrg = e.getMessage();
			return false;
		}
	}
	
	/* ( Javadoc)
	 * pingƻ
	 * @see com.clustercontrol.monitor.run.factory.OperationNumericValueInfo#setMonitorAdditionInfo()
	 */
	@Override
	public void setCheckInfo() throws FinderException, NamingException{
		
		// pingƻ
		MonitorPingInfoPK pk = new MonitorPingInfoPK(m_monitorId, m_monitorTypeId);
		m_ping = MonitorPingInfoUtil.getLocalHome().findByPrimaryKey(pk);
		
		// pingƻ
		if(m_ping.getRunCount() != null)
			m_runCount = m_ping.getRunCount().intValue();
		if(m_ping.getRunInterval() != null)
			m_runInterval = m_ping.getRunInterval().intValue();
		if(m_ping.getTimeout() != null)
			m_pingTimeout = m_ping.getTimeout().intValue();
	}
	
	
	/* ( Javadoc)
	 * Ƚ̤
	 * @see com.clustercontrol.monitor.run.factory.RunMonitorNumericValueType#getCheckResult(boolean)
	 */
	@Override
	public int getCheckResult(boolean ret) {
		// lowerLimit : ѥåʶΨʡ
		// upperLimit : ֡ʥߥá
		
		int result = -1;
		MonitorNumericValueInfo info = null;
		
		// ͼ
		if(ret){
			
			// Τå
			info = (MonitorNumericValueInfo)m_judgementInfoList.get(Integer.valueOf(PriorityConstant.TYPE_INFO));
			if(m_lost <= info.getThresholdLowerLimit() && m_average <= info.getThresholdUpperLimit()){
				result = PriorityConstant.TYPE_INFO;
			}
			else {
				// ٹϰϥå
				info = (MonitorNumericValueInfo)m_judgementInfoList.get(Integer.valueOf(PriorityConstant.TYPE_WARNING));
				if(m_lost <= info.getThresholdLowerLimit() && m_average <= info.getThresholdUpperLimit()){
					result = PriorityConstant.TYPE_WARNING;
				}
				else{
					// Ρٹʳ
					result = PriorityConstant.TYPE_CRITICAL;
				}
			}
		}
		return result;
	}

	/* ( Javadoc)
	 * ΡѥåID
	 * @see com.clustercontrol.monitor.run.factory.OperationMonitor#getMessageId(int)
	 */
	@Override
	public String getMessageId(int id) {

		if(id == PriorityConstant.TYPE_INFO){
			return MESSAGE_ID_INFO;
		}
		else if(id == PriorityConstant.TYPE_WARNING){
			return MESSAGE_ID_WARNING;
		}
		else if(id == PriorityConstant.TYPE_CRITICAL){
			return MESSAGE_ID_CRITICAL;
		}
		else{
			return MESSAGE_ID_UNKNOWN;
		}
	}
	
	/* ( Javadoc)
	 * Ρѥå
	 * @see com.clustercontrol.monitor.run.factory.OperationMonitor#getMessage(int)
	 */
	@Override
	public String getMessage(int id) {
		return m_message;
	}

	/* ( Javadoc)
	 * Ρѥꥸʥå
	 * @see com.clustercontrol.monitor.run.factory.OperationMonitor#getMessageOrg(int)
	 */
	@Override
	public String getMessageOrg(int id) {
		return m_messageOrg;
	}
	
	/* ( Javadoc)
	 * ѥåID
	 * @see com.clustercontrol.monitor.run.factory.RunMonitor#getMessageIdForScope(int)
	 */
	@Override
	public String getMessageIdForScope(int priority) {
		
		if(priority == PriorityConstant.TYPE_INFO){
			return MESSAGE_ID_INFO;
		}
		else if(priority == PriorityConstant.TYPE_WARNING){
			return MESSAGE_ID_WARNING;
		}
		else if(priority == PriorityConstant.TYPE_CRITICAL){
			return MESSAGE_ID_CRITICAL;
		}
		else{
			return MESSAGE_ID_UNKNOWN;
		}
	}
}