/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.priority.factory;

import java.util.Date;

import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.naming.NamingException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.accesscontrol.factory.AccessLock;
import com.clustercontrol.priority.bean.PriorityJudgmentInfo;
import com.clustercontrol.priority.ejb.entity.PriorityInfoLocal;
import com.clustercontrol.priority.ejb.entity.PriorityInfoUtil;
import com.clustercontrol.priority.util.PriorityJudgment;
import com.clustercontrol.util.apllog.AplLogger;

/**
 * Ƚ깹饹
 *
 * @version 2.1.0
 * @since 2.1.0
 */
public class ModifyPriorityJudgment {
	protected static Log m_log = LogFactory.getLog(ModifyPriorityJudgment.class);

	/**
	 * Ƚɲ
	 * 
	 * @param info
	 * @param userName
	 * @throws NamingException
	 * @throws CreateException
	 * @throws FinderException
	 */
	public void addPriorityJudgment(PriorityJudgmentInfo info, String userName) throws NamingException, CreateException, FinderException  {
    	//å
    	AccessLock.lock(AccessLock.PRIORITY_JUDGMENT);
    	
	    try {
			//
			Date now = new Date();
			
			//Ƚ
			PriorityInfoUtil.getLocalHome().create(
					info.getJudgment_id(), 
					info.getDescription(),
					info.getPattern_01(), 
					info.getPattern_02(), 
					info.getPattern_03(), 
					info.getPattern_04(), 
					info.getPattern_05(), 
					info.getPattern_06(), 
					info.getPattern_07(), 
					info.getPattern_08(), 
					info.getPattern_09(), 
					info.getPattern_10(), 
					info.getPattern_11(), 
					info.getPattern_12(), 
					info.getPattern_13(), 
					info.getPattern_14(), 
					info.getPattern_15(), 
					now, 
					now, 
					userName, 
					userName);
			
		} catch (EJBException e) {
            AplLogger apllog = new AplLogger("PRIORITY", "priority");
            String[] args = {info.getJudgment_id()};
            apllog.put("SYS", "001", args);
            
            m_log.debug("addPriorityJudgment() : " + e.getMessage());
			throw e;
		} catch (NamingException e) {
            AplLogger apllog = new AplLogger("PRIORITY", "priority");
            String[] args = {info.getJudgment_id()};
            apllog.put("SYS", "001", args);
            
            m_log.debug("addPriorityJudgment() : " + e.getMessage());
			throw e;
		}
	}
	
	/**
	 * Ƚѹ
	 * 
	 * @param info
	 * @param userName
	 * @throws NamingException
	 * @throws FinderException
	 */
	public void modifyPriorityJudgment(PriorityJudgmentInfo info, String userName) throws NamingException, FinderException {
    	//å
    	AccessLock.lock(AccessLock.PRIORITY_JUDGMENT);
    	
	    try {
			Date now = new Date();
			
			//PriorityInfo򸡺
			PriorityInfoLocal priority = PriorityInfoUtil.getLocalHome().findByPrimaryKey(info.getJudgment_id());
			//PriorityInfo
			priority.setDescription(info.getDescription());
			//ѥ01PriorityInfo
			priority.setPattern_01(info.getPattern_01());
			//ѥ02PriorityInfo
			priority.setPattern_02(info.getPattern_02());
			//ѥ03PriorityInfo
			priority.setPattern_03(info.getPattern_03());
			//ѥ04PriorityInfo
			priority.setPattern_04(info.getPattern_04());
			//ѥ05PriorityInfo
			priority.setPattern_05(info.getPattern_05());
			//ѥ06PriorityInfo
			priority.setPattern_06(info.getPattern_06());
			//ѥ07PriorityInfo
			priority.setPattern_07(info.getPattern_07());
			//ѥ08PriorityInfo
			priority.setPattern_08(info.getPattern_08());
			//ѥ09PriorityInfo
			priority.setPattern_09(info.getPattern_09());
			//ѥ10PriorityInfo
			priority.setPattern_10(info.getPattern_10());
			//ѥ11PriorityInfo
			priority.setPattern_11(info.getPattern_11());
			//ѥ12PriorityInfo
			priority.setPattern_12(info.getPattern_12());
			//ѥ13PriorityInfo
			priority.setPattern_13(info.getPattern_13());
			//ѥ14PriorityInfo
			priority.setPattern_14(info.getPattern_14());
			//ѥ15PriorityInfo
			priority.setPattern_15(info.getPattern_15());
			//ԤPriorityInfo
			priority.setUpdate_user(userName);
			//PriorityInfo
			priority.setUpdate_date(now);
			
			//Ƚ󹹿
			PriorityJudgment.setPattern();
			
		} catch (EJBException e) {
            AplLogger apllog = new AplLogger("PRIORITY", "priority");
            String[] args = {info.getJudgment_id()};
            apllog.put("SYS", "002", args);
            
            m_log.debug("modifyPriorityJudgment() : " + e.getMessage());
			throw e;
		} catch (FinderException e) {
            AplLogger apllog = new AplLogger("PRIORITY", "priority");
            String[] args = {info.getJudgment_id()};
            apllog.put("SYS", "002", args);
            
            m_log.debug("modifyPriorityJudgment() : " + e.getMessage());
			throw e;
		}
	}
	
	/**
	 * Ƚ
	 * 
	 * @param judgmentId
	 * @throws NamingException
	 * @throws RemoveException
	 * @throws FinderException
	 */
	public void deletePriorityJudgment(String judgmentId) throws NamingException, RemoveException, FinderException {
    	//å
    	AccessLock.lock(AccessLock.PRIORITY_JUDGMENT);
    	
    	try {
			//Ƚ򸡺
    		PriorityInfoLocal priority = PriorityInfoUtil.getLocalHome().findByPrimaryKey(judgmentId);

            //Ƚ
            priority.remove();
            
		} catch (FinderException e) {
            AplLogger apllog = new AplLogger("PRIORITY", "priority");
            String[] args = {judgmentId};
            apllog.put("SYS", "003", args);
            
            m_log.debug("deletePriorityJudgment() : " + e.getMessage());
			throw e;
		} catch (RemoveException e) {
            AplLogger apllog = new AplLogger("PRIORITY", "priority");
            String[] args = {judgmentId};
            apllog.put("SYS", "003", args);
            
            m_log.debug("deletePriorityJudgment() : " + e.getMessage());
			throw e;
		} catch (NamingException e) {
            AplLogger apllog = new AplLogger("PRIORITY", "priority");
            String[] args = {judgmentId};
            apllog.put("SYS", "003", args);
            
            m_log.debug("deletePriorityJudgment() : " + e.getMessage());
			throw e;
		}
	}
}
