/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.priority.util;

import java.util.ArrayList;
import java.util.HashMap;

import javax.ejb.FinderException;
import javax.naming.NamingException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.bean.PriorityConstant;
import com.clustercontrol.priority.bean.PriorityJudgmentInfo;
import com.clustercontrol.priority.factory.SelectPriorityJudgment;

/**
 * Ƚꥯ饹
 *
 * @version 2.1.0
 * @since 2.1.0
 */
public class PriorityJudgment {
	protected static Log m_log = LogFactory.getLog(PriorityJudgment.class);
	
    protected static HashMap<String, Integer> m_patternMap = new HashMap<String, Integer>();
    protected static final String PATTERN_1 = "1";
    protected static final String PATTERN_2 = "2";
    protected static final String PATTERN_3 = "3";
    protected static final String PATTERN_4 = "4";
    protected static final String PATTERN_5 = "5";
    protected static final String PATTERN_6 = "6";
    protected static final String PATTERN_7 = "7";
    protected static final String PATTERN_8 = "8";
    protected static final String PATTERN_9 = "9";
    protected static final String PATTERN_10 = "10";
    protected static final String PATTERN_11 = "11";
    protected static final String PATTERN_12 = "12";
    protected static final String PATTERN_13 = "13";
    protected static final String PATTERN_14 = "14";
    protected static final String PATTERN_15 = "15";
    
	static{
		setPattern();
	}
    
	/**
	 * ٤ѥƤϤơȽꤹ
	 * 
	 * @param priorityList ٤(int)
	 * @return
	 */
	public static Integer judgment(ArrayList priorityList) {
        Integer priority = null;
        boolean normal = false;
        boolean critical = false;
        boolean warning = false;
        boolean unknown = false;
        
        for(int i =0; i < priorityList.size(); i++){
            Integer status = (Integer)priorityList.get(i);

            if(status.intValue() == PriorityConstant.TYPE_INFO){
                normal = true;
            }
            else if(status.intValue() == PriorityConstant.TYPE_WARNING){
                warning = true;
            }
            else if(status.intValue() == PriorityConstant.TYPE_UNKNOWN){
            	unknown = true;
            }
            else if(status.intValue() == PriorityConstant.TYPE_CRITICAL){
                critical = true;
            }
        }

        if(normal && !warning && !critical && !unknown){
    		//      | ٹ |  | 
            // ѥ 1:  | ߡ | ߡ | ߡ
        	priority = (Integer)m_patternMap.get(PATTERN_1);
        }
        else if(normal && !warning && !critical && unknown){
    		//      | ٹ |  | 
    		// ѥ 2:  | ߡ | ߡ | 
            priority = (Integer)m_patternMap.get(PATTERN_2);
        }
        else if(normal && warning && !critical && !unknown){
    		//      | ٹ |  | 
    		// ѥ 3:  |  | ߡ | ߡ
            priority = (Integer)m_patternMap.get(PATTERN_3);
        }
        else if(normal && warning && !critical && unknown){
    		//      | ٹ |  | 
            // ѥ 4:  |  | ߡ |  
            priority = (Integer)m_patternMap.get(PATTERN_4);
        }
        else if(!normal && warning && !critical && !unknown){
    		//      | ٹ |  | 
    		// ѥ 5: ߡ |  | ߡ | ߡ
            priority = (Integer)m_patternMap.get(PATTERN_5);
        }
        else if(!normal && warning && !critical && unknown){
    		//      | ٹ |  | 
    		// ѥ 6: ߡ |  | ߡ |  
            priority = (Integer)m_patternMap.get(PATTERN_6);
        }
        else if(normal && !warning && critical && !unknown){
    		//      | ٹ |  | 
    		// ѥ 7:  | ߡ |  | ߡ 
            priority = (Integer)m_patternMap.get(PATTERN_7);
        }
        else if(normal && !warning && critical && unknown){
    		//      | ٹ |  | 
    		// ѥ 8:  | ߡ |  |  
            priority = (Integer)m_patternMap.get(PATTERN_8);
        }
        else if(normal && warning && critical && !unknown){
    		//      | ٹ |  | 
    		// ѥ 9:  |  |  | ߡ 
            priority = (Integer)m_patternMap.get(PATTERN_9);
        }
        else if(normal && warning && critical && unknown){
    		//      | ٹ |  | 
    		// ѥ10:  |  |  |  
            priority = (Integer)m_patternMap.get(PATTERN_10);
        }
        else if(!normal && warning && critical && !unknown){
    		//      | ٹ |  | 
    		// ѥ11: ߡ |  |  | ߡ 
            priority = (Integer)m_patternMap.get(PATTERN_11);
        }
        else if(!normal && warning && critical && unknown){
    		//      | ٹ |  | 
    		// ѥ12: ߡ |  |  |  
            priority = (Integer)m_patternMap.get(PATTERN_12);
        }
        else if(!normal && !warning && critical && !unknown){
    		//      | ٹ |  | 
    		// ѥ13: ߡ | ߡ |  | ߡ 
            priority = (Integer)m_patternMap.get(PATTERN_13);
        }
        else if(!normal && !warning && critical && unknown){
    		//      | ٹ |  | 
    		// ѥ14: ߡ | ߡ |  | 
            priority = (Integer)m_patternMap.get(PATTERN_14);
        }
        else if(!normal && !warning && !critical && unknown){
    		//      | ٹ |  | 
    		// ѥ15: ߡ | ߡ | ߡ |  
            priority = (Integer)m_patternMap.get(PATTERN_15);
        }
        else{
            return null;
        }
        
	    return priority;
    }
	
	public static void setPattern() {
		// ٤Υѥϥåݻ
		// 
		// Ρٹ
		// 
		//      | ٹ |  | 
        // ѥ 1:  | ߡ | ߡ | ߡ
		// ѥ 2:  | ߡ | ߡ | 
		// ѥ 3:  |  | ߡ | ߡ
        // ѥ 4:  |  | ߡ |  
		// ѥ 5: ߡ |  | ߡ | ߡ
		// ѥ 6: ߡ |  | ߡ |  
		// ѥ 7:  | ߡ |  | ߡ
		// ѥ 8:  | ߡ |  |  
		// ѥ 9:  |  |  | ߡ 
		// ѥ10:  |  |  |  
		// ѥ11: ߡ |  |  | ߡ 
		// ѥ12: ߡ |  |  |  
		// ѥ13: ߡ | ߡ |  | ߡ 
		// ѥ14: ߡ | ߡ |  | 
		// ѥ15: ߡ | ߡ | ߡ |  
		
		SelectPriorityJudgment select = new SelectPriorityJudgment();
		PriorityJudgmentInfo info = null;
		try {
			info = select.getPriorityJudgment("DEFAULT");
		} catch (FinderException e) {
			m_log.debug("PriorityJudgment : " + e.getMessage());
		} catch (NamingException e) {
			m_log.debug("PriorityJudgment : " + e.getMessage());
		}
		
		if(info != null){
			m_patternMap.put(PATTERN_1, info.getPattern_01());
			m_patternMap.put(PATTERN_2, info.getPattern_02());
			m_patternMap.put(PATTERN_3, info.getPattern_03());
			m_patternMap.put(PATTERN_4, info.getPattern_04());
	        m_patternMap.put(PATTERN_5, info.getPattern_05());
	        m_patternMap.put(PATTERN_6, info.getPattern_06());
	        m_patternMap.put(PATTERN_7, info.getPattern_07());
	        m_patternMap.put(PATTERN_8, info.getPattern_08());
	        m_patternMap.put(PATTERN_9, info.getPattern_09());
	        m_patternMap.put(PATTERN_10, info.getPattern_10());
	        m_patternMap.put(PATTERN_11, info.getPattern_11());
	        m_patternMap.put(PATTERN_12, info.getPattern_12());
	        m_patternMap.put(PATTERN_13, info.getPattern_13());
	        m_patternMap.put(PATTERN_14, info.getPattern_14());
	        m_patternMap.put(PATTERN_15, info.getPattern_15());
		}
		else{
			m_patternMap.put(PATTERN_1, new Integer(PriorityConstant.TYPE_INFO));
			m_patternMap.put(PATTERN_2, new Integer(PriorityConstant.TYPE_UNKNOWN));
			m_patternMap.put(PATTERN_3, new Integer(PriorityConstant.TYPE_WARNING));
			m_patternMap.put(PATTERN_4, new Integer(PriorityConstant.TYPE_UNKNOWN));
	        m_patternMap.put(PATTERN_5, new Integer(PriorityConstant.TYPE_WARNING));
	        m_patternMap.put(PATTERN_6, new Integer(PriorityConstant.TYPE_UNKNOWN));
	        m_patternMap.put(PATTERN_7, new Integer(PriorityConstant.TYPE_CRITICAL));
	        m_patternMap.put(PATTERN_8, new Integer(PriorityConstant.TYPE_CRITICAL));
	        m_patternMap.put(PATTERN_9, new Integer(PriorityConstant.TYPE_CRITICAL));
	        m_patternMap.put(PATTERN_10, new Integer(PriorityConstant.TYPE_CRITICAL));
	        m_patternMap.put(PATTERN_11, new Integer(PriorityConstant.TYPE_CRITICAL));
	        m_patternMap.put(PATTERN_12, new Integer(PriorityConstant.TYPE_CRITICAL));
	        m_patternMap.put(PATTERN_13, new Integer(PriorityConstant.TYPE_CRITICAL));
	        m_patternMap.put(PATTERN_14, new Integer(PriorityConstant.TYPE_CRITICAL));
	        m_patternMap.put(PATTERN_15, new Integer(PriorityConstant.TYPE_UNKNOWN));
		}
	}
}
