/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.process.action;

import java.rmi.AccessException;
import java.rmi.RemoteException;
import java.util.ArrayList;

import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.naming.NamingException;

import org.eclipse.jface.dialogs.MessageDialog;
import org.quartz.SchedulerException;

import com.clustercontrol.monitor.run.bean.MonitorInfo;
import com.clustercontrol.process.ejb.session.MonitorProcessController;
import com.clustercontrol.process.util.EjbConnectionManager;
import com.clustercontrol.util.Messages;

/**
 * ץƻ륯饹Ǥ
 * 
 * @version 2.0.0
 * @since 2.0.0
 */
public class GetProcess {

    /**
     * ץƻ֤ޤ
     * 
     * @param monitorId ִƻID
     * @return ץƻ
     */
    public MonitorInfo getProcess(String monitorId) {

    	MonitorProcessController process = EjbConnectionManager.getConnectionManager().getProcessController();

    	MonitorInfo info = null;
        try {
        	info = process.getProcess(monitorId);
        } catch (RemoteException e) {
			if(e instanceof AccessException){
				// ʤξ硢顼ɽ
	            MessageDialog.openInformation(null, Messages.getString("message"),
	                    Messages.getString("message.accesscontrol.16"));
			}
        } catch (CreateException e) {
        } catch (FinderException e) {
        } catch (SchedulerException e) {
        } catch (NamingException e) {
        }
        return info;
    }
    
    /**
     * ץƻ֤ޤ
     * 
     * @return ץƻ
     */
    public ArrayList getProcessList() {

    	MonitorProcessController process = EjbConnectionManager.getConnectionManager()
                .getProcessController();

        ArrayList records = null;
        try {
            records = process.getProcessList();
        } catch (RemoteException e) {
			if(e instanceof AccessException){
				// ʤξ硢顼ɽ
	            MessageDialog.openInformation(null, Messages.getString("message"),
	                    Messages.getString("message.accesscontrol.16"));
			}
        } catch (CreateException e) {
        } catch (FinderException e) {
        } catch (SchedulerException e) {
        } catch (NamingException e) {
        }
        return records;
    }
}