/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.process.factory;

import java.util.ArrayList;

import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.naming.NamingException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.process.util.SnmpProcConnectionManager;
import com.clustercontrol.repository.ejb.session.RepositoryControllerBean;
import com.clustercontrol.repository.ejb.session.RepositoryControllerLocal;
import com.clustercontrol.repository.ejb.session.RepositoryControllerUtil;
import com.clustercontrol.snmppoller.SnmpSharedTable;
import com.clustercontrol.util.apllog.AplLogger;

/**
 * SNMPݡϿ饹
 *
 * @version 2.0.0
 * @since 2.0.0
 */
public class ModifyPollingSchedule {
	
	protected static Log m_log = LogFactory.getLog( ModifyPollingSchedule.class );
	
	/**
	 * SNMPݡ󥰤Ͽ
	 * 
	 * @param parentFacilityId եƥID
	 * @param interval ֳ()
	 * @throws CreateException
	 * @throws FinderException
	 * @throws NamingException
	 */
	@SuppressWarnings("unchecked")
	public boolean addSchedule(String parentFacilityId, int interval) {

		if(parentFacilityId != null && !"".equals(parentFacilityId)){
			
			try{
				// SNMPͤζͭơ֥åå
		        SnmpSharedTable sst = SnmpProcConnectionManager.getConnectionManager().getSnmpSharedTable();
				
				// եƥID۲Ƥΰ
				RepositoryControllerLocal repository = RepositoryControllerUtil.getLocalHome().create();
				ArrayList facilityList = repository.getNodeFacilityIdList(parentFacilityId, RepositoryControllerBean.ALL);

				//۲˥ΡɤʤȤȤϥΡɤβǽΤǻꤵ줿ID򥻥å
				if (facilityList.size() == 0) {
					facilityList.add(parentFacilityId);
				}
				
				// եƥϿ
				String facilityId = null;
				for(int index=0; index<facilityList.size(); index++){
					facilityId = (String)facilityList.get(index);
					if(facilityId != null && !"".equals(facilityId)){
						sst.setPollingSchedule(facilityId, interval);
					}
				}
				return true;
				
			}catch(CreateException e){
				AplLogger apllog = new AplLogger("PROC", "proc");
				String[] args = { parentFacilityId };
				apllog.put("SYS", "001", args);
				m_log.debug("addSchedule():" + e.getMessage());
			}catch(FinderException e){
				AplLogger apllog = new AplLogger("PROC", "proc");
				String[] args = { parentFacilityId };
				apllog.put("SYS", "001", args);
				m_log.debug("addSchedule():" + e.getMessage());
			}catch(NamingException e){
				AplLogger apllog = new AplLogger("PROC", "proc");
				String[] args = { parentFacilityId };
				apllog.put("SYS", "001", args);
				m_log.debug("addSchedule():" + e.getMessage());
			}
		}
		return false;
	}
}