/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.process.factory;

import java.text.DateFormat;
import java.text.NumberFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.jms.JMSException;
import javax.naming.NamingException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.bean.PriorityConstant;
import com.clustercontrol.monitor.run.factory.RunMonitorNumericValueType;
import com.clustercontrol.process.bean.SnmpSharedTableConstant;
import com.clustercontrol.process.ejb.entity.MonitorProcessInfoLocal;
import com.clustercontrol.process.ejb.entity.MonitorProcessInfoPK;
import com.clustercontrol.process.ejb.entity.MonitorProcessInfoUtil;
import com.clustercontrol.process.util.ProcessProperties;
import com.clustercontrol.process.util.SnmpProcConnectionManager;
import com.clustercontrol.sharedtable.bean.ValueObject;
import com.clustercontrol.snmppoller.SnmpSharedTable;
import com.clustercontrol.util.Messages;

/**
 * ץƻ륯饹
 *
 * @version 2.0.0
 * @since 2.0.0
 */
public class RunMonitorProcess extends RunMonitorNumericValueType {
	
	protected static Log m_log = LogFactory.getLog( RunMonitorProcess.class );
	
	public static final String MESSAGE_ID_INFO = "001";
	public static final String MESSAGE_ID_WARNING = "002";
	public static final String MESSAGE_ID_CRITICAL = "003";
	public static final String MESSAGE_ID_UNKNOWN = "004";
	
	/** ץƻ */
	protected MonitorProcessInfoLocal m_process = null;
	
	/** ޥ */
	protected String m_command = "";
	
	/**  */
	protected String m_param = "";
	
	/** SNMPͤζͭơ֥ */
	protected SnmpSharedTable m_sst = null;
	
	/** å */
	protected String m_message = null;
	
	/** ꥸʥå */
	protected String m_messageOrg = null;
	
	/** ͥեޥå */
	protected NumberFormat m_numberFormat = NumberFormat.getNumberInstance();
	
	
	/**
	 * 󥹥ȥ饯
	 * 
	 */
	public RunMonitorProcess() throws NamingException, JMSException, CreateException{
		super();
		
		// SNMPͤζͭơ֥åå
		setSnmpSharedTable();
	}
	
	/**
	 * ץ
	 * 
	 * @param facilityId եƥID
	 * @return ͼ硢true
	 */
	@Override
	@SuppressWarnings("unchecked")
	public boolean collect(String facilityId) {
		
		// Υޥ,ѥ᡼˰פץ
		int count = 0;
		
		// ƻ볫ϻ
		m_nodeDate = m_now.getTime();
		m_value = 0;
		
		// å
		m_message = "";
		m_messageOrg = Messages.getString("command") + " : " + m_command + ", " + Messages.getString("param") + " : " + m_param;
		
		// ޥ,ѥ᡼Υѥ
		Pattern pCommand = null;
		Pattern pParam = null;
		Matcher m = null;
		
		try{
			pCommand = Pattern.compile(m_command);
			pParam = Pattern.compile(m_param);
		}
		catch(PatternSyntaxException e){
			m_log.error("collect(): ޥ,ѥ᡼ɽѥʸ顼" + e.getMessage());
			
			m_message = Messages.getString("message.process.4");
			return false;
		}
		
		// ¹Դֳ
		int runInterval = m_monitor.getRunInterval().intValue();

    	// ư̾ꤷƥ֥ĥ꡼ͤ٤˼
		Set valueSetName = m_sst.getValueSet(facilityId, runInterval, SnmpSharedTableConstant.OID_RUN_NAME);
		
		if(valueSetName == null){
			m_log.debug("collect(): " + "SNMPݡ顼̤. valueSetName is null.");
			
			m_message = Messages.getString("message.process.6");
			return false;
		} else {
			
			ValueObject valueObjCommand = null;
			ValueObject valueObjParam = null;
			ValueObject valueObjName = null;
			String valueCommand = null;
			String valueParam = null;
			String valueName = null;
			
			Iterator itr = valueSetName.iterator();
			while(itr.hasNext()){
				valueObjName = (ValueObject)itr.next();
				if(valueObjName != null){
					valueName = (String)valueObjName.getValue();
					if(valueName == null){
						m_log.debug("collect(): " + "SNMPݡ顼̤. valueName is null.");
						m_message = Messages.getString("message.process.6");
						return false;
					}	
				}
				else{
					m_log.debug("collect(): " + "SNMPݡ顼̤. valueObjName is null.");
					m_message = Messages.getString("message.process.6");
					return false;
				}

	        	// ǥåդεưѥOID
	        	String key = valueObjName.getKey();
				String index = key.substring(key.lastIndexOf("."));
				
				// ưѥOIDꤷͤ
				valueObjCommand  = m_sst.getValue(facilityId, runInterval, SnmpSharedTableConstant.OID_RUN_PATH + index);
				if(valueObjCommand != null){
					valueCommand = (String)valueObjCommand.getValue();
					if(valueCommand == null){
						m_log.debug("collect(): " + "SNMPݡ顼̤. valueCommand is null");
						m_message = Messages.getString("message.process.6");
						return false;
					}
				}
				else{
					m_log.debug("collect(): " + "SNMPݡ顼̤. valueObjCommand is null");
					m_message = Messages.getString("message.process.6");
					return false;
				}
				
				//WindowsξθơvalueCommandvalueNameϢ뤹
				if(valueCommand.length() == 0){
					//ѥǤʤϥޥ̾
					//ѥnull OR ʸ
					valueCommand = valueName;
				}else if(!valueCommand.startsWith("/") && 
					valueCommand.endsWith("\\") &&
					!valueCommand.equals(valueName) ){
					//
					//ѥ'/'ʳʸǻϤޤ
					//ѥ'\'ǽäƤ
					//ѥȥޥ̾㤦
					
					valueCommand = valueCommand + valueName;
				}
				
				
		        m = pCommand.matcher(valueCommand);
		        
		        // ưѥꤷޥɤפ
		        if(m.matches()) {
		        	m_log.debug("collect(): SNMPݡưѥ: " + valueObjCommand);
		        	
					
		        	// ưѥ᡼OIDꤷͤ
		        	valueObjParam = m_sst.getValue(facilityId, runInterval, SnmpSharedTableConstant.OID_RUN_PARAM + index);
		        	if(valueObjParam != null){
		        		valueParam = (String)valueObjParam.getValue();
						if(valueParam == null){
							m_log.debug("collect(): " + "SNMPݡ顼̤. valueParam is null.");
							m_message = Messages.getString("message.process.6");
							return false;
						}	
					}
					else{
						m_log.debug("collect(): " + "SNMPݡ顼̤. valueObjParam is null.");
						m_message = Messages.getString("message.process.6");
						return false;
					}
		        	
		        	//ưѥ᡼ꤷȰפ
		        	m = pParam.matcher(valueParam);
		        	if (m.matches()) {
		        		m_log.debug("collect(): SNMPݡưѥ᡼ : " + valueObjParam);
		        		
		        		// SNMPݡ
		        		Date pollingDate = new Date(valueObjCommand.getDate()); 
		        		
		        		// 郎SNMPݡ顼ƻ֤ä硢ͼ
		        		int tolerance = ProcessProperties.getProperties().getStartSecond() + 
		        						 ProcessProperties.getProperties().getValidSecond();

		        		Calendar cal = Calendar.getInstance();
						cal.setTime(m_now);
				        cal.add(Calendar.SECOND, -tolerance);
						if(cal.getTime().compareTo(pollingDate) > 0){
							// ƻ볫ϻ
							m_nodeDate = m_now.getTime();
							
							String[] args = { DateFormat.getDateTimeInstance().format(pollingDate)};
							m_message = Messages.getString("message.process.7",args);
							return false;
				        }
		        		
						// Ρɤͼ
						m_nodeDate = valueObjCommand.getDate();
		        		count++;
		        	}
		        }
			}
			m_value = count;
			m_message = Messages.getString("process.number") + " : " + m_numberFormat.format(m_value);
			return true;
		}
	}
	
	/* ( Javadoc)
	 * ץƻ
	 * @see com.clustercontrol.monitor.run.factory.OperationNumericValueInfo#setMonitorAdditionInfo()
	 */
	@Override
	public void setCheckInfo() throws FinderException, NamingException{
		
		// ץƻ
		MonitorProcessInfoPK pk = new MonitorProcessInfoPK(m_monitorId, m_monitorTypeId);
		m_process = MonitorProcessInfoUtil.getLocalHome().findByPrimaryKey(pk);
		
		// ץƻ
		m_command = m_process.getCommand().trim();
		if(m_process.getParam() != null){
			m_param = m_process.getParam().trim();
		}
	}

	/* ( Javadoc)
	 * ΡѥåID
	 * @see com.clustercontrol.monitor.run.factory.OperationMonitor#getMessageId(int)
	 */
	@Override
	public String getMessageId(int id) {

		if(id == PriorityConstant.TYPE_INFO){
			return MESSAGE_ID_INFO;
		}
		else if(id == PriorityConstant.TYPE_WARNING){
			return MESSAGE_ID_WARNING;
		}
		else if(id == PriorityConstant.TYPE_CRITICAL){
			return MESSAGE_ID_CRITICAL;
		}
		else{
			return MESSAGE_ID_UNKNOWN;
		}
	}
	
	/* ( Javadoc)
	 * Ρѥå
	 * @see com.clustercontrol.monitor.run.factory.OperationMonitor#getMessage(int)
	 */
	@Override
	public String getMessage(int id) {
		return m_message;
	}

	/* ( Javadoc)
	 * Ρѥꥸʥå
	 * @see com.clustercontrol.monitor.run.factory.OperationMonitor#getMessageOrg(int)
	 */
	@Override
	public String getMessageOrg(int id) {
		return m_messageOrg;
	}
	
	/* ( Javadoc)
	 * ѥåID
	 * @see com.clustercontrol.monitor.run.factory.RunMonitor#getMessageIdForScope(int)
	 */
	@Override
	public String getMessageIdForScope(int priority) {
		
		if(priority == PriorityConstant.TYPE_INFO){
			return MESSAGE_ID_INFO;
		}
		else if(priority == PriorityConstant.TYPE_WARNING){
			return MESSAGE_ID_WARNING;
		}
		else if(priority == PriorityConstant.TYPE_CRITICAL){
			return MESSAGE_ID_CRITICAL;
		}
		else{
			return MESSAGE_ID_UNKNOWN;
		}
	}
	
	/**
	 * SNMPͤζͭơ֥åå
	 * 
	 */
	private void setSnmpSharedTable() throws NamingException{
		
		// SNMPͤζͭơ֥åå
		m_sst = SnmpProcConnectionManager.getConnectionManager().getSnmpSharedTable();
	}
}