/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.repository.composite;

import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.TableTree;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;

import com.clustercontrol.bean.Property;
import com.clustercontrol.bean.PropertyConstant;
import com.clustercontrol.composite.PropertySheet;
import com.clustercontrol.repository.action.GetNodeProperty;

/**
 * Ρ°ݥåȥ饹Ǥ
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class NodeAttributeComposite extends Composite {

    // ----- instance ե ----- //

    /** ơ֥ӥ塼 */
    private PropertySheet propertySheet = null;

    // ----- 󥹥ȥ饯 ----- //

    /**
     * 󥹥󥹤֤ޤ
     * 
     * @param parent
     *            ƤΥݥå
     * @param style
     *            
     */
    public NodeAttributeComposite(Composite parent, int style) {
        super(parent, style);
        initialize();
    }

    // ----- instance ᥽å ----- //

    private void initialize() {
        GridLayout layout = new GridLayout(1, true);
        this.setLayout(layout);
        layout.marginHeight = 0;
        layout.marginWidth = 0;

        TableTree table = new TableTree(this, SWT.H_SCROLL | SWT.V_SCROLL
                | SWT.FULL_SELECTION | SWT.MULTI);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.verticalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalSpan = 1;
        table.setLayoutData(gridData);

        this.propertySheet = new PropertySheet(table);
    }

    /**
     * PropertySheet֤ޤ
     * 
     * @return PropertySheet
     */
    public PropertySheet getPropertySheet() {
        return this.propertySheet;
    }

    /**
     * ꤵ줿Ρɤξɽޤ
     * 
     * @param facilityId
     *            եƥID
     */
    public void update(String facilityId) {
        Property data = null;

        data = new GetNodeProperty().getProperty(facilityId,
                PropertyConstant.MODE_SHOW);
        
        if(data == null){
        	data = new Property(null, null, "");
        }

        this.propertySheet.setInput(data);
        this.propertySheet.expandAll();
    }
}