/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.repository.dialog;

import java.util.ArrayList;

import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

import com.clustercontrol.dialog.CommonDialog;
import com.clustercontrol.dialog.ValidateResult;
import com.clustercontrol.repository.composite.NodeFilterComposite;
import com.clustercontrol.util.Messages;

/**
 * פؤΥΡɳƲ饹Ǥ
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class NodeReleaseDialog extends CommonDialog {

    // ----- instance ե ----- //

    /** оݥפΥեƥID */
    private String facilityId = "";

    /** Ρɰơ֥ */
    private NodeFilterComposite nodeList = null;

    /** 򤵤줿ƥ */
    private String[] filterItems = null;

    // ----- 󥹥ȥ饯 ----- //

    /**
     * ꤷΥΥ󥹥󥹤֤ޤ
     * 
     * @param parent
     *            ƤΥ륪֥
     * @param facilityId
     *            ɽ륹פΥեƥID
     */
    public NodeReleaseDialog(Shell parent, String facilityId) {
        super(parent);

        this.facilityId = facilityId;
    }

    // ----- instance ᥽å ----- //

    /**
     * ν֤ޤ
     * 
     * @return 
     */
    protected Point getInitialSize() {
        return new Point(450, 500);
    }

    /**
     * ꥢޤ
     * 
     * @param parent
     *            ƤΥ󥹥
     */
    protected void customizeDialog(Composite parent) {
        Shell shell = this.getShell();

        // ȥ
        shell.setText(Messages.getString("dialog.repository.select.nodes"));

        // 쥤
        GridLayout layout = new GridLayout(1, true);
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        parent.setLayout(layout);

        /*
         * Ρɰ
         */

        // ơ֥
        this.nodeList = new NodeFilterComposite(parent, SWT.NONE,
                this.facilityId);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.verticalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalSpan = 1;
        this.nodeList.setLayoutData(gridData);

        this.nodeList.update();

        // 饤
        Label line = new Label(parent, SWT.SEPARATOR | SWT.HORIZONTAL);
        gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 1;
        line.setLayoutData(gridData);

        // 
        Display display = shell.getDisplay();
        shell.setLocation((display.getBounds().width - shell.getSize().x) / 2,
                (display.getBounds().height - shell.getSize().y) / 2);
    }

    /**
     * ͥå򤷤ޤ
     * 
     * @return ڷ
     */
    protected ValidateResult validate() {
        ValidateResult result = null;

        StructuredSelection selection = (StructuredSelection) this.nodeList
                .getTableViewer().getSelection();

        Object[] items = selection.toArray();
        if (items == null || items.length == 0) {
            result = new ValidateResult();
            result.setID(Messages.getString("message.hinemos.2"));
            result.setMessage(Messages.getString("message.repository.2"));
            result.setValid(false);
        } else {
            int size = items.length;
            this.filterItems = new String[size];
            for (int i = 0; i < size; i++) {
                this.filterItems[i] = (String) ((ArrayList) items[i]).get(0);
            }
        }

        return result;
    }

    /**
     * оݥפΥեƥID֤ޤ
     * 
     * @return оݥפΥեƥID
     */
    public String getScopeId() {
        return this.facilityId;
    }

    /**
     * 򤵤줿Ρɤ֤ޤ
     * 
     * @return ΡɤΥեƥID
     */
    public String[] getFilterItems() {
        return this.filterItems;
    }

    /**
     * ϣ˥ܥΥƥȤ֤ޤ
     * 
     * @return ϣ˥ܥΥƥ
     */
    protected String getOkButtonText() {
        return Messages.getString("ok");
    }

    /**
     * 󥻥ܥΥƥȤ֤ޤ
     * 
     * @return 󥻥ܥΥƥ
     */
    protected String getCancelButtonText() {
        return Messages.getString("cancel");
    }
}