/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.repository.view;

import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;

import com.clustercontrol.bean.Property;
import com.clustercontrol.repository.composite.NodeListComposite;
import com.clustercontrol.repository.view.action.NodeAddAction;
import com.clustercontrol.repository.view.action.NodeDeleteAction;
import com.clustercontrol.repository.view.action.NodeModifyAction;
import com.clustercontrol.view.CommonViewPart;

/**
 * ΡȰӥ塼饹
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class NodeListView extends CommonViewPart {
    public static final String ID = "com.clustercontrol.repository.view.NodeListView";

    // ----- instance ե ----- //

    /** Ρɰݥå */
    private NodeListComposite composite = null;

    /**  */
    private Property condition = null;

    // ----- 󥹥ȥ饯 ----- //

    /**
     * 󥹥󥹤֤ޤ
     */
    public NodeListView() {
        super();
    }

    // ----- instance ᥽å ----- //

    /**
     * @see org.eclipse.ui.IWorkbenchPart#createPartControl(org.eclipse.swt.widgets.Composite)
     */
    public void createPartControl(Composite parent) {
        GridLayout layout = new GridLayout(1, true);
        parent.setLayout(layout);
        layout.marginHeight = 0;
        layout.marginWidth = 0;

        this.composite = new NodeListComposite(parent, SWT.NONE);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.verticalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        this.composite.setLayoutData(gridData);
        
        //ݥåץåץ˥塼
        createContextMenu();

        this.update();
    }
    
    /**
     * ݥåץåץ˥塼
     * 
     *  
     */
    protected void createContextMenu() {
        MenuManager menuManager = new MenuManager();
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener(new IMenuListener() {
            /*
             * (non-Javadoc)
             * 
             * @see org.eclipse.jface.action.IMenuListener#menuAboutToShow(org.eclipse.jface.action.IMenuManager)
             */
            public void menuAboutToShow(IMenuManager manager) {
                //˥塼
                fillContextMenu(manager);
            }
        });

        Menu menu = menuManager.createContextMenu(this.composite.getTable());
        this.composite.getTable().setMenu(menu);
    }

    /**
     * ˥塼ɲ
     * 
     * @param manager
     */
    protected void fillContextMenu(IMenuManager manager) {
        //ӥ塼ΥΥ󥹥󥹤
        IToolBarManager toolbar = this.getViewSite().getActionBars()
                .getToolBarManager();
        ActionContributionItem nodeAddAction = (ActionContributionItem) toolbar
                .find(NodeAddAction.ID);
        ActionContributionItem nodeModifyAction = (ActionContributionItem) toolbar
                .find(NodeModifyAction.ID);
        ActionContributionItem nodeDeleteAction = (ActionContributionItem) toolbar
        .find(NodeDeleteAction.ID);

        //ݥåץåץ˥塼˥ɲ
        manager.add(nodeAddAction.getAction());
        manager.add(nodeModifyAction.getAction());
        manager.add(nodeDeleteAction.getAction());
    }

    /**
     * composite֤ޤ
     * 
     * @return composite
     */
    public NodeListComposite getComposite() {
        return this.composite;
    }

    /**
     * ˥ҥåȤΡɤΰɽޤ
     * <p>
     * 
     * conditionnullξ硢Ρɤɽޤ
     * 
     * @param condition
     *            
     */
    public void update(Property condition) {
        this.condition = condition;

        this.update();
    }

    /**
     * ӥ塼򹹿ޤ
     * <p>
     * 
     * 郎ꤵƤ硢ξ˥ҥåȤΡɤΰ ɽޤ <br>
     * 郎ꤵƤʤϡΡɤɽޤ
     */
    public void update() {
        this.composite.update(this.condition);
    }
}