/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.repository.view;

import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;

import com.clustercontrol.bean.FacilityTreeItem;
import com.clustercontrol.repository.composite.ScopeListComposite;
import com.clustercontrol.repository.view.action.NodeAssignAction;
import com.clustercontrol.repository.view.action.NodeReleaseAction;
import com.clustercontrol.repository.view.action.ScopeAddAction;
import com.clustercontrol.repository.view.action.ScopeDeleteAction;
import com.clustercontrol.repository.view.action.ScopeModifyAction;
import com.clustercontrol.view.ScopeListBaseView;

/**
 * Ͽӥ塼饹
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class ScopeListView extends ScopeListBaseView {
    public static final String ID = "com.clustercontrol.repository.view.ScopeListView";

    // ----- instance ե ----- //

    private ScopeListComposite composite = null;

    // ----- 󥹥ȥ饯 ----- //

    // ----- instance ᥽å ----- //

    /**
     * @see com.clustercontrol.view.ScopeListBaseView#createListContents(org.eclipse.swt.widgets.Composite)
     */
    protected Composite createListContents(Composite parent) {
        GridLayout layout = new GridLayout(1, true);
        parent.setLayout(layout);
        layout.marginHeight = 0;
        layout.marginWidth = 0;

        this.composite = new ScopeListComposite(parent, SWT.NONE);

        GridData gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.verticalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        this.composite.setLayoutData(gridData);
        
        //ݥåץåץ˥塼
        createContextMenu();

        this.update();

        return this.composite;
    }
    
    /**
     * ݥåץåץ˥塼
     * 
     *  
     */
    protected void createContextMenu() {
        MenuManager menuManager = new MenuManager();
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener(new IMenuListener() {
            /*
             * (non-Javadoc)
             * 
             * @see org.eclipse.jface.action.IMenuListener#menuAboutToShow(org.eclipse.jface.action.IMenuManager)
             */
            public void menuAboutToShow(IMenuManager manager) {
                //˥塼
                fillContextMenu(manager);
            }
        });
        
        Menu treeMenu = menuManager.createContextMenu(this.getScopeTreeComposite().getTree());
        this.getScopeTreeComposite().getTree().setMenu(treeMenu);

        Menu listMenu = menuManager.createContextMenu(this.composite.getTable());
        this.composite.getTable().setMenu(listMenu);
    }

    /**
     * ˥塼ɲ
     * 
     * @param manager
     */
    protected void fillContextMenu(IMenuManager manager) {
        //ӥ塼ΥΥ󥹥󥹤
        IToolBarManager toolbar = this.getViewSite().getActionBars()
                .getToolBarManager();
        ActionContributionItem scopeAddAction = (ActionContributionItem) toolbar
                .find(ScopeAddAction.ID);
        ActionContributionItem scopeModifyAction = (ActionContributionItem) toolbar
                .find(ScopeModifyAction.ID);
        ActionContributionItem scopeDeleteAction = (ActionContributionItem) toolbar
        		.find(ScopeDeleteAction.ID);
        ActionContributionItem nodeAssignAction = (ActionContributionItem) toolbar
        		.find(NodeAssignAction.ID);
        ActionContributionItem nodeReleaseAction = (ActionContributionItem) toolbar
        		.find(NodeReleaseAction.ID);

        //ݥåץåץ˥塼˥ɲ
        manager.add(scopeAddAction.getAction());
        manager.add(scopeModifyAction.getAction());
        manager.add(scopeDeleteAction.getAction());
        manager.add(nodeAssignAction.getAction());
        manager.add(nodeReleaseAction.getAction());
    }


    /**
     * 򤵤줿(Ρ)ξɽޤ
     * 
     * @param item
     *            ĥ꡼ƥ
     */
    protected void doSelectTreeItem(FacilityTreeItem item) {
        this.composite.update(item);
    }

    /**
     * ӥ塼򹹿ޤ
     * 
     * @see com.clustercontrol.view.AutoUpdateView#update()
     */
    public void update() {
        FacilityTreeItem item = this.getScopeTreeComposite().getSelectItem();
        this.composite.update(item);
    }

    /**
     * ץȤ׵ᤵ줿硢ȤΥ󥹥󥹤Ϥޤ
     * 
     * @param cls
     *            饹Υ󥹥
     * @return ȤΥ󥹥
     */
    public Object getAdapter(Class cls) {
        if (cls.isInstance(this)) {
            return this;
        } else {
            return super.getAdapter(cls);
        }
    }
}