/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.repository.view.action;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;

import com.clustercontrol.composite.FacilityTreeComposite;
import com.clustercontrol.repository.view.NodeAttributeView;
import com.clustercontrol.repository.view.NodeListView;
import com.clustercontrol.repository.view.NodeScopeView;
import com.clustercontrol.repository.view.ScopeListView;

/**
 * ӥ塼ιԤ󥯥饹Ǥ
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class RefreshAction implements IViewActionDelegate {

    //	 ----- instance ե ----- //

    private IViewPart viewPart; // ӥ塼

    // ----- instance ᥽å ----- //

    /**
     * @see org.eclipse.ui.IViewActionDelegate#init(org.eclipse.ui.IViewPart)
     */
    public void init(IViewPart viewPart) {
        this.viewPart = viewPart;
    }

    /**
     * @see org.eclipse.ui.IActionDelegate#run(org.eclipse.jface.action.IAction)
     */
    public void run(IAction action) {
        if (this.viewPart instanceof NodeListView) {
            ((NodeListView) this.viewPart).update();
        } else if (this.viewPart instanceof NodeAttributeView) {
            ((NodeAttributeView) this.viewPart).update();
        } else if (this.viewPart instanceof NodeScopeView) {
            ((NodeScopeView) this.viewPart).update();
        } else if (this.viewPart instanceof ScopeListView) {
            ((ScopeListView) this.viewPart).update();
            FacilityTreeComposite tree = ((ScopeListView) this.viewPart)
                    .getScopeTreeComposite();
            tree.update();
        }
    }

    /**
     * @see org.eclipse.ui.IActionDelegate#selectionChanged(org.eclipse.jface.action.IAction,
     *      org.eclipse.jface.viewers.ISelection)
     */
    public void selectionChanged(IAction action, ISelection selection) {
    }
}