/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.repository.view.action;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;

import com.clustercontrol.bean.FacilityConstant;
import com.clustercontrol.bean.FacilityInfo;
import com.clustercontrol.bean.FacilityTreeItem;
import com.clustercontrol.composite.FacilityTreeComposite;
import com.clustercontrol.repository.action.DeleteScopeProperty;
import com.clustercontrol.repository.composite.ScopeListComposite;
import com.clustercontrol.repository.view.ScopeListView;
import com.clustercontrol.util.Messages;

/**
 * פκԤ󥯥饹Ǥ
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class ScopeDeleteAction implements IViewActionDelegate {
	public static final String ID = "com.clustercontrol.repository.view.action.ScopeDeleteAction";

    //	 ----- instance ե ----- //

    private IViewPart viewPart; // ӥ塼

    // ----- instance ᥽å ----- //

    /**
     * @see org.eclipse.ui.IViewActionDelegate#init(org.eclipse.ui.IViewPart)
     */
    public void init(IViewPart viewPart) {
        this.viewPart = viewPart;
    }

    /**
     * @see org.eclipse.ui.IActionDelegate#run(org.eclipse.jface.action.IAction)
     */
    public void run(IAction action) {
        // װꡢ򤵤Ƥ륢ƥ
        // ץĥ꡼ꡢ򤵤Ƥ륹פ
        ScopeListView view = (ScopeListView) this.viewPart
                .getAdapter(ScopeListView.class);

        FacilityTreeComposite tree = view.getScopeTreeComposite();
        ScopeListComposite list = (ScopeListComposite)view.getListComposite();
        
        FacilityTreeItem item = null;
        if(tree.getTree().isFocusControl()){
			item = tree.getSelectItem();
        }
        else if(list.getTableViewer().getTable().isFocusControl()){
        	item = list.getSelectItem();
        }
        else{
        	return;
        }

        // ̤ξϡλ
        if (item == null) {
            return;
        }
        // ݥåȡΡɤ򤷤Ƥϡλ
        FacilityInfo info = item.getData();
        if (item == null || info.getType() == FacilityConstant.TYPE_COMPOSITE
                || info.getType() == FacilityConstant.TYPE_NODE) {
            return;
        }

        String facilityId = info.getFacilityId();
        String facilityName = info.getFacilityName();

        // ǧ
        MessageBox box = new MessageBox(this.viewPart.getSite().getShell(),
                SWT.OK | SWT.CANCEL | SWT.ICON_WARNING);
        box.setText(Messages.getString("confirmed"));
        String[] args = { facilityName, facilityId };
        box.setMessage(Messages.getString("message.repository.3", args));

        // ˤѹ򤵤줿硢Ԥ
        if (box.open() == SWT.OK) {

            if (new DeleteScopeProperty().delete(facilityId)) {
                // 
                box = new MessageBox(this.viewPart.getSite().getShell(),
                        SWT.ICON_INFORMATION);
                box.setText(Messages.getString("successful"));
                box.setMessage(Messages.getString("message.repository.16"));
                box.open();
            } else {
                // 
                box = new MessageBox(this.viewPart.getSite().getShell(),
                        SWT.ICON_ERROR);
                box.setText(Messages.getString("failed"));
                box.setMessage(Messages.getString("message.repository.17"));
                box.open();
            }

            // ӥ塼򹹿
            tree.update();
            view.update();
        }
    }

    /**
     * @see org.eclipse.ui.IActionDelegate#selectionChanged(org.eclipse.jface.action.IAction,
     *      org.eclipse.jface.viewers.ISelection)
     */
    public void selectionChanged(IAction action, ISelection selection) {
    }
}