/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.repository.action;

import java.rmi.AccessException;
import java.rmi.RemoteException;
import java.util.ArrayList;

import javax.ejb.FinderException;
import javax.naming.NamingException;

import org.eclipse.jface.dialogs.MessageDialog;

import com.clustercontrol.repository.ejb.session.RepositoryController;
import com.clustercontrol.repository.util.EjbConnectionManager;
import com.clustercontrol.util.Messages;

/**
 * Ͽװ륯饹Ǥ
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class GetScopeList {

    // ----- instance ᥽å ----- //

    /**
     * Ͽװ֤ޤ
     * 
     * @param facilityId
     *            եƥID
     * @return Ͽװ
     */
    public ArrayList getScopeList(String facilityId) {
        RepositoryController repository = EjbConnectionManager
                .getConnectionManager().getRepositoryController();

        ArrayList records = null;
        try {
            records = repository.getScopeList(facilityId);
        } catch (RemoteException e) {
			if(e instanceof AccessException){
				// ʤξ硢顼ɽ
	            MessageDialog.openInformation(null, Messages.getString("message"),
	                    Messages.getString("message.accesscontrol.16"));
			}
        } catch (FinderException e) {
        } catch (NamingException e) {
        }
        return records;
    }
}