/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.repository.ejb.session;

import java.rmi.RemoteException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;

import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.ejb.SessionContext;
import javax.naming.NamingException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.swt.SWT;

import com.clustercontrol.bean.FacilityTreeItem;
import com.clustercontrol.bean.Property;
import com.clustercontrol.bean.TableColumnInfo;
import com.clustercontrol.repository.bean.NodeListTabelDefine;
import com.clustercontrol.repository.bean.NodeScopeTabelDefine;
import com.clustercontrol.repository.bean.ScopeListTableDefine;
import com.clustercontrol.repository.factory.DeleteFacility;
import com.clustercontrol.repository.factory.ModifyFacility;
import com.clustercontrol.repository.factory.NodeFilterProperty;
import com.clustercontrol.repository.factory.NodeProperty;
import com.clustercontrol.repository.factory.ScopeProperty;
import com.clustercontrol.repository.factory.SelectFacility;
import com.clustercontrol.util.Messages;

/**
 *
 * <!-- begin-user-doc --> A generated session bean <!-- end-user-doc --> *
 *
 * <!-- begin-xdoclet-definition --> 
 * @ejb.bean name="RepositoryController"	
 *           jndi-name="RepositoryController"
 *           type="Stateless" 
 *           transaction-type="Container"
 * 
 * @jboss.depends name="jboss.j2ee:service=EJB,jndiName=AccessController"
 * 
 * @ejb.permission
 *     unchecked="true"
 *     method-intf="Home"
 *     
 * @ejb.permission
 *     unchecked="true"
 *     method-intf="LocalHome"
 *     
 * @ejb.permission
 *     unchecked="true"
 *     method-intf="Local"
 *           
 * <!-- end-xdoclet-definition --> 
 * @generated
 */
public abstract class RepositoryControllerBean implements javax.ejb.SessionBean {
	protected static Log m_log = LogFactory.getLog( RepositoryControllerBean.class ); 
	
	private SessionContext m_context;
	
	public static final int ALL = 0;
	public static final int ONE_LEVEL = 1;
	
	public void setSessionContext(SessionContext ctx) throws EJBException, RemoteException {
		m_context = ctx;
	}

	/**
	 * եƥĥ꡼(Ρɴޤ)
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     role-name="RepositoryRead"
     *     method-intf="Remote"
	 * 
	 * @jboss.method-attributes
	 *     read-only="true"
	 *     
     * @ejb.transaction
	 *     type="NotSupported"
	 * 
	 * @version 1.0.0
	 * @since 1.0.0
	 * 
	 * @param locale
	 * @return FacilityTreeItemγإ֥
	 * @throws FinderException
	 * @throws NamingException
	 */
	public FacilityTreeItem getFacilityTree(Locale locale) throws FinderException, NamingException {

		//եƥĥ꡼(Ρɴޤ)
		SelectFacility select = new SelectFacility();
		FacilityTreeItem item = select.getFacilityTree(locale);

		return item;
	}
	
	/**
	 * եƥĥ꡼(פΤ)
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     role-name="RepositoryRead"
     *     method-intf="Remote"
	 *     
     * @ejb.transaction
	 *     type="NotSupported"
	 * 
	 * @version 1.0.0
	 * @since 1.0.0
	 * 
	 * @param locale
	 * @return FacilityTreeItemγإ֥
	 * @throws NamingException
	 * @throws FinderException
	 */
	public FacilityTreeItem getScopeFacilityTree(Locale locale) throws FinderException, NamingException {
		
		//եƥĥ꡼(פΤ)
		SelectFacility select = new SelectFacility();
		FacilityTreeItem item = select.getScopeFacilityTree(locale);

		return item;
	}
	
	/**
	 * Ρɰơ֥
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     unchecked="true"
     *     method-intf="Remote"
	 *     
     * @ejb.transaction
	 *     type="NotSupported"
	 * 
	 * @version 1.0.0
	 * @since 1.0.0
	 * 
	 * @param local
	 * @return TableColumnInfo
	 */
	@SuppressWarnings("unchecked")
	public ArrayList getNodeListTableDefine(Locale local) {
		
		//ơ֥
		ArrayList tableDefine = new ArrayList();

		tableDefine.add(NodeListTabelDefine.FACILITY_ID, 
				new TableColumnInfo(Messages.getString("facility.id", local), TableColumnInfo.FACILITY_ID, 100, SWT.LEFT));
		tableDefine.add(NodeListTabelDefine.FACILITY_NAME, 
				new TableColumnInfo(Messages.getString("facility.name", local), TableColumnInfo.FACILITY_NAME, 150, SWT.LEFT));
		tableDefine.add(NodeListTabelDefine.DESCRIPTION, 
				new TableColumnInfo(Messages.getString("description", local), TableColumnInfo.NONE, 200, SWT.LEFT));

		return tableDefine;
	}
	
	/**
	 * װơ֥
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     unchecked="true"
     *     method-intf="Remote"
	 *     
     * @ejb.transaction
	 *     type="NotSupported"
	 * 
	 * @version 1.0.0
	 * @since 1.0.0
	 * 
	 * @param local
	 * @return TableColumnInfo
	 */
	@SuppressWarnings("unchecked")
	public ArrayList getNodeScopeTableDefine(Locale local) {
		
		//ơ֥
		ArrayList tableDefine = new ArrayList();

		tableDefine.add(NodeScopeTabelDefine.SCOPE, 
				new TableColumnInfo(Messages.getString("scope", local), TableColumnInfo.NONE, 300, SWT.LEFT));

		return tableDefine;
	}
	
	/**
	 * װ
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     role-name="RepositoryRead"
     *     method-intf="Remote"
	 *     
     * @ejb.transaction
	 *     type="NotSupported"
	 * 
	 * @version 1.0.0
	 * @since 1.0.0
	 * 
	 * @param facilityId
	 * @return ֥Ȥ2
	 * @throws NamingException
	 * @throws FinderException
	 */
	public ArrayList getNodeScopeList(String facilityId) throws FinderException, NamingException {
		
		SelectFacility select = new SelectFacility();
		ArrayList list = select.getNodeScopeList(facilityId);
		
		return list;
	}
	
	/**
	 * װơ֥
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     unchecked="true"
     *     method-intf="Remote"
	 *     
     * @ejb.transaction
	 *     type="NotSupported"
	 * 
	 * @version 1.0.0
	 * @since 1.0.0
	 * 
	 * @param local
	 * @return TableColumnInfo
	 */
	@SuppressWarnings("unchecked")
	public ArrayList getScopeListTableDefine(Locale local) {
		
		/** ơ֥ */
		ArrayList tableDefine = new ArrayList();

		tableDefine.add(ScopeListTableDefine.FACILITY_ID, 
				new TableColumnInfo(Messages.getString("facility.id", local), TableColumnInfo.FACILITY_ID, 100, SWT.LEFT));
		tableDefine.add(ScopeListTableDefine.FACILITY_NAME, 
				new TableColumnInfo(Messages.getString("facility.name", local), TableColumnInfo.FACILITY_NAME, 150, SWT.LEFT));
		tableDefine.add(ScopeListTableDefine.DESCRIPTION, 
				new TableColumnInfo(Messages.getString("description", local), TableColumnInfo.NONE, 200, SWT.LEFT));

		return tableDefine;
	}
	

	/**
	 * װ
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     role-name="RepositoryRead"
     *     method-intf="Remote"
	 *     
     * @ejb.transaction
	 *     type="NotSupported"
	 * 
	 * @version 1.0.0
	 * @since 1.0.0
	 * 
	 * @param parentFacilityId
	 * @return ֥Ȥ2
	 * @throws NamingException
	 * @throws FinderException
	 */
	public ArrayList getScopeList(String parentFacilityId) throws FinderException, NamingException {
		
		SelectFacility select = new SelectFacility();
		ArrayList list = select.getScopeList(parentFacilityId);
		
		return list;
	}
	
	/**
	 * Ρɰ
	 * 
	 * @ejb.interface-method
     *     
	 * @ejb.permission
     *     role-name="RepositoryRead"
     *     method-intf="Remote"
	 *     
     * @ejb.transaction
	 *     type="NotSupported"
	 * 
	 * @version 1.0.0
	 * @since 1.0.0
	 * 
	 * @return ֥Ȥ2
	 * @throws FinderException
	 * @throws NamingException
	 */
	public ArrayList getNodeList() throws FinderException, NamingException {
	
		//եƥĥ꡼
		SelectFacility select = new SelectFacility();
		ArrayList list = select.getNodeList();

		return list;
	}
	
	/**
	 * Ρɰ
	 * 
	 * եƥID۲ޤľΥΡɰ
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     role-name="RepositoryRead"
     *     method-intf="Remote"
	 *     
     * @ejb.transaction
	 *     type="NotSupported"
	 * 
	 * @version 1.0.0
	 * @since 1.0.0
	 * 
	 * @param parentFacilityId
	 * @param level
	 * @return ֥Ȥ2
	 * @throws NamingException
	 * @throws FinderException
	 */
	public ArrayList getNodeList(String parentFacilityId, int level) throws FinderException, NamingException {
		
		//եƥĥ꡼
		SelectFacility select = new SelectFacility();
		ArrayList list = select.getNodeList(parentFacilityId, level);

		return list;
	}
	
	/**
	 * Ρɰ
	 * 
	 * Propertyθ˳Ρɰ
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     role-name="RepositoryRead"
     *     method-intf="Remote"
	 *     
     * @ejb.transaction
	 *     type="NotSupported"
	 * 
	 * @version 1.0.0
	 * @since 1.0.0
	 * 
	 * @param property
	 * @return ֥Ȥ2
	 * @throws FinderException
	 * @throws NamingException
	 */
	public ArrayList getNodeList(Property property) throws FinderException, NamingException {
		
		//եƥĥ꡼
		SelectFacility select = new SelectFacility();
		ArrayList list = select.getNodeList(property);

		return list;
	}
	
	/**
	 * եƥIDꥹȼ
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     role-name="RepositoryRead"
     *     method-intf="Remote"
	 *     
     * @ejb.transaction
	 *     type="NotSupported"
	 * 
	 * @version 2.1.0
	 * @since 1.0.0
	 * 
	 * @param parentFacilityId
	 * @param level
	 * @return եƥID
	 * @throws NamingException
	 * @throws FinderException
	 */
	public ArrayList getFacilityIdList(String parentFacilityId, int level) throws FinderException, NamingException {
		
		//եƥĥ꡼
		SelectFacility select = new SelectFacility();
		ArrayList list = select.getFacilityIdList(parentFacilityId, level, false);

		return list;
	}
	
	/**
	 * եƥIDꥹȼ
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     role-name="RepositoryRead"
     *     method-intf="Remote"
	 *     
     * @ejb.transaction
	 *     type="NotSupported"
	 * 
	 * @version 2.1.0
	 * @since 2.1.0
	 * 
	 * @param parentFacilityId
	 * @param level
	 * @param sort
	 * @return եƥID
	 * @throws FinderException
	 * @throws NamingException
	 */
	public ArrayList getFacilityIdList(String parentFacilityId, int level, boolean sort) throws FinderException, NamingException {
		
		//եƥĥ꡼
		SelectFacility select = new SelectFacility();
		ArrayList list = select.getFacilityIdList(parentFacilityId, level, sort);

		return list;
	}
	
	/**
	 * եƥIDꥹȼ
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     role-name="RepositoryRead"
     *     method-intf="Remote"
	 *     
     * @ejb.transaction
	 *     type="NotSupported"
	 * 
	 * @version 2.1.0
	 * @since 1.0.0
	 * 
	 * @param parentFacilityId
	 * @param level
	 * @return եƥID
	 * @throws NamingException
	 * @throws FinderException
	 */
	public ArrayList getNodeFacilityIdList(String parentFacilityId, int level) throws FinderException, NamingException {
		
		//եƥĥ꡼
		SelectFacility select = new SelectFacility();
		ArrayList list = select.getNodeFacilityIdList(parentFacilityId, level, false);

		return list;
	}
	
	/**
	 * եƥIDꥹȼ
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     role-name="RepositoryRead"
     *     method-intf="Remote"
	 *     
     * @ejb.transaction
	 *     type="NotSupported"
	 * 
	 * @version 2.1.0
	 * @since 2.1.0
	 * 
	 * @param parentFacilityId
	 * @param level
	 * @param sort
	 * @return եƥID
	 * @throws NamingException
	 * @throws FinderException
	 */
	public ArrayList getNodeFacilityIdList(String parentFacilityId, int level, boolean sort) throws FinderException, NamingException {
		
		//եƥĥ꡼
		SelectFacility select = new SelectFacility();
		ArrayList list = select.getNodeFacilityIdList(parentFacilityId, level, sort);

		return list;
	}
	
	/**
	 * եƥIDꥹȼ
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     role-name="RepositoryRead"
     *     method-intf="Remote"
	 *     
     * @ejb.transaction
	 *     type="NotSupported"
	 * 
	 * @version 1.0.0
	 * @since 1.0.0
	 * 
	 * @return եƥID
	 * @throws FinderException
	 * @throws NamingException
	 */
	public ArrayList getNodeFacilityIdList() throws FinderException, NamingException {
		
		//եƥĥ꡼
		SelectFacility select = new SelectFacility();
		ArrayList list = select.getNodeFacilityIdList(false);

		return list;
	}
	
	/**
	 * եƥIDꥹȼ
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     role-name="RepositoryRead"
     *     method-intf="Remote"
	 *     
     * @ejb.transaction
	 *     type="NotSupported"
	 * 
	 * @version 2.1.0
	 * @since 2.1.0
	 * 
	 * @param sort
	 * @return եƥID
	 * @throws FinderException
	 * @throws NamingException
	 */
	public ArrayList getNodeFacilityIdList(boolean sort) throws FinderException, NamingException {
		
		//եƥĥ꡼
		SelectFacility select = new SelectFacility();
		ArrayList list = select.getNodeFacilityIdList(sort);

		return list;
	}
	
	/**
	 * ǥХꥹȼ
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     role-name="RepositoryRead"
     *     method-intf="Remote"
	 * 
     * @ejb.transaction
	 *     type="NotSupported"
	 * 
	 * @version 1.0.0
	 * @since 1.0.0
	 * 
	 * @param facilityId
	 * @return DeviceData
	 * @throws NamingException
	 * @throws FinderException
	 */
	public ArrayList getDeviceList(String facilityId) throws FinderException, NamingException {
		
		SelectFacility select = new SelectFacility();
		ArrayList list = select.getDeviceList(facilityId);
		
		return list;
	}
	
	/**
	 * Ρɾܺټ
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     role-name="RepositoryRead"
     *     method-intf="Remote"
	 *     
     * @ejb.transaction
	 *     type="NotSupported"
	 * 
	 * @version 1.0.0
	 * @since 1.0.0
	 * 
	 * @param facilityId
	 * @param attributes
	 * @return °̾ͤHashMapȤ֤
	 * @throws NamingException
	 * @throws FinderException
	 */
	public HashMap getNodeDetail(String facilityId, ArrayList attributes) throws FinderException, NamingException {
		
		SelectFacility select = new SelectFacility();
		HashMap map = select.getNodeDetail(facilityId, attributes);
		
		return map;
	}
	
	/**
	 * Ρɾܺټ
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     role-name="RepositoryRead"
     *     method-intf="Remote"
	 *     
     * @ejb.transaction
	 *     type="NotSupported"
	 * 
	 * @version 1.0.0
	 * @since 1.0.0
	 * 
	 * @param facilityIdList
	 * @param attributes
	 * @return եƥID°(°̾ͤHashMap)HashMap
	 * @throws NamingException
	 * @throws FinderException
	 */
	public HashMap getNodeDetail(ArrayList facilityIdList, ArrayList attributes) throws FinderException, NamingException {
		
		SelectFacility select = new SelectFacility();
		HashMap map = select.getNodeDetail(facilityIdList, attributes);
		
		return map;
	}
	
	/**
	 * Ρɾܺ
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     role-name="RepositoryWrite"
     *     method-intf="Remote"
	 * 
	 * @version 1.0.0
	 * @since 1.0.0
	 * 
	 * @param facilityId
	 * @param attributes °̾ͤHashMap
	 * @throws FinderException
	 * @throws NamingException
	 */
	public void setNodeDetail(String facilityId, HashMap attributes) throws FinderException, NamingException {
		ModifyFacility modify = new ModifyFacility();
		modify.setNodeDetail(facilityId, attributes);
	}
	
	/**
	 * ɲ
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     role-name="RepositoryWrite"
     *     method-intf="Remote"
	 * 
	 * @version 1.0.0
	 * @since 1.0.0
	 * 
	 * @param parentFacilityId
	 * @param property
	 * @throws CreateException
	 * @throws NamingException
	 * @throws RemoveException
	 */
	public void addScope(String parentFacilityId, Property property) throws RemoveException, CreateException, NamingException {
		ModifyFacility modify = new ModifyFacility();
		modify.addScope(parentFacilityId, property);
	}
	
	/**
	 * ѹ
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     role-name="RepositoryWrite"
     *     method-intf="Remote"
	 * 
	 * @version 1.0.0
	 * @since 1.0.0
	 * 
	 * @param property
	 * @throws NamingException
	 * @throws FinderException
	 */
	public void modifyScope(Property property) throws NamingException, FinderException {
		ModifyFacility modify = new ModifyFacility();
		modify.modifyScope(property);
	}
	
	/**
	 * Ρɲ
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     role-name="RepositoryWrite"
     *     method-intf="Remote"
	 * 
	 * @version 2.0.0
	 * @since 1.0.0
	 * 
	 * @param property
	 * @throws NamingException
	 * @throws CreateException
	 */
	public void addNode(Property property) throws NamingException, CreateException {
		Principal pri = m_context.getCallerPrincipal();
		
		ModifyFacility modify = new ModifyFacility();
		modify.addNode(property, pri.getName());
	}
	
	/**
	 * Ρѹ
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     role-name="RepositoryWrite"
     *     method-intf="Remote"
	 * 
	 * @version 2.0.0
	 * @since 1.0.0
	 * 
	 * @param property
	 * @throws NamingException
	 * @throws FinderException
	 * @throws CreateException
	 */
	public void modifyNode(Property property) throws NamingException, FinderException, CreateException {
		Principal pri = m_context.getCallerPrincipal();
		
		ModifyFacility modify = new ModifyFacility();
		modify.modifyNode(property, pri.getName());
	}
	
	/**
	 * Ρѹ()
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     role-name="RepositoryWrite"
     *     method-intf="Remote"
	 * 
	 * @version 2.0.0
	 * @since 1.0.0
	 * 
	 * @param property
	 * @param parentFacilityId
	 * @throws NamingException
	 * @throws FinderException
	 */
	public void modifyNode(Property property, String parentFacilityId) throws NamingException, FinderException {
		Principal pri = m_context.getCallerPrincipal();
		
		ModifyFacility modify = new ModifyFacility();
		modify.modifyAllNode(property, parentFacilityId, pri.getName());
	}
	
	/**
	 * Ρɺ
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     role-name="RepositoryWrite"
     *     method-intf="Remote"
	 * 
	 * @version 1.0.0
	 * @since 1.0.0
	 * 
	 * @param facilityId
	 * @throws FinderException
	 * @throws RemoveException
	 * @throws NamingException
	 */
	public void deleteNode(String facilityId) throws FinderException, RemoveException, NamingException {
		DeleteFacility delete = new DeleteFacility();
		delete.deleteNode(facilityId);
	}
	
	/**
	 * ׺
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     role-name="RepositoryWrite"
     *     method-intf="Remote"
	 * 
	 * @ejb.permission
     *     role-name="RepositoryWrite"
     *     method-intf="Remote"
	 * 
	 * @version 1.0.0
	 * @since 1.0.0
	 * 
	 * @param facilityId
	 * @throws FinderException
	 * @throws NamingException
	 * @throws RemoveException
	 */
	public void deleteScope(String facilityId) throws FinderException, NamingException, RemoveException {
		DeleteFacility delete = new DeleteFacility();
		delete.deleteScope(facilityId);
	}
	
	/**
	 * פؤΥΡɤγ
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     role-name="RepositoryWrite"
     *     method-intf="Remote"
	 * 
	 * @version 1.0.0
	 * @since 1.0.0
	 * 
	 * @param parentFacilityId
	 * @param facilityIds
	 * @throws NamingException
	 * @throws CreateException
	 */
	public void assignNodeScope(String parentFacilityId, String[] facilityIds) throws NamingException, CreateException {
		ModifyFacility modify = new ModifyFacility();
		modify.assignNodeScope(parentFacilityId, facilityIds);
	}
	
	/**
	 * ΡɤΥפκ
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     role-name="RepositoryWrite"
     *     method-intf="Remote"
	 * 
	 * @version 1.0.0
	 * @since 1.0.0
	 * 
	 * @param parentFacilityId
	 * @param facilityIds
	 * @throws RemoveException
	 * @throws NamingException
	 * @throws FinderException
	 */
	public void releaseNodeScope(String parentFacilityId, String[] facilityIds) throws FinderException, NamingException, RemoveException {
		DeleteFacility delete = new DeleteFacility();
		delete.releaseNodeScope(parentFacilityId, facilityIds);
	}
	
	/**
	 * ѥץѥƥ
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     role-name="RepositoryRead"
     *     method-intf="Remote"
	 *     
     * @ejb.transaction
	 *     type="NotSupported"
	 * 
	 * @version 1.0.0
	 * @since 1.0.0
	 * 
	 * @param facilityId
	 * @param mode
	 * @param local
	 * @return
	 * @throws FinderException
	 * @throws NamingException
	 */
	public Property getScopeProperty(String facilityId, int mode, Locale local) throws FinderException, NamingException {
		ScopeProperty scope = new ScopeProperty();
		return scope.getProperty(facilityId, mode, local);
	}
	
	/**
	 * Ρѥץѥƥ
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     role-name="RepositoryRead"
     *     method-intf="Remote"
	 *     
     * @ejb.transaction
	 *     type="NotSupported"
	 * 
	 * @version 1.0.0
	 * @since 1.0.0
	 * 
	 * @param facilityId
	 * @param mode
	 * @param local
	 * @return
	 * @throws FinderException
	 * @throws NamingException
	 */
	public Property getNodeProperty(String facilityId, int mode, Locale local) throws FinderException, NamingException {
		NodeProperty node = new NodeProperty();
		return node.getProperty(facilityId, mode, local);
	}
	
	/**
	 * Ρѥץѥƥ
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     role-name="RepositoryRead"
     *     method-intf="Remote"
	 *     
     * @ejb.transaction
	 *     type="NotSupported"
	 * 
	 * @version 1.0.0
	 * @since 1.0.0
	 * 
	 * @param local
	 * @return
	 */
	public Property getNodeFilterProperty(Locale local) {
		NodeFilterProperty node = new NodeFilterProperty();
		return node.getProperty(local);
	}
	
	/**
	 * եƥѥ
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     role-name="RepositoryRead"
     *     method-intf="Remote"
     *     
     * @ejb.transaction
	 *     type="NotSupported"
	 *     
	 * @version 1.0.0
	 * @since 1.0.0
	 * 
	 * @param facilityId
	 * @param parentFacilityId
	 * @return
	 * @throws FinderException
	 * @throws NamingException
	 */
	public String getFacilityPath(String facilityId, String parentFacilityId) throws FinderException, NamingException {
		SelectFacility select = new SelectFacility();
		return select.getFacilityPath(facilityId, parentFacilityId);
	}
	
	/**
	 * եƥIDꥹȼ
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     role-name="RepositoryRead"
     *     method-intf="Remote"
	 * 
     * @ejb.transaction
	 *     type="NotSupported"
	 * 
	 * @version 1.0.0
	 * @since 1.0.0
	 * 
	 * @param hostName
	 * @param ipAddress
	 * @return եƥID
	 * @throws FinderException
	 * @throws NamingException
	 */
	public ArrayList getFacilityIdList(String hostName, String ipAddress) throws FinderException, NamingException {
		SelectFacility select = new SelectFacility();
		return select.getFacilityIdList(hostName, ipAddress);
	}
	
    /**
     * Ρɥå
     * 
     * եƥIDΡɤå̤boolean֤
     * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     role-name="RepositoryRead"
     *     method-intf="Remote"
	 *     
     * @ejb.transaction
	 *     type="NotSupported"
	 * 
	 * @version 1.0.0
	 * @since 1.0.0
	 * 
	 * @param facilityId
	 * @param parentFacilityId
	 * @return եƥID
	 * @throws FinderException
	 * @throws NamingException
	 */
	public boolean isNode(String facilityId) throws FinderException, NamingException {
		SelectFacility select = new SelectFacility();
		return select.isNode(facilityId);
	}
	
	/**
	 * ѥ졼ʸ
	 * 
	 * @ejb.interface-method
	 * @generated
	 * 
	 * @ejb.permission
     *     unchecked="true"
     *     method-intf="Remote"
	 * 
     * @ejb.transaction
	 *     type="NotSupported"
	 * 
	 * @version 1.0.0
	 * @since 1.0.0
	 * 
	 * @return
	 */
	public String getSeparator() {
		return SelectFacility.SEPARATOR;
	}
}
