/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.repository.factory;

import java.util.Collection;
import java.util.Iterator;

import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.naming.NamingException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.accesscontrol.factory.AccessLock;
import com.clustercontrol.bean.FacilityConstant;
import com.clustercontrol.repository.bean.TopicConstant;
import com.clustercontrol.repository.ejb.entity.DeviceInfoLocal;
import com.clustercontrol.repository.ejb.entity.FacilityLocal;
import com.clustercontrol.repository.ejb.entity.FacilityTreeLocal;
import com.clustercontrol.repository.ejb.entity.FacilityTreeUtil;
import com.clustercontrol.repository.ejb.entity.FacilityUtil;
import com.clustercontrol.repository.message.UpdateRepositoryInfo;
import com.clustercontrol.repository.util.SendTopic;
import com.clustercontrol.util.apllog.AplLogger;

/**
 * եƥ饹
 *
 * @version 1.0.0
 * @since 1.0.0
 */
public class DeleteFacility {
    protected static Log m_log = LogFactory.getLog( DeleteFacility.class );
    
	/**
	 * Ρɺ
	 * 
	 * @param facilityId
	 * @throws FinderException
	 * @throws RemoveException
	 * @throws NamingException
	 */
	public void deleteNode(String facilityId) throws FinderException, RemoveException, NamingException {
    	//å
    	AccessLock.lock(AccessLock.REPOSITORY);
    	
    	try {
			//եƥIDFacility
			FacilityLocal facility = FacilityUtil.getLocalHome().findByFacilityId(facilityId);

			//եƥIDFacilityTree
			Collection collection = facility.getFacilityTree();
			if(collection != null){
				Iterator itr = collection.iterator();
				while(itr.hasNext()){
					FacilityTreeLocal facilityTree = (FacilityTreeLocal)itr.next();
					//FacilityTree
					removeFacilityTree(facilityTree);
				}
			}
			//Facility
			removeFacility(facility);
			
			try {
				//Topic
				SendTopic send = new SendTopic(TopicConstant.TOPIC_NAME_EXECUTE);
				send.put(new UpdateRepositoryInfo());
			} catch (Exception e) {
				m_log.debug("addScope() : 顼 : " + e.getMessage());
			}
		} catch (EJBException e) {
            AplLogger apllog = new AplLogger("REP", "rep");
            String[] args = {facilityId};
            apllog.put("SYS", "010", args);
            
			m_log.debug("deleteNode() : " + e.getMessage());
			throw e;
		} catch (RemoveException e) {
            AplLogger apllog = new AplLogger("REP", "rep");
            String[] args = {facilityId};
            apllog.put("SYS", "010", args);
            
            m_log.debug("deleteNode() : " + e.getMessage());
			throw e;
		} catch (FinderException e) {
            AplLogger apllog = new AplLogger("REP", "rep");
            String[] args = {facilityId};
            apllog.put("SYS", "010", args);
            
            m_log.debug("deleteNode() : " + e.getMessage());
			throw e;
		}
	}
	
	/**
	 * ׺
	 * 
	 * @param facilityId
	 * @throws FinderException
	 * @throws NamingException
	 * @throws RemoveException
	 */
	public void deleteScope(String facilityId) throws FinderException, NamingException, RemoveException  {
    	//å
    	AccessLock.lock(AccessLock.REPOSITORY);
    	
    	try {
			//եƥIDFacility
			FacilityLocal facility = FacilityUtil.getLocalHome().findByFacilityId(facilityId);
			
			//եƥIDFacilityTree
			Collection collection = facility.getFacilityTree();
			if(collection != null){
				Iterator itr = collection.iterator();
				while(itr.hasNext()){
					FacilityTreeLocal facilityTree = (FacilityTreeLocal)itr.next();
					//FacilityTree
					removeFacilityTree(facilityTree);
				}
			}
			
			try {
				//Topic
				SendTopic send = new SendTopic(TopicConstant.TOPIC_NAME_EXECUTE);
				send.put(new UpdateRepositoryInfo());
			} catch (Exception e) {
				m_log.debug("addScope() : 顼 : " + e.getMessage());
			}
		} catch (FinderException e) {
            AplLogger apllog = new AplLogger("REP", "rep");
            String[] args = {facilityId};
            apllog.put("SYS", "013", args);
            
            m_log.debug("deleteScope() : " + e.getMessage());
			throw e;
		} catch (EJBException e) {
            AplLogger apllog = new AplLogger("REP", "rep");
            String[] args = {facilityId};
            apllog.put("SYS", "013", args);
            
            m_log.debug("deleteScope() : " + e.getMessage());
			throw e;
		} catch (RemoveException e) {
            AplLogger apllog = new AplLogger("REP", "rep");
            String[] args = {facilityId};
            apllog.put("SYS", "013", args);
            
            m_log.debug("deleteScope() : " + e.getMessage());
			throw e;
		}
	}
	
	/**
	 * פؤΥΡɤγƲ
	 * 
	 * @param parentFacilityId
	 * @param facilityIds
	 * @throws FinderException
	 * @throws NamingException
	 * @throws RemoveException
	 */
	public void releaseNodeScope(String parentFacilityId, String[] facilityIds) throws FinderException, NamingException, RemoveException {
    	//å
    	AccessLock.lock(AccessLock.REPOSITORY);
    	
    	String facilityId = null;
	    try {
			//եƥIDľΥΡɤFacilityTree
			Collection collection = FacilityTreeUtil.getLocalHome().findOneLevelNode(parentFacilityId);
			if(collection != null){
				Iterator itr = collection.iterator();
				while(itr.hasNext()){
					//ΡɤFacilityTreeեƥIDȰפ
					FacilityTreeLocal facilityTree = (FacilityTreeLocal)itr.next();
					for(int i = 0; i < facilityIds.length; i++){
						String nodeFacilityId = facilityTree.getFacilityId();
						if(nodeFacilityId.compareTo(facilityIds[i]) == 0){
						    facilityId = facilityIds[i];
							removeFacilityTree(facilityTree);
							break;
						}
					}
				}
			}
			
			try {
				//Topic
				SendTopic send = new SendTopic(TopicConstant.TOPIC_NAME_EXECUTE);
				send.put(new UpdateRepositoryInfo());
			} catch (Exception e) {
				m_log.debug("addScope() : 顼 : " + e.getMessage());
			}
		} catch (EJBException e) {
            AplLogger apllog = new AplLogger("REP", "rep");
            String[] args = {facilityId, parentFacilityId};
            apllog.put("SYS", "016", args);
            
            m_log.debug("releaseNodeScope() : " + e.getMessage());
			throw e;
		} catch (NamingException e) {
            AplLogger apllog = new AplLogger("REP", "rep");
            String[] args = {facilityId, parentFacilityId};
            apllog.put("SYS", "016", args);
            
            m_log.debug("releaseNodeScope() : " + e.getMessage());
			throw e;
		}
	}
	
	/**
	 * Facility
	 * 
	 * @param facility
	 * @throws RemoveException
	 */
	protected void removeFacility(FacilityLocal facility) throws RemoveException {
		//DeviceInfo
		Collection collection = null;
		try {
			collection = facility.getDeviceInfo();
		} catch (FinderException e) {
		    m_log.debug("removeFacility() : " + e.getMessage());
		}
		
		try {
			//DeviceInfo
			if(collection != null && collection.size() > 0){
				Iterator itr = collection.iterator();
				while(itr.hasNext()){
					DeviceInfoLocal device = (DeviceInfoLocal)itr.next();
					device.remove();
				}
			}
		
			//Facility
			facility.remove();
			
		} catch (RemoveException e) {
		    m_log.debug("removeFacility() : " + e.getMessage());
			throw e;
		}
	}
	
	/**
	 * FacilityTree
	 * 
	 * @param facilityTree
	 * @throws RemoveException
	 * @throws NamingException
	 * @throws FinderException
	 */
	protected void removeFacilityTree(FacilityTreeLocal facilityTree) throws RemoveException, NamingException, FinderException {
		
		//Ҥ
		Collection collection = null;
		try {
			collection = facilityTree.getChildren();
		} catch (FinderException e) {
		    m_log.debug("removeFacilityTree() : " + e.getMessage());
		}
		
		//FacilityTree
		if(collection != null && collection.size() > 0){
			Iterator itr = collection.iterator();
			while(itr.hasNext()){
				FacilityTreeLocal children = (FacilityTreeLocal)itr.next();
				removeFacilityTree(children);
			}
		}
		
		try {
			//FacilityTreeפʤСFacility
			FacilityLocal facility = facilityTree.getFacility();
			if(facility.getType() == FacilityConstant.TYPE_SCOPE){
				removeFacility(facility);
			}

			//FacilityTree
			FacilityTreeUtil.getLocalHome().remove(facilityTree.getPrimaryKey());
			
		} catch (RemoveException e) {
		    m_log.debug("removeFacilityTree() : " + e.getMessage());
			throw e;
		} catch (FinderException e) {
		    m_log.debug("removeFacilityTree() : " + e.getMessage());
			throw e;
		}
	}
}
