/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.repository.factory;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;

import javax.ejb.FinderException;
import javax.naming.NamingException;

import com.clustercontrol.bean.FacilityConstant;
import com.clustercontrol.bean.FacilityInfo;
import com.clustercontrol.bean.FacilityTreeItem;
import com.clustercontrol.bean.Property;
import com.clustercontrol.performanceMGR.bean.DeviceData;
import com.clustercontrol.repository.bean.FacilityAttributeConstant;
import com.clustercontrol.repository.ejb.entity.DeviceInfoLocal;
import com.clustercontrol.repository.ejb.entity.DeviceInfoUtil;
import com.clustercontrol.repository.ejb.entity.FacilityLocal;
import com.clustercontrol.repository.ejb.entity.FacilityTreeLocal;
import com.clustercontrol.repository.ejb.entity.FacilityTreeUtil;
import com.clustercontrol.repository.ejb.entity.FacilityUtil;
import com.clustercontrol.repository.ejb.session.RepositoryControllerBean;
import com.clustercontrol.repository.util.ListSorter;
import com.clustercontrol.util.Messages;
import com.clustercontrol.util.PropertyUtil;

/**
 * եƥ饹
 *
 * @version 1.0.0
 * @since 1.0.0
 */
public class SelectFacility {
	public static final String SEPARATOR = ">";
	
	/**
	 * Ρɾܺ٤
	 * 
	 * °̾ͤHashMapȤ֤
	 * 
	 * @param facilityId
	 * @param attributes
	 * @return °̾ͤHashMap
	 * @throws FinderException
	 * @throws NamingException
	 */
	public HashMap getNodeDetail(String facilityId, ArrayList attributes) throws FinderException, NamingException {
		HashMap map = new HashMap();
		try {
			FacilityLocal facility = FacilityUtil.getLocalHome().findByFacilityId(facilityId);
			
			for(int i = 0; i < attributes.size(); i++){
				//°
				String attribute = (String)attributes.get(i);
				
				if(attribute.compareTo(FacilityAttributeConstant.FACILITYID) == 0){
					//ccFacilityId
					map.put(attribute, facility.getFacilityId());
				}
				else if(attribute.compareTo(FacilityAttributeConstant.CN) == 0){
					//cn
					map.put(attribute, facility.getCn());
				}
				else if(attribute.compareTo(FacilityAttributeConstant.DESCRIPTION) == 0){
					//description
					map.put(attribute, facility.getDescription());
				}
				else if(attribute.compareTo(FacilityAttributeConstant.AGENTCONTROL) == 0){
					//ccAgentControl
					map.put(attribute, facility.getAgentControl());
				}
				else if(attribute.compareTo(FacilityAttributeConstant.AGENTWATCH) == 0){
					//ccAgentWatch
					map.put(attribute, facility.getAgentWatch());
				}
				else if(attribute.compareTo(FacilityAttributeConstant.AGENTWATCHSTATUS) == 0){
					//ccAgentWatchStatus
					map.put(attribute, facility.getAgentWatchStatus());
				}
				else if(attribute.compareTo(FacilityAttributeConstant.CHARSET) == 0){
					//ccCharSet
					map.put(attribute, facility.getCharSet());
				}
				else if(attribute.compareTo(FacilityAttributeConstant.CREATETIMESTAMP) == 0){
					//ccCreateTimestamp
					map.put(attribute, facility.getCreateTimestamp());
				}
				else if(attribute.compareTo(FacilityAttributeConstant.CREATORSNAME) == 0){
					//ccCreatorsName
					map.put(attribute, facility.getCreatorsName());
				}
				else if(attribute.compareTo(FacilityAttributeConstant.DHCPCLIENT) == 0){
					//ccDhcpClient
					map.put(attribute, facility.getDhcpClient());
				}
				else if(attribute.compareTo(FacilityAttributeConstant.HOST) == 0){
					//host
					map.put(attribute, facility.getHost());
				}
				else if(attribute.compareTo(FacilityAttributeConstant.IPNETWORKNUMBER) == 0){
					//ipNetworkNumber
					map.put(attribute, facility.getIpNetworkNumber());
				}
				else if(attribute.compareTo(FacilityAttributeConstant.IPNETWORKNUMBERV6) == 0){
					//ccIpNetworkNumberV6
					map.put(attribute, facility.getIpNetworkNumberV6());
				}
				else if(attribute.compareTo(FacilityAttributeConstant.IPPROTOCOLNUMBER) == 0){
					//ipProtocolNumber
					map.put(attribute, facility.getIpProtocolNumber());
				}
				else if(attribute.compareTo(FacilityAttributeConstant.IPTYPE) == 0){
					//ccIpType
					map.put(attribute, facility.getIpType());
				}
				else if(attribute.compareTo(FacilityAttributeConstant.LOGWATCH) == 0){
					//ccLogWatch
					map.put(attribute, facility.getLogWatch());
				}
				else if(attribute.compareTo(FacilityAttributeConstant.MACHINE) == 0){
					//ccMachine
					map.put(attribute, facility.getMachine());
				}
				else if(attribute.compareTo(FacilityAttributeConstant.MANAGERCONTACT) == 0){
					//ccManagerContact
					map.put(attribute, facility.getManagerContact());
				}
				else if(attribute.compareTo(FacilityAttributeConstant.MANAGERNAME) == 0){
					//ccManagerName
					map.put(attribute, facility.getManagerName());
				}
				else if(attribute.compareTo(FacilityAttributeConstant.MODIFIERSNAME) == 0){
					//ccModifiersName
					map.put(attribute, facility.getModifiersName());
				}
				else if(attribute.compareTo(FacilityAttributeConstant.MODIFYTIMESTAMP) == 0){
					//ccModifyTimestamp
					map.put(attribute, facility.getModifyTimestamp());
				}
				else if(attribute.compareTo(FacilityAttributeConstant.NODENAME) == 0){
					//ccNodeName
					map.put(attribute, facility.getNodeName());
				}
				else if(attribute.compareTo(FacilityAttributeConstant.OSNAME) == 0){
					//ccOsName
					map.put(attribute, facility.getOsName());
				}
				else if(attribute.compareTo(FacilityAttributeConstant.OSRELEASE) == 0){
					//ccOsRelease
					map.put(attribute, facility.getOsRelease());
				}
				else if(attribute.compareTo(FacilityAttributeConstant.OSVERSION) == 0){
					//ccOsVersion
					map.put(attribute, facility.getOsVersion());
				}
				else if(attribute.compareTo(FacilityAttributeConstant.PINGWATCH) == 0){
					//ccPingWatch
					map.put(attribute, facility.getPingWatch());
				}
				else if(attribute.compareTo(FacilityAttributeConstant.PINGWATCHSTATUS) == 0){
					//ccPingWatchStatus
					map.put(attribute, facility.getPingWatchStatus());
				}
				else if(attribute.compareTo(FacilityAttributeConstant.PLATFORM) == 0){
					//ccPlatform
					map.put(attribute, facility.getPlatform());
				}
				else if(attribute.compareTo(FacilityAttributeConstant.STATUSWATCH) == 0){
					//ccPlatform
					map.put(attribute, facility.getStatusWatch());
				}
			}
		} catch (FinderException e) {
			throw e;
		} catch (NamingException e) {
			throw e;
		}
		
		return map;
	}
	
	/**
	 * Ρɾܺ٤
	 * 
	 * եƥID°(°̾ͤHashMap)HashMapȤ֤
	 * 
	 * @param facilityIdList
	 * @param attributes
	 * @return եƥID°(°̾ͤHashMap)HashMap
	 * @throws NamingException
	 * @throws FinderException
	 */
	public HashMap getNodeDetail(ArrayList facilityIdList, ArrayList attributes) throws FinderException, NamingException {
		HashMap map = new HashMap();
		
		for(int i = 0; i < facilityIdList.size(); i++){
			String facilityId = (String)facilityIdList.get(i);
			HashMap detailMap = getNodeDetail(facilityId, attributes);
			map.put(facilityId, detailMap);
		}
		
		return map;
	}
	
	/**
	 * ǥХ
	 * 
	 * DeviceData֤
	 * 
	 * @param facilityId
	 * @return DeviceData
	 * @throws FinderException
	 * @throws NamingException
	 */
	public ArrayList getDeviceList(String facilityId) throws FinderException, NamingException {
		ArrayList list = null;
		try {
			//FacilityTreeκǾ̥ȥ
			Collection ct = DeviceInfoUtil.getLocalHome().findByFacilityId(facilityId);
			
			list = new ArrayList();
			Iterator itr = ct.iterator();
			while(itr.hasNext()){
				DeviceInfoLocal d = (DeviceInfoLocal)itr.next();
				DeviceData data = new DeviceData(
						d.getFacilityId(), 
						d.getSnmpOID(), 
						d.getDeviceIndex().intValue(), 
						d.getCn(), 
						d.getDeviceType());
				
				list.add(data);
			}
		} catch (FinderException e) {
			throw e;
		} catch (NamingException e) {
			throw e;
		}
		
		return list;
	}
	
	/**
	 * Ρɰ
	 * 
	 * ֥Ȥ2Ȥ֤
	 * 
	 * @return
	 * @throws FinderException
	 * @throws NamingException
	 */
	public ArrayList getNodeList() throws FinderException, NamingException {
		ArrayList list = null;
		try {
			//FacilityκǾ̥ȥ
			Collection ct = FacilityUtil.getLocalHome().findAllNode();
			
			list = new ArrayList();
			Iterator itr = ct.iterator();
			while(itr.hasNext()){
				FacilityLocal ft = (FacilityLocal)itr.next();
				
				ArrayList info = new ArrayList();
				info.add(ft.getFacilityId());
				info.add(ft.getCn());
				info.add(ft.getDescription());
				list.add(info);
			}
		} catch (FinderException e) {
			throw e;
		} catch (NamingException e) {
			throw e;
		}
		
		return list;
	}
	
	/**
	 * Ρɰ
	 * 
	 * ֥Ȥ2Ȥ֤
	 * 
	 * @param parentFacilityId
	 * @param level
	 * @return
	 * @throws FinderException
	 * @throws NamingException
	 */
	public ArrayList getNodeList(String parentFacilityId, int level) throws FinderException, NamingException {
		ArrayList list = null;
		try {
			Collection ct = null;
			if(level == RepositoryControllerBean.ALL){
				//FacilityTreeκǾ̥ȥ
				ct = FacilityTreeUtil.getLocalHome().findAllNode(parentFacilityId);
			}
			else{
				//FacilityTreeκǾ̥ȥ
				ct = FacilityTreeUtil.getLocalHome().findOneLevelNode(parentFacilityId);
			}
			
			HashMap map = new HashMap();
			list = new ArrayList();
			Iterator itr = ct.iterator();
			while(itr.hasNext()){
				FacilityTreeLocal ft = (FacilityTreeLocal)itr.next();
				
				if(map.get(ft.getFacilityId()) == null){
					map.put(ft.getFacilityId(), "1");
					
					FacilityLocal facility = ft.getFacility();
					ArrayList info = new ArrayList();
					info.add(facility.getFacilityId());
					info.add(facility.getCn());
					info.add(facility.getDescription());
					list.add(info);
				}
			}
		} catch (FinderException e) {
			throw e;
		} catch (NamingException e) {
			throw e;
		}
		
		return list;
	}
	
	/**
	 * Ρɰ
	 * 
	 * ֥Ȥ2Ȥ֤
	 * 
	 * @param property
	 * @return
	 * @throws FinderException
	 * @throws NamingException
	 */
	public ArrayList getNodeList(Property property) throws FinderException, NamingException {
		ArrayList list = null;
		try {
			ArrayList values = null;
			//եƥID
			values = PropertyUtil.getPropertyValue(property, NodeFilterProperty.FACILITY_ID);
			String facilityId = (String)values.get(0);
			//եƥ̾
			values = PropertyUtil.getPropertyValue(property, NodeFilterProperty.FACILITY_NAME);
			String facilityName = (String)values.get(0);
			//
			values = PropertyUtil.getPropertyValue(property, NodeFilterProperty.DESCRIPTION);
			String description = (String)values.get(0);
			//IPɥ쥹
			values = PropertyUtil.getPropertyValue(property, NodeFilterProperty.IP_ADDRESS);
			String ipAddress = (String)values.get(0);
			//OS̾
			values = PropertyUtil.getPropertyValue(property, NodeFilterProperty.OS_NAME);
			String osName = (String)values.get(0);
			//OS꡼
			values = PropertyUtil.getPropertyValue(property, NodeFilterProperty.OS_RELEASE);
			String osRelease = (String)values.get(0);
			//Լ
			values = PropertyUtil.getPropertyValue(property, NodeFilterProperty.ADMINISTRATOR);
			String managerName = (String)values.get(0);
			//Ϣ
			values = PropertyUtil.getPropertyValue(property, NodeFilterProperty.CONTACT);
			String managerContact = (String)values.get(0);
			
			//FacilityκǾ̤鸡
			Collection ct = 
				FacilityUtil.getLocalHome().findNode(
						facilityId, 
						facilityName, 
						description, 
						ipAddress, 
						osName, 
						osRelease, 
						managerName, 
						managerContact);
			
			list = new ArrayList();
			Iterator itr = ct.iterator();
			while(itr.hasNext()){
				FacilityLocal ft = (FacilityLocal)itr.next();
				
				ArrayList info = new ArrayList();
				info.add(ft.getFacilityId());
				info.add(ft.getCn());
				info.add(ft.getDescription());
				list.add(info);
			}
		} catch (FinderException e) {
			throw e;
		} catch (NamingException e) {
			throw e;
		}
		
		return list;
	}
	
	/**
	 * եƥIDꥹȼ
	 * 
	 * եƥIDȤ֤
	 * 
	 * @param parentFacilityId
	 * @param level
	 * @param sort
	 * @return
	 * @throws FinderException
	 * @throws NamingException
	 */
	public ArrayList getFacilityIdList(String parentFacilityId, int level, boolean sort) throws FinderException, NamingException {
		ArrayList list = null;
		try {
			Collection ct = null;
			if(level == RepositoryControllerBean.ALL){
				//FacilityTreeκǾ̥ȥ
				ct = FacilityTreeUtil.getLocalHome().findAll(parentFacilityId);
			}
			else{
				//FacilityTreeκǾ̥ȥ
				ct = FacilityTreeUtil.getLocalHome().findOneLevel(parentFacilityId);
			}
			
			HashMap map = new HashMap();
			list = new ArrayList();
			Iterator itr = ct.iterator();
			int i = 0;
			while(itr.hasNext()){
				if(i == 0){
					//findOneLevel()η̤ˤϿƥեƥϴޤޤʤΤɲä
					if(i == 0 && parentFacilityId != null && parentFacilityId.compareTo("") != 0){
						if(map.get(parentFacilityId) == null){
							map.put(parentFacilityId, "1");
							
							list.add(parentFacilityId);
						}
					}
					i++;
				}
				
				FacilityTreeLocal ft = (FacilityTreeLocal)itr.next();
				
				if(map.get(ft.getFacilityId()) == null){
					map.put(ft.getFacilityId(), "1");
					
					list.add(ft.getFacilityId());
				}
			}
			
			//Ȥ
			if(sort){
				ListSorter sorter = new ListSorter();
				sorter.sort(list);
			}
		} catch (FinderException e) {
			throw e;
		} catch (NamingException e) {
			throw e;
		}
		
		return list;
	}
	
	/**
	 * եƥIDꥹȼ
	 * 
	 * եƥIDȤ֤
	 * 
	 * @param parentFacilityId
	 * @param level
	 * @return
	 * @throws FinderException
	 * @throws NamingException
	 */
	public ArrayList getNodeFacilityIdList(String parentFacilityId, int level, boolean sort) throws FinderException, NamingException {
		ArrayList list = null;
		try {
			Collection ct = null;
			if(level == RepositoryControllerBean.ALL){
				//FacilityTreeκǾ̥ȥ
				ct = FacilityTreeUtil.getLocalHome().findAllNode(parentFacilityId);
			}
			else{
				//FacilityTreeκǾ̥ȥ
				ct = FacilityTreeUtil.getLocalHome().findOneLevelNode(parentFacilityId);
			}
			
			HashMap map = new HashMap();
			list = new ArrayList();
			Iterator itr = ct.iterator();
			while(itr.hasNext()){
				FacilityTreeLocal ft = (FacilityTreeLocal)itr.next();
				
				if(map.get(ft.getFacilityId()) == null){
					map.put(ft.getFacilityId(), "1");
					
					list.add(ft.getFacilityId());
				}
			}
			
			//Ȥ
			if(sort){
				ListSorter sorter = new ListSorter();
				sorter.sort(list);
			}
		} catch (FinderException e) {
			throw e;
		} catch (NamingException e) {
			throw e;
		}
		
		return list;
	}
	
	/**
	 * եƥIDꥹȼ
	 * 
	 * եƥIDȤ֤
	 * 
	 * @return
	 * @throws FinderException
	 * @throws NamingException
	 */
	public ArrayList getNodeFacilityIdList(boolean sort) throws FinderException, NamingException {
		ArrayList list = null;
		try {
			//FacilityκǾ̥ȥ
			Collection ct = FacilityUtil.getLocalHome().findAllNode();
			
			list = new ArrayList();
			Iterator itr = ct.iterator();
			while(itr.hasNext()){
				FacilityLocal ft = (FacilityLocal)itr.next();
				list.add(ft.getFacilityId());
			}
			
			//Ȥ
			if(sort){
				ListSorter sorter = new ListSorter();
				sorter.sort(list);
			}
		} catch (FinderException e) {
			throw e;
		} catch (NamingException e) {
			throw e;
		}
		
		return list;
	}
	
	/**
	 * װ
	 * 
	 * ֥Ȥ2Ȥ֤
	 * 
	 * @param parentFacilityId
	 * @return
	 * @throws FinderException
	 * @throws NamingException
	 */
	public ArrayList getScopeList(String parentFacilityId) throws FinderException, NamingException {
		ArrayList list = null;
		try {
			//FacilityTreeκǾ̥ȥ
			Collection ct = FacilityTreeUtil.getLocalHome().findOneLevel(parentFacilityId);
			
			list = new ArrayList();
			Iterator itr = ct.iterator();
			while(itr.hasNext()){
				FacilityTreeLocal ft = (FacilityTreeLocal)itr.next();
				FacilityLocal facility = ft.getFacility();
				ArrayList info = new ArrayList();
				info.add(facility.getFacilityId());
				info.add(facility.getCn());
				info.add(facility.getDescription());
				list.add(info);
			}
		} catch (FinderException e) {
			throw e;
		} catch (NamingException e) {
			throw e;
		}
		
		return list;
	}
	
	/**
	 * Facility
	 * 
	 * @param facilityId
	 * @return
	 * @throws FinderException
	 * @throws NamingException
	 */
	public FacilityLocal getFacility(String facilityId) throws FinderException, NamingException {
		FacilityLocal facility = null;
		try {
			//Facility
			facility = FacilityUtil.getLocalHome().findByFacilityId(facilityId);
		} catch (FinderException e) {
			throw e;
		} catch (NamingException e) {
			throw e;
		}
		
		return facility;
	}
	
	/**
	 * ΡɤƤװ
	 * 
	 * @param facilityId
	 * @param level
	 * @return
	 * @throws FinderException
	 * @throws NamingException
	 */
	public ArrayList getNodeScopeList(String facilityId) throws FinderException, NamingException {
		ArrayList list = null;
		try {
			//FacilityTreeκǾ̥ȥ
			Collection ct = FacilityTreeUtil.getLocalHome().findByFacilityId(facilityId);
			FacilityTreeItem item = this.getFacilityTree(Locale.getDefault());
			
			list = new ArrayList();
			Iterator itr = ct.iterator();
			while(itr.hasNext()){
				FacilityTreeLocal ft = (FacilityTreeLocal)itr.next();
				String dn[] = ft.getDn().split(",");
				StringBuffer path = new StringBuffer();
				for(int i = 1; i < dn.length - 1; i++){
					String id = dn[i].replaceFirst("[\\s\\w]*=", "");
					FacilityLocal facility = FacilityUtil.getLocalHome().findByFacilityId(id);
					if(facility.getType() == FacilityConstant.TYPE_SCOPE){
						path.insert(0, SEPARATOR);
					}
					path.insert(0, facility.getCn());
				}
				ArrayList info = new ArrayList();
				info.add(path.toString());
				list.add(info);
			}
		} catch (FinderException e) {
			throw e;
		} catch (NamingException e) {
			throw e;
		}
		
		return list;
	}
	
	/**
	 * եƥĥ꡼ʥΡɴޤ
	 * 
	 * @param locale
	 * @return
	 * @throws FinderException
	 * @throws NamingException
	 */
	public FacilityTreeItem getFacilityTree(Locale locale) throws FinderException, NamingException {
		
		//FacilityTreeκǾ̥󥹥󥹤
		FacilityInfo info = new FacilityInfo();
		info.setFacilityName(FacilityConstant.STRING_COMPOSITE);
		info.setType(FacilityConstant.TYPE_COMPOSITE);
		FacilityTreeItem tree = new FacilityTreeItem(null, info);
		
		// ݥåȥƥ֤ޤ
		info = new FacilityInfo();
		info.setFacilityName(Messages.getString("scope", locale));
		info.setType(FacilityConstant.TYPE_COMPOSITE);
		FacilityTreeItem item = new FacilityTreeItem(tree, info);
		
		try {
			//FacilityTreeκǾ̥ȥ
			Collection ct = FacilityTreeUtil.getLocalHome().findOneLevel();
			
			Iterator itr = ct.iterator();
			while(itr.hasNext()){
				FacilityTreeLocal ft = (FacilityTreeLocal)itr.next();
				createFacilityTree(ft, item);
			}
		} catch (FinderException e) {
			throw e;
		} catch (NamingException e) {
			throw e;
		}
		
		return tree;
	}
	
	/**
	 * եƥĥ꡼ʥפΤߡ
	 * 
	 * @param locale
	 * @return
	 * @throws FinderException
	 * @throws NamingException
	 */
	public FacilityTreeItem getScopeFacilityTree(Locale locale) throws FinderException, NamingException {
		
		//FacilityTreeκǾ̥󥹥󥹤
		FacilityInfo info = new FacilityInfo();
		info.setFacilityName(FacilityConstant.STRING_COMPOSITE);
		info.setType(FacilityConstant.TYPE_COMPOSITE);
		FacilityTreeItem tree = new FacilityTreeItem(null, info);
		
		// ݥåȥƥ֤ޤ
		info = new FacilityInfo();
		info.setFacilityName(Messages.getString("scope", locale));
		info.setType(FacilityConstant.TYPE_COMPOSITE);
		FacilityTreeItem item = new FacilityTreeItem(tree, info);
		
		try {
			//FacilityTreeκǾ̥ȥ
			Collection ct = FacilityTreeUtil.getLocalHome().findOneLevelScope(null);
			
			Iterator itr = ct.iterator();
			while(itr.hasNext()){
				FacilityTreeLocal ft = (FacilityTreeLocal)itr.next();
				createScopeFacilityTree(ft, item);
			}
		} catch (FinderException e) {
			throw e;
		} catch (NamingException e) {
			throw e;
		}
		
		return tree;
	}
	
	/**
	 * FacilityTreeItemʥΡɴޤ
	 * 
	 * @param facilityTree
	 * @param parent
	 */
	protected void createFacilityTree(FacilityTreeLocal facilityTree, FacilityTreeItem parent) {
		FacilityLocal facility = null;
		try {
			facility = facilityTree.getFacility();
		} catch (FinderException e) {
			return;
		}
		
		FacilityInfo info = null;
		FacilityTreeItem item = null;
		if(facility != null){
			info = new FacilityInfo();
			info.setFacilityId(facility.getFacilityId());
			info.setFacilityName(facility.getCn());
			if(facility.getType() == FacilityConstant.TYPE_NODE){
				info.setType(FacilityConstant.TYPE_NODE);
			}
			else{
				info.setType(FacilityConstant.TYPE_SCOPE);
			}
			item = new FacilityTreeItem(parent, info);
		}
		
		Collection collection = null;
		try {
			collection = facilityTree.getChildren();
		} catch (FinderException e) {
		}
		
		if(collection != null && collection.size() > 0){
			Iterator itr = collection.iterator();
			while(itr.hasNext()){
				FacilityTreeLocal children = (FacilityTreeLocal)itr.next();
				createFacilityTree(children, item);
			}
		}
	}
	
	/**
	 * FacilityTreeItemʥפΤߡ
	 * 
	 * @param facilityTree
	 * @param parent
	 */
	protected void createScopeFacilityTree(FacilityTreeLocal facilityTree, FacilityTreeItem parent) {
		FacilityLocal facility = null;
		try {
			facility = facilityTree.getFacility();
		} catch (FinderException e) {
			return;
		}
		
		FacilityInfo info = null;
		FacilityTreeItem item = null;
		if(facility != null){
			info = new FacilityInfo();
			info.setFacilityId(facility.getFacilityId());
			info.setFacilityName(facility.getCn());
			if(facility.getType() == FacilityConstant.TYPE_SCOPE){
				info.setType(FacilityConstant.TYPE_SCOPE);
				item = new FacilityTreeItem(parent, info);
			}
			else{
				return;
			}
		}
		
		Collection collection = null;
		try {
			collection = facilityTree.getChildren();
		} catch (FinderException e) {
		}
		
		if(collection != null && collection.size() > 0){
			Iterator itr = collection.iterator();
			while(itr.hasNext()){
				FacilityTreeLocal children = (FacilityTreeLocal)itr.next();
				createScopeFacilityTree(children, item);
			}
		}
	}
	
	/**
	 * եƥѥ
	 * 
	 * եƥΥѥ֤
	 * 
	 * @param facilityId
	 * @return
	 * @throws FinderException
	 * @throws NamingException
	 */
	public String getFacilityPath(String facilityId, String parentFacilityId) throws FinderException, NamingException {
		try {
			Collection ct = FacilityTreeUtil.getLocalHome().findByFacilityId(facilityId);
			
			if(ct != null){
				FacilityTreeLocal tree = null;
				Iterator itr = ct.iterator();
				if(itr.hasNext()){
					tree = (FacilityTreeLocal)itr.next();
				}
				
				if(tree != null){
					StringBuffer buffer = new StringBuffer();
					if (tree.getTreeType().intValue() == FacilityConstant.TYPE_SCOPE) {
						//פΥѥ
						if(parentFacilityId != null && parentFacilityId.length() > 0){
							//Хѥ
							FacilityTreeLocal parentTree = tree;
							while (parentTree != null) {
								FacilityLocal parent = parentTree.getFacility();
								if(parentFacilityId.compareTo(parent.getFacilityId()) == 0){
									if(buffer.length() == 0){
										buffer.insert(0, SEPARATOR);
									}
									break;
								}
								buffer.insert(0, SEPARATOR);
								buffer.insert(0, parent.getCn());
								parentTree = parentTree.getParent();
							}
						}
						else{
							//Хѥ
							FacilityTreeLocal parentTree = tree;
							while (parentTree != null) {
								FacilityLocal parent = parentTree.getFacility();
								buffer.insert(0, SEPARATOR);
								buffer.insert(0, parent.getCn());
								parentTree = parentTree.getParent();
							}
						}
					}
					else{
						//Ρɤξ硢Ρ̾
						FacilityLocal facility = tree.getFacility();
						buffer.append(facility.getCn());
					}
					
					return buffer.toString();
				}
			}
		} catch (FinderException e) {
			throw e;
		} catch (NamingException e) {
			throw e;
		}
		
		return "";
	}
	
	/**
	 * եƥIDꥹȼ
	 * 
	 * եƥIDȤ֤
	 * 
	 * @param hostName
	 * @param ipAddress
	 * @return
	 * @throws FinderException
	 * @throws NamingException
	 */
	public ArrayList getFacilityIdList(String hostName, String ipAddress) throws FinderException, NamingException {
		ArrayList list = null;
		try {
			HashMap map = new HashMap();
			list = new ArrayList();
			
			//IPɥ쥹פFacility
			if(ipAddress != null && ipAddress.length() > 0){
				Collection ct = FacilityUtil.getLocalHome().findByIpAddress(ipAddress);
				Iterator itr = ct.iterator();
				while(itr.hasNext()){
					FacilityLocal facility = (FacilityLocal)itr.next();
					
					if(map.get(facility.getFacilityId()) == null){
						map.put(facility.getFacilityId(), "1");
						
						list.add(facility.getFacilityId());
					}
				}
			}
			
			//Ρ̾פFacility
			if(hostName != null && hostName.length() > 0){
				Collection ct = FacilityUtil.getLocalHome().findByNodeName(hostName);
				Iterator itr = ct.iterator();
				while(itr.hasNext()){
					FacilityLocal facility = (FacilityLocal)itr.next();
					
					if(map.get(facility.getFacilityId()) == null){
						map.put(facility.getFacilityId(), "1");
						
						list.add(facility.getFacilityId());
					}
				}
			}
		} catch (FinderException e) {
			throw e;
		} catch (NamingException e) {
			throw e;
		}
		
		return list;
	}
	
	/**
	 * Ρɥå
	 * 
	 * եƥIDΡɤå̤boolean֤
	 * 
	 * @param facilityId
	 * @return true:Ρ/false:
	 * @throws FinderException
	 * @throws NamingException
	 */
	public boolean isNode(String facilityId) throws FinderException, NamingException {
		boolean node = false;
		try {
			//FacilityTreeκǾ̥ȥ
			FacilityLocal facility = FacilityUtil.getLocalHome().findByFacilityId(facilityId);
			
			if(facility.getType() == FacilityConstant.TYPE_NODE){
				node = true;
			}
			
		} catch (FinderException e) {
			throw e;
		} catch (NamingException e) {
			throw e;
		}
		return node;
	}
}
