/*
                                                                                                
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.
 
*/

package com.clustercontrol.sharedtable.bean;

import java.util.HashMap;
import java.util.Set;

/**
 * ȥ֥ȤΥޥåԥ󥰤ݻ륯饹
 * 
 * @version 2.0.0
 * @since 2.0.0
 */
public class DataTable implements Cloneable {
	HashMap<String, ValueObject> m_hm;   // ֥ͥȤΥޥåԥ󥰤ݻޥå
	long m_lastReference = 0;	// ǽ	
	long m_lastReferenceInterval;  // ǽȤλȻȤκʬλ
	
	/**
	 * Υơ֥ޤ
	 */
	public DataTable(){
		m_hm = new HashMap<String, ValueObject>();
		m_lastReference = System.currentTimeMillis();
	}

	private DataTable(HashMap<String, ValueObject> hp, long lastReference){
		m_hm = hp;
	}
	
	/**
	 * ꤵ줿ͤȻꤵ줿򤳤Υơ֥˴Ϣդޤ
	 * 
	 * @param key ꤵͤϢդ륭
	 * @param date ꤵͤ˴Ϣդ
	 * @param value ꤵ륭˴Ϣդ
	 */
	synchronized public void putValue(String key, long date, Object value) {
		m_hm.put(key, new ValueObject(key, date, value));
	}

	/**
	 * ꤵ줿ơ֥뤫Ƥͤơ֥˥ԡޤ
	 * 
	 * @param table ǼͤΥåȤǼƤơ֥
	 */
	synchronized public void putValueAll(DataTable table) {
		m_hm.putAll(table.m_hm);
	}

	/**
	 * ơ֥ݻƤͤƺ
	 * ꤵ줿ơ֥Ƥͤ񤭴ޤ
	 * 
	 * @param table ǼͤΥåȤǼƤơ֥
	 */
	synchronized public void setValueAll(DataTable table) {
		m_hm.clear();
		m_hm.putAll(table.m_hm);
	}
	
	/**
	 * ꤵ줿˥ޥåפƤ֤ͤޤ
	 * 
	 * @param key Ϣդ줿֤ͤ륭
	 * @return ꤵ줿˥ޥåԥ󥰤Ƥ֥ͥȡ
	 *          ΥФ֥ͥơ֥ˤʤ null
	 */
	synchronized public ValueObject getValue(String key){
		ValueObject vo = (ValueObject)m_hm.get(key);
	
		// ǽ狼ηв֤򻻽
		long now = System.currentTimeMillis();
		m_lastReferenceInterval = now - m_lastReference;
		
		m_lastReference = now;  // 
		
		return vo;
	}
	
	/**
	 * ꤵ줿˥ޥåפƤͤޤ
	 * 
	 * @param key Ϣդ줿ͤΥ
	 * @return ꤵ줿˥ޥåԥ󥰤Ƥ֥ͥȡ
	 *          ΥФ֥ͥơ֥ˤʤ null
	 */
	synchronized public ValueObject removeValue(String key){
		return m_hm.remove(key);
	}

	/**
	 * ߤΥơ֥ʣʥơ֥֤ޤ
	 * 
	 * @return ߤΥơ֥ʣʥơ֥
	 */
	synchronized public DataTable getValueAll(){
		DataTable st = (DataTable)this.clone();
		
		// ǽ狼ηв֤򻻽
		long now = System.currentTimeMillis();
		m_lastReferenceInterval = now - m_lastReference;
		
		m_lastReference = System.currentTimeMillis();  // 
		return st;
	}
	
	// clone ᥽åɤ򥪡С饤
	protected Object clone(){
		DataTable st = new DataTable((HashMap)m_hm.clone(), this.m_lastReference);
		
		return st;
	}

	/**
	 * ǽȻ֤ޤ
	 * @return ǽȻ
	 */
	public long getLastReference() {
		return m_lastReference;
	}
	
	/**
	 * ǸλȤȤλȤޤǤλ֤֤
	 * @return ǸλȤȤλȤޤǤλ(ߥ)
	 */
	public long getLastReferenceInterval(){
		return m_lastReferenceInterval;
	}
	
	/**
	 * ΥåȤ֤ޤ
	 * @return Υå
	 */
	public Set keySet(){
		return this.m_hm.keySet();
	}
}
