/*
 
 Copyright (C) 2006 NTT DATA Corporation
 
 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License
 as published by the Free Software Foundation, version 2.
 
 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.
 
 */

package com.clustercontrol.snmppoller.bean;

import java.io.Serializable;
import java.net.InetAddress;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.snmppoller.SnmpConfig;

/**
 * ݡ󥰤ݻ륯饹
 * 
 * @version 2.0.0
 * @since 2.0.0
 */
public class PollingConfig implements Serializable {
	protected static Log m_log = LogFactory.getLog( PollingConfig.class ); 
	
	private static final String[] cronExpressionSet = { 
		"*/1 * * * * ? *",
		"*/5 * * * * ? *",
		"*/15 * * * * ? *",
		"*/30 * * * * ? *",
		"0 */1 * * * ? *",
		"0 */5 * * * ? *",
		"0 */15 * * * ? *",
		"0 */30 * * * ? *",
		"0 0 */1 * * ? *"
	};
	
	// ǽʥ󥿡Х
	private static final int[] intervalSet
	= {     1,     5,    15,    30,    60,   300,   900,  1800,  3600 };
	private boolean[] m_intervalFlug
	= { false, false, false, false, false, false, false, false, false };
	
	public static int parseInterval(String cronExpression){
		for(int i=0; i < cronExpressionSet.length; i++){
			if(cronExpressionSet[i].equals(cronExpression)){
				return intervalSet[i];
			}
		}
		
		// ǧƤʤֳ֤Ǥ
		return -1;
	}
	
	public static String parseCronExpression(int interval){
		for(int i=0; i < intervalSet.length; i++){
			if(intervalSet[i] == interval){
				return cronExpressionSet[i];
			}
		}
		
		// ǧƤʤֳ֤Ǥ
		return null;
	}
	
	// SNMPݡ󥰤Ԥ
	private SnmpConfig m_snmpConfig;
	
	// 󥹥ȥ饯
	public PollingConfig(
			InetAddress address, 
			int port,
			int version, 
			String community,
			int retries,
			int timeout){
		m_snmpConfig = new SnmpConfig(address);
		m_snmpConfig.setPort(port);
		m_snmpConfig.setVersion(version);
		m_snmpConfig.setComunity(community);
		m_snmpConfig.setRetries(retries);
		m_snmpConfig.setTimeout(timeout);
	}
	
	/**
	 * μֳ֤ɲäޤ
	 * @param interval
	 * @return ֳ֤ɲä뤳ȤǼֳ֤ѹtrue֤ޤ
	 */
	public boolean addInterval(int interval){
		// μֳ֤Υե饰򤿤Ƥ
		for(int i=intervalSet.length-1; i >= 0 ; i--){
			if(intervalSet[i] <= interval){
				// ¸Ĵ٤
				if(m_intervalFlug[i]){
					// ꤵƤΤǲ⤷ʤ
					return false;
				} else {
					// μֳ֤ɲäȤǺǾֳ֤Ѳ뤫Ĵ٤
					int minInterval = getMinInterval();
					if(minInterval == 0 || intervalSet[i] < minInterval){
						// μֳ֤򥪥ˤ
						m_intervalFlug[i] = true;
						// Ǿֳ֤ѹ뤿true֤
						return true;
					} else {
						// μֳ֤򥪥ˤ
						m_intervalFlug[i] = true;
						// Ǿֳ֤ѹʤfalse֤
						return false;
					}
				}
			}
		}
		return false;
	}
	
	/**
	 * Υ󥿡Хޤ
	 * @param interval
	 */
	public void removeInterval(int interval){
		for(int i=0; i < intervalSet.length; i++){
			if(intervalSet[i] == interval){
				m_intervalFlug[i] = false;
			}
		}
	}
	
	/**
	 * Ǿμֳ֤֤ޤ
	 * ֳ֤ҤȤĤꤵƤʤ0֤ޤ
	 * @return Ǿμֳ
	 */
	public int getMinInterval(){
		for(int i=0; i < m_intervalFlug.length; i++){
			if(m_intervalFlug[i]){
				return intervalSet[i];
			}
		}
		
		// ֳ֤ҤȤĤꤵƤʤ0֤
		return 0;
	}
	
	/**
	 * ǽʼֳ֤֤ޤ
	 * @return ǽʼֳ֤
	 */
	public static int[] getAvailableIntervals(){
		return intervalSet;
	}
	
	/**
	 * SNMPݡ󥰤֤ޤ
	 * @return SNMPݡ
	 */
	public SnmpConfig getSnmpConfig() {
		return m_snmpConfig;
	}
}
