/*
                                                                                                
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.
 
*/

package com.clustercontrol.snmppoller.job;

import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

import com.clustercontrol.snmppoller.SnmpSharedTable;
import com.clustercontrol.snmppoller.util.JNDIConnectionManager;

/**
 * ȤƤʤơ֥Ĵ٤륯饹
 * 
 * @version 2.0.0
 * @since 2.0.0
 */
public class CheckJob implements Job{
	protected static Log m_log = LogFactory.getLog( CheckJob.class );

	public void execute(JobExecutionContext context) throws JobExecutionException {
		// ޤ
		JobDataMap dataMap = context.getJobDetail().getJobDataMap();
		
		String jndiName    = dataMap.getString("jndiName");

		// ǥХå
		m_log.debug("Check Job Execute : " + jndiName);
		
		try {
			// ͳǼѥơ֥åå
			InitialContext iniCtx = JNDIConnectionManager.getInitialContext();
			
			Object obj = iniCtx.lookup(jndiName);
			
			SnmpSharedTable table = (SnmpSharedTable)PortableRemoteObject.narrow(obj, SnmpSharedTable.class);
			table.checkAll();
			
			// ݥȥƤIPɥ쥹򹹿
			table.refreshTable();
		} catch (NamingException e) {
			m_log.error(e);
		}
	}
}
