/*
                                                                                                
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.
 
*/

package com.clustercontrol.snmppoller.job;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.sharedtable.bean.DataTable;
import com.clustercontrol.snmppoller.FacilityNotFoundExciption;
import com.clustercontrol.snmppoller.SnmpConfig;
import com.clustercontrol.snmppoller.SnmpPoller;
import com.clustercontrol.snmppoller.SnmpSharedTable;
import com.clustercontrol.snmppoller.util.JNDIConnectionManager;

/**
 * SNMPݡ󥰤¹Ԥ륹åɤΥ饹
 * 
 * @version 2.0.0
 * @since 2.0.0
 */
public class PollingThread implements Runnable {
	protected static Log m_log = LogFactory.getLog( PollingThread.class );
	
	private SnmpPoller m_poller = new SnmpPoller();
	
	private SnmpConfig snmpConfig;
	private List oids;	

	private String tableJndiName;
	private String facilityId;
	
	public PollingThread(
			SnmpConfig snmpConfig, 
			List oids, 
			String tableJndiName, 
			String facilityId){
		this.snmpConfig = snmpConfig;
		this.oids = oids;
		this.tableJndiName = tableJndiName;
		this.facilityId = facilityId;
	}
	
	public void run() {
		// ǥХå
		m_log.debug("run start : " + tableJndiName + "  " + facilityId);
		
		// ݡ󥰤Ԥͤ
		DataTable dataTable = new DataTable();
		m_poller.polling(
				snmpConfig.getAddress(), 
				snmpConfig.getPort(),
				snmpConfig.getVersion(),
				snmpConfig.getComunity(),
				snmpConfig.getRetries(),
				snmpConfig.getTimeout(),
				oids, 
				dataTable);
		
		// ͳǼѥơ֥åå
		try {
//			iniCtx = new InitialContext();
			InitialContext iniCtx = JNDIConnectionManager.getInitialContext();

			Object obj = iniCtx.lookup(tableJndiName);			
			SnmpSharedTable table = 
				(SnmpSharedTable)PortableRemoteObject.narrow(obj, SnmpSharedTable.class);

			// ǥơ֥񤭴
			// ͤƺ
			table.setValueAll(facilityId, dataTable);
		} catch (NamingException e) {
			m_log.error(e);
		} catch (FacilityNotFoundExciption e) {
			m_log.error(e);
		}
		
		// ǥХå
		m_log.debug("run end   : " + tableJndiName + "  " + facilityId);
	}

	public SnmpConfig getSnmpConfig() {
		return snmpConfig;
	}

	public void setSnmpConfig(SnmpConfig snmpConfig) {
		this.snmpConfig = snmpConfig;
	}
	
	/**
	 * @param args
	 */
	public static void main(String[] args) {
		HashMap hm = new HashMap();
		
		Iterator itr = hm.keySet().iterator();
		
		while(itr.hasNext()){
			String facilityId = (String)itr.next();
			SnmpConfig config = (SnmpConfig)hm.get(facilityId);
			
			PollingThread pt = new PollingThread(
					config,
					null,
					"table",
					facilityId
			);
			Thread th = new Thread(pt);
			th.start();
		}
	}
}
