/*
                                                                                                
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.
 
*/

package com.clustercontrol.snmppoller.job;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

import com.clustercontrol.snmppoller.SnmpSharedTable;
import com.clustercontrol.snmppoller.bean.PollingConfig;
import com.clustercontrol.snmppoller.util.JNDIConnectionManager;

/**
 * SNMPݡ󥰤¹Ԥ른֥饹
 * 
 * @version 2.0.0
 * @since 2.0.0
 */
public class SnmpPollingJob implements Job {
	protected static Log m_log = LogFactory.getLog( SnmpPollingJob.class );

	public void execute(JobExecutionContext context) throws JobExecutionException {
		// ǥХå
		m_log.debug("execute start : ");
		
		// ޤ
		JobDataMap dataMap = context.getJobDetail().getJobDataMap();

		// ͳǼѥơ֥򻲾Ȥ뤿JNDI̾
		String jndiName = dataMap.getString("jndiName");

		// ֳ֤
		int interval = dataMap.getInt("interval");
		
		// оݤOIDΥꥹ
		List oids = (List)dataMap.get("oidList");

		// ݡ󥰤
		HashMap snmpConfMap = (HashMap)dataMap.get("snmpConfMap");
		
		/* ߤ٤ݡ󥰤ʤåޤ(ߤ٤Τߤޤ) */
		// ͳǼѥơ֥åå
		try {
			InitialContext iniCtx = JNDIConnectionManager.getInitialContext();
			
			Object obj = iniCtx.lookup(jndiName);
			
			SnmpSharedTable table = 
				(SnmpSharedTable)PortableRemoteObject.narrow(obj, SnmpSharedTable.class);

			// եƥIDΥꥹȤ
			Iterator itr = snmpConfMap.keySet().iterator();
			while(itr.hasNext()){
				String facilityId = (String)itr.next();
				// ݡ󥰴ֳ֤ꤹ(ӥ¦ξ󤬼ƤDBξ)
				table.setPollingInterval(facilityId, interval);
			}
			
			// ƤΥեƥΥݡ󥰥塼å
			table.checkAll();

			// եƥIDΥꥹȤ
			itr = snmpConfMap.keySet().iterator();
			while(itr.hasNext()){
				String facilityId = (String)itr.next();
				PollingConfig pConfig = table.getConfig(facilityId);
				if(pConfig == null){
					// ⤷ʤ
					// ǤΥåǻȤƤʤơ֥뤬줿ˤ̤
				} else {
					// åɤ򤿤Ƥƥݡ󥰤¹Ԥ
					PollingThread pt = new PollingThread(
							pConfig.getSnmpConfig(),
							oids,
							jndiName,
							facilityId
					);
					Thread th = new Thread(pt);
					// åɤǡ󥹥åɤȤƵư
					th.start();
				}
			}
			
		} catch (NamingException e) {
			m_log.error(e);
		}
		
		// ǥХå
		m_log.debug("execute end   : " + jndiName);
	}
}
