/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.snmptrap.action;

import com.clustercontrol.bean.PriorityConstant;
import com.clustercontrol.bean.Property;
import com.clustercontrol.bean.PropertyConstant;
import com.clustercontrol.util.Messages;

/**
 * OID󹹿ѥץѥƥ饹
 * 
 * @version 2.1.0
 * @since 2.1.0
 */
public class GetSnmpTrapModifyProperty {
    /** MIB */
    public static final String ID_MIB = "mib";

    /** ȥå̾ */
    public static final String ID_TRAP_NAME = "trapName";

    /** ȥåOID */
    public static final String ID_TRAP_OID = "trapOid";

    /** generic_id */
    public static final String ID_GENERIC_ID = "genericId";
    
    /** specific_id */
    public static final String ID_SPRCIFIC_ID = "specificId";
    
    /** ͭ/̵ */
    public static final String ID_VALID = "valid";
    
    /**  */
    public static final String ID_PRIORITY = "priority";
    
    /** å */
    public static final String ID_LOGMSG = "logmsg";
    
    /** ܺ٥å */
    public static final String ID_DESCR = "descr";
    
    /**
     * OID󹹿ѥץѥƥ֤ޤ
     * 
     * @param local
     * @return OID󹹿ѥץѥƥ
     */
    @SuppressWarnings("unchecked")
	public Property getProperty() {

        //ץѥƥ
        Property mib = new Property(ID_MIB, Messages.getString("mib"), 
        		PropertyConstant.EDITOR_TEXT);
        Property trapName = new Property(ID_TRAP_NAME, Messages.getString("trap.name"), 
        		PropertyConstant.EDITOR_TEXT);
        Property trapOid = new Property(ID_TRAP_OID, Messages.getString("oid"), 
        		PropertyConstant.EDITOR_TEXT);
        Property genericId = new Property(ID_GENERIC_ID, Messages.getString("generic.id"), 
        		PropertyConstant.EDITOR_TEXT);
        Property specificId = new Property(ID_SPRCIFIC_ID, Messages.getString("specific.id"), 
        		PropertyConstant.EDITOR_TEXT);
        Property valid = new Property(ID_VALID, Messages.getString("valid") + "/" + Messages.getString("invalid"), 
        		PropertyConstant.EDITOR_BOOL);
        Property priority = new Property(ID_PRIORITY, Messages.getString("priority"), 
        		PropertyConstant.EDITOR_SELECT);
        Property logmsg = new Property(ID_LOGMSG, Messages.getString("message"), 
        		PropertyConstant.EDITOR_TEXTAREA);
        Property descr = new Property(ID_DESCR, Messages.getString("detail") + Messages.getString("message"), 
        		PropertyConstant.EDITOR_TEXTAREA);
        
		//ͤ
        
		Object priorityValues[][] = { 
				{ PriorityConstant.STRING_CRITICAL, PriorityConstant.STRING_WARNING, PriorityConstant.STRING_INFO, PriorityConstant.STRING_UNKNOWN}, 
				{ PriorityConstant.STRING_CRITICAL, PriorityConstant.STRING_WARNING, PriorityConstant.STRING_INFO, PriorityConstant.STRING_UNKNOWN}};
				
		priority.setSelectValues(priorityValues);
		priority.setValue(PriorityConstant.STRING_CRITICAL);

        //ͤ
		mib.setValue("");
		trapName.setValue("");
		trapOid.setValue("");
		genericId.setValue("");
		specificId.setValue("");
		valid.setValue(new Boolean(true));
		logmsg.setValue("");
		descr.setValue("");
		
        //ѹβ/ԲĤ
		mib.setModify(PropertyConstant.MODIFY_NG);
		trapName.setModify(PropertyConstant.MODIFY_NG);
		trapOid.setModify(PropertyConstant.MODIFY_NG);
		genericId.setModify(PropertyConstant.MODIFY_NG);
		specificId.setModify(PropertyConstant.MODIFY_NG);
		valid.setModify(PropertyConstant.MODIFY_OK);
		priority.setModify(PropertyConstant.MODIFY_OK);
		logmsg.setModify(PropertyConstant.MODIFY_OK);
		descr.setModify(PropertyConstant.MODIFY_OK);
		
        Property property = new Property(null, null, null);

        // ɽĥ꡼
        property.removeChildren();
        property.addChildren(mib);
        property.addChildren(trapName);
        property.addChildren(trapOid);
        property.addChildren(genericId);
        property.addChildren(specificId);
        property.addChildren(valid);
        property.addChildren(priority);
        property.addChildren(logmsg);
        property.addChildren(descr);
        
        return property;
    }
}