/*
 
 Copyright (C) 2006 NTT DATA Corporation
 
 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License 
 as published by the Free Software Foundation, version 2.
 
 This program is distributed in the hope that it will be
 useful, but WITHOUT ANY WARRANTY; without even the implied 
 warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 PURPOSE.  See the GNU General Public License for more details.
 
 */

package com.clustercontrol.snmptrap.bean;

import java.io.Serializable;
import java.util.ArrayList;

/**
 * SNMPTRAPƻ󥯥饹
 *
 * @version 2.1.0
 * @since 2.1.0
 */
public class SnmpTrapFacilityInfo implements Serializable {
	
	private static final long serialVersionUID = 8865430590959491257L;
	
	String m_monitorId;
	String m_facilityId;
	String m_communityName;
	ArrayList<String> m_facilityIdList;
	ArrayList<SnmpTrapOidInfo> m_oidList;
	
	public SnmpTrapFacilityInfo() {
	}
	
	public SnmpTrapFacilityInfo(String monitorId, String facilityId, String communityName, ArrayList<String> facilityIdList, ArrayList<SnmpTrapOidInfo> oidList) {
		this.m_monitorId = monitorId;
		this.m_facilityId = facilityId;
		this.m_communityName = communityName;
		this.m_facilityIdList = facilityIdList;
		this.m_oidList = oidList;
	}
	
	public String getCommunityName() {
		return m_communityName;
	}
	
	public void setCommunityName(String communityName) {
		this.m_communityName = communityName;
	}
	
	public String getFacilityId() {
		return m_facilityId;
	}
	
	public void setFacilityId(String id) {
		m_facilityId = id;
	}
	
	public ArrayList<String> getFacilityIdList() {
		return m_facilityIdList;
	}
	
	public void setFacilityIdList(ArrayList<String> facilityIdList) {
		this.m_facilityIdList = facilityIdList;
	}
	
	public String getMonitorId() {
		return m_monitorId;
	}
	
	public void setMonitorId(String monitorId) {
		this.m_monitorId = monitorId;
	}
	
	public ArrayList<SnmpTrapOidInfo> getOidList() {
		return m_oidList;
	}
	
	public void setOidList(ArrayList<SnmpTrapOidInfo> oidList) {
		this.m_oidList = oidList;
	}
}
