/*
 
 Copyright (C) 2006 NTT DATA Corporation
 
 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License 
 as published by the Free Software Foundation, version 2.
 
 This program is distributed in the hope that it will be
 useful, but WITHOUT ANY WARRANTY; without even the implied 
 warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 PURPOSE.  See the GNU General Public License for more details.
 
 */
package com.clustercontrol.snmptrap.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;

import javax.ejb.CreateException;
import javax.ejb.DuplicateKeyException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.snmptrap.ejb.entity.SnmpTrapMasterBean;
import com.clustercontrol.snmptrap.ejb.entity.SnmpTrapMasterPK;
import com.clustercontrol.snmptrap.util.ConnectionManager;

/**
 * Entity Bean SnmpTrapMaster DAO饹
 * 
 * @version 2.1.0
 * @since 2.1.0
 */
public class SnmpTrapMasterDAOImpl implements SnmpTrapMasterDAO {
	
	protected static Log m_log = LogFactory.getLog(SnmpTrapMasterDAOImpl.class);
	
	public void init() {
	}
	
	/* (non Javadoc)
	 * @see com.clustercontrol.snmptrap.dao.SnmpTrapMasterDAO#load(com.clustercontrol.snmptrap.ejb.entity.SnmpTrapMasterPK, com.clustercontrol.snmptrap.ejb.entity.SnmpTrapMasterBean)
	 */
	public void load(SnmpTrapMasterPK pk, SnmpTrapMasterBean ejb) throws EJBException {
		m_log.debug("load() start : " + pk.toString());
		
		Connection conn = null;
		PreparedStatement stmt = null;
		ResultSet res = null;
		
		try {
			conn = ConnectionManager.getConnectionManager().getConnection();
			
			// SQLʸ
			String sql = "SELECT * FROM cc_snmp_trap_mst WHERE mib = ? AND trap_oid = ? AND generic_id = ? AND specific_id = ?";
			//SQLʸΥå
			stmt = conn.prepareStatement(sql);
			
			stmt.setString(1, pk.mib);
			stmt.setString(2, pk.trapOid);
			stmt.setInt(3, pk.genericId);
			stmt.setInt(4, pk.specificId);
			
			res = stmt.executeQuery();
			
			if (res.next()) {
				//ͤBean˥å
				ejb.setMib(res.getString("mib"));
				ejb.setTrapOid(res.getString("trap_oid"));
				ejb.setGenericId(res.getInt("generic_id"));
				ejb.setSpecificId(res.getInt("specific_id"));
				ejb.setUei(res.getString("uei"));
				ejb.setPriority(res.getInt("priority"));
				ejb.setLogmsg(res.getString("logmsg"));
				ejb.setDescr(res.getString("descr"));
				
			} else {
				String msg = "SnmpTrapMaster data is not found.";
				m_log.error("load() error : " + pk.toString() + " SQLException " + msg);
				throw new EJBException(msg);
			}
		} catch (SQLException e) {
			m_log.error("load() error : " + pk.toString() + " SQLException");
			throw new EJBException(e.getMessage());
		} finally {
			// ͥ󡢷̥åȡץڥɥơȥȤΥ
			try {
				if (stmt != null) {
					stmt.close();
				}
				if (res != null) {
					res.close();
				}
				if (conn != null) {
					conn.close();
				}
			} catch (SQLException e1) {
				m_log.error("load() error : " + pk.toString() + " SQLException " + e1.getMessage());
				throw new EJBException(e1.getMessage());
			}
		}
		m_log.debug("load() end : " + pk.toString());
	}
	
	/* ( Javadoc)
	 * @see com.clustercontrol.snmptrap.dao.SnmpTrapMasterDAO#store(com.clustercontrol.snmptrap.ejb.entity.SnmpTrapMasterBean)
	 */
	public void store(SnmpTrapMasterBean ejb) throws EJBException {
		m_log.debug("store() start : " + ejb.getMib() + ", " + ejb.getTrapOid() + ", " + ejb.getGenericId() + ", " + ejb.getSpecificId());
		
		Connection conn = null;
		PreparedStatement stmt = null;
		
		try {
			conn = ConnectionManager.getConnectionManager().getConnection();
			//SQLʸ
			StringBuilder sql = new StringBuilder();
			sql.append("UPDATE cc_snmp_trap_mst SET ");
			sql.append("uei = ?, ");
			sql.append("priority = ?, ");
			sql.append("logmsg = ?, ");
			sql.append("descr = ?");
			sql.append("WHERE mib = ? AND ");
			sql.append("trap_oid = ? AND ");
			sql.append("generic_id = ? AND ");
			sql.append("specific_id = ?");
			
			//SQLʸΥå
			stmt = conn.prepareStatement(sql.toString());
			
			stmt.setString(1, ejb.getUei());
			stmt.setInt(2, ejb.getPriority());
			stmt.setString(3, ejb.getLogmsg());
			stmt.setString(4, ejb.getDescr());
			
			stmt.setString(5, ejb.getMib());
			stmt.setString(6, ejb.getTrapOid());
			stmt.setInt(7, ejb.getGenericId());
			stmt.setInt(8, ejb.getSpecificId());
			
			int row = stmt.executeUpdate();
			
			if (row != 1) {
				String msg = "result row is not 1";
				m_log.error("store() error : " + ejb.getMib() + ", "
						+ ejb.getTrapOid() + ", " + ejb.getGenericId() + ", "
						+ ejb.getSpecificId() + " SQLException" + msg);
				throw new EJBException(msg);
			}
		} catch (SQLException e) {
			m_log.error("store() error : " + ejb.getMib() + ", "
					+ ejb.getTrapOid() + ", " + ejb.getGenericId() + ", "
					+ ejb.getSpecificId() + " SQLException");
			e.printStackTrace();
			throw new EJBException(e.getMessage());
		} finally {
			// ͥ󡢷̥åȡץڥɥơȥȤΥ
			try {
				if (stmt != null) {
					stmt.close();
				}
				if (conn != null) {
					conn.close();
				}
			} catch (SQLException e1) {
				m_log.error("store() error : " + ejb.getMib() + ", "
						+ ejb.getTrapOid() + ", " + ejb.getGenericId() + ", "
						+ ejb.getSpecificId() + " SQLException");
				e1.printStackTrace();
				throw new EJBException(e1.getMessage());
			}
		}
		m_log.debug("store() end : " + ejb.getMib() + ", " + ejb.getTrapOid() + ", " + ejb.getGenericId() + ", " + ejb.getSpecificId());
	}
	
	/* ( Javadoc)
	 * @see com.clustercontrol.snmptrap.dao.SnmpTrapMasterDAO#remove(com.clustercontrol.snmptrap.ejb.entity.SnmpTrapMasterPK)
	 */
	public void remove(SnmpTrapMasterPK pk) throws RemoveException, EJBException {
		m_log.debug("remove() start : " + pk.toString());
		
		Connection conn = null;
		PreparedStatement stmt = null;
		try {
			conn = ConnectionManager.getConnectionManager().getConnection();
			
			//SQLʸ
			String sql = "DELETE FROM cc_snmp_trap_mst WHERE mib = ? AND trap_oid = ? AND generic_id = ? AND specific_id = ?";
			//SQLʸΥå
			stmt = conn.prepareStatement(sql);
			
			stmt.setString(1, pk.mib);
			stmt.setString(2, pk.trapOid);
			stmt.setInt(3, pk.genericId);
			stmt.setInt(4, pk.specificId);
			
			int row = stmt.executeUpdate();
			
			if (row != 1 ) {
				String msg = "result row is not 1";
				m_log.error("remove() error : " + pk.toString() + " SQLException" + msg);
				throw new EJBException(msg);	
			}
		} catch (SQLException e) {
			m_log.error("remove() error : " + pk.toString() + " SQLException");
			throw new EJBException(e.getMessage());
			
		} finally {
			try {
				if(stmt != null){
					stmt.close();
				}
				if(conn != null){
					conn.close();
				}
			} catch (SQLException e1) {
				m_log.error("remove() error : " + pk.toString() + " SQLException");
				throw new EJBException(e1.getMessage());
			}
		}
		m_log.debug("remove() end : " + pk.toString());
	}
	
	/* ( Javadoc)
	 * @see com.clustercontrol.snmptrap.dao.SnmpTrapMasterDAO#create(com.clustercontrol.snmptrap.ejb.entity.SnmpTrapMasterBean)
	 */
	public SnmpTrapMasterPK create(SnmpTrapMasterBean ejb) throws CreateException,
	EJBException {
		m_log.debug("create() start : " + ejb.getMib() + ", " + ejb.getTrapOid() + ", " + ejb.getGenericId() + ", " + ejb.getSpecificId());
		
		Connection conn = null;
		PreparedStatement stmt = null;
		SnmpTrapMasterPK pk;
		try {
			conn = ConnectionManager.getConnectionManager().getConnection();
			//SQLʸ
			StringBuilder sql = new StringBuilder();
			sql.append("INSERT INTO cc_snmp_trap_mst (");
			sql.append("mib, ");
			sql.append("trap_oid, ");
			sql.append("generic_id, ");
			sql.append("specific_id, ");
			sql.append("uei, ");
			sql.append("priority, ");
			sql.append("logmsg, ");
			sql.append("descr )");
			sql.append("values (?,?,?,?,?,?,?,?)");
			
			//SQLʸΥå
			stmt = conn.prepareStatement(sql.toString());
			
			stmt.setString(1, ejb.getMib());
			stmt.setString(2, ejb.getTrapOid());
			stmt.setInt(3, ejb.getGenericId());
			stmt.setInt(4, ejb.getSpecificId());
			stmt.setString(5, ejb.getUei());
			stmt.setInt(6, ejb.getPriority());
			stmt.setString(7, ejb.getLogmsg());
			stmt.setString(8, ejb.getDescr());
			
			int row =	stmt.executeUpdate();
			pk = new SnmpTrapMasterPK(
					ejb.getMib(),
					ejb.getTrapOid(),
					ejb.getGenericId(),
					ejb.getSpecificId()
			);
			
			if (row != 1) {
				String msg = "result row is not 1";
				m_log.error("create() error : " + ejb.getMib() + ", " + ejb.getTrapOid() + ", " + ejb.getGenericId() + ", " + ejb.getSpecificId() + " SQLException");
				throw new EJBException(msg);
			}
		} catch (SQLException e) {
			if(e.getSQLState().equals("23505")){
				m_log.error("create() error : " + ejb.getMib() + ", " + ejb.getTrapOid() + ", " + ejb.getGenericId() + ", " + ejb.getSpecificId() + " SQLException" + "DuplicateKeyException ");
				throw new DuplicateKeyException(e.getMessage());
			}
			throw new CreateException(e.getMessage());
		}finally{
			try {
				if(stmt != null){
					stmt.close();
				}
				if(conn != null){
					conn.close();
				}
			} catch (SQLException e1) {
				m_log.error("create() error : " + ejb.getMib() + ", " + ejb.getTrapOid() + ", " + ejb.getGenericId() + ", " + ejb.getSpecificId() + " SQLException");
				throw new EJBException(e1.getMessage());
			}
		}
		m_log.debug("create() end : " + ejb.getMib() + ", " + ejb.getTrapOid() + ", " + ejb.getGenericId() + ", " + ejb.getSpecificId());
		return pk;
	}
	
	/* ( Javadoc)
	 * @see com.clustercontrol.snmptrap.dao.SnmpTrapMasterDAO#findAll()
	 */
	public Collection findAll() throws FinderException {
		m_log.debug("findAll() start : ");
		
		ArrayList<SnmpTrapMasterPK> ret = new ArrayList<SnmpTrapMasterPK>();
		
		Connection conn = null;
		PreparedStatement stmt = null;
		ResultSet res = null;
		try {
			conn = ConnectionManager.getConnectionManager().getConnection();	
			//SQLʸ
			String sql = "SELECT * FROM cc_snmp_trap_mst";
			//SQLʸΥå
			stmt = conn.prepareStatement(sql);
			res = stmt.executeQuery();
			
			while(res.next()) {
				SnmpTrapMasterPK pk= new SnmpTrapMasterPK(
						res.getString("mib"),
						res.getString("trap_oid"),
						res.getInt("generic_id"),
						res.getInt("specific_id")
				);
				ret.add(pk);
			}
			
		} catch (SQLException e) {
			m_log.error("findAll() error :  SQLException");
			throw new EJBException(e.getMessage());
		}  finally{
			try {
				if(stmt != null){
					stmt.close();}
				if(res != null){
					res.close();}
				if(conn != null){
					conn.close();
				}
			} catch (SQLException e1) {
				m_log.error("findAll() error :  SQLException");
				throw new EJBException(e1.getMessage());
			}
		}
		m_log.debug("findAll() end : ");
		return ret;
	}
	
	/* ( Javadoc)
	 * @see com.clustercontrol.snmptrap.dao.SnmpTrapMasterDAO#findByPrimaryKey(com.clustercontrol.snmptrap.ejb.entity.SnmpTrapMasterPK)
	 */
	public SnmpTrapMasterPK findByPrimaryKey(SnmpTrapMasterPK pk) throws FinderException {
		m_log.debug("findByPrimaryKey() start : " + pk.toString());
		
		Connection conn = null;
		PreparedStatement stmt = null;
		ResultSet res = null;
		try {
			conn = ConnectionManager.getConnectionManager().getConnection();
			
			// SQLʸ
			String sql = "SELECT * FROM cc_snmp_trap_mst WHERE mib = ? AND trap_oid = ? AND generic_id = ? AND specific_id = ?";
			//SQLʸΥå
			stmt = conn.prepareStatement(sql);
			
			stmt.setString(1, pk.mib);
			stmt.setString(2, pk.trapOid);
			stmt.setInt(3, pk.genericId);
			stmt.setInt(4, pk.specificId);
			
			res = stmt.executeQuery();
			
			if (res.next()) {
				return pk;
			} else {
				String msg = "id " + pk.toString() + " not found.";
				throw new FinderException(msg);
			}
		} catch (SQLException e) {
			m_log.error("find() error : " + pk.toString() + " SQLException");
			throw new EJBException(e.getMessage());
		}  finally{
			try {
				if(stmt != null){
					stmt.close();}
				if(res != null){
					res.close();}
				if(conn != null){
					conn.close();
				}
			} catch (SQLException e1) {
				m_log.error("find() error : " + pk.toString() + " SQLException");
				throw new EJBException(e1.getMessage());
			}
			m_log.debug("findByPrimaryKey() end : " + pk.toString());
		}
	}
	
	/* ( Javadoc)
	 * @see com.clustercontrol.snmptrap.dao.SnmpTrapMasterDAO#findByMib(java.lang.String)
	 */
	public Collection findByMib(String mib) throws FinderException {
		m_log.debug("findByMib() start : " + mib);
		
		ArrayList<SnmpTrapMasterPK> ret = new ArrayList<SnmpTrapMasterPK>();
		
		Connection conn = null;
		PreparedStatement stmt = null;
		ResultSet res = null;
		try {
			conn = ConnectionManager.getConnectionManager().getConnection();
			
			//SQLʸ
			String sql = "SELECT * FROM cc_snmp_trap_mst WHERE mib = ? ORDER BY mib ASC";
			
			//SQLʸΥå
			stmt = conn.prepareStatement(sql);	
			stmt.setString(1, mib);
			
			res = stmt.executeQuery();
			while(res.next()) {
				SnmpTrapMasterPK pk= new SnmpTrapMasterPK(
						res.getString("mib"),
						res.getString("trap_oid"),
						res.getInt("generic_id"),
						res.getInt("specific_id")
				);
				ret.add(pk);
			}
			
		} catch (SQLException e) {
			m_log.error("findByMib() error : " + mib + " SQLException");
			throw new EJBException(e.getMessage());
		}  finally{
			try {
				if(stmt != null){
					stmt.close();}
				if(res != null){
					res.close();}
				if(conn != null){
					conn.close();
				}
			} catch (SQLException e1) {
				m_log.error("findByMib() error : " + mib + " SQLException");
				throw new EJBException(e1.getMessage());
			}
		}
		m_log.debug("findByMib() end : " + mib);
		return ret;
	}	
}
