/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.snmptrap.factory;

import java.sql.Timestamp;
import java.util.Date;

import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.jms.JMSException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.accesscontrol.factory.AccessLock;
import com.clustercontrol.snmptrap.bean.MonitorSnmpTrapInfo;
import com.clustercontrol.snmptrap.bean.MonitorSnmpTrapOidInfo;
import com.clustercontrol.snmptrap.bean.TopicConstant;
import com.clustercontrol.snmptrap.ejb.entity.SnmpTrapInfoUtil;
import com.clustercontrol.snmptrap.ejb.entity.SnmpTrapMasterLocal;
import com.clustercontrol.snmptrap.ejb.entity.SnmpTrapMasterPK;
import com.clustercontrol.snmptrap.ejb.entity.SnmpTrapMasterUtil;
import com.clustercontrol.snmptrap.ejb.entity.SnmpTrapOidInfoUtil;
import com.clustercontrol.snmptrap.message.UpdateSnmpTrapInfo;
import com.clustercontrol.snmptrap.util.SendTopic;
import com.clustercontrol.util.apllog.AplLogger;

/**
 * ƻϿ饹
 *
 * @version 2.1.0
 * @since 2.1.0
 */
public class AddMonitorInfo {
	
	protected static Log m_log = LogFactory.getLog( AddMonitorInfo.class );
	
	/** ƻӡ */
	protected MonitorSnmpTrapInfo m_monitorInfo;
	
	/**
	 * ƻϿ
	 * 
	 * @param info ƻ
	 * @param user 桼
	 * @return Ͽ硢true
	 * @throws CreateException
	 * @throws NotSupportedException
	 * @throws RollbackException
	 * @throws HeuristicMixedException
	 * @throws HeuristicRollbackException
	 * @throws SystemException
	 * @throws InvalidTransactionException
	 * @throws NamingException
	 * @throws FinderException 
	 */
	public boolean add(MonitorSnmpTrapInfo info, String user) throws CreateException, NotSupportedException, RollbackException, HeuristicMixedException, HeuristicRollbackException, SystemException, InvalidTransactionException, NamingException, FinderException {
		
    	//å
    	AccessLock.lock(AccessLock.MONITOR_SNMPTRAP);

		m_monitorInfo = info;
		
		TransactionManager tm = null;
		Transaction tx = null;
		Transaction oldTx = null;
		boolean result = false;
		
		try 
		{
			// TransactionManager
			InitialContext context = new InitialContext();
			tm = (TransactionManager)context.lookup("java:/TransactionManager");
			
			// ¹Υåɤȥ󥶥˴ϢդƤϡȥ󥶥 
			if(tm.getTransaction() != null){
				oldTx = tm.suspend();
			}
			
			try{
				// ȥ󥶥󳫻
				if(tm.getTransaction() == null){
					tm.begin();	
					tx = tm.getTransaction();
				}
				
				// ƻϿ
				result = addMonitorInfo(user);
				if(result){
					// ߥå
					tx.commit();
				}
				
				try {
					// 
					UpdateSnmpTrapInfo updateInfo = new UpdateSnmpTrapInfo(
							UpdateSnmpTrapInfo.TYPE_ADD,
							info.getMonitorId());
					
					SendTopic sendTopic = new SendTopic(TopicConstant.TOPIC_NAME_UPDATE);
					sendTopic.put(updateInfo);
					
				} catch (NamingException e) {
					m_log.error("add() : 顼" + e.getMessage() );
				} catch (JMSException e) {
					m_log.error("add() : 顼" + e.getMessage() );
				}
			
			} catch(NotSupportedException e){
				outputLog(e, "add()");
				throw e;
			} catch (RollbackException e) {
				outputLog(e, "add()");
				throw e;
			} catch (HeuristicMixedException e) {
				outputLog(e, "add()");
				throw e;
			} catch(HeuristicRollbackException e){
				outputLog(e, "add()");
				throw e;
			} catch(SystemException e){
				outputLog(e, "add()");
				throw e;
			}
			finally{
				// ȥ󥶥Ϣ㳰ȯϡХå
				if(tx != null){
					if(!result){
						tx.rollback();
					}
					tx = null;
				}
			}
		}
		finally{
			
			// ߤƤȥ󥶥Ƴ
			if(oldTx != null){
				try{
					tm.resume(oldTx);
				
				} catch(InvalidTransactionException e){
					outputLog(e, "add()");
					throw e;
				} catch(IllegalStateException e){
					outputLog(e, "add()");
					throw e;
				} catch(SystemException e){
					outputLog(e, "add()");
					throw e;
				}
			}
		}
		return result;
	}

	/**
	 * ƻϿ
	 * 
	 * @param user 桼
	 * @return Ͽ硢true
	 * @throws CreateException
	 * @throws NamingException
	 * @throws FinderException 
	 */
	public boolean addMonitorInfo(String user) throws CreateException, NamingException, FinderException {
		boolean result = false;
		
		try 
		{
			Timestamp now = new Timestamp(new Date().getTime());
			
			// ƻ
			SnmpTrapInfoUtil.getLocalHome().create(
					m_monitorInfo.getMonitorId(),
					m_monitorInfo.getDescription(),
					m_monitorInfo.getFacilityId(),
					m_monitorInfo.getCommunityName(),
					m_monitorInfo.getNotifyId(),
					m_monitorInfo.getApplication(),
					m_monitorInfo.getValid(),
					m_monitorInfo.getCalendarId(),
					now,
					now,
					user,
					user
			);
			
			if(m_monitorInfo.getOidInfos() != null){
				
				for(int i = 0; i < m_monitorInfo.getOidInfos().size(); i++){
					MonitorSnmpTrapOidInfo oidInfo = m_monitorInfo.getOidInfos().get(i);
					
					SnmpTrapMasterLocal master = 
						SnmpTrapMasterUtil.getLocalHome().findByPrimaryKey(
							new SnmpTrapMasterPK(
									oidInfo.getMib(), 
									oidInfo.getTrapOid(), 
									oidInfo.getGenericId(), 
									oidInfo.getSpecificId()));
					
					//ܺ٥åޥξܺ٥å
					String descr = new String();
					if(oidInfo.getDescr() != null && master.getDescr() != null && 
							!oidInfo.getDescr().equalsIgnoreCase(master.getDescr())){
						if(!oidInfo.getDescr().equalsIgnoreCase(master.getDescr())){
							descr = oidInfo.getDescr();
						}
					}
					else{
						descr = oidInfo.getDescr();
					}
					
					// ƻOID
					SnmpTrapOidInfoUtil.getLocalHome().create(
							oidInfo.getMonitorId(),
							oidInfo.getMib(),
							oidInfo.getTrapOid(),
							new Integer(oidInfo.getGenericId()),
							new Integer(oidInfo.getSpecificId()),
							new Integer(oidInfo.getValidFlg()),
							new Integer(oidInfo.getPriority()),
							oidInfo.getLogmsg(),
							descr
					);
				}
			}
				
			result = true;
			
		} catch (CreateException e) {
			outputLog(e, "addMonitorInfo()");
			throw e;
		} catch (NamingException e) {
			outputLog(e, "addMonitorInfo()");
			throw e;
		} catch (FinderException e) {
			outputLog(e, "addMonitorInfo()");
			throw e;
		}
		
		return result;
	}
	
	/**
     * ץꥱ˥
     * 
     * @param e 㳰
     */
	private void outputLog(Exception e, String method){
		AplLogger apllog = new AplLogger("TRAP", "trap");
		String[] args = {m_monitorInfo.getMonitorId() };
        apllog.put("SYS", "001", args);
        m_log.debug(method + ":" + e.getMessage());
	}
}
