/*
 
 Copyright (C) 2006 NTT DATA Corporation
 
 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License 
 as published by the Free Software Foundation, version 2.
 
 This program is distributed in the hope that it will be
 useful, but WITHOUT ANY WARRANTY; without even the implied 
 warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 PURPOSE.  See the GNU General Public License for more details.
 
 */

package com.clustercontrol.snmptrap.util;

import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;

import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;
import javax.jms.Session;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.jms.TopicSession;
import javax.jms.TopicSubscriber;
import javax.naming.InitialContext;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.repository.message.UpdateRepositoryInfo;
import com.clustercontrol.repository.bean.TopicConstant;
import com.clustercontrol.snmptrap.factory.TrapSnmpManager;
import com.clustercontrol.syslogng.message.UpdateMonitorRuleInfo;

/**
 * Topic饹
 * Topicؤ³ȡåμԤ
 * @version 2.1.0
 * @since 2.1.0
 * 
 */
public class ReceiveRepositoryTopic implements MessageListener, ExceptionListener {
	
	private static long RETRY_INTERVAL = 10000;
	
	private static final String TOPIC_CON_FACTORY = "ConnectionFactory";
	
	private TopicConnectionFactory m_factory;
	
	protected TopicConnection m_con;
	protected Topic m_topic;
	protected TopicSession m_session;
	protected TopicSubscriber m_subscriber;
	
	protected TrapSnmpManager m_manager;
	
	private boolean m_errFlg = false;
	
	/** åӥ³ѥޡ * */
	protected static Timer m_timer = new Timer(true);
	
	//
	static private Log log = LogFactory.getLog(ReceiveRepositoryTopic.class);
	
	/**
	 * 󥹥ȥ饯
	 * @param trapSnmpManager
	 */
	public ReceiveRepositoryTopic(TrapSnmpManager trapSnmpManager) {
		super();
		m_manager = trapSnmpManager;
		
		//³
		initial();
	}
	
	/* 
	 * ȥԥå
	 * (non-Javadoc)
	 * @see javax.jms.MessageListener#onMessage(javax.jms.Message)
	 */
	@SuppressWarnings("unchecked")
	public void onMessage(Message message) {
		if(message instanceof ObjectMessage){
			ObjectMessage objectMessage = (ObjectMessage)message;
			Object obj;
			try {
				obj = objectMessage.getObject();
			} catch (JMSException e) {
				log.error("onMessage()å ", e);
				return;
			}
			
			if(obj instanceof UpdateRepositoryInfo){
				log.debug("onMessage() get UpdateRepositoryInfo");
				
				UpdateRepositoryInfo info = (UpdateRepositoryInfo)obj;
				
				// å幹
				m_manager.updateCache(info);
			}else if(obj instanceof UpdateMonitorRuleInfo){
				log.debug("onMessage() get UpdateMonitorRuleInfo");
			}else{
				log.error("onMessage()å " + obj.toString());
			}
		}else{
			log.error("onMessage()å " + message.getClass());
		}
	}
	
	/* ̿顼ϥɥ
	 * (non-Javadoc)
	 * @see javax.jms.ExceptionListener#onException(javax.jms.JMSException)
	 */
	public void onException(JMSException arg0) {
		
		log.error(arg0);
		
		setErrFlg(true);
	}
	
	/**
	 * errFlg ꡣ
	 * 
	 * @param errFlg
	 */
	synchronized private void setErrFlg(boolean errFlg) {
		if (m_errFlg == false && errFlg == true) {
			
			m_timer.schedule(new ReSetupTask(), RETRY_INTERVAL, RETRY_INTERVAL);
			
		}
		m_errFlg = errFlg;
	}
	
	/**
	 *  
	 */
	synchronized private boolean reInitial() {
		
		boolean ret = false;
		
		log.info("³!");
		
		terminate();
		
		if (initial()) {
			
			ret = true;
			
			log.info("³:!");
			
			//顼ե饰
			setErrFlg(false);
			
			// å幹
			m_manager.updateCache();
			
		} else {
			log.info("³:!");
		}
		
		return ret;
	}
	/**
	 * ³νλ
	 *  
	 */
	public void terminate() {
		
		terminateSubscriber();
		
		
		try {
			if (m_session != null)
				m_session.close();
		} catch (JMSException e) {
		}
		
		try {
			if (m_con != null)
				m_con.close();
		} catch (JMSException e1) {
		}
	}
	/**
	 * ȥԥåνλ 
	 */
	private void terminateSubscriber() {
		try {
			if (m_subscriber != null)
				m_subscriber.close();
		} catch (JMSException e) {
		}
	}
	
	/**
	 * 
	 * JMSؤ³ȥԥåԤ
	 * @return
	 */
	private boolean initial() {
		
		log.info("EJB³");
		
		InitialContext context = null;
		
		try {
			//InitialContext
			String serverName = System.getProperty("jboss.server.name");
			if(serverName.equals("all")){
				Properties properties = new Properties(); 
				properties.put(InitialContext.INITIAL_CONTEXT_FACTORY,"org.jnp.interfaces.NamingContextFactory");
				properties.put(InitialContext.URL_PKG_PREFIXES,"org.jboss.naming:org.jnp.interfaces");
				properties.put(InitialContext.PROVIDER_URL,"jnp://localhost:1100");
				
				context = new InitialContext(properties);
			}
			else{
				context = new InitialContext();
			}
			
			//ͥեȥ
			m_factory = (TopicConnectionFactory) context.lookup(TOPIC_CON_FACTORY);
			
			//ͥ
			m_con = m_factory.createTopicConnection();
			
			//å
			m_session = m_con.createTopicSession(false,
					Session.AUTO_ACKNOWLEDGE);
			
			//åTopic
			m_topic = (Topic) context.lookup(TopicConstant.TOPIC_NAME_EXECUTE);
			
			//顼ϥɥ饻å
			m_con.setExceptionListener(this);
			
			m_con.start();
			
			//ȥԥå³
			initialTopic();
			
		} catch (Exception e) {
			log.error("initial", e);
			setErrFlg(true);
			return false;
		} finally {
			try {
				if (context != null)
					context.close();
			} catch (Exception e1) {
			}
		}
		return true;
		
	}
	
	/**
	 * ȥԥå
	 * @return
	 * @since
	 */
	private boolean initialTopic() {
		
		// ߤTopicλ
		terminateSubscriber();
		
		// ȥԥå
		try {
			m_subscriber = m_session.createSubscriber(m_topic);
			
			//ХåϿ
			m_subscriber.setMessageListener(this);
			
		} catch (Exception e) {
			log.error("initialTopic", e);
			setErrFlg(true);
			return false;
		} finally {
			
		}
		return true;
		
	}
	/**
	 * EJB³ޡ
	 * ̿顼ȤʤäǸƤФ³Ԥ 
	 */
	protected class ReSetupTask extends TimerTask {
		
		/**
		 * ͥ󥯥
		 */
		public void run() {
			if (reInitial()) {
				//Υ򥿥ޡ
				cancel();
			}
		}
	}
}
