/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.snmptrap.dialog;

import java.util.ArrayList;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

import com.clustercontrol.dialog.CommonDialog;
import com.clustercontrol.dialog.ValidateResult;
import com.clustercontrol.snmptrap.bean.MonitorSnmpTrapOidInfo;
import com.clustercontrol.snmptrap.bean.SnmpTrapMasterInfo;
import com.clustercontrol.snmptrap.composite.MasterListComposite;
import com.clustercontrol.util.Messages;

/**
 * SNMPTRAPƻ ޥ饹Ǥ
 * 
 * @version 2.1.0
 * @since 2.1.0
 */
public class SnmpTrapMasterDialog extends CommonDialog {
	
	public static final int WIDTH_TITLE = 5;
	public static final int WIDTH_VALUE = 2;
	
	// ----- instance ե ----- //
	
	/** ͤݻ륪֥ */
	private ArrayList<SnmpTrapMasterInfo> inputData = null;
	
	/** ͤݻ륪֥ */
	private ValidateResult validateResult = null;
	
	/** ޥơ֥ */
	private MasterListComposite masterListComposite = null;
	
    /** OID */
    private ArrayList<MonitorSnmpTrapOidInfo> oidList = null;
	
	// ----- 󥹥ȥ饯 ----- //
	
	/**
	 * ѥΥ󥹥󥹤֤ޤ
	 * 
	 * @param parent ƤΥ륪֥
	 * @param monitorType ƻȽ꥿
	 */
	public SnmpTrapMasterDialog(Shell parent) {
		super(parent);
		setShellStyle(getShellStyle() | SWT.RESIZE | SWT.MAX);
	}
	
	// ----- instance ᥽å ----- //
    
    /**
     * ν֤ޤ
     * 
     * @return 
     */
    protected Point getInitialSize() {
        return new Point(750, 400);
    }
	
	/**
	 * ꥢޤ
	 * 
	 * @param parent
	 *            ƤΥ󥹥
	 */
	protected void customizeDialog(Composite parent) {
		Shell shell = this.getShell();
		
		// ȥ
		shell.setText(Messages.getString("dialog.snmptrap.add.definition"));
		
		// ѿȤѤ륰åɥǡ
		GridData gridData = null;
		
		// 쥤
		GridLayout layout = new GridLayout(1, true);
		layout.marginWidth = 10;
		layout.marginHeight = 10;
		layout.numColumns = 15;
		parent.setLayout(layout);
		
		/*
		 * ޥơ֥
		 */
		this.masterListComposite = new MasterListComposite(parent, SWT.NONE);
		gridData = new GridData();
		gridData.horizontalSpan = 15;
		gridData.horizontalAlignment = GridData.FILL;
		gridData.verticalAlignment = GridData.FILL;
		gridData.grabExcessHorizontalSpace = true;
		gridData.grabExcessVerticalSpace = true;
		this.masterListComposite.setLayoutData(gridData);
		this.masterListComposite.setOidList(oidList);
		
		// 饤
		Label line = new Label(parent, SWT.SEPARATOR | SWT.HORIZONTAL);
		gridData = new GridData();
		gridData.horizontalAlignment = GridData.FILL;
		gridData.grabExcessHorizontalSpace = true;
		gridData.horizontalSpan = 15;
		line.setLayoutData(gridData);
		
		// 
		Display display = shell.getDisplay();
		shell.setLocation((display.getBounds().width - shell.getSize().x) / 2,
				(display.getBounds().height - shell.getSize().y) / 2);
		
		// ɽ
		this.setInputData();
		
	}
	
	/**
	 * Ƥ֤ޤ
	 * 
	 * @return Ƥݻξ
	 */
	public ArrayList<SnmpTrapMasterInfo> getInputData() {
		return this.inputData;
	}
	
	/**
	 * ƹܤͤꤷޤ
	 * 
	 * @param monitor
	 *            ͤȤѤƻ
	 */
	protected void setInputData() {
		
		masterListComposite.update();
		
	}
	
	/**
	 * ͥå򤷤ޤ
	 * 
	 * @return ڷ
	 */
	protected ValidateResult validate() {
		// 
		this.inputData = masterListComposite.getSelectMaster();
		
		if (this.inputData != null) {
			return super.validate();
		} else {
			return validateResult;
		}
	}
	
	/**
	 * ϣ˥ܥΥƥȤ֤ޤ
	 * 
	 * @return ϣ˥ܥΥƥ
	 */
	protected String getOkButtonText() {
		return Messages.getString("add");
	}
	
	/**
	 * 󥻥ܥΥƥȤ֤ޤ
	 * 
	 * @return 󥻥ܥΥƥ
	 */
	protected String getCancelButtonText() {
		return Messages.getString("cancel");
	}
	

	/**
	 * @return
	 */
	public ArrayList<MonitorSnmpTrapOidInfo> getOidList() {
		return oidList;
	}

	/**
	 * @param oidList
	 */
	public void setOidList(ArrayList<MonitorSnmpTrapOidInfo> oidList) {
		this.oidList = oidList;
	}
}