/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.sql.action;

import java.rmi.AccessException;
import java.rmi.RemoteException;
import java.text.ParseException;

import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.naming.NamingException;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;

import org.eclipse.jface.dialogs.MessageDialog;
import org.quartz.SchedulerException;

import com.clustercontrol.monitor.run.bean.MonitorInfo;
import com.clustercontrol.sql.ejb.session.MonitorSqlController;
import com.clustercontrol.sql.util.EjbConnectionManager;
import com.clustercontrol.util.Messages;

/**
 * SQLƻ򹹿륯饹Ǥ
 * 
 * @version 2.0.0
 * @since 2.0.0
 */
public class ModifySql {

    /**
     * SQLƻ򹹿ޤ
     * 
     * @param info SQLƻ
     * @return 硢true
     */
    public boolean modify(MonitorInfo info) {
    	
    	MonitorSqlController sql = EjbConnectionManager.getConnectionManager().getSqlController();

        boolean result = false;

        try {
        	result = sql.modifySql(info);
        	return result;
        } catch (InvalidTransactionException e) {
        } catch (IllegalStateException e) {
        } catch (RemoteException e) {
        	if(e instanceof AccessException){
        		// ʤξ硢顼ɽ
        		MessageDialog.openInformation(null, Messages.getString("message"),
        				Messages.getString("message.accesscontrol.16"));
        	}
        } catch (CreateException e) {
        } catch (FinderException e) {
        } catch (RemoveException e) {
        } catch (SchedulerException e) {
        } catch (ParseException e) {
        } catch (NamingException e) {
        } catch (NotSupportedException e) {
        } catch (HeuristicMixedException e) {
        } catch (HeuristicRollbackException e) {
        } catch (RollbackException e) {
        } catch (SystemException e) {
        }

        return false;
    }
}