/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.sql.util;

import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.naming.NamingException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.sql.bean.MonitorSqlInfo;
import com.clustercontrol.sql.ejb.entity.MonitorSqlInfoLocal;
import com.clustercontrol.sql.ejb.entity.MonitorSqlInfoPK;
import com.clustercontrol.sql.ejb.entity.MonitorSqlInfoUtil;

/**
 * SQLƻ Ƚ饹
 *
 * @version 2.1.0
 * @since 2.1.0
 */
public class ControlSqlInfo {
    protected static Log m_log = LogFactory.getLog( ControlSqlInfo.class );
    
    /** ƻоID */
	protected String m_monitorTypeId;
	
	/** ƻID */
	protected String m_monitorId;
	
	/**
	 * 󥹥ȥ饯
	 * 
	 * @param monitorId ƻID
	 * @param monitorTypeId ƻоID
	 * @version 2.1.0
	 * @since 2.1.0
	 */
	public ControlSqlInfo(String monitorId, String monitorTypeId) {
		m_monitorId = monitorId;
		m_monitorTypeId = monitorTypeId;
	}
	
	/**
	 * SQLƻ
	 * 
	 * @return SQLƻ
	 * @throws FinderException
	 * @throws NamingException
	 * @version 2.1.0
	 * @since 2.1.0
	 */
	public MonitorSqlInfo get() throws FinderException, NamingException{
		
		// SQLƻ
		MonitorSqlInfoPK pk = new MonitorSqlInfoPK(m_monitorId, m_monitorTypeId);
		MonitorSqlInfoLocal sqlLocal = MonitorSqlInfoUtil.getLocalHome().findByPrimaryKey(pk);
		
		MonitorSqlInfo sql = new MonitorSqlInfo();
		sql.setMonitorTypeId(m_monitorTypeId);
		sql.setMonitorId(m_monitorId);
		sql.setConnectionUrl(sqlLocal.getConnection_url());
		sql.setUser(sqlLocal.getConnection_user());
		sql.setPassword(sqlLocal.getConnection_password());
		sql.setQuery(sqlLocal.getQuery());
		sql.setJdbcDriver(sqlLocal.getJdbc_driver());
		
		return sql;
	}

	/**
	 * SQLƻɲ
	 * 
	 * @param sql SQLƻ
	 * @return 硢true
	 * @throws CreateException
	 * @throws NamingException
	 * @version 2.1.0
	 * @since 2.1.0
	 */
	public boolean add(MonitorSqlInfo sql) throws CreateException, NamingException {
		
		// SQLƻɲ
		MonitorSqlInfoUtil.getLocalHome().create(
				m_monitorTypeId,
				m_monitorId,
				sql.getConnectionUrl(),
				sql.getUser(),
				sql.getPassword(),
				sql.getQuery(),
				sql.getJdbcDriver());
		
		return true;
	}
	
	/**
	 * SQLƻѹ
	 * 
	 * @param sql SQLƻ
	 * @return 硢true
	 * @throws CreateException
	 * @throws FinderException
	 * @throws NamingException
	 * @version 2.1.0
	 * @since 2.1.0
	 */
	public boolean modify(MonitorSqlInfo sql) throws CreateException, FinderException, NamingException {
		
		// SQLƻ
		MonitorSqlInfoPK pk = new MonitorSqlInfoPK(m_monitorId, m_monitorTypeId);
		MonitorSqlInfoLocal sqlLocal = MonitorSqlInfoUtil.getLocalHome().findByPrimaryKey(pk);
		
		// SQLƻ
		sqlLocal.setConnection_url(sql.getConnectionUrl());
		sqlLocal.setConnection_user(sql.getUser());
		sqlLocal.setConnection_password(sql.getPassword());
		sqlLocal.setQuery(sql.getQuery());
		sqlLocal.setJdbc_driver(sql.getJdbcDriver());
		
		return true;
	}

	/**
	 * SQLƻ
	 * 
	 * @return 硢true
	 * @throws FinderException
	 * @throws RemoveException
	 * @throws NamingException
	 * @version 2.1.0
	 * @since 2.1.0
	 */
	public boolean delete() throws FinderException, RemoveException, NamingException {
		
		// SQLƻ
		MonitorSqlInfoPK pk = new MonitorSqlInfoPK(m_monitorId, m_monitorTypeId);
		MonitorSqlInfoLocal sqlLocal = MonitorSqlInfoUtil.getLocalHome().findByPrimaryKey(pk);
		
		// SQLƻ
		sqlLocal.remove();
		
		return true;
	}
}
