/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.syslogng.forward;

import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;

import javax.ejb.FinderException;
import javax.jms.JMSException;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.Session;
import javax.naming.InitialContext;
import javax.naming.NamingException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jnp.interfaces.NamingContext;

import com.clustercontrol.calendar.ejb.session.CalendarController;
import com.clustercontrol.calendar.ejb.session.CalendarControllerHome;
import com.clustercontrol.monitor.bean.QueueConstant;
import com.clustercontrol.monitor.message.LogOutputNotifyInfo;
import com.clustercontrol.repository.bean.FacilityAttributeConstant;
import com.clustercontrol.repository.ejb.session.RepositoryController;
import com.clustercontrol.repository.ejb.session.RepositoryControllerBean;
import com.clustercontrol.repository.ejb.session.RepositoryControllerHome;
import com.clustercontrol.syslogng.bean.LogFilterInfo;
import com.clustercontrol.syslogng.ejb.session.SyslogNGController;
import com.clustercontrol.syslogng.ejb.session.SyslogNGControllerHome;

/**
 * syslogEJB饹.
 * 
 * syslogΤEJBԤ饹
 * @version $Revision: 1.18 $
 * @since 1.0.0
 */
public class EJBContoroler {

	private static final String QUEUE_CON_FACTORY = "ConnectionFactory";

	private static final String QUEUE_USER_NAME = "queue.user.name";

	private static final String QUEUE_USER_PASSWORD = "queue.user.password";

	private final static String MSG_RETRY_INTERVAL = "msg.retry.interval";

	private final static String FILTER_CHACHE_INTERVAL = "filter.cache.interval";

	private final static String MSG_FILE_PATH = "msg.file.msg.path";

	private final static String MSG_FILE_SUFFIX = "msg.file.msg.syffix";

	private QueueConnection m_con;

	private Queue m_queue;

	private QueueSession m_session;

	private QueueConnectionFactory m_factory;

	private boolean m_errFlg = false;

	private long m_retryInterval = 10000;

	private long m_cacheInterval = 600000;

	private Properties m_props;

	private LogManager m_logManager;

	private FileUtil m_fileUtil;

	/** åӥ³ѥޡ * */
	protected static Timer m_timer = new Timer(true);

	//
	static Log log = LogFactory.getLog(EJBContoroler.class);

	private RepositoryControllerHome m_repositoryHome;

	private SyslogNGControllerHome m_logFilterHome;
	
	/**
	 * 󥹥ȥ饯.
	 * @param manageLog 饹
	 * @param props		ץѥƥե
	 */
	public EJBContoroler(LogManager logManager, Properties props) {

		//󥹥ѿν

		//ޥ͡
		m_logManager = logManager;

		//ץѥƥե
		m_props = props;

		//顼ȥ饤󥿡Х
		String retryInterval = props.getProperty(MSG_RETRY_INTERVAL);
		if (retryInterval != null) {
			try {
				m_retryInterval = Long.parseLong(retryInterval);
			} catch (NumberFormatException e) {
			}
		}

		//å幹󥿡Х
		String casheInterval = props.getProperty(FILTER_CHACHE_INTERVAL);
		if (casheInterval != null) {
			try {
				m_cacheInterval = Long.parseLong(casheInterval);
			} catch (NumberFormatException e) {
			}
		}

		//եϥ桼ƥƥ
		String filePath = m_props.getProperty(MSG_FILE_PATH, ".");
		String msgSuffix = m_props.getProperty(MSG_FILE_SUFFIX, ".msg");

		m_fileUtil = new FileUtil(filePath, msgSuffix);

		
		//С³
		if (initial()) {
			sendMsgRetry();
		}

		//ե륿ɤ߹
		loadFilterInfo();

		//å幹ޡ
		m_timer.schedule(new ReflashFilterTask(), m_cacheInterval,
				m_cacheInterval);

	}

	/**
	 * СQueueˤؤ³
	 */
	private boolean initial() {

		log.info("EJB³");

		InitialContext con = null;

		try {
			//InitialContext
			con = new InitialContext(m_props);

			//ͥեȥ
			m_factory = (QueueConnectionFactory) con.lookup(QUEUE_CON_FACTORY);

			//ͥ
			if (m_props.getProperty(QUEUE_USER_NAME) != null) {
				//桼ǧ
				m_con = m_factory.createQueueConnection(m_props
						.getProperty(QUEUE_USER_NAME), m_props
						.getProperty(QUEUE_USER_PASSWORD));
			} else {
				//桼ǧڤʤ
				m_con = m_factory.createQueueConnection();
			}

			//å
			m_session = m_con.createQueueSession(false,
					Session.AUTO_ACKNOWLEDGE);

			//åQueue
			m_queue = (Queue) con.lookup(QueueConstant.QUEUE_NAME_LOG);

		} catch (Exception e) {
			log.error("Init", e);
			setErrFlg(true);
			return false;
		} finally {
			try {
				if (con != null)
					con.close();
			} catch (Exception e1) {
			}
		}
		return true;

	}

	/**
	 * ե륿ݥȥɤ߹.
	 * ե륿ɤ߹ߡե륿ꤵƤ륹פ
	 * Ρɾɤ߹ࡣ
	 * ̤ե륿եƥ˳Ǽ
	 *
	 */
	public void loadFilterInfo() {

		log.info("ե륿!");
		
		//
		// syslog-ngƻ
		//
		ArrayList<LogFilterRepositoryInfo> filterRepList = null;
		
		NamingContext con;
		try {
			con = LoginManager.getContextManager(m_props).getNamingContext();
			
			//ݥȥۡ।󥿡ե
			m_repositoryHome = (RepositoryControllerHome) con
					.lookup(RepositoryControllerHome.JNDI_NAME);

			//syslog-ngƻۡ।󥿡ե
			m_logFilterHome =  (SyslogNGControllerHome) con
					.lookup(SyslogNGControllerHome.JNDI_NAME);
		} catch (NamingException e) {
		}

		RepositoryController repositoryController = null;
		SyslogNGController logFilter = null;


		try {
			//
			// EJB
			//
			log.debug("EJB᥽åɽ");
			logFilter = m_logFilterHome.create();
			repositoryController = m_repositoryHome.create();
		
			
			//ե륿
			ArrayList filterList = logFilter.getFilterInfoList();

			filterRepList = new ArrayList<LogFilterRepositoryInfo>();

			// syslog-ngƻȥݥȥǥե륿
			for (Iterator iter = filterList.iterator(); iter.hasNext();) {
				LogFilterInfo filterInfo = (LogFilterInfo) iter.next();
				if (filterInfo.isValidFlg()) {
					LogFilterRepositoryInfo filterRepInfo = 
						new LogFilterRepositoryInfo(filterInfo);

					String facilityID = filterInfo.getFacilityId();
					log.debug("getList For:" + facilityID);

					//۲ΰ
					ArrayList facilityList = repositoryController
							.getNodeFacilityIdList(facilityID,
									RepositoryControllerBean.ALL);

					//۲˥ΡɤʤȤȤϥΡɤβǽΤǻꤵ줿ID򥻥å
					if (facilityList.size() == 0) {
						facilityList.add(facilityID);
					}

					//Ρ̾
					ArrayList<String> attributeList = new ArrayList<String>();
					attributeList.add(FacilityAttributeConstant.NODENAME);
					attributeList.add(FacilityAttributeConstant.CN);

					HashMap facilityAttrMap = repositoryController
							.getNodeDetail(facilityList, attributeList);

					filterRepInfo.setMap(facilityAttrMap);

					filterRepList.add(filterRepInfo);

				}

			}

		} catch (Exception e) {

			log.error("ե륿!",e);

			return;


		} finally {

			log.debug("EJB᥽åɳ");
			//
			// EJBλ
			//
			try {
				repositoryController.remove();
				logFilter.remove();
			} catch (Exception e) {
			}
			
			//
			try {
				LoginManager.getContextManager(m_props).logout();
			} catch (NamingException e) {
			}
		}

		//
		// ե륿
		//

		m_logManager.add(filterRepList);

		log.info("ե륿λ!");

		return;
	}
	
	/**
	 * Ưå
	 * ե륿ꤵƤ륫IDꡢ
	 * ե륿郎Ưɤå롣
	 * 
	 * @param id ID
	 * @param timestamp å
	 * @return
	 */
	public boolean isRun(String id, Date timestamp) {

		CalendarController calendarController = null;
		
		try {
			NamingContext con = LoginManager.getContextManager(m_props).getNamingContext();
			
			//ۡ।󥿡ե
			CalendarControllerHome calendarHome = (CalendarControllerHome) con.lookup(CalendarControllerHome.JNDI_NAME);
			calendarController = calendarHome.create();
			
			try {
				if(calendarController.isRun(id, timestamp).booleanValue()){
					// ư
					return true;
				}
				else{
					// Ư
					log.debug("isRun() : ID" + id + "ƯǤ");
				}
			} catch (FinderException e) {
				// ꤵ줿IDǤ¸ߤʤ
				log.info("isRun() : ե륿˻ꤵ줿ID" + id + "פ¸ߤޤ");
			}

		} catch (Exception e) {
			log.error("isRun() : Ưå!",e);

		} finally {

			log.debug("EJB᥽åɳ");
			//
			// EJBλ
			//
			try {
				calendarController.remove();
			} catch (Exception e) {
			}
			
			//
			try {
				LoginManager.getContextManager(m_props).logout();
			} catch (NamingException e) {
			}
		}
		return false;		
	}

	/**
	 * å
	 * QueueؤߤơԤե
	 * @param msg
	 * @return
	 */
	synchronized public void sendMsg(LogOutputNotifyInfo msg) {


		if (!_sendMsg(msg)) {
			//Ԥϥե
			log.info("֥ȥåե񤭹!");
			m_fileUtil.write(msg);
		}
	}

	/**
	 * åQueue
	 * 
	 * @param msg
	 */
	private boolean _sendMsg(Object msg) {

		if (isErrFlg()) {
			return false;
		}

		QueueSender sender = null;
		try {
			//Sender
			sender = m_session.createSender(m_queue);
			//å
			ObjectMessage mess = m_session.createObjectMessage((Serializable)msg);
			//
			log.info("֥ȥå!");
			sender.send(mess);

		} catch (JMSException e) {
			log.error(e);
			setErrFlg(true);
			return false;

		} finally {
			try {
				if (sender != null)
					sender.close();
			} catch (Exception e1) {
			}
		}
		return true;

	}

	/**
	 * å
	 *  
	 */
	synchronized private void sendMsgRetry() {

		log.info("֥ȥå!");

		//ե
		Collection col = m_fileUtil.getFileList();

		for (Iterator iter = col.iterator(); iter.hasNext();) {
			File file = (File) iter.next();
			//եɤ߹
			Object msg = m_fileUtil.readMsgFile(file);

			//
			if (!_sendMsg(msg)) {
				//Ԥ
				break;
			}
			//ե
			file.delete();
		}

	}

	/**
	 * ³νλ
	 *  
	 */
	public void terminate() {

		m_timer.cancel();

		_terminate();
	}

	/**
	 * ³νλ
	 *  
	 */
	public void _terminate() {

		try {
			if (m_session != null)
				m_session.close();
		} catch (JMSException e) {
		}

		try {
			if (m_con != null)
				m_con.close();
		} catch (JMSException e1) {
		}
	}
	


	/**
	 * @param errFlg
	 *            errFlg ꡣ
	 */
	synchronized private void setErrFlg(boolean errFlg) {
		if (m_errFlg == false && errFlg == true) {

			m_timer.schedule(new ReSetupTask(), m_retryInterval,
					m_retryInterval);

		}
		m_errFlg = errFlg;
	}

	/**
	 * @return errFlg ᤷޤ
	 */
	synchronized private boolean isErrFlg() {
		return m_errFlg;
	}

	/**
	 *  ³
	 */
	synchronized private boolean reInitial() {

		boolean ret = false;

		log.info("³!");

		_terminate();

		if (initial()) {

			ret = true;

			log.info("³:!");

			//顼ե饰
			setErrFlg(false);

			loadFilterInfo();

			sendMsgRetry();

		} else {
			log.info("³:!");
		}

		return ret;
	}

	/**
	 * ե륿ޡ
	 */
	protected class ReflashFilterTask extends TimerTask {

		/**
		 * å幹
		 */
		public void run() {

			loadFilterInfo();

		}

	}
	/**
	 * EJB³ޡ 
	 */
	protected class ReSetupTask extends TimerTask {

		/**
		 * ͥ󥯥
		 */
		public void run() {
			if (reInitial()) {
				//Υ򥿥ޡ
				cancel();
			}
		}

	}

}
