/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.syslogng.forward;

import java.text.MessageFormat;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * åϥ饹 syslogåMessageInf饹Ѵ롣
 *
 * @version $Revision: 1.7 $
 * @since
 */
public class MessageParser {

	/** syslogåβѥեޥå */
	static private MessageFormat m_msgfmt = new MessageFormat(
			"<{0}>{1,date,MMM dd HH:mm:ss} {2} {3}", Locale.ENGLISH);

	@SuppressWarnings("unused")
	private final static int INDEX_PRI = 0;

	private final static int INDEX_DATE = 1;

	private final static int INDEX_HOST = 2;

	private final static int INDEX_MSG = 3;

	//
	static Log log = LogFactory.getLog(MessageParser.class);

	/**
	 * å
	 * 
	 * @param msg
	 *            syslogå
	 * @return MessageInf饹
	 */
	static public MessageInfo parse(String msg) {

		//MessageFormat饹ˤå
		Object[] parseArgs = null;
		try {
			parseArgs = m_msgfmt.parse(msg);
		} catch (ParseException e) {
			log.error(msg, e);
			return null;
		}
		if (log.isDebugEnabled()) {
			log.debug("parsed msg");
			for (int i = 0; i < parseArgs.length; i++) {
				log.debug(parseArgs[i]);
			}
		}

		//Ϸ̤MessageInfo˥å
		MessageInfo logMessage = new MessageInfo();
		logMessage.setHostName((String) parseArgs[INDEX_HOST]);
		logMessage.setMessage((String) parseArgs[INDEX_MSG]);
		logMessage.setGenerationDate(setYear((Date) parseArgs[INDEX_DATE]));

		return logMessage;
	}

	/**
	 * շ.
	 * syslogåաʷˤ顢ǯꤷդ֤.
	 * 
	 * @param parseArgs	դʸ
	 * @return	ǯޤ᤿
	 */
	static private Date setYear(Date date) {

		//߻μ
		Calendar nowDate = Calendar.getInstance();
		//ѤΥ
		Calendar dataDate = Calendar.getInstance();

		//åparseDate
		dataDate.setTime(date);

		//ǯʥåǯޤޤʤΤ1970ˤʤ
		int monthNow = nowDate.get(Calendar.MONTH);
		int monthdat = dataDate.get(Calendar.MONTH);
		int year = nowDate.get(Calendar.YEAR);

		//åηǡߤ1ξ硢ǯΥǡȤ
		if (monthdat == Calendar.DECEMBER && monthNow == Calendar.JANUARY) {
			year -= 1;
		}
		dataDate.set(Calendar.YEAR, year);

		log.debug(dataDate.getTime().toString());
		return dataDate.getTime();
	}
}
