/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.syslogng.bean;

import java.io.Serializable;
import java.util.Date;

import com.clustercontrol.bean.PriorityConstant;
import com.clustercontrol.bean.ProcessConstant;
import com.clustercontrol.bean.YesNoConstant;

/**
 * syslog-ngե륿ݻ륯饹Ǥ
 *
 * @version 2.1.0
 * @since 1.0.0
 */
public class LogFilterInfo implements Serializable {

	private static final long serialVersionUID = -544655198328111919L;

	//åID
    private String m_logId = null;

    //ͥ
    private int m_orderNo = Integer.MAX_VALUE;

    //
    private String m_description = null;

    //
    private String m_scope = null;

    //եƥID
    private String m_facilityId = null;

    //ѥ
    private String m_pattern = null;

    //
    private int m_processType = ProcessConstant.TYPE_YES;

    //
    private int m_priority = PriorityConstant.TYPE_CRITICAL;

    //ƻID
    private String m_monitorId = null;

    //ץꥱ̾
    private String m_application = null;

    //åID
    private String m_messageId = null;

    //å
    private String m_message = null;
    
    //ID
    private String m_calendarId = null;
    
    //ID
    private String m_notifyId = null;

    //ͭե饰
    private boolean m_validFlg = true;
    
    //Ͽ
    private Date m_regDate = null;
    
    //
    private Date m_updateDate = null;
    
    /** ּ¹ @version 2.1.0 */
    private int m_jobRun = YesNoConstant.TYPE_NO;
	
	/** ID @version 2.1.0 */
    private String m_jobId;
	
	/** ּ¹ Ϣư @version 2.1.0 */
    private int m_jobInhibitionFlg = YesNoConstant.TYPE_NO;
	
	/** ָƤӽФԻ @version 2.1.0 */
    private int m_jobFailurePriority = PriorityConstant.TYPE_UNKNOWN;
    
    /** 桼 @since 2.1.0 */
	protected String m_regUser;
	
	/** ǽѹ桼 @since 2.1.0 */
	protected String m_updateUser;

    /**
     *  
     */
    public LogFilterInfo() {
        super();
    }

    /**
     * 󥹥ȥ饯
     * 
     * @param orderNo
     * @param description
     * @param facilityId
     * @param pattern
     * @param processType
     * @param priority
     * @param monitorId
     * @param application
     * @param messageId
     * @param message
     * @param notifyId
     * @param jobRun
     * @param jobId
     * @param jobInhibitionFlg
     * @param jobFailurePriority
     * @param validFlg
     * @param regDate
     * @param updateDate
     * @param regUser
     * @param updateUser
     */
    public LogFilterInfo(
    		int orderNo, 
    		String description, 
    		String facilityId,
            String pattern, 
            int processType, 
            int priority, 
            String monitorId,
            String application, 
            String messageId, 
            String message,
            String notifyId, 
            int jobRun, 
			String jobId, 
			int jobInhibitionFlg, 
			int jobFailurePriority, 
            boolean validFlg, 
            Date regDate, 
            Date updateDate,
            String regUser,
            String updateUser) {
    	
        super();
        m_orderNo = orderNo;
        m_description = description;
        m_facilityId = facilityId;
        m_pattern = pattern;
        m_processType = processType;
        m_priority = priority;
        m_monitorId = monitorId;
        m_application = application;
        m_messageId = messageId;
        m_message = message;
        m_notifyId = notifyId;
        m_jobRun = jobRun;
        m_jobId = jobId;
        m_jobInhibitionFlg = jobInhibitionFlg;
        m_jobFailurePriority = jobFailurePriority;
        m_validFlg = validFlg;
        m_regDate = regDate;
        m_updateDate = updateDate;
        m_regUser = regUser;
        m_updateUser = updateUser;
    }

    /**
     * @return application ᤷޤ
     */
    public String getApplication() {
        return m_application;
    }

    /**
     * @param application
     *            application ꡣ
     */
    public void setApplication(String application) {
        m_application = application;
    }

    /**
     * @return description ᤷޤ
     */
    public String getDescription() {
        return m_description;
    }

    /**
     * @param description
     *            description ꡣ
     */
    public void setDescription(String description) {
        m_description = description;
    }

    /**
     * @return facilityId ᤷޤ
     */
    public String getFacilityId() {
        return m_facilityId;
    }

    /**
     * @param facilityId
     *            facilityId ꡣ
     */
    public void setFacilityId(String facilityId) {
        m_facilityId = facilityId;
    }

    /**
     * @return message ᤷޤ
     */
    public String getMessage() {
        return m_message;
    }

    /**
     * @param message
     *            message ꡣ
     */
    public void setMessage(String message) {
        m_message = message;
    }

    /**
     * @return messageId ᤷޤ
     */
    public String getMessageId() {
        return m_messageId;
    }

    /**
     * @param messageId
     *            messageId ꡣ
     */
    public void setMessageId(String messageId) {
        m_messageId = messageId;
    }

    /**
     * @return moniterId ᤷޤ
     */
    public String getMonitorId() {
        return m_monitorId;
    }

    /**
     * @param monitorId
     *            monitorId ꡣ
     */
    public void setMonitorId(String monitorId) {
        m_monitorId = monitorId;
    }

    /**
     * @return orderNo ᤷޤ
     */
    public int getOrderNo() {
        return m_orderNo;
    }

    /**
     * @param orderNo
     *            orderNo ꡣ
     */
    public void setOrderNo(int orderNo) {
        m_orderNo = orderNo;
    }

    /**
     * @return pattern ᤷޤ
     */
    public String getPattern() {
        return m_pattern;
    }

    /**
     * @param pattern
     *            pattern ꡣ
     */
    public void setPattern(String pattern) {
        m_pattern = pattern;
    }

    /**
     * @return priority ᤷޤ
     */
    public int getPriority() {
        return m_priority;
    }

    /**
     * @param priority
     *            priority ꡣ
     */
    public void setPriority(int priority) {
        m_priority = priority;
    }

    /**
     * @return processType ᤷޤ
     */
    public int getProcessType() {
        return m_processType;
    }

    /**
     * @param processType
     *            processType ꡣ
     */
    public void setProcessType(int processType) {
        m_processType = processType;
    }

    public boolean isValidFlg() {
        return m_validFlg;
    }

    public void setValidFlg(boolean validFlg) {
        m_validFlg = validFlg;
    }

    /**
     * @return logId ᤷޤ
     */
    public String getLogId() {
        return this.m_logId;
    }

    /**
     * @param logId
     *            logId ꡣ
     */
    public void setLogId(String logId) {
        this.m_logId = logId;
    }

    /**
     * @return scope ᤷޤ
     */
    public String getScope() {
        return m_scope;
    }

    /**
     * @param scope
     *            scope ꡣ
     */
    public void setScope(String scope) {
        this.m_scope = scope;
    }

	/**
	 * @return m_notifyId ᤷޤ
	 * @since 2.0.0
	 */
	public String getNotifyId() {
		return m_notifyId;
	}

	/**
	 * @param id ꤹ notifyId
	 * @since 2.0.0
	 */
	public void setNotifyId(String id) {
		m_notifyId = id;
	}

	/**
	 * @return m_regDate ᤷޤ
	 * @since 2.0.0
	 */
	public Date getRegDate() {
		return m_regDate;
	}

	/**
	 * @param date ꤹ m_regDate
	 * @since 2.0.0
	 */
	public void setRegDate(Date date) {
		m_regDate = date;
	}

	/**
	 * @return m_updateDate ᤷޤ
	 * @since 2.0.0
	 */
	public Date getUpdateDate() {
		return m_updateDate;
	}

	/**
	 * @param date ꤹ m_updateDate
	 * @since 2.0.0
	 */
	public void setUpdateDate(Date date) {
		m_updateDate = date;
	}

	/**
	 * @return m_calendarId ᤷޤ
	 * @since 2.1.0
	 */
	public String getCalendarId() {
		return m_calendarId;
	}

	/**
	 * @param calendarId ꤹ m_calendarId
	 * @since 2.1.0
	 */
	public void setCalendarId(String calendarId) {
		this.m_calendarId = calendarId;
	}
	
	/**
	 * @return jobFailurePriority ᤷޤ
	 * @since 2.1.0
	 */
	public int getJobFailurePriority() {
		return m_jobFailurePriority;
	}
	
	/**
	 * @param jobFailurePriority ꤹ jobFailurePriority
	 * @since 2.1.0
	 */
	public void setJobFailurePriority(int jobFailurePriority) {
		this.m_jobFailurePriority = jobFailurePriority;
	}
	
	/**
	 * @return jobId ᤷޤ
	 * @since 2.1.0
	 */
	public String getJobId() {
		return m_jobId;
	}
	
	/**
	 * @param jobId ꤹ jobId
	 * @since 2.1.0
	 */
	public void setJobId(String jobId) {
		this.m_jobId = jobId;
	}
	
	/**
	 * @return jobInhibitionFlg ᤷޤ
	 * @since 2.1.0
	 */
	public int getJobInhibitionFlg() {
		return m_jobInhibitionFlg;
	}
	
	/**
	 * @param jobInhibitionFlg ꤹ jobInhibitionFlg
	 * @since 2.1.0
	 */
	public void setJobInhibitionFlg(int jobInhibitionFlg) {
		this.m_jobInhibitionFlg = jobInhibitionFlg;
	}
	
	/**
	 * @return jobRun ᤷޤ
	 * @since 2.1.0
	 */
	public int getJobRun() {
		return m_jobRun;
	}
	
	/**
	 * @param jobRun ꤹ jobRun
	 * @since 2.1.0
	 */
	public void setJobRun(int jobRun) {
		this.m_jobRun = jobRun;
	}
	
	/**
	 * @param m_regUser ꤹ m_regUser
	 * @since 2.1.0
	 */
	public String getRegUser() {
		return m_regUser;
	}
	
	/**
	 * @param m_regUser ꤹ m_regUser
	 * @since 2.1.0
	 */
	public void setRegUser(String user) {
		m_regUser = user;
	}
	
	/**
	 * @param m_updateUser ꤹ m_updateUser
	 * @since 2.1.0
	 */
	public String getUpdateUser() {
		return m_updateUser;
	}
	
	/**
	 * @param m_updateUser ꤹ m_updateUser
	 * @since 2.1.0
	 */
	public void setUpdateUser(String user) {
		m_updateUser = user;
	}
}